package software.amazon.awscdk.services.fsx;

/**
 * Class for scheduling a daily automatic backup time.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Map&lt;String, Object&gt; lustreConfiguration = Map.of(
 *         // ...
 *         "automaticBackupRetention", Duration.days(3),  // backup retention
 *         "copyTagsToBackups", true,  // if true, tags are copied to backups
 *         "dailyAutomaticBackupStartTime", DailyAutomaticBackupStartTime.Builder.create().hour(11).minute(30).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:19.593Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.DailyAutomaticBackupStartTime")
public class DailyAutomaticBackupStartTime extends software.amazon.jsii.JsiiObject {

    protected DailyAutomaticBackupStartTime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DailyAutomaticBackupStartTime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DailyAutomaticBackupStartTime(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.DailyAutomaticBackupStartTimeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Converts an hour, and minute into HH:MM string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toTimestamp() {
        return software.amazon.jsii.Kernel.call(this, "toTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.DailyAutomaticBackupStartTime}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.DailyAutomaticBackupStartTime> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.fsx.DailyAutomaticBackupStartTimeProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.fsx.DailyAutomaticBackupStartTimeProps.Builder();
        }

        /**
         * The hour of the day (from 0-23) for automatic backup starts.
         * <p>
         * @return {@code this}
         * @param hour The hour of the day (from 0-23) for automatic backup starts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hour(final java.lang.Number hour) {
            this.props.hour(hour);
            return this;
        }

        /**
         * The minute of the hour (from 0-59) for automatic backup starts.
         * <p>
         * @return {@code this}
         * @param minute The minute of the hour (from 0-59) for automatic backup starts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minute(final java.lang.Number minute) {
            this.props.minute(minute);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.fsx.DailyAutomaticBackupStartTime}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.DailyAutomaticBackupStartTime build() {
            return new software.amazon.awscdk.services.fsx.DailyAutomaticBackupStartTime(
                this.props.build()
            );
        }
    }
}
