package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnScheduledAudit</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnScheduledAuditProps cfnScheduledAuditProps = CfnScheduledAuditProps.builder()
 *         .frequency("frequency")
 *         .targetCheckNames(List.of("targetCheckNames"))
 *         // the properties below are optional
 *         .dayOfMonth("dayOfMonth")
 *         .dayOfWeek("dayOfWeek")
 *         .scheduledAuditName("scheduledAuditName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:20.334Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnScheduledAuditProps")
@software.amazon.jsii.Jsii.Proxy(CfnScheduledAuditProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScheduledAuditProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * How often the scheduled audit occurs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-frequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-frequency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFrequency();

    /**
     * Which checks are performed during the scheduled audit.
     * <p>
     * Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
     * <p>
     * The following checks are currently aviable:
     * <p>
     * <ul>
     * <li><code>AUTHENTICATED_COGNITO_ROLE_OVERLY_PERMISSIVE_CHECK</code></li>
     * <li><code>CA_CERTIFICATE_EXPIRING_CHECK</code></li>
     * <li><code>CA_CERTIFICATE_KEY_QUALITY_CHECK</code></li>
     * <li><code>CONFLICTING_CLIENT_IDS_CHECK</code></li>
     * <li><code>DEVICE_CERTIFICATE_EXPIRING_CHECK</code></li>
     * <li><code>DEVICE_CERTIFICATE_KEY_QUALITY_CHECK</code></li>
     * <li><code>DEVICE_CERTIFICATE_SHARED_CHECK</code></li>
     * <li><code>IOT_POLICY_OVERLY_PERMISSIVE_CHECK</code></li>
     * <li><code>IOT_ROLE_ALIAS_ALLOWS_ACCESS_TO_UNUSED_SERVICES_CHECK</code></li>
     * <li><code>IOT_ROLE_ALIAS_OVERLY_PERMISSIVE_CHECK</code></li>
     * <li><code>LOGGING_DISABLED_CHECK</code></li>
     * <li><code>REVOKED_CA_CERTIFICATE_STILL_ACTIVE_CHECK</code></li>
     * <li><code>REVOKED_DEVICE_CERTIFICATE_STILL_ACTIVE_CHECK</code></li>
     * <li><code>UNAUTHENTICATED_COGNITO_ROLE_OVERLY_PERMISSIVE_CHECK</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-targetchecknames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-targetchecknames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargetCheckNames();

    /**
     * The day of the month on which the scheduled audit is run (if the <code>frequency</code> is "MONTHLY").
     * <p>
     * If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-dayofmonth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-dayofmonth</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDayOfMonth() {
        return null;
    }

    /**
     * The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or "BIWEEKLY").
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-dayofweek">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-dayofweek</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDayOfWeek() {
        return null;
    }

    /**
     * The name of the scheduled audit.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-scheduledauditname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-scheduledauditname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheduledAuditName() {
        return null;
    }

    /**
     * Metadata that can be used to manage the scheduled audit.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnScheduledAuditProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScheduledAuditProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScheduledAuditProps> {
        java.lang.String frequency;
        java.util.List<java.lang.String> targetCheckNames;
        java.lang.String dayOfMonth;
        java.lang.String dayOfWeek;
        java.lang.String scheduledAuditName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnScheduledAuditProps#getFrequency}
         * @param frequency How often the scheduled audit occurs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frequency(java.lang.String frequency) {
            this.frequency = frequency;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledAuditProps#getTargetCheckNames}
         * @param targetCheckNames Which checks are performed during the scheduled audit. This parameter is required.
         *                         Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)
         *                         <p>
         *                         The following checks are currently aviable:
         *                         <p>
         *                         <ul>
         *                         <li><code>AUTHENTICATED_COGNITO_ROLE_OVERLY_PERMISSIVE_CHECK</code></li>
         *                         <li><code>CA_CERTIFICATE_EXPIRING_CHECK</code></li>
         *                         <li><code>CA_CERTIFICATE_KEY_QUALITY_CHECK</code></li>
         *                         <li><code>CONFLICTING_CLIENT_IDS_CHECK</code></li>
         *                         <li><code>DEVICE_CERTIFICATE_EXPIRING_CHECK</code></li>
         *                         <li><code>DEVICE_CERTIFICATE_KEY_QUALITY_CHECK</code></li>
         *                         <li><code>DEVICE_CERTIFICATE_SHARED_CHECK</code></li>
         *                         <li><code>IOT_POLICY_OVERLY_PERMISSIVE_CHECK</code></li>
         *                         <li><code>IOT_ROLE_ALIAS_ALLOWS_ACCESS_TO_UNUSED_SERVICES_CHECK</code></li>
         *                         <li><code>IOT_ROLE_ALIAS_OVERLY_PERMISSIVE_CHECK</code></li>
         *                         <li><code>LOGGING_DISABLED_CHECK</code></li>
         *                         <li><code>REVOKED_CA_CERTIFICATE_STILL_ACTIVE_CHECK</code></li>
         *                         <li><code>REVOKED_DEVICE_CERTIFICATE_STILL_ACTIVE_CHECK</code></li>
         *                         <li><code>UNAUTHENTICATED_COGNITO_ROLE_OVERLY_PERMISSIVE_CHECK</code></li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCheckNames(java.util.List<java.lang.String> targetCheckNames) {
            this.targetCheckNames = targetCheckNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledAuditProps#getDayOfMonth}
         * @param dayOfMonth The day of the month on which the scheduled audit is run (if the <code>frequency</code> is "MONTHLY").
         *                   If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dayOfMonth(java.lang.String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledAuditProps#getDayOfWeek}
         * @param dayOfWeek The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or "BIWEEKLY").
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dayOfWeek(java.lang.String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledAuditProps#getScheduledAuditName}
         * @param scheduledAuditName The name of the scheduled audit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledAuditName(java.lang.String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledAuditProps#getTags}
         * @param tags Metadata that can be used to manage the scheduled audit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScheduledAuditProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScheduledAuditProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScheduledAuditProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScheduledAuditProps {
        private final java.lang.String frequency;
        private final java.util.List<java.lang.String> targetCheckNames;
        private final java.lang.String dayOfMonth;
        private final java.lang.String dayOfWeek;
        private final java.lang.String scheduledAuditName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.frequency = software.amazon.jsii.Kernel.get(this, "frequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetCheckNames = software.amazon.jsii.Kernel.get(this, "targetCheckNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dayOfMonth = software.amazon.jsii.Kernel.get(this, "dayOfMonth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dayOfWeek = software.amazon.jsii.Kernel.get(this, "dayOfWeek", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduledAuditName = software.amazon.jsii.Kernel.get(this, "scheduledAuditName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.frequency = java.util.Objects.requireNonNull(builder.frequency, "frequency is required");
            this.targetCheckNames = java.util.Objects.requireNonNull(builder.targetCheckNames, "targetCheckNames is required");
            this.dayOfMonth = builder.dayOfMonth;
            this.dayOfWeek = builder.dayOfWeek;
            this.scheduledAuditName = builder.scheduledAuditName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getFrequency() {
            return this.frequency;
        }

        @Override
        public final java.util.List<java.lang.String> getTargetCheckNames() {
            return this.targetCheckNames;
        }

        @Override
        public final java.lang.String getDayOfMonth() {
            return this.dayOfMonth;
        }

        @Override
        public final java.lang.String getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        public final java.lang.String getScheduledAuditName() {
            return this.scheduledAuditName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("frequency", om.valueToTree(this.getFrequency()));
            data.set("targetCheckNames", om.valueToTree(this.getTargetCheckNames()));
            if (this.getDayOfMonth() != null) {
                data.set("dayOfMonth", om.valueToTree(this.getDayOfMonth()));
            }
            if (this.getDayOfWeek() != null) {
                data.set("dayOfWeek", om.valueToTree(this.getDayOfWeek()));
            }
            if (this.getScheduledAuditName() != null) {
                data.set("scheduledAuditName", om.valueToTree(this.getScheduledAuditName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnScheduledAuditProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScheduledAuditProps.Jsii$Proxy that = (CfnScheduledAuditProps.Jsii$Proxy) o;

            if (!frequency.equals(that.frequency)) return false;
            if (!targetCheckNames.equals(that.targetCheckNames)) return false;
            if (this.dayOfMonth != null ? !this.dayOfMonth.equals(that.dayOfMonth) : that.dayOfMonth != null) return false;
            if (this.dayOfWeek != null ? !this.dayOfWeek.equals(that.dayOfWeek) : that.dayOfWeek != null) return false;
            if (this.scheduledAuditName != null ? !this.scheduledAuditName.equals(that.scheduledAuditName) : that.scheduledAuditName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.frequency.hashCode();
            result = 31 * result + (this.targetCheckNames.hashCode());
            result = 31 * result + (this.dayOfMonth != null ? this.dayOfMonth.hashCode() : 0);
            result = 31 * result + (this.dayOfWeek != null ? this.dayOfWeek.hashCode() : 0);
            result = 31 * result + (this.scheduledAuditName != null ? this.scheduledAuditName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
