package software.amazon.awscdk.services.iotsitewise;

/**
 * Properties for defining a <code>CfnPortal</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * Object alarms;
 * CfnPortalProps cfnPortalProps = CfnPortalProps.builder()
 *         .portalContactEmail("portalContactEmail")
 *         .portalName("portalName")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .alarms(alarms)
 *         .notificationSenderEmail("notificationSenderEmail")
 *         .portalAuthMode("portalAuthMode")
 *         .portalDescription("portalDescription")
 *         .portalType("portalType")
 *         .portalTypeConfiguration(Map.of(
 *                 "portalTypeConfigurationKey", PortalTypeEntryProperty.builder()
 *                         .portalTools(List.of("portalTools"))
 *                         .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:20.609Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnPortalProps")
@software.amazon.jsii.Jsii.Proxy(CfnPortalProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPortalProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS administrator's contact email address.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalcontactemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalcontactemail</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortalContactEmail();

    /**
     * A friendly name for the portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPortalName();

    /**
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for AWS IoT SiteWise Monitor</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Contains the configuration information of an alarm created in an AWS IoT SiteWise Monitor portal.
     * <p>
     * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <em>AWS IoT SiteWise Application Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-alarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-alarms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAlarms() {
        return null;
    }

    /**
     * The email address that sends alarm notifications.
     * <p>
     * <blockquote>
     * <p>
     * If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS IoT Events managed Lambda function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email address in Amazon SES</a> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-notificationsenderemail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-notificationsenderemail</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNotificationSenderEmail() {
        return null;
    }

    /**
     * The service to use to authenticate users to the portal. Choose from the following options:.
     * <p>
     * <ul>
     * <li><code>SSO</code> – The portal uses AWS IAM Identity Center to authenticate users and manage user permissions. Before you can create a portal that uses IAM Identity Center, you must enable IAM Identity Center. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling IAM Identity Center</a> in the <em>AWS IoT SiteWise User Guide</em> . This option is only available in AWS Regions other than the China Regions.</li>
     * <li><code>IAM</code> – The portal uses AWS Identity and Access Management to authenticate users and manage user permissions.</li>
     * </ul>
     * <p>
     * You can't change this value after you create a portal.
     * <p>
     * Default: <code>SSO</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalauthmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portalauthmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPortalAuthMode() {
        return null;
    }

    /**
     * A description for the portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portaldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portaldescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPortalDescription() {
        return null;
    }

    /**
     * The type of portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portaltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portaltype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPortalType() {
        return null;
    }

    /**
     * Map to associate detail of configuration related with a PortalType.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portaltypeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-portaltypeconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPortalTypeConfiguration() {
        return null;
    }

    /**
     * A list of key-value pairs that contain metadata for the portal.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-portal.html#cfn-iotsitewise-portal-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPortalProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPortalProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPortalProps> {
        java.lang.String portalContactEmail;
        java.lang.String portalName;
        java.lang.String roleArn;
        java.lang.Object alarms;
        java.lang.String notificationSenderEmail;
        java.lang.String portalAuthMode;
        java.lang.String portalDescription;
        java.lang.String portalType;
        java.lang.Object portalTypeConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPortalProps#getPortalContactEmail}
         * @param portalContactEmail The AWS administrator's contact email address. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalContactEmail(java.lang.String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getPortalName}
         * @param portalName A friendly name for the portal. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalName(java.lang.String portalName) {
            this.portalName = portalName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getRoleArn}
         * @param roleArn The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for AWS IoT SiteWise Monitor</a> in the <em>AWS IoT SiteWise User Guide</em> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getAlarms}
         * @param alarms Contains the configuration information of an alarm created in an AWS IoT SiteWise Monitor portal.
         *               You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <em>AWS IoT SiteWise Application Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarms(java.lang.Object alarms) {
            this.alarms = alarms;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getNotificationSenderEmail}
         * @param notificationSenderEmail The email address that sends alarm notifications.
         *                                <blockquote>
         *                                <p>
         *                                If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS IoT Events managed Lambda function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email address in Amazon SES</a> .
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationSenderEmail(java.lang.String notificationSenderEmail) {
            this.notificationSenderEmail = notificationSenderEmail;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getPortalAuthMode}
         * @param portalAuthMode The service to use to authenticate users to the portal. Choose from the following options:.
         *                       <ul>
         *                       <li><code>SSO</code> – The portal uses AWS IAM Identity Center to authenticate users and manage user permissions. Before you can create a portal that uses IAM Identity Center, you must enable IAM Identity Center. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling IAM Identity Center</a> in the <em>AWS IoT SiteWise User Guide</em> . This option is only available in AWS Regions other than the China Regions.</li>
         *                       <li><code>IAM</code> – The portal uses AWS Identity and Access Management to authenticate users and manage user permissions.</li>
         *                       </ul>
         *                       <p>
         *                       You can't change this value after you create a portal.
         *                       <p>
         *                       Default: <code>SSO</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalAuthMode(java.lang.String portalAuthMode) {
            this.portalAuthMode = portalAuthMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getPortalDescription}
         * @param portalDescription A description for the portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalDescription(java.lang.String portalDescription) {
            this.portalDescription = portalDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getPortalType}
         * @param portalType The type of portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalType(java.lang.String portalType) {
            this.portalType = portalType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getPortalTypeConfiguration}
         * @param portalTypeConfiguration Map to associate detail of configuration related with a PortalType.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalTypeConfiguration(software.amazon.awscdk.IResolvable portalTypeConfiguration) {
            this.portalTypeConfiguration = portalTypeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getPortalTypeConfiguration}
         * @param portalTypeConfiguration Map to associate detail of configuration related with a PortalType.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalTypeConfiguration(java.util.Map<java.lang.String, ? extends java.lang.Object> portalTypeConfiguration) {
            this.portalTypeConfiguration = portalTypeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getTags}
         * @param tags A list of key-value pairs that contain metadata for the portal.
         *             For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPortalProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPortalProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPortalProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPortalProps {
        private final java.lang.String portalContactEmail;
        private final java.lang.String portalName;
        private final java.lang.String roleArn;
        private final java.lang.Object alarms;
        private final java.lang.String notificationSenderEmail;
        private final java.lang.String portalAuthMode;
        private final java.lang.String portalDescription;
        private final java.lang.String portalType;
        private final java.lang.Object portalTypeConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.portalContactEmail = software.amazon.jsii.Kernel.get(this, "portalContactEmail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.portalName = software.amazon.jsii.Kernel.get(this, "portalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationSenderEmail = software.amazon.jsii.Kernel.get(this, "notificationSenderEmail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.portalAuthMode = software.amazon.jsii.Kernel.get(this, "portalAuthMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.portalDescription = software.amazon.jsii.Kernel.get(this, "portalDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.portalType = software.amazon.jsii.Kernel.get(this, "portalType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.portalTypeConfiguration = software.amazon.jsii.Kernel.get(this, "portalTypeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.portalContactEmail = java.util.Objects.requireNonNull(builder.portalContactEmail, "portalContactEmail is required");
            this.portalName = java.util.Objects.requireNonNull(builder.portalName, "portalName is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.alarms = builder.alarms;
            this.notificationSenderEmail = builder.notificationSenderEmail;
            this.portalAuthMode = builder.portalAuthMode;
            this.portalDescription = builder.portalDescription;
            this.portalType = builder.portalType;
            this.portalTypeConfiguration = builder.portalTypeConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getPortalContactEmail() {
            return this.portalContactEmail;
        }

        @Override
        public final java.lang.String getPortalName() {
            return this.portalName;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getAlarms() {
            return this.alarms;
        }

        @Override
        public final java.lang.String getNotificationSenderEmail() {
            return this.notificationSenderEmail;
        }

        @Override
        public final java.lang.String getPortalAuthMode() {
            return this.portalAuthMode;
        }

        @Override
        public final java.lang.String getPortalDescription() {
            return this.portalDescription;
        }

        @Override
        public final java.lang.String getPortalType() {
            return this.portalType;
        }

        @Override
        public final java.lang.Object getPortalTypeConfiguration() {
            return this.portalTypeConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("portalContactEmail", om.valueToTree(this.getPortalContactEmail()));
            data.set("portalName", om.valueToTree(this.getPortalName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAlarms() != null) {
                data.set("alarms", om.valueToTree(this.getAlarms()));
            }
            if (this.getNotificationSenderEmail() != null) {
                data.set("notificationSenderEmail", om.valueToTree(this.getNotificationSenderEmail()));
            }
            if (this.getPortalAuthMode() != null) {
                data.set("portalAuthMode", om.valueToTree(this.getPortalAuthMode()));
            }
            if (this.getPortalDescription() != null) {
                data.set("portalDescription", om.valueToTree(this.getPortalDescription()));
            }
            if (this.getPortalType() != null) {
                data.set("portalType", om.valueToTree(this.getPortalType()));
            }
            if (this.getPortalTypeConfiguration() != null) {
                data.set("portalTypeConfiguration", om.valueToTree(this.getPortalTypeConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnPortalProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPortalProps.Jsii$Proxy that = (CfnPortalProps.Jsii$Proxy) o;

            if (!portalContactEmail.equals(that.portalContactEmail)) return false;
            if (!portalName.equals(that.portalName)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
            if (this.notificationSenderEmail != null ? !this.notificationSenderEmail.equals(that.notificationSenderEmail) : that.notificationSenderEmail != null) return false;
            if (this.portalAuthMode != null ? !this.portalAuthMode.equals(that.portalAuthMode) : that.portalAuthMode != null) return false;
            if (this.portalDescription != null ? !this.portalDescription.equals(that.portalDescription) : that.portalDescription != null) return false;
            if (this.portalType != null ? !this.portalType.equals(that.portalType) : that.portalType != null) return false;
            if (this.portalTypeConfiguration != null ? !this.portalTypeConfiguration.equals(that.portalTypeConfiguration) : that.portalTypeConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.portalContactEmail.hashCode();
            result = 31 * result + (this.portalName.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.alarms != null ? this.alarms.hashCode() : 0);
            result = 31 * result + (this.notificationSenderEmail != null ? this.notificationSenderEmail.hashCode() : 0);
            result = 31 * result + (this.portalAuthMode != null ? this.portalAuthMode.hashCode() : 0);
            result = 31 * result + (this.portalDescription != null ? this.portalDescription.hashCode() : 0);
            result = 31 * result + (this.portalType != null ? this.portalType.hashCode() : 0);
            result = 31 * result + (this.portalTypeConfiguration != null ? this.portalTypeConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
