package software.amazon.awscdk.services.iotwireless;

/**
 * Creates a gateway task definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnTaskDefinition cfnTaskDefinition = CfnTaskDefinition.Builder.create(this, "MyCfnTaskDefinition")
 *         .autoCreateTasks(false)
 *         // the properties below are optional
 *         .loRaWanUpdateGatewayTaskEntry(LoRaWANUpdateGatewayTaskEntryProperty.builder()
 *                 .currentVersion(LoRaWANGatewayVersionProperty.builder()
 *                         .model("model")
 *                         .packageVersion("packageVersion")
 *                         .station("station")
 *                         .build())
 *                 .updateVersion(LoRaWANGatewayVersionProperty.builder()
 *                         .model("model")
 *                         .packageVersion("packageVersion")
 *                         .station("station")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskDefinitionType("taskDefinitionType")
 *         .update(UpdateWirelessGatewayTaskCreateProperty.builder()
 *                 .loRaWan(LoRaWANUpdateGatewayTaskCreateProperty.builder()
 *                         .currentVersion(LoRaWANGatewayVersionProperty.builder()
 *                                 .model("model")
 *                                 .packageVersion("packageVersion")
 *                                 .station("station")
 *                                 .build())
 *                         .sigKeyCrc(123)
 *                         .updateSignature("updateSignature")
 *                         .updateVersion(LoRaWANGatewayVersionProperty.builder()
 *                                 .model("model")
 *                                 .packageVersion("packageVersion")
 *                                 .station("station")
 *                                 .build())
 *                         .build())
 *                 .updateDataRole("updateDataRole")
 *                 .updateDataSource("updateDataSource")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:20.680Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnTaskDefinition")
public class CfnTaskDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnTaskDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTaskDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotwireless.CfnTaskDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the new wireless gateway task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Whether to automatically create tasks using this task definition for all gateways with the specified current version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAutoCreateTasks() {
        return software.amazon.jsii.Kernel.get(this, "autoCreateTasks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to automatically create tasks using this task definition for all gateways with the specified current version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoCreateTasks(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoCreateTasks", java.util.Objects.requireNonNull(value, "autoCreateTasks is required"));
    }

    /**
     * Whether to automatically create tasks using this task definition for all gateways with the specified current version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoCreateTasks(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoCreateTasks", java.util.Objects.requireNonNull(value, "autoCreateTasks is required"));
    }

    /**
     * LoRaWANUpdateGatewayTaskEntry object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoRaWanUpdateGatewayTaskEntry() {
        return software.amazon.jsii.Kernel.get(this, "loRaWanUpdateGatewayTaskEntry", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * LoRaWANUpdateGatewayTaskEntry object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoRaWanUpdateGatewayTaskEntry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loRaWanUpdateGatewayTaskEntry", value);
    }

    /**
     * LoRaWANUpdateGatewayTaskEntry object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoRaWanUpdateGatewayTaskEntry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.LoRaWANUpdateGatewayTaskEntryProperty value) {
        software.amazon.jsii.Kernel.set(this, "loRaWanUpdateGatewayTaskEntry", value);
    }

    /**
     * The name of the new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the new resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * A filter to list only the wireless gateway task definitions that use this task definition type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTaskDefinitionType() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinitionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A filter to list only the wireless gateway task definitions that use this task definition type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskDefinitionType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "taskDefinitionType", value);
    }

    /**
     * Information about the gateways to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUpdate() {
        return software.amazon.jsii.Kernel.get(this, "update", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about the gateways to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "update", value);
    }

    /**
     * Information about the gateways to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.UpdateWirelessGatewayTaskCreateProperty value) {
        software.amazon.jsii.Kernel.set(this, "update", value);
    }
    /**
     * LoRaWANGatewayVersion object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * LoRaWANGatewayVersionProperty loRaWANGatewayVersionProperty = LoRaWANGatewayVersionProperty.builder()
     *         .model("model")
     *         .packageVersion("packageVersion")
     *         .station("station")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawangatewayversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawangatewayversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnTaskDefinition.LoRaWANGatewayVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(LoRaWANGatewayVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoRaWANGatewayVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The model number of the wireless gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawangatewayversion.html#cfn-iotwireless-taskdefinition-lorawangatewayversion-model">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawangatewayversion.html#cfn-iotwireless-taskdefinition-lorawangatewayversion-model</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModel() {
            return null;
        }

        /**
         * The version of the wireless gateway firmware.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawangatewayversion.html#cfn-iotwireless-taskdefinition-lorawangatewayversion-packageversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawangatewayversion.html#cfn-iotwireless-taskdefinition-lorawangatewayversion-packageversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPackageVersion() {
            return null;
        }

        /**
         * The basic station version of the wireless gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawangatewayversion.html#cfn-iotwireless-taskdefinition-lorawangatewayversion-station">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawangatewayversion.html#cfn-iotwireless-taskdefinition-lorawangatewayversion-station</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoRaWANGatewayVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoRaWANGatewayVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoRaWANGatewayVersionProperty> {
            java.lang.String model;
            java.lang.String packageVersion;
            java.lang.String station;

            /**
             * Sets the value of {@link LoRaWANGatewayVersionProperty#getModel}
             * @param model The model number of the wireless gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder model(java.lang.String model) {
                this.model = model;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANGatewayVersionProperty#getPackageVersion}
             * @param packageVersion The version of the wireless gateway firmware.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder packageVersion(java.lang.String packageVersion) {
                this.packageVersion = packageVersion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANGatewayVersionProperty#getStation}
             * @param station The basic station version of the wireless gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder station(java.lang.String station) {
                this.station = station;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoRaWANGatewayVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoRaWANGatewayVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoRaWANGatewayVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoRaWANGatewayVersionProperty {
            private final java.lang.String model;
            private final java.lang.String packageVersion;
            private final java.lang.String station;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.model = software.amazon.jsii.Kernel.get(this, "model", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.packageVersion = software.amazon.jsii.Kernel.get(this, "packageVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.station = software.amazon.jsii.Kernel.get(this, "station", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.model = builder.model;
                this.packageVersion = builder.packageVersion;
                this.station = builder.station;
            }

            @Override
            public final java.lang.String getModel() {
                return this.model;
            }

            @Override
            public final java.lang.String getPackageVersion() {
                return this.packageVersion;
            }

            @Override
            public final java.lang.String getStation() {
                return this.station;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getModel() != null) {
                    data.set("model", om.valueToTree(this.getModel()));
                }
                if (this.getPackageVersion() != null) {
                    data.set("packageVersion", om.valueToTree(this.getPackageVersion()));
                }
                if (this.getStation() != null) {
                    data.set("station", om.valueToTree(this.getStation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnTaskDefinition.LoRaWANGatewayVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoRaWANGatewayVersionProperty.Jsii$Proxy that = (LoRaWANGatewayVersionProperty.Jsii$Proxy) o;

                if (this.model != null ? !this.model.equals(that.model) : that.model != null) return false;
                if (this.packageVersion != null ? !this.packageVersion.equals(that.packageVersion) : that.packageVersion != null) return false;
                return this.station != null ? this.station.equals(that.station) : that.station == null;
            }

            @Override
            public final int hashCode() {
                int result = this.model != null ? this.model.hashCode() : 0;
                result = 31 * result + (this.packageVersion != null ? this.packageVersion.hashCode() : 0);
                result = 31 * result + (this.station != null ? this.station.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The signature used to verify the update firmware.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * LoRaWANUpdateGatewayTaskCreateProperty loRaWANUpdateGatewayTaskCreateProperty = LoRaWANUpdateGatewayTaskCreateProperty.builder()
     *         .currentVersion(LoRaWANGatewayVersionProperty.builder()
     *                 .model("model")
     *                 .packageVersion("packageVersion")
     *                 .station("station")
     *                 .build())
     *         .sigKeyCrc(123)
     *         .updateSignature("updateSignature")
     *         .updateVersion(LoRaWANGatewayVersionProperty.builder()
     *                 .model("model")
     *                 .packageVersion("packageVersion")
     *                 .station("station")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnTaskDefinition.LoRaWANUpdateGatewayTaskCreateProperty")
    @software.amazon.jsii.Jsii.Proxy(LoRaWANUpdateGatewayTaskCreateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoRaWANUpdateGatewayTaskCreateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The version of the gateways that should receive the update.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate-currentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate-currentversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCurrentVersion() {
            return null;
        }

        /**
         * The CRC of the signature private key to check.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate-sigkeycrc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate-sigkeycrc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSigKeyCrc() {
            return null;
        }

        /**
         * The signature used to verify the update firmware.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate-updatesignature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate-updatesignature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdateSignature() {
            return null;
        }

        /**
         * The firmware version to update the gateway to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate-updateversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskcreate-updateversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoRaWANUpdateGatewayTaskCreateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoRaWANUpdateGatewayTaskCreateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoRaWANUpdateGatewayTaskCreateProperty> {
            java.lang.Object currentVersion;
            java.lang.Number sigKeyCrc;
            java.lang.String updateSignature;
            java.lang.Object updateVersion;

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskCreateProperty#getCurrentVersion}
             * @param currentVersion The version of the gateways that should receive the update.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentVersion(software.amazon.awscdk.IResolvable currentVersion) {
                this.currentVersion = currentVersion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskCreateProperty#getCurrentVersion}
             * @param currentVersion The version of the gateways that should receive the update.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentVersion(software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.LoRaWANGatewayVersionProperty currentVersion) {
                this.currentVersion = currentVersion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskCreateProperty#getSigKeyCrc}
             * @param sigKeyCrc The CRC of the signature private key to check.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sigKeyCrc(java.lang.Number sigKeyCrc) {
                this.sigKeyCrc = sigKeyCrc;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskCreateProperty#getUpdateSignature}
             * @param updateSignature The signature used to verify the update firmware.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateSignature(java.lang.String updateSignature) {
                this.updateSignature = updateSignature;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskCreateProperty#getUpdateVersion}
             * @param updateVersion The firmware version to update the gateway to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateVersion(software.amazon.awscdk.IResolvable updateVersion) {
                this.updateVersion = updateVersion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskCreateProperty#getUpdateVersion}
             * @param updateVersion The firmware version to update the gateway to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateVersion(software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.LoRaWANGatewayVersionProperty updateVersion) {
                this.updateVersion = updateVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoRaWANUpdateGatewayTaskCreateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoRaWANUpdateGatewayTaskCreateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoRaWANUpdateGatewayTaskCreateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoRaWANUpdateGatewayTaskCreateProperty {
            private final java.lang.Object currentVersion;
            private final java.lang.Number sigKeyCrc;
            private final java.lang.String updateSignature;
            private final java.lang.Object updateVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.currentVersion = software.amazon.jsii.Kernel.get(this, "currentVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sigKeyCrc = software.amazon.jsii.Kernel.get(this, "sigKeyCrc", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.updateSignature = software.amazon.jsii.Kernel.get(this, "updateSignature", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.updateVersion = software.amazon.jsii.Kernel.get(this, "updateVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.currentVersion = builder.currentVersion;
                this.sigKeyCrc = builder.sigKeyCrc;
                this.updateSignature = builder.updateSignature;
                this.updateVersion = builder.updateVersion;
            }

            @Override
            public final java.lang.Object getCurrentVersion() {
                return this.currentVersion;
            }

            @Override
            public final java.lang.Number getSigKeyCrc() {
                return this.sigKeyCrc;
            }

            @Override
            public final java.lang.String getUpdateSignature() {
                return this.updateSignature;
            }

            @Override
            public final java.lang.Object getUpdateVersion() {
                return this.updateVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCurrentVersion() != null) {
                    data.set("currentVersion", om.valueToTree(this.getCurrentVersion()));
                }
                if (this.getSigKeyCrc() != null) {
                    data.set("sigKeyCrc", om.valueToTree(this.getSigKeyCrc()));
                }
                if (this.getUpdateSignature() != null) {
                    data.set("updateSignature", om.valueToTree(this.getUpdateSignature()));
                }
                if (this.getUpdateVersion() != null) {
                    data.set("updateVersion", om.valueToTree(this.getUpdateVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnTaskDefinition.LoRaWANUpdateGatewayTaskCreateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoRaWANUpdateGatewayTaskCreateProperty.Jsii$Proxy that = (LoRaWANUpdateGatewayTaskCreateProperty.Jsii$Proxy) o;

                if (this.currentVersion != null ? !this.currentVersion.equals(that.currentVersion) : that.currentVersion != null) return false;
                if (this.sigKeyCrc != null ? !this.sigKeyCrc.equals(that.sigKeyCrc) : that.sigKeyCrc != null) return false;
                if (this.updateSignature != null ? !this.updateSignature.equals(that.updateSignature) : that.updateSignature != null) return false;
                return this.updateVersion != null ? this.updateVersion.equals(that.updateVersion) : that.updateVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.currentVersion != null ? this.currentVersion.hashCode() : 0;
                result = 31 * result + (this.sigKeyCrc != null ? this.sigKeyCrc.hashCode() : 0);
                result = 31 * result + (this.updateSignature != null ? this.updateSignature.hashCode() : 0);
                result = 31 * result + (this.updateVersion != null ? this.updateVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * LoRaWANUpdateGatewayTaskEntry object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * LoRaWANUpdateGatewayTaskEntryProperty loRaWANUpdateGatewayTaskEntryProperty = LoRaWANUpdateGatewayTaskEntryProperty.builder()
     *         .currentVersion(LoRaWANGatewayVersionProperty.builder()
     *                 .model("model")
     *                 .packageVersion("packageVersion")
     *                 .station("station")
     *                 .build())
     *         .updateVersion(LoRaWANGatewayVersionProperty.builder()
     *                 .model("model")
     *                 .packageVersion("packageVersion")
     *                 .station("station")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnTaskDefinition.LoRaWANUpdateGatewayTaskEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(LoRaWANUpdateGatewayTaskEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoRaWANUpdateGatewayTaskEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The version of the gateways that should receive the update.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskentry.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry-currentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskentry.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry-currentversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCurrentVersion() {
            return null;
        }

        /**
         * The firmware version to update the gateway to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskentry.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry-updateversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-lorawanupdategatewaytaskentry.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry-updateversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoRaWANUpdateGatewayTaskEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoRaWANUpdateGatewayTaskEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoRaWANUpdateGatewayTaskEntryProperty> {
            java.lang.Object currentVersion;
            java.lang.Object updateVersion;

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskEntryProperty#getCurrentVersion}
             * @param currentVersion The version of the gateways that should receive the update.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentVersion(software.amazon.awscdk.IResolvable currentVersion) {
                this.currentVersion = currentVersion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskEntryProperty#getCurrentVersion}
             * @param currentVersion The version of the gateways that should receive the update.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentVersion(software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.LoRaWANGatewayVersionProperty currentVersion) {
                this.currentVersion = currentVersion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskEntryProperty#getUpdateVersion}
             * @param updateVersion The firmware version to update the gateway to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateVersion(software.amazon.awscdk.IResolvable updateVersion) {
                this.updateVersion = updateVersion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANUpdateGatewayTaskEntryProperty#getUpdateVersion}
             * @param updateVersion The firmware version to update the gateway to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateVersion(software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.LoRaWANGatewayVersionProperty updateVersion) {
                this.updateVersion = updateVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoRaWANUpdateGatewayTaskEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoRaWANUpdateGatewayTaskEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoRaWANUpdateGatewayTaskEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoRaWANUpdateGatewayTaskEntryProperty {
            private final java.lang.Object currentVersion;
            private final java.lang.Object updateVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.currentVersion = software.amazon.jsii.Kernel.get(this, "currentVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.updateVersion = software.amazon.jsii.Kernel.get(this, "updateVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.currentVersion = builder.currentVersion;
                this.updateVersion = builder.updateVersion;
            }

            @Override
            public final java.lang.Object getCurrentVersion() {
                return this.currentVersion;
            }

            @Override
            public final java.lang.Object getUpdateVersion() {
                return this.updateVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCurrentVersion() != null) {
                    data.set("currentVersion", om.valueToTree(this.getCurrentVersion()));
                }
                if (this.getUpdateVersion() != null) {
                    data.set("updateVersion", om.valueToTree(this.getUpdateVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnTaskDefinition.LoRaWANUpdateGatewayTaskEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoRaWANUpdateGatewayTaskEntryProperty.Jsii$Proxy that = (LoRaWANUpdateGatewayTaskEntryProperty.Jsii$Proxy) o;

                if (this.currentVersion != null ? !this.currentVersion.equals(that.currentVersion) : that.currentVersion != null) return false;
                return this.updateVersion != null ? this.updateVersion.equals(that.updateVersion) : that.updateVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.currentVersion != null ? this.currentVersion.hashCode() : 0;
                result = 31 * result + (this.updateVersion != null ? this.updateVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * UpdateWirelessGatewayTaskCreate object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * UpdateWirelessGatewayTaskCreateProperty updateWirelessGatewayTaskCreateProperty = UpdateWirelessGatewayTaskCreateProperty.builder()
     *         .loRaWan(LoRaWANUpdateGatewayTaskCreateProperty.builder()
     *                 .currentVersion(LoRaWANGatewayVersionProperty.builder()
     *                         .model("model")
     *                         .packageVersion("packageVersion")
     *                         .station("station")
     *                         .build())
     *                 .sigKeyCrc(123)
     *                 .updateSignature("updateSignature")
     *                 .updateVersion(LoRaWANGatewayVersionProperty.builder()
     *                         .model("model")
     *                         .packageVersion("packageVersion")
     *                         .station("station")
     *                         .build())
     *                 .build())
     *         .updateDataRole("updateDataRole")
     *         .updateDataSource("updateDataSource")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnTaskDefinition.UpdateWirelessGatewayTaskCreateProperty")
    @software.amazon.jsii.Jsii.Proxy(UpdateWirelessGatewayTaskCreateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpdateWirelessGatewayTaskCreateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties that relate to the LoRaWAN wireless gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate.html#cfn-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate-lorawan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate.html#cfn-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate-lorawan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLoRaWan() {
            return null;
        }

        /**
         * The IAM role used to read data from the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate.html#cfn-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate-updatedatarole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate.html#cfn-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate-updatedatarole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdateDataRole() {
            return null;
        }

        /**
         * The link to the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate.html#cfn-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate-updatedatasource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate.html#cfn-iotwireless-taskdefinition-updatewirelessgatewaytaskcreate-updatedatasource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdateDataSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UpdateWirelessGatewayTaskCreateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpdateWirelessGatewayTaskCreateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpdateWirelessGatewayTaskCreateProperty> {
            java.lang.Object loRaWan;
            java.lang.String updateDataRole;
            java.lang.String updateDataSource;

            /**
             * Sets the value of {@link UpdateWirelessGatewayTaskCreateProperty#getLoRaWan}
             * @param loRaWan The properties that relate to the LoRaWAN wireless gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loRaWan(software.amazon.awscdk.IResolvable loRaWan) {
                this.loRaWan = loRaWan;
                return this;
            }

            /**
             * Sets the value of {@link UpdateWirelessGatewayTaskCreateProperty#getLoRaWan}
             * @param loRaWan The properties that relate to the LoRaWAN wireless gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loRaWan(software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.LoRaWANUpdateGatewayTaskCreateProperty loRaWan) {
                this.loRaWan = loRaWan;
                return this;
            }

            /**
             * Sets the value of {@link UpdateWirelessGatewayTaskCreateProperty#getUpdateDataRole}
             * @param updateDataRole The IAM role used to read data from the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateDataRole(java.lang.String updateDataRole) {
                this.updateDataRole = updateDataRole;
                return this;
            }

            /**
             * Sets the value of {@link UpdateWirelessGatewayTaskCreateProperty#getUpdateDataSource}
             * @param updateDataSource The link to the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateDataSource(java.lang.String updateDataSource) {
                this.updateDataSource = updateDataSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpdateWirelessGatewayTaskCreateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpdateWirelessGatewayTaskCreateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpdateWirelessGatewayTaskCreateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpdateWirelessGatewayTaskCreateProperty {
            private final java.lang.Object loRaWan;
            private final java.lang.String updateDataRole;
            private final java.lang.String updateDataSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.loRaWan = software.amazon.jsii.Kernel.get(this, "loRaWan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.updateDataRole = software.amazon.jsii.Kernel.get(this, "updateDataRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.updateDataSource = software.amazon.jsii.Kernel.get(this, "updateDataSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.loRaWan = builder.loRaWan;
                this.updateDataRole = builder.updateDataRole;
                this.updateDataSource = builder.updateDataSource;
            }

            @Override
            public final java.lang.Object getLoRaWan() {
                return this.loRaWan;
            }

            @Override
            public final java.lang.String getUpdateDataRole() {
                return this.updateDataRole;
            }

            @Override
            public final java.lang.String getUpdateDataSource() {
                return this.updateDataSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLoRaWan() != null) {
                    data.set("loRaWan", om.valueToTree(this.getLoRaWan()));
                }
                if (this.getUpdateDataRole() != null) {
                    data.set("updateDataRole", om.valueToTree(this.getUpdateDataRole()));
                }
                if (this.getUpdateDataSource() != null) {
                    data.set("updateDataSource", om.valueToTree(this.getUpdateDataSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnTaskDefinition.UpdateWirelessGatewayTaskCreateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpdateWirelessGatewayTaskCreateProperty.Jsii$Proxy that = (UpdateWirelessGatewayTaskCreateProperty.Jsii$Proxy) o;

                if (this.loRaWan != null ? !this.loRaWan.equals(that.loRaWan) : that.loRaWan != null) return false;
                if (this.updateDataRole != null ? !this.updateDataRole.equals(that.updateDataRole) : that.updateDataRole != null) return false;
                return this.updateDataSource != null ? this.updateDataSource.equals(that.updateDataSource) : that.updateDataSource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.loRaWan != null ? this.loRaWan.hashCode() : 0;
                result = 31 * result + (this.updateDataRole != null ? this.updateDataRole.hashCode() : 0);
                result = 31 * result + (this.updateDataSource != null ? this.updateDataSource.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotwireless.CfnTaskDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotwireless.CfnTaskDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotwireless.CfnTaskDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotwireless.CfnTaskDefinitionProps.Builder();
        }

        /**
         * Whether to automatically create tasks using this task definition for all gateways with the specified current version.
         * <p>
         * If <code>false</code> , the task must be created by calling <code>CreateWirelessGatewayTask</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-autocreatetasks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-autocreatetasks</a>
         * @param autoCreateTasks Whether to automatically create tasks using this task definition for all gateways with the specified current version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoCreateTasks(final java.lang.Boolean autoCreateTasks) {
            this.props.autoCreateTasks(autoCreateTasks);
            return this;
        }
        /**
         * Whether to automatically create tasks using this task definition for all gateways with the specified current version.
         * <p>
         * If <code>false</code> , the task must be created by calling <code>CreateWirelessGatewayTask</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-autocreatetasks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-autocreatetasks</a>
         * @param autoCreateTasks Whether to automatically create tasks using this task definition for all gateways with the specified current version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoCreateTasks(final software.amazon.awscdk.IResolvable autoCreateTasks) {
            this.props.autoCreateTasks(autoCreateTasks);
            return this;
        }

        /**
         * LoRaWANUpdateGatewayTaskEntry object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry</a>
         * @param loRaWanUpdateGatewayTaskEntry LoRaWANUpdateGatewayTaskEntry object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWanUpdateGatewayTaskEntry(final software.amazon.awscdk.IResolvable loRaWanUpdateGatewayTaskEntry) {
            this.props.loRaWanUpdateGatewayTaskEntry(loRaWanUpdateGatewayTaskEntry);
            return this;
        }
        /**
         * LoRaWANUpdateGatewayTaskEntry object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-lorawanupdategatewaytaskentry</a>
         * @param loRaWanUpdateGatewayTaskEntry LoRaWANUpdateGatewayTaskEntry object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWanUpdateGatewayTaskEntry(final software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.LoRaWANUpdateGatewayTaskEntryProperty loRaWanUpdateGatewayTaskEntry) {
            this.props.loRaWanUpdateGatewayTaskEntry(loRaWanUpdateGatewayTaskEntry);
            return this;
        }

        /**
         * The name of the new resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-name</a>
         * @param name The name of the new resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The tags are an array of key-value pairs to attach to the specified resource.
         * <p>
         * Tags can have a minimum of 0 and a maximum of 50 items.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-tags</a>
         * @param tags The tags are an array of key-value pairs to attach to the specified resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A filter to list only the wireless gateway task definitions that use this task definition type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-taskdefinitiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-taskdefinitiontype</a>
         * @param taskDefinitionType A filter to list only the wireless gateway task definitions that use this task definition type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinitionType(final java.lang.String taskDefinitionType) {
            this.props.taskDefinitionType(taskDefinitionType);
            return this;
        }

        /**
         * Information about the gateways to update.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-update">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-update</a>
         * @param update Information about the gateways to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder update(final software.amazon.awscdk.IResolvable update) {
            this.props.update(update);
            return this;
        }
        /**
         * Information about the gateways to update.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-update">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-taskdefinition.html#cfn-iotwireless-taskdefinition-update</a>
         * @param update Information about the gateways to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder update(final software.amazon.awscdk.services.iotwireless.CfnTaskDefinition.UpdateWirelessGatewayTaskCreateProperty update) {
            this.props.update(update);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotwireless.CfnTaskDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotwireless.CfnTaskDefinition build() {
            return new software.amazon.awscdk.services.iotwireless.CfnTaskDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
