package software.amazon.awscdk.services.kinesis;

/**
 * The policy for a data stream or registered consumer.
 * <p>
 * Policies define the operations that are allowed on this resource.
 * <p>
 * You almost never need to define this construct directly.
 * <p>
 * All AWS resources that support resource policies have a method called
 * <code>addToResourcePolicy()</code>, which will automatically create a new resource
 * policy if one doesn't exist yet, otherwise it will add to the existing
 * policy.
 * <p>
 * Prefer to use <code>addToResourcePolicy()</code> instead.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stream stream = new Stream(this, "MyStream");
 * // create a custom policy document
 * PolicyDocument policyDocument = PolicyDocument.Builder.create()
 *         .assignSids(true)
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("kinesis:GetRecords"))
 *                     .resources(List.of(stream.getStreamArn()))
 *                     .principals(List.of(new AnyPrincipal()))
 *                     .build()))
 *         .build();
 * // create a resource policy manually
 * // create a resource policy manually
 * ResourcePolicy.Builder.create(this, "ResourcePolicy")
 *         .stream(stream)
 *         .policyDocument(policyDocument)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:20.869Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesis.ResourcePolicy")
public class ResourcePolicy extends software.amazon.awscdk.Resource {

    protected ResourcePolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResourcePolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ResourcePolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.ResourcePolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The IAM policy document for this policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesis.ResourcePolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesis.ResourcePolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kinesis.ResourcePolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kinesis.ResourcePolicyProps.Builder();
        }

        /**
         * The stream this policy applies to.
         * <p>
         * @return {@code this}
         * @param stream The stream this policy applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(final software.amazon.awscdk.services.kinesis.IStream stream) {
            this.props.stream(stream);
            return this;
        }

        /**
         * IAM policy document to apply to a data stream.
         * <p>
         * Default: - empty policy document
         * <p>
         * @return {@code this}
         * @param policyDocument IAM policy document to apply to a data stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(final software.amazon.awscdk.services.iam.PolicyDocument policyDocument) {
            this.props.policyDocument(policyDocument);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesis.ResourcePolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesis.ResourcePolicy build() {
            return new software.amazon.awscdk.services.kinesis.ResourcePolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
