package software.amazon.awscdk.services.lambda;

/**
 * Defines a Lambda function url.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * FunctionUrl fnUrl = fn.addFunctionUrl(FunctionUrlOptions.builder()
 *         .authType(FunctionUrlAuthType.AWS_IAM)
 *         .build());
 * Distribution.Builder.create(this, "MyDistribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(FunctionUrlOrigin.withOriginAccessControl(fnUrl))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:21.294Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.FunctionUrl")
public class FunctionUrl extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.lambda.IFunctionUrl {

    protected FunctionUrl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FunctionUrl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FunctionUrl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrlProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Grant the given identity permissions to invoke this Lambda Function URL.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeUrl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantInvokeUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The authentication type used for this Function URL.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrlAuthType getAuthType() {
        return software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrlAuthType.class));
    }

    /**
     * The ARN of the function this URL refers to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The url of the Lambda function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUrl() {
        return software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.FunctionUrl}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.FunctionUrl> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.FunctionUrlProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.FunctionUrlProps.Builder();
        }

        /**
         * The type of authentication that your function URL uses.
         * <p>
         * Default: FunctionUrlAuthType.AWS_IAM
         * <p>
         * @return {@code this}
         * @param authType The type of authentication that your function URL uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(final software.amazon.awscdk.services.lambda.FunctionUrlAuthType authType) {
            this.props.authType(authType);
            return this;
        }

        /**
         * The cross-origin resource sharing (CORS) settings for your function URL.
         * <p>
         * Default: - No CORS configuration.
         * <p>
         * @return {@code this}
         * @param cors The cross-origin resource sharing (CORS) settings for your function URL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(final software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions cors) {
            this.props.cors(cors);
            return this;
        }

        /**
         * The type of invocation mode that your Lambda function uses.
         * <p>
         * Default: InvokeMode.BUFFERED
         * <p>
         * @return {@code this}
         * @param invokeMode The type of invocation mode that your Lambda function uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invokeMode(final software.amazon.awscdk.services.lambda.InvokeMode invokeMode) {
            this.props.invokeMode(invokeMode);
            return this;
        }

        /**
         * The function to which this url refers.
         * <p>
         * It can also be an <code>Alias</code> but not a <code>Version</code>.
         * <p>
         * @return {@code this}
         * @param function The function to which this url refers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder function(final software.amazon.awscdk.services.lambda.IFunction function) {
            this.props.function(function);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.FunctionUrl}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.FunctionUrl build() {
            return new software.amazon.awscdk.services.lambda.FunctionUrl(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
