package software.amazon.awscdk.services.omics;

/**
 * Properties for defining a <code>CfnAnnotationStore</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.omics.*;
 * Object schema;
 * CfnAnnotationStoreProps cfnAnnotationStoreProps = CfnAnnotationStoreProps.builder()
 *         .name("name")
 *         .storeFormat("storeFormat")
 *         // the properties below are optional
 *         .description("description")
 *         .reference(ReferenceItemProperty.builder()
 *                 .referenceArn("referenceArn")
 *                 .build())
 *         .sseConfig(SseConfigProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .keyArn("keyArn")
 *                 .build())
 *         .storeOptions(StoreOptionsProperty.builder()
 *                 .tsvStoreOptions(TsvStoreOptionsProperty.builder()
 *                         .annotationType("annotationType")
 *                         .formatToHeader(Map.of(
 *                                 "formatToHeaderKey", "formatToHeader"))
 *                         .schema(schema)
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:22.363Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnAnnotationStoreProps")
@software.amazon.jsii.Jsii.Proxy(CfnAnnotationStoreProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAnnotationStoreProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Annotation Store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The annotation file format of the store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-storeformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-storeformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStoreFormat();

    /**
     * A description for the store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The genome reference for the store's annotations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-reference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-reference</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReference() {
        return null;
    }

    /**
     * The store's server-side encryption (SSE) settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-sseconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-sseconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseConfig() {
        return null;
    }

    /**
     * File parsing options for the annotation store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-storeoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-storeoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStoreOptions() {
        return null;
    }

    /**
     * Tags for the store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAnnotationStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAnnotationStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAnnotationStoreProps> {
        java.lang.String name;
        java.lang.String storeFormat;
        java.lang.String description;
        java.lang.Object reference;
        java.lang.Object sseConfig;
        java.lang.Object storeOptions;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getName}
         * @param name The name of the Annotation Store. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getStoreFormat}
         * @param storeFormat The annotation file format of the store. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storeFormat(java.lang.String storeFormat) {
            this.storeFormat = storeFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getDescription}
         * @param description A description for the store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getReference}
         * @param reference The genome reference for the store's annotations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reference(software.amazon.awscdk.IResolvable reference) {
            this.reference = reference;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getReference}
         * @param reference The genome reference for the store's annotations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reference(software.amazon.awscdk.services.omics.CfnAnnotationStore.ReferenceItemProperty reference) {
            this.reference = reference;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getSseConfig}
         * @param sseConfig The store's server-side encryption (SSE) settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfig(software.amazon.awscdk.IResolvable sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getSseConfig}
         * @param sseConfig The store's server-side encryption (SSE) settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfig(software.amazon.awscdk.services.omics.CfnAnnotationStore.SseConfigProperty sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getStoreOptions}
         * @param storeOptions File parsing options for the annotation store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storeOptions(software.amazon.awscdk.IResolvable storeOptions) {
            this.storeOptions = storeOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getStoreOptions}
         * @param storeOptions File parsing options for the annotation store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storeOptions(software.amazon.awscdk.services.omics.CfnAnnotationStore.StoreOptionsProperty storeOptions) {
            this.storeOptions = storeOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnnotationStoreProps#getTags}
         * @param tags Tags for the store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAnnotationStoreProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAnnotationStoreProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAnnotationStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAnnotationStoreProps {
        private final java.lang.String name;
        private final java.lang.String storeFormat;
        private final java.lang.String description;
        private final java.lang.Object reference;
        private final java.lang.Object sseConfig;
        private final java.lang.Object storeOptions;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storeFormat = software.amazon.jsii.Kernel.get(this, "storeFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.reference = software.amazon.jsii.Kernel.get(this, "reference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sseConfig = software.amazon.jsii.Kernel.get(this, "sseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.storeOptions = software.amazon.jsii.Kernel.get(this, "storeOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.storeFormat = java.util.Objects.requireNonNull(builder.storeFormat, "storeFormat is required");
            this.description = builder.description;
            this.reference = builder.reference;
            this.sseConfig = builder.sseConfig;
            this.storeOptions = builder.storeOptions;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getStoreFormat() {
            return this.storeFormat;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getReference() {
            return this.reference;
        }

        @Override
        public final java.lang.Object getSseConfig() {
            return this.sseConfig;
        }

        @Override
        public final java.lang.Object getStoreOptions() {
            return this.storeOptions;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("storeFormat", om.valueToTree(this.getStoreFormat()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getReference() != null) {
                data.set("reference", om.valueToTree(this.getReference()));
            }
            if (this.getSseConfig() != null) {
                data.set("sseConfig", om.valueToTree(this.getSseConfig()));
            }
            if (this.getStoreOptions() != null) {
                data.set("storeOptions", om.valueToTree(this.getStoreOptions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnAnnotationStoreProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAnnotationStoreProps.Jsii$Proxy that = (CfnAnnotationStoreProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!storeFormat.equals(that.storeFormat)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.reference != null ? !this.reference.equals(that.reference) : that.reference != null) return false;
            if (this.sseConfig != null ? !this.sseConfig.equals(that.sseConfig) : that.sseConfig != null) return false;
            if (this.storeOptions != null ? !this.storeOptions.equals(that.storeOptions) : that.storeOptions != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.storeFormat.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.reference != null ? this.reference.hashCode() : 0);
            result = 31 * result + (this.sseConfig != null ? this.sseConfig.hashCode() : 0);
            result = 31 * result + (this.storeOptions != null ? this.storeOptions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
