package software.amazon.awscdk.services.proton;

/**
 * Properties for defining a <code>CfnEnvironmentAccountConnection</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.proton.*;
 * CfnEnvironmentAccountConnectionProps cfnEnvironmentAccountConnectionProps = CfnEnvironmentAccountConnectionProps.builder()
 *         .codebuildRoleArn("codebuildRoleArn")
 *         .componentRoleArn("componentRoleArn")
 *         .environmentAccountId("environmentAccountId")
 *         .environmentName("environmentName")
 *         .managementAccountId("managementAccountId")
 *         .roleArn("roleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:22.797Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_proton.CfnEnvironmentAccountConnectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentAccountConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentAccountConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of an IAM service role in the environment account.
     * <p>
     * AWS Proton uses this role to provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-codebuildrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-codebuildrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCodebuildRoleArn() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM service role that AWS Proton uses when provisioning directly defined components in the associated environment account.
     * <p>
     * It determines the scope of infrastructure that a component can provision in the account.
     * <p>
     * The environment account connection must have a <code>componentRoleArn</code> to allow directly defined components to be associated with any environments running in the account.
     * <p>
     * For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">AWS Proton components</a> in the <em>AWS Proton User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-componentrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-componentrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComponentRoleArn() {
        return null;
    }

    /**
     * The environment account that's connected to the environment account connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-environmentaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-environmentaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentAccountId() {
        return null;
    }

    /**
     * The name of the environment that's associated with the environment account connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-environmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-environmentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentName() {
        return null;
    }

    /**
     * The ID of the management account that's connected to the environment account connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-managementaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-managementaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getManagementAccountId() {
        return null;
    }

    /**
     * The IAM service role that's associated with the environment account connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * An optional list of metadata items that you can associate with the AWS Proton environment account connection.
     * <p>
     * A tag is a key-value pair.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton resources and tagging</a> in the <em>AWS Proton User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-proton-environmentaccountconnection.html#cfn-proton-environmentaccountconnection-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentAccountConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentAccountConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentAccountConnectionProps> {
        java.lang.String codebuildRoleArn;
        java.lang.String componentRoleArn;
        java.lang.String environmentAccountId;
        java.lang.String environmentName;
        java.lang.String managementAccountId;
        java.lang.String roleArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEnvironmentAccountConnectionProps#getCodebuildRoleArn}
         * @param codebuildRoleArn The Amazon Resource Name (ARN) of an IAM service role in the environment account.
         *                         AWS Proton uses this role to provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codebuildRoleArn(java.lang.String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentAccountConnectionProps#getComponentRoleArn}
         * @param componentRoleArn The Amazon Resource Name (ARN) of the IAM service role that AWS Proton uses when provisioning directly defined components in the associated environment account.
         *                         It determines the scope of infrastructure that a component can provision in the account.
         *                         <p>
         *                         The environment account connection must have a <code>componentRoleArn</code> to allow directly defined components to be associated with any environments running in the account.
         *                         <p>
         *                         For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">AWS Proton components</a> in the <em>AWS Proton User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentRoleArn(java.lang.String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentAccountConnectionProps#getEnvironmentAccountId}
         * @param environmentAccountId The environment account that's connected to the environment account connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentAccountId(java.lang.String environmentAccountId) {
            this.environmentAccountId = environmentAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentAccountConnectionProps#getEnvironmentName}
         * @param environmentName The name of the environment that's associated with the environment account connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(java.lang.String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentAccountConnectionProps#getManagementAccountId}
         * @param managementAccountId The ID of the management account that's connected to the environment account connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managementAccountId(java.lang.String managementAccountId) {
            this.managementAccountId = managementAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentAccountConnectionProps#getRoleArn}
         * @param roleArn The IAM service role that's associated with the environment account connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentAccountConnectionProps#getTags}
         * @param tags An optional list of metadata items that you can associate with the AWS Proton environment account connection.
         *             A tag is a key-value pair.
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">AWS Proton resources and tagging</a> in the <em>AWS Proton User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentAccountConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentAccountConnectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentAccountConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentAccountConnectionProps {
        private final java.lang.String codebuildRoleArn;
        private final java.lang.String componentRoleArn;
        private final java.lang.String environmentAccountId;
        private final java.lang.String environmentName;
        private final java.lang.String managementAccountId;
        private final java.lang.String roleArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.codebuildRoleArn = software.amazon.jsii.Kernel.get(this, "codebuildRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.componentRoleArn = software.amazon.jsii.Kernel.get(this, "componentRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentAccountId = software.amazon.jsii.Kernel.get(this, "environmentAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentName = software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.managementAccountId = software.amazon.jsii.Kernel.get(this, "managementAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.codebuildRoleArn = builder.codebuildRoleArn;
            this.componentRoleArn = builder.componentRoleArn;
            this.environmentAccountId = builder.environmentAccountId;
            this.environmentName = builder.environmentName;
            this.managementAccountId = builder.managementAccountId;
            this.roleArn = builder.roleArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCodebuildRoleArn() {
            return this.codebuildRoleArn;
        }

        @Override
        public final java.lang.String getComponentRoleArn() {
            return this.componentRoleArn;
        }

        @Override
        public final java.lang.String getEnvironmentAccountId() {
            return this.environmentAccountId;
        }

        @Override
        public final java.lang.String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final java.lang.String getManagementAccountId() {
            return this.managementAccountId;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCodebuildRoleArn() != null) {
                data.set("codebuildRoleArn", om.valueToTree(this.getCodebuildRoleArn()));
            }
            if (this.getComponentRoleArn() != null) {
                data.set("componentRoleArn", om.valueToTree(this.getComponentRoleArn()));
            }
            if (this.getEnvironmentAccountId() != null) {
                data.set("environmentAccountId", om.valueToTree(this.getEnvironmentAccountId()));
            }
            if (this.getEnvironmentName() != null) {
                data.set("environmentName", om.valueToTree(this.getEnvironmentName()));
            }
            if (this.getManagementAccountId() != null) {
                data.set("managementAccountId", om.valueToTree(this.getManagementAccountId()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_proton.CfnEnvironmentAccountConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentAccountConnectionProps.Jsii$Proxy that = (CfnEnvironmentAccountConnectionProps.Jsii$Proxy) o;

            if (this.codebuildRoleArn != null ? !this.codebuildRoleArn.equals(that.codebuildRoleArn) : that.codebuildRoleArn != null) return false;
            if (this.componentRoleArn != null ? !this.componentRoleArn.equals(that.componentRoleArn) : that.componentRoleArn != null) return false;
            if (this.environmentAccountId != null ? !this.environmentAccountId.equals(that.environmentAccountId) : that.environmentAccountId != null) return false;
            if (this.environmentName != null ? !this.environmentName.equals(that.environmentName) : that.environmentName != null) return false;
            if (this.managementAccountId != null ? !this.managementAccountId.equals(that.managementAccountId) : that.managementAccountId != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.codebuildRoleArn != null ? this.codebuildRoleArn.hashCode() : 0;
            result = 31 * result + (this.componentRoleArn != null ? this.componentRoleArn.hashCode() : 0);
            result = 31 * result + (this.environmentAccountId != null ? this.environmentAccountId.hashCode() : 0);
            result = 31 * result + (this.environmentName != null ? this.environmentName.hashCode() : 0);
            result = 31 * result + (this.managementAccountId != null ? this.managementAccountId.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
