package software.amazon.awscdk.services.route53;

/**
 * The <code>AWS::Route53::HealthCheck</code> resource is a Route 53 resource type that contains settings for a Route 53 health check.
 * <p>
 * For information about associating health checks with records, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId">HealthCheckId</a> in <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html">ChangeResourceRecordSets</a> .
 * <p>
 * <blockquote>
 * <p>
 * You can't create a health check with simple routing.
 * <p>
 * </blockquote>
 * <p>
 * <em>ELB Load Balancers</em>
 * <p>
 * If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you configure settings for an ELB health check, which performs a similar function to a Route 53 health check.
 * <p>
 * <em>Private Hosted Zones</em>
 * <p>
 * You can associate health checks with failover records in a private hosted zone. Note the following:
 * <p>
 * <ul>
 * <li>Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you must assign a public IP address to the instance in the VPC.</li>
 * <li>You can configure a health checker to check the health of an external resource that the instance relies on, such as a database server.</li>
 * <li>You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the Amazon EC2 <code>StatusCheckFailed</code> metric, add an alarm to the metric, and then create a health check that is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the CloudWatch console, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a> .</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CfnHealthCheck cfnHealthCheck = CfnHealthCheck.Builder.create(this, "MyCfnHealthCheck")
 *         .healthCheckConfig(HealthCheckConfigProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .alarmIdentifier(AlarmIdentifierProperty.builder()
 *                         .name("name")
 *                         .region("region")
 *                         .build())
 *                 .childHealthChecks(List.of("childHealthChecks"))
 *                 .enableSni(false)
 *                 .failureThreshold(123)
 *                 .fullyQualifiedDomainName("fullyQualifiedDomainName")
 *                 .healthThreshold(123)
 *                 .insufficientDataHealthStatus("insufficientDataHealthStatus")
 *                 .inverted(false)
 *                 .ipAddress("ipAddress")
 *                 .measureLatency(false)
 *                 .port(123)
 *                 .regions(List.of("regions"))
 *                 .requestInterval(123)
 *                 .resourcePath("resourcePath")
 *                 .routingControlArn("routingControlArn")
 *                 .searchString("searchString")
 *                 .build())
 *         // the properties below are optional
 *         .healthCheckTags(List.of(HealthCheckTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:26.158Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnHealthCheck")
public class CfnHealthCheck extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnHealthCheck(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnHealthCheck(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53.CfnHealthCheck.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnHealthCheck(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CfnHealthCheckProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The identifier that Amazon Route 53 assigned to the health check when you created it.
     * <p>
     * When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrHealthCheckId() {
        return software.amazon.jsii.Kernel.get(this, "attrHealthCheckId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A complex type that contains detailed information about one health check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getHealthCheckConfig() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A complex type that contains detailed information about one health check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckConfig", java.util.Objects.requireNonNull(value, "healthCheckConfig is required"));
    }

    /**
     * A complex type that contains detailed information about one health check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CfnHealthCheck.HealthCheckConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckConfig", java.util.Objects.requireNonNull(value, "healthCheckConfig is required"));
    }

    /**
     * The <code>HealthCheckTags</code> property describes key-value pairs that are associated with an <code>AWS::Route53::HealthCheck</code> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheckTags() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The <code>HealthCheckTags</code> property describes key-value pairs that are associated with an <code>AWS::Route53::HealthCheck</code> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckTags", value);
    }

    /**
     * The <code>HealthCheckTags</code> property describes key-value pairs that are associated with an <code>AWS::Route53::HealthCheck</code> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.route53.CfnHealthCheck.HealthCheckTagProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.route53.CfnHealthCheck.HealthCheckTagProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "healthCheckTags", value);
    }
    /**
     * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * AlarmIdentifierProperty alarmIdentifierProperty = AlarmIdentifierProperty.builder()
     *         .name("name")
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnHealthCheck.AlarmIdentifierProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmIdentifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmIdentifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.
         * <p>
         * <blockquote>
         * <p>
         * Route 53 supports CloudWatch alarms with the following features:
         * <p>
         * <ul>
         * <li>Standard-resolution metrics. High-resolution metrics aren't supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the <em>Amazon CloudWatch User Guide</em> .</li>
         * <li>Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended statistics aren't supported.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html#cfn-route53-healthcheck-alarmidentifier-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html#cfn-route53-healthcheck-alarmidentifier-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * For the CloudWatch alarm that you want Route 53 health checkers to use to determine whether this health check is healthy, the region that the alarm was created in.
         * <p>
         * For the current list of CloudWatch regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/cw_region.html">Amazon CloudWatch endpoints and quotas</a> in the <em>Amazon Web Services General Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html#cfn-route53-healthcheck-alarmidentifier-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html#cfn-route53-healthcheck-alarmidentifier-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * @return a {@link Builder} of {@link AlarmIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmIdentifierProperty> {
            java.lang.String name;
            java.lang.String region;

            /**
             * Sets the value of {@link AlarmIdentifierProperty#getName}
             * @param name The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy. This parameter is required.
             *             <blockquote>
             *             <p>
             *             Route 53 supports CloudWatch alarms with the following features:
             *             <p>
             *             <ul>
             *             <li>Standard-resolution metrics. High-resolution metrics aren't supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the <em>Amazon CloudWatch User Guide</em> .</li>
             *             <li>Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended statistics aren't supported.</li>
             *             </ul>
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AlarmIdentifierProperty#getRegion}
             * @param region For the CloudWatch alarm that you want Route 53 health checkers to use to determine whether this health check is healthy, the region that the alarm was created in. This parameter is required.
             *               For the current list of CloudWatch regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/cw_region.html">Amazon CloudWatch endpoints and quotas</a> in the <em>Amazon Web Services General Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmIdentifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmIdentifierProperty {
            private final java.lang.String name;
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("region", om.valueToTree(this.getRegion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CfnHealthCheck.AlarmIdentifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmIdentifierProperty.Jsii$Proxy that = (AlarmIdentifierProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.region.equals(that.region);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.region.hashCode());
                return result;
            }
        }
    }
    /**
     * A complex type that contains information about the health check.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * HealthCheckConfigProperty healthCheckConfigProperty = HealthCheckConfigProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .alarmIdentifier(AlarmIdentifierProperty.builder()
     *                 .name("name")
     *                 .region("region")
     *                 .build())
     *         .childHealthChecks(List.of("childHealthChecks"))
     *         .enableSni(false)
     *         .failureThreshold(123)
     *         .fullyQualifiedDomainName("fullyQualifiedDomainName")
     *         .healthThreshold(123)
     *         .insufficientDataHealthStatus("insufficientDataHealthStatus")
     *         .inverted(false)
     *         .ipAddress("ipAddress")
     *         .measureLatency(false)
     *         .port(123)
     *         .regions(List.of("regions"))
     *         .requestInterval(123)
     *         .resourcePath("resourcePath")
     *         .routingControlArn("routingControlArn")
     *         .searchString("searchString")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnHealthCheck.HealthCheckConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an endpoint is healthy.
         * <p>
         * <blockquote>
         * <p>
         * You can't change the value of <code>Type</code> after you create a health check.
         * <p>
         * </blockquote>
         * <p>
         * You can create the following types of health checks:
         * <p>
         * <ul>
         * <li><em>HTTP</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.</li>
         * <li><em>HTTPS</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>HTTPS</code> for the value of <code>Type</code> , the endpoint must support TLS v1.0 or later.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><em>HTTP_STR_MATCH</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and searches the first 5,120 bytes of the response body for the string that you specify in <code>SearchString</code> .</li>
         * <li><em>HTTPS_STR_MATCH</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string that you specify in <code>SearchString</code> .</li>
         * <li><em>TCP</em> : Route 53 tries to establish a TCP connection.</li>
         * <li><em>CLOUDWATCH_METRIC</em> : The health check is associated with a CloudWatch alarm. If the state of the alarm is <code>OK</code> , the health check is considered healthy. If the state is <code>ALARM</code> , the health check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the state is <code>OK</code> or <code>ALARM</code> , the health check status depends on the setting for <code>InsufficientDataHealthStatus</code> : <code>Healthy</code> , <code>Unhealthy</code> , or <code>LastKnownStatus</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Route 53 supports CloudWatch alarms with the following features:
         * <p>
         * <ul>
         * <li>Standard-resolution metrics. High-resolution metrics aren't supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the <em>Amazon CloudWatch User Guide</em> .</li>
         * <li>Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended statistics aren't supported.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><em>CALCULATED</em> : For health checks that monitor the status of other health checks, Route 53 adds up the number of health checks that Route 53 health checkers consider to be healthy and compares that number with the value of <code>HealthThreshold</code> .</li>
         * <li><em>RECOVERY_CONTROL</em> : The health check is assocated with a Route53 Application Recovery Controller routing control. If the routing control state is <code>ON</code> , the health check is considered healthy. If the state is <code>OFF</code> , the health check is considered unhealthy.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <em>Amazon Route 53 Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-alarmidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-alarmidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlarmIdentifier() {
            return null;
        }

        /**
         * (CALCULATED Health Checks Only) A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a <code>CALCULATED</code> health check.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-childhealthchecks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-childhealthchecks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getChildHealthChecks() {
            return null;
        }

        /**
         * Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during TLS negotiation.
         * <p>
         * This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.
         * <p>
         * Some endpoints require that <code>HTTPS</code> requests include the host name in the <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be <code>SSL alert handshake_failure</code> . A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.
         * <p>
         * The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code> . If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code> , a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-enablesni">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-enablesni</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableSni() {
            return null;
        }

        /**
         * The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <em>Amazon Route 53 Developer Guide</em> .
         * <p>
         * If you don't specify a value for <code>FailureThreshold</code> , the default value is three health checks.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-failurethreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-failurethreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFailureThreshold() {
            return null;
        }

        /**
         * Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code> .
         * <p>
         * <em>If you specify a value for</em> <code>IPAddress</code> :
         * <p>
         * Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.
         * <p>
         * When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:
         * <p>
         * <ul>
         * <li>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for <code>Type</code> , Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the Host header.</li>
         * <li>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for <code>Type</code> , Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</li>
         * <li>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code> , Route 53 passes <code>FullyQualifiedDomainName:Port</code> to the endpoint in the <code>Host</code> header.</li>
         * </ul>
         * <p>
         * If you don't specify a value for <code>FullyQualifiedDomainName</code> , Route 53 substitutes the value of <code>IPAddress</code> in the <code>Host</code> header in each of the preceding cases.
         * <p>
         * <em>If you don't specify a value for <code>IPAddress</code></em> :
         * <p>
         * Route 53 sends a DNS request to the domain that you specify for <code>FullyQualifiedDomainName</code> at the interval that you specify for <code>RequestInterval</code> . Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.
         * <p>
         * <blockquote>
         * <p>
         * If you don't specify a value for <code>IPAddress</code> , Route 53 uses only IPv4 to send health checks to the endpoint. If there's no record with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code> , the health check fails with a "DNS resolution failed" error.
         * <p>
         * </blockquote>
         * <p>
         * If you want to check the health of multiple records that have the same name and type, such as multiple weighted records, and if you choose to specify the endpoint only by <code>FullyQualifiedDomainName</code> , we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code> , specify the domain name of the server (such as us-east-2-www.example.com), not the name of the records (www.example.com).
         * <p>
         * <blockquote>
         * <p>
         * In this configuration, if you create a health check for which the value of <code>FullyQualifiedDomainName</code> matches the name of the records and you then associate the health check with those records, health check results will be unpredictable.
         * <p>
         * </blockquote>
         * <p>
         * In addition, if the value that you specify for <code>Type</code> is <code>HTTP</code> , <code>HTTPS</code> , <code>HTTP_STR_MATCH</code> , or <code>HTTPS_STR_MATCH</code> , Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for <code>IPAddress</code> . If the value of <code>Type</code> is <code>TCP</code> , Route 53 doesn't pass a <code>Host</code> header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-fullyqualifieddomainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-fullyqualifieddomainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFullyQualifiedDomainName() {
            return null;
        }

        /**
         * The number of child health checks that are associated with a <code>CALCULATED</code> health check that Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy.
         * <p>
         * To specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks">ChildHealthChecks</a> element.
         * <p>
         * Note the following:
         * <p>
         * <ul>
         * <li>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</li>
         * <li>If you specify <code>0</code> , Route 53 always considers this health check to be healthy.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-healththreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-healththreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHealthThreshold() {
            return null;
        }

        /**
         * When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:  - <code>Healthy</code> : Route 53 considers the health check to be healthy.
         * <p>
         * <ul>
         * <li><code>Unhealthy</code> : Route 53 considers the health check to be unhealthy.</li>
         * <li><code>LastKnownStatus</code> : Route 53 uses the status of the health check from the last time that CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-insufficientdatahealthstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-insufficientdatahealthstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInsufficientDataHealthStatus() {
            return null;
        }

        /**
         * Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-inverted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-inverted</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInverted() {
            return null;
        }

        /**
         * The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to perform health checks on.
         * <p>
         * If you don't specify a value for <code>IPAddress</code> , Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in <code>RequestInterval</code> . Using an IP address returned by DNS, Route 53 then checks the health of the endpoint.
         * <p>
         * Use one of the following formats for the value of <code>IPAddress</code> :
         * <p>
         * <ul>
         * <li><em>IPv4 address</em> : four values between 0 and 255, separated by periods (.), for example, <code>192.0.2.44</code> .</li>
         * <li><em>IPv6 address</em> : eight groups of four hexadecimal values, separated by colons (:), for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code> . You can also shorten IPv6 addresses as described in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code> .</li>
         * </ul>
         * <p>
         * If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code> . This ensures that the IP address of your instance will never change.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a> .
         * <p>
         * Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can't create health checks, see the following documents:
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a></li>
         * <li><a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a></li>
         * <li><a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a></li>
         * </ul>
         * <p>
         * When the value of <code>Type</code> is <code>CALCULATED</code> or <code>CLOUDWATCH_METRIC</code> , omit <code>IPAddress</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-ipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-ipaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpAddress() {
            return null;
        }

        /**
         * Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the <em>Health Checks</em> page in the Route 53 console.
         * <p>
         * <blockquote>
         * <p>
         * You can't change the value of <code>MeasureLatency</code> after you create a health check.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-measurelatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-measurelatency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMeasureLatency() {
            return null;
        }

        /**
         * The port on the endpoint that you want Amazon Route 53 to perform health checks on.
         * <p>
         * <blockquote>
         * <p>
         * Don't specify a value for <code>Port</code> when you specify a value for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-type">Type</a> of <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * A complex type that contains one <code>Region</code> element for each region from which you want Amazon Route 53 health checkers to check the specified endpoint.
         * <p>
         * If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the regions that are listed under <em>Valid Values</em> .
         * <p>
         * If you update a health check to remove a region that has been performing health checks, Route 53 will briefly continue to perform checks from that region to ensure that some health checkers are always checking the endpoint (for example, if you replace three regions with four different regions).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-regions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-regions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegions() {
            return null;
        }

        /**
         * The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health check request.
         * <p>
         * Each Route 53 health checker makes requests at this interval.
         * <p>
         * <blockquote>
         * <p>
         * You can't change the value of <code>RequestInterval</code> after you create a health check.
         * <p>
         * </blockquote>
         * <p>
         * If you don't specify a value for <code>RequestInterval</code> , the default value is <code>30</code> seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-requestinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-requestinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRequestInterval() {
            return null;
        }

        /**
         * The path, if any, that you want Amazon Route 53 to request when performing health checks.
         * <p>
         * The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example, the file /docs/route53-health-check.html. You can also include query string parameters, for example, <code>/welcome.html?language=jp&amp;login=y</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-resourcepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-resourcepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourcePath() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control.
         * <p>
         * For more information about Route 53 Application Recovery Controller, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route-53-recovery.html">Route 53 Application Recovery Controller Developer Guide.</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-routingcontrolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-routingcontrolarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoutingControlArn() {
            return null;
        }

        /**
         * If the value of Type is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code> , the string that you want Amazon Route 53 to search for in the response body from the specified resource.
         * <p>
         * If the string appears in the response body, Route 53 considers the resource healthy.
         * <p>
         * Route 53 considers case when searching for <code>SearchString</code> in the response body.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-searchstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-searchstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSearchString() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthCheckConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckConfigProperty> {
            java.lang.String type;
            java.lang.Object alarmIdentifier;
            java.util.List<java.lang.String> childHealthChecks;
            java.lang.Object enableSni;
            java.lang.Number failureThreshold;
            java.lang.String fullyQualifiedDomainName;
            java.lang.Number healthThreshold;
            java.lang.String insufficientDataHealthStatus;
            java.lang.Object inverted;
            java.lang.String ipAddress;
            java.lang.Object measureLatency;
            java.lang.Number port;
            java.util.List<java.lang.String> regions;
            java.lang.Number requestInterval;
            java.lang.String resourcePath;
            java.lang.String routingControlArn;
            java.lang.String searchString;

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getType}
             * @param type The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an endpoint is healthy. This parameter is required.
             *             <blockquote>
             *             <p>
             *             You can't change the value of <code>Type</code> after you create a health check.
             *             <p>
             *             </blockquote>
             *             <p>
             *             You can create the following types of health checks:
             *             <p>
             *             <ul>
             *             <li><em>HTTP</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.</li>
             *             <li><em>HTTPS</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.</li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             If you specify <code>HTTPS</code> for the value of <code>Type</code> , the endpoint must support TLS v1.0 or later.
             *             <p>
             *             </blockquote>
             *             <p>
             *             <ul>
             *             <li><em>HTTP_STR_MATCH</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and searches the first 5,120 bytes of the response body for the string that you specify in <code>SearchString</code> .</li>
             *             <li><em>HTTPS_STR_MATCH</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string that you specify in <code>SearchString</code> .</li>
             *             <li><em>TCP</em> : Route 53 tries to establish a TCP connection.</li>
             *             <li><em>CLOUDWATCH_METRIC</em> : The health check is associated with a CloudWatch alarm. If the state of the alarm is <code>OK</code> , the health check is considered healthy. If the state is <code>ALARM</code> , the health check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the state is <code>OK</code> or <code>ALARM</code> , the health check status depends on the setting for <code>InsufficientDataHealthStatus</code> : <code>Healthy</code> , <code>Unhealthy</code> , or <code>LastKnownStatus</code> .</li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             Route 53 supports CloudWatch alarms with the following features:
             *             <p>
             *             <ul>
             *             <li>Standard-resolution metrics. High-resolution metrics aren't supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the <em>Amazon CloudWatch User Guide</em> .</li>
             *             <li>Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended statistics aren't supported.</li>
             *             </ul>
             *             <p>
             *             </blockquote>
             *             <p>
             *             <ul>
             *             <li><em>CALCULATED</em> : For health checks that monitor the status of other health checks, Route 53 adds up the number of health checks that Route 53 health checkers consider to be healthy and compares that number with the value of <code>HealthThreshold</code> .</li>
             *             <li><em>RECOVERY_CONTROL</em> : The health check is assocated with a Route53 Application Recovery Controller routing control. If the routing control state is <code>ON</code> , the health check is considered healthy. If the state is <code>OFF</code> , the health check is considered unhealthy.</li>
             *             </ul>
             *             <p>
             *             For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <em>Amazon Route 53 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getAlarmIdentifier}
             * @param alarmIdentifier A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmIdentifier(software.amazon.awscdk.IResolvable alarmIdentifier) {
                this.alarmIdentifier = alarmIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getAlarmIdentifier}
             * @param alarmIdentifier A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmIdentifier(software.amazon.awscdk.services.route53.CfnHealthCheck.AlarmIdentifierProperty alarmIdentifier) {
                this.alarmIdentifier = alarmIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getChildHealthChecks}
             * @param childHealthChecks (CALCULATED Health Checks Only) A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a <code>CALCULATED</code> health check.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder childHealthChecks(java.util.List<java.lang.String> childHealthChecks) {
                this.childHealthChecks = childHealthChecks;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getEnableSni}
             * @param enableSni Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during TLS negotiation.
             *                  This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.
             *                  <p>
             *                  Some endpoints require that <code>HTTPS</code> requests include the host name in the <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be <code>SSL alert handshake_failure</code> . A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.
             *                  <p>
             *                  The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code> . If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code> , a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableSni(java.lang.Boolean enableSni) {
                this.enableSni = enableSni;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getEnableSni}
             * @param enableSni Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during TLS negotiation.
             *                  This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.
             *                  <p>
             *                  Some endpoints require that <code>HTTPS</code> requests include the host name in the <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be <code>SSL alert handshake_failure</code> . A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.
             *                  <p>
             *                  The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code> . If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code> , a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableSni(software.amazon.awscdk.IResolvable enableSni) {
                this.enableSni = enableSni;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getFailureThreshold}
             * @param failureThreshold The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa.
             *                         For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <em>Amazon Route 53 Developer Guide</em> .
             *                         <p>
             *                         If you don't specify a value for <code>FailureThreshold</code> , the default value is three health checks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureThreshold(java.lang.Number failureThreshold) {
                this.failureThreshold = failureThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getFullyQualifiedDomainName}
             * @param fullyQualifiedDomainName Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code> .
             *                                 <em>If you specify a value for</em> <code>IPAddress</code> :
             *                                 <p>
             *                                 Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.
             *                                 <p>
             *                                 When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:
             *                                 <p>
             *                                 <ul>
             *                                 <li>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for <code>Type</code> , Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the Host header.</li>
             *                                 <li>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for <code>Type</code> , Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</li>
             *                                 <li>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code> , Route 53 passes <code>FullyQualifiedDomainName:Port</code> to the endpoint in the <code>Host</code> header.</li>
             *                                 </ul>
             *                                 <p>
             *                                 If you don't specify a value for <code>FullyQualifiedDomainName</code> , Route 53 substitutes the value of <code>IPAddress</code> in the <code>Host</code> header in each of the preceding cases.
             *                                 <p>
             *                                 <em>If you don't specify a value for <code>IPAddress</code></em> :
             *                                 <p>
             *                                 Route 53 sends a DNS request to the domain that you specify for <code>FullyQualifiedDomainName</code> at the interval that you specify for <code>RequestInterval</code> . Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.
             *                                 <p>
             *                                 <blockquote>
             *                                 <p>
             *                                 If you don't specify a value for <code>IPAddress</code> , Route 53 uses only IPv4 to send health checks to the endpoint. If there's no record with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code> , the health check fails with a "DNS resolution failed" error.
             *                                 <p>
             *                                 </blockquote>
             *                                 <p>
             *                                 If you want to check the health of multiple records that have the same name and type, such as multiple weighted records, and if you choose to specify the endpoint only by <code>FullyQualifiedDomainName</code> , we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code> , specify the domain name of the server (such as us-east-2-www.example.com), not the name of the records (www.example.com).
             *                                 <p>
             *                                 <blockquote>
             *                                 <p>
             *                                 In this configuration, if you create a health check for which the value of <code>FullyQualifiedDomainName</code> matches the name of the records and you then associate the health check with those records, health check results will be unpredictable.
             *                                 <p>
             *                                 </blockquote>
             *                                 <p>
             *                                 In addition, if the value that you specify for <code>Type</code> is <code>HTTP</code> , <code>HTTPS</code> , <code>HTTP_STR_MATCH</code> , or <code>HTTPS_STR_MATCH</code> , Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for <code>IPAddress</code> . If the value of <code>Type</code> is <code>TCP</code> , Route 53 doesn't pass a <code>Host</code> header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedDomainName(java.lang.String fullyQualifiedDomainName) {
                this.fullyQualifiedDomainName = fullyQualifiedDomainName;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getHealthThreshold}
             * @param healthThreshold The number of child health checks that are associated with a <code>CALCULATED</code> health check that Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy.
             *                        To specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks">ChildHealthChecks</a> element.
             *                        <p>
             *                        Note the following:
             *                        <p>
             *                        <ul>
             *                        <li>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</li>
             *                        <li>If you specify <code>0</code> , Route 53 always considers this health check to be healthy.</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthThreshold(java.lang.Number healthThreshold) {
                this.healthThreshold = healthThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getInsufficientDataHealthStatus}
             * @param insufficientDataHealthStatus When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:  - <code>Healthy</code> : Route 53 considers the health check to be healthy.
             *                                     <ul>
             *                                     <li><code>Unhealthy</code> : Route 53 considers the health check to be unhealthy.</li>
             *                                     <li><code>LastKnownStatus</code> : Route 53 uses the status of the health check from the last time that CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.</li>
             *                                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insufficientDataHealthStatus(java.lang.String insufficientDataHealthStatus) {
                this.insufficientDataHealthStatus = insufficientDataHealthStatus;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getInverted}
             * @param inverted Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inverted(java.lang.Boolean inverted) {
                this.inverted = inverted;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getInverted}
             * @param inverted Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inverted(software.amazon.awscdk.IResolvable inverted) {
                this.inverted = inverted;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getIpAddress}
             * @param ipAddress The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to perform health checks on.
             *                  If you don't specify a value for <code>IPAddress</code> , Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in <code>RequestInterval</code> . Using an IP address returned by DNS, Route 53 then checks the health of the endpoint.
             *                  <p>
             *                  Use one of the following formats for the value of <code>IPAddress</code> :
             *                  <p>
             *                  <ul>
             *                  <li><em>IPv4 address</em> : four values between 0 and 255, separated by periods (.), for example, <code>192.0.2.44</code> .</li>
             *                  <li><em>IPv6 address</em> : eight groups of four hexadecimal values, separated by colons (:), for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code> . You can also shorten IPv6 addresses as described in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code> .</li>
             *                  </ul>
             *                  <p>
             *                  If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code> . This ensures that the IP address of your instance will never change.
             *                  <p>
             *                  For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a> .
             *                  <p>
             *                  Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can't create health checks, see the following documents:
             *                  <p>
             *                  <ul>
             *                  <li><a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a></li>
             *                  <li><a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a></li>
             *                  <li><a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a></li>
             *                  </ul>
             *                  <p>
             *                  When the value of <code>Type</code> is <code>CALCULATED</code> or <code>CLOUDWATCH_METRIC</code> , omit <code>IPAddress</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipAddress(java.lang.String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getMeasureLatency}
             * @param measureLatency Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the <em>Health Checks</em> page in the Route 53 console.
             *                       <blockquote>
             *                       <p>
             *                       You can't change the value of <code>MeasureLatency</code> after you create a health check.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder measureLatency(java.lang.Boolean measureLatency) {
                this.measureLatency = measureLatency;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getMeasureLatency}
             * @param measureLatency Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the <em>Health Checks</em> page in the Route 53 console.
             *                       <blockquote>
             *                       <p>
             *                       You can't change the value of <code>MeasureLatency</code> after you create a health check.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder measureLatency(software.amazon.awscdk.IResolvable measureLatency) {
                this.measureLatency = measureLatency;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getPort}
             * @param port The port on the endpoint that you want Amazon Route 53 to perform health checks on.
             *             <blockquote>
             *             <p>
             *             Don't specify a value for <code>Port</code> when you specify a value for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-type">Type</a> of <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code> .
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getRegions}
             * @param regions A complex type that contains one <code>Region</code> element for each region from which you want Amazon Route 53 health checkers to check the specified endpoint.
             *                If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the regions that are listed under <em>Valid Values</em> .
             *                <p>
             *                If you update a health check to remove a region that has been performing health checks, Route 53 will briefly continue to perform checks from that region to ensure that some health checkers are always checking the endpoint (for example, if you replace three regions with four different regions).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regions(java.util.List<java.lang.String> regions) {
                this.regions = regions;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getRequestInterval}
             * @param requestInterval The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health check request.
             *                        Each Route 53 health checker makes requests at this interval.
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        You can't change the value of <code>RequestInterval</code> after you create a health check.
             *                        <p>
             *                        </blockquote>
             *                        <p>
             *                        If you don't specify a value for <code>RequestInterval</code> , the default value is <code>30</code> seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestInterval(java.lang.Number requestInterval) {
                this.requestInterval = requestInterval;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getResourcePath}
             * @param resourcePath The path, if any, that you want Amazon Route 53 to request when performing health checks.
             *                     The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example, the file /docs/route53-health-check.html. You can also include query string parameters, for example, <code>/welcome.html?language=jp&amp;login=y</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePath(java.lang.String resourcePath) {
                this.resourcePath = resourcePath;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getRoutingControlArn}
             * @param routingControlArn The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control.
             *                          For more information about Route 53 Application Recovery Controller, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route-53-recovery.html">Route 53 Application Recovery Controller Developer Guide.</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingControlArn(java.lang.String routingControlArn) {
                this.routingControlArn = routingControlArn;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getSearchString}
             * @param searchString If the value of Type is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code> , the string that you want Amazon Route 53 to search for in the response body from the specified resource.
             *                     If the string appears in the response body, Route 53 considers the resource healthy.
             *                     <p>
             *                     Route 53 considers case when searching for <code>SearchString</code> in the response body.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder searchString(java.lang.String searchString) {
                this.searchString = searchString;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthCheckConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckConfigProperty {
            private final java.lang.String type;
            private final java.lang.Object alarmIdentifier;
            private final java.util.List<java.lang.String> childHealthChecks;
            private final java.lang.Object enableSni;
            private final java.lang.Number failureThreshold;
            private final java.lang.String fullyQualifiedDomainName;
            private final java.lang.Number healthThreshold;
            private final java.lang.String insufficientDataHealthStatus;
            private final java.lang.Object inverted;
            private final java.lang.String ipAddress;
            private final java.lang.Object measureLatency;
            private final java.lang.Number port;
            private final java.util.List<java.lang.String> regions;
            private final java.lang.Number requestInterval;
            private final java.lang.String resourcePath;
            private final java.lang.String routingControlArn;
            private final java.lang.String searchString;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.alarmIdentifier = software.amazon.jsii.Kernel.get(this, "alarmIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.childHealthChecks = software.amazon.jsii.Kernel.get(this, "childHealthChecks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.enableSni = software.amazon.jsii.Kernel.get(this, "enableSni", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureThreshold = software.amazon.jsii.Kernel.get(this, "failureThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fullyQualifiedDomainName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.healthThreshold = software.amazon.jsii.Kernel.get(this, "healthThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.insufficientDataHealthStatus = software.amazon.jsii.Kernel.get(this, "insufficientDataHealthStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inverted = software.amazon.jsii.Kernel.get(this, "inverted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipAddress = software.amazon.jsii.Kernel.get(this, "ipAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.measureLatency = software.amazon.jsii.Kernel.get(this, "measureLatency", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.requestInterval = software.amazon.jsii.Kernel.get(this, "requestInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.resourcePath = software.amazon.jsii.Kernel.get(this, "resourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.routingControlArn = software.amazon.jsii.Kernel.get(this, "routingControlArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.searchString = software.amazon.jsii.Kernel.get(this, "searchString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.alarmIdentifier = builder.alarmIdentifier;
                this.childHealthChecks = builder.childHealthChecks;
                this.enableSni = builder.enableSni;
                this.failureThreshold = builder.failureThreshold;
                this.fullyQualifiedDomainName = builder.fullyQualifiedDomainName;
                this.healthThreshold = builder.healthThreshold;
                this.insufficientDataHealthStatus = builder.insufficientDataHealthStatus;
                this.inverted = builder.inverted;
                this.ipAddress = builder.ipAddress;
                this.measureLatency = builder.measureLatency;
                this.port = builder.port;
                this.regions = builder.regions;
                this.requestInterval = builder.requestInterval;
                this.resourcePath = builder.resourcePath;
                this.routingControlArn = builder.routingControlArn;
                this.searchString = builder.searchString;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getAlarmIdentifier() {
                return this.alarmIdentifier;
            }

            @Override
            public final java.util.List<java.lang.String> getChildHealthChecks() {
                return this.childHealthChecks;
            }

            @Override
            public final java.lang.Object getEnableSni() {
                return this.enableSni;
            }

            @Override
            public final java.lang.Number getFailureThreshold() {
                return this.failureThreshold;
            }

            @Override
            public final java.lang.String getFullyQualifiedDomainName() {
                return this.fullyQualifiedDomainName;
            }

            @Override
            public final java.lang.Number getHealthThreshold() {
                return this.healthThreshold;
            }

            @Override
            public final java.lang.String getInsufficientDataHealthStatus() {
                return this.insufficientDataHealthStatus;
            }

            @Override
            public final java.lang.Object getInverted() {
                return this.inverted;
            }

            @Override
            public final java.lang.String getIpAddress() {
                return this.ipAddress;
            }

            @Override
            public final java.lang.Object getMeasureLatency() {
                return this.measureLatency;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.util.List<java.lang.String> getRegions() {
                return this.regions;
            }

            @Override
            public final java.lang.Number getRequestInterval() {
                return this.requestInterval;
            }

            @Override
            public final java.lang.String getResourcePath() {
                return this.resourcePath;
            }

            @Override
            public final java.lang.String getRoutingControlArn() {
                return this.routingControlArn;
            }

            @Override
            public final java.lang.String getSearchString() {
                return this.searchString;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAlarmIdentifier() != null) {
                    data.set("alarmIdentifier", om.valueToTree(this.getAlarmIdentifier()));
                }
                if (this.getChildHealthChecks() != null) {
                    data.set("childHealthChecks", om.valueToTree(this.getChildHealthChecks()));
                }
                if (this.getEnableSni() != null) {
                    data.set("enableSni", om.valueToTree(this.getEnableSni()));
                }
                if (this.getFailureThreshold() != null) {
                    data.set("failureThreshold", om.valueToTree(this.getFailureThreshold()));
                }
                if (this.getFullyQualifiedDomainName() != null) {
                    data.set("fullyQualifiedDomainName", om.valueToTree(this.getFullyQualifiedDomainName()));
                }
                if (this.getHealthThreshold() != null) {
                    data.set("healthThreshold", om.valueToTree(this.getHealthThreshold()));
                }
                if (this.getInsufficientDataHealthStatus() != null) {
                    data.set("insufficientDataHealthStatus", om.valueToTree(this.getInsufficientDataHealthStatus()));
                }
                if (this.getInverted() != null) {
                    data.set("inverted", om.valueToTree(this.getInverted()));
                }
                if (this.getIpAddress() != null) {
                    data.set("ipAddress", om.valueToTree(this.getIpAddress()));
                }
                if (this.getMeasureLatency() != null) {
                    data.set("measureLatency", om.valueToTree(this.getMeasureLatency()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getRegions() != null) {
                    data.set("regions", om.valueToTree(this.getRegions()));
                }
                if (this.getRequestInterval() != null) {
                    data.set("requestInterval", om.valueToTree(this.getRequestInterval()));
                }
                if (this.getResourcePath() != null) {
                    data.set("resourcePath", om.valueToTree(this.getResourcePath()));
                }
                if (this.getRoutingControlArn() != null) {
                    data.set("routingControlArn", om.valueToTree(this.getRoutingControlArn()));
                }
                if (this.getSearchString() != null) {
                    data.set("searchString", om.valueToTree(this.getSearchString()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CfnHealthCheck.HealthCheckConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckConfigProperty.Jsii$Proxy that = (HealthCheckConfigProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.alarmIdentifier != null ? !this.alarmIdentifier.equals(that.alarmIdentifier) : that.alarmIdentifier != null) return false;
                if (this.childHealthChecks != null ? !this.childHealthChecks.equals(that.childHealthChecks) : that.childHealthChecks != null) return false;
                if (this.enableSni != null ? !this.enableSni.equals(that.enableSni) : that.enableSni != null) return false;
                if (this.failureThreshold != null ? !this.failureThreshold.equals(that.failureThreshold) : that.failureThreshold != null) return false;
                if (this.fullyQualifiedDomainName != null ? !this.fullyQualifiedDomainName.equals(that.fullyQualifiedDomainName) : that.fullyQualifiedDomainName != null) return false;
                if (this.healthThreshold != null ? !this.healthThreshold.equals(that.healthThreshold) : that.healthThreshold != null) return false;
                if (this.insufficientDataHealthStatus != null ? !this.insufficientDataHealthStatus.equals(that.insufficientDataHealthStatus) : that.insufficientDataHealthStatus != null) return false;
                if (this.inverted != null ? !this.inverted.equals(that.inverted) : that.inverted != null) return false;
                if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) return false;
                if (this.measureLatency != null ? !this.measureLatency.equals(that.measureLatency) : that.measureLatency != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.regions != null ? !this.regions.equals(that.regions) : that.regions != null) return false;
                if (this.requestInterval != null ? !this.requestInterval.equals(that.requestInterval) : that.requestInterval != null) return false;
                if (this.resourcePath != null ? !this.resourcePath.equals(that.resourcePath) : that.resourcePath != null) return false;
                if (this.routingControlArn != null ? !this.routingControlArn.equals(that.routingControlArn) : that.routingControlArn != null) return false;
                return this.searchString != null ? this.searchString.equals(that.searchString) : that.searchString == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.alarmIdentifier != null ? this.alarmIdentifier.hashCode() : 0);
                result = 31 * result + (this.childHealthChecks != null ? this.childHealthChecks.hashCode() : 0);
                result = 31 * result + (this.enableSni != null ? this.enableSni.hashCode() : 0);
                result = 31 * result + (this.failureThreshold != null ? this.failureThreshold.hashCode() : 0);
                result = 31 * result + (this.fullyQualifiedDomainName != null ? this.fullyQualifiedDomainName.hashCode() : 0);
                result = 31 * result + (this.healthThreshold != null ? this.healthThreshold.hashCode() : 0);
                result = 31 * result + (this.insufficientDataHealthStatus != null ? this.insufficientDataHealthStatus.hashCode() : 0);
                result = 31 * result + (this.inverted != null ? this.inverted.hashCode() : 0);
                result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
                result = 31 * result + (this.measureLatency != null ? this.measureLatency.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
                result = 31 * result + (this.requestInterval != null ? this.requestInterval.hashCode() : 0);
                result = 31 * result + (this.resourcePath != null ? this.resourcePath.hashCode() : 0);
                result = 31 * result + (this.routingControlArn != null ? this.routingControlArn.hashCode() : 0);
                result = 31 * result + (this.searchString != null ? this.searchString.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>HealthCheckTag</code> property describes one key-value pair that is associated with an <code>AWS::Route53::HealthCheck</code> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * HealthCheckTagProperty healthCheckTagProperty = HealthCheckTagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnHealthCheck.HealthCheckTagProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of <code>Key</code> depends on the operation that you want to perform:.
         * <p>
         * <ul>
         * <li><em>Add a tag to a health check or hosted zone</em> : <code>Key</code> is the name that you want to give the new tag.</li>
         * <li><em>Edit a tag</em> : <code>Key</code> is the name of the tag that you want to change the <code>Value</code> for.</li>
         * <li><em>Delete a key</em> : <code>Key</code> is the name of the tag you want to remove.</li>
         * <li><em>Give a name to a health check</em> : Edit the default <code>Name</code> tag. In the Amazon Route 53 console, the list of your health checks includes a <em>Name</em> column that lets you see the name that you've given to each health check.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of <code>Value</code> depends on the operation that you want to perform:.
         * <p>
         * <ul>
         * <li><em>Add a tag to a health check or hosted zone</em> : <code>Value</code> is the value that you want to give the new tag.</li>
         * <li><em>Edit a tag</em> : <code>Value</code> is the new value that you want to assign the tag.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link HealthCheckTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link HealthCheckTagProperty#getKey}
             * @param key The value of <code>Key</code> depends on the operation that you want to perform:. This parameter is required.
             *            <ul>
             *            <li><em>Add a tag to a health check or hosted zone</em> : <code>Key</code> is the name that you want to give the new tag.</li>
             *            <li><em>Edit a tag</em> : <code>Key</code> is the name of the tag that you want to change the <code>Value</code> for.</li>
             *            <li><em>Delete a key</em> : <code>Key</code> is the name of the tag you want to remove.</li>
             *            <li><em>Give a name to a health check</em> : Edit the default <code>Name</code> tag. In the Amazon Route 53 console, the list of your health checks includes a <em>Name</em> column that lets you see the name that you've given to each health check.</li>
             *            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckTagProperty#getValue}
             * @param value The value of <code>Value</code> depends on the operation that you want to perform:. This parameter is required.
             *              <ul>
             *              <li><em>Add a tag to a health check or hosted zone</em> : <code>Value</code> is the value that you want to give the new tag.</li>
             *              <li><em>Edit a tag</em> : <code>Value</code> is the new value that you want to assign the tag.</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthCheckTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CfnHealthCheck.HealthCheckTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckTagProperty.Jsii$Proxy that = (HealthCheckTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.CfnHealthCheck}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.CfnHealthCheck> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.CfnHealthCheckProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.CfnHealthCheckProps.Builder();
        }

        /**
         * A complex type that contains detailed information about one health check.
         * <p>
         * For the values to enter for <code>HealthCheckConfig</code> , see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html">HealthCheckConfig</a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig</a>
         * @param healthCheckConfig A complex type that contains detailed information about one health check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfig(final software.amazon.awscdk.IResolvable healthCheckConfig) {
            this.props.healthCheckConfig(healthCheckConfig);
            return this;
        }
        /**
         * A complex type that contains detailed information about one health check.
         * <p>
         * For the values to enter for <code>HealthCheckConfig</code> , see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html">HealthCheckConfig</a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig</a>
         * @param healthCheckConfig A complex type that contains detailed information about one health check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfig(final software.amazon.awscdk.services.route53.CfnHealthCheck.HealthCheckConfigProperty healthCheckConfig) {
            this.props.healthCheckConfig(healthCheckConfig);
            return this;
        }

        /**
         * The <code>HealthCheckTags</code> property describes key-value pairs that are associated with an <code>AWS::Route53::HealthCheck</code> resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags</a>
         * @param healthCheckTags The <code>HealthCheckTags</code> property describes key-value pairs that are associated with an <code>AWS::Route53::HealthCheck</code> resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckTags(final software.amazon.awscdk.IResolvable healthCheckTags) {
            this.props.healthCheckTags(healthCheckTags);
            return this;
        }
        /**
         * The <code>HealthCheckTags</code> property describes key-value pairs that are associated with an <code>AWS::Route53::HealthCheck</code> resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags</a>
         * @param healthCheckTags The <code>HealthCheckTags</code> property describes key-value pairs that are associated with an <code>AWS::Route53::HealthCheck</code> resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckTags(final java.util.List<? extends java.lang.Object> healthCheckTags) {
            this.props.healthCheckTags(healthCheckTags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.route53.CfnHealthCheck}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.CfnHealthCheck build() {
            return new software.amazon.awscdk.services.route53.CfnHealthCheck(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
