package software.amazon.awscdk.services.route53;

/**
 * Routing based on geographical location.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone myZone;
 * // continent
 * // continent
 * ARecord.Builder.create(this, "ARecordGeoLocationContinent")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.0", "5.6.7.0"))
 *         .geoLocation(GeoLocation.continent(Continent.EUROPE))
 *         .build();
 * // country
 * // country
 * ARecord.Builder.create(this, "ARecordGeoLocationCountry")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.1", "5.6.7.1"))
 *         .geoLocation(GeoLocation.country("DE"))
 *         .build();
 * // subdivision
 * // subdivision
 * ARecord.Builder.create(this, "ARecordGeoLocationSubDividion")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.2", "5.6.7.2"))
 *         .geoLocation(GeoLocation.subdivision("WA"))
 *         .build();
 * // default (wildcard record if no specific record is found)
 * // default (wildcard record if no specific record is found)
 * ARecord.Builder.create(this, "ARecordGeoLocationDefault")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.3", "5.6.7.3"))
 *         .geoLocation(GeoLocation.default())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:26.231Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.GeoLocation")
public class GeoLocation extends software.amazon.jsii.JsiiObject {

    protected GeoLocation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GeoLocation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Geolocation resource record based on continent code.
     * <p>
     * @return Continent-based geolocation record
     * @param continentCode Continent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.GeoLocation continent(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.Continent continentCode) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.GeoLocation.class, "continent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.GeoLocation.class), new Object[] { java.util.Objects.requireNonNull(continentCode, "continentCode is required") });
    }

    /**
     * Geolocation resource record based on country code.
     * <p>
     * @return Country-based geolocation record
     * @see <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2</a>
     * @param countryCode Two-letter, uppercase country code for the country. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.GeoLocation country(final @org.jetbrains.annotations.NotNull java.lang.String countryCode) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.GeoLocation.class, "country", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.GeoLocation.class), new Object[] { java.util.Objects.requireNonNull(countryCode, "countryCode is required") });
    }

    /**
     * Default (wildcard) routing record if no specific geolocation record is found.
     * <p>
     * @return Wildcard routing record
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.GeoLocation doDefault() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.GeoLocation.class, "default", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.GeoLocation.class));
    }

    /**
     * Geolocation resource record based on subdivision code (e.g. state of the United States).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html#Route53-Type-GeoLocation-SubdivisionCode">https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html#Route53-Type-GeoLocation-SubdivisionCode</a>
     * @param subdivisionCode Code of the subdivision (e.g. state of the United States). This parameter is required.
     * @param countryCode Country code (ISO 3166-1-alpha-2) of this record, by default US (United States).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.GeoLocation subdivision(final @org.jetbrains.annotations.NotNull java.lang.String subdivisionCode, final @org.jetbrains.annotations.Nullable java.lang.String countryCode) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.GeoLocation.class, "subdivision", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.GeoLocation.class), new Object[] { java.util.Objects.requireNonNull(subdivisionCode, "subdivisionCode is required"), countryCode });
    }

    /**
     * Geolocation resource record based on subdivision code (e.g. state of the United States).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html#Route53-Type-GeoLocation-SubdivisionCode">https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html#Route53-Type-GeoLocation-SubdivisionCode</a>
     * @param subdivisionCode Code of the subdivision (e.g. state of the United States). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.GeoLocation subdivision(final @org.jetbrains.annotations.NotNull java.lang.String subdivisionCode) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.GeoLocation.class, "subdivision", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.GeoLocation.class), new Object[] { java.util.Objects.requireNonNull(subdivisionCode, "subdivisionCode is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.Continent getContinentCode() {
        return software.amazon.jsii.Kernel.get(this, "continentCode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.Continent.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCountryCode() {
        return software.amazon.jsii.Kernel.get(this, "countryCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSubdivisionCode() {
        return software.amazon.jsii.Kernel.get(this, "subdivisionCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
