package software.amazon.awscdk.services.route53.targets;

/**
 * Use a Global Accelerator instance domain name as an alias record target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.globalaccelerator.*;
 * HostedZone zone;
 * Accelerator accelerator;
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new GlobalAcceleratorTarget(accelerator)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:26.274Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53_targets.GlobalAcceleratorTarget")
public class GlobalAcceleratorTarget extends software.amazon.awscdk.services.route53.targets.GlobalAcceleratorDomainTarget {

    protected GlobalAcceleratorTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GlobalAcceleratorTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create an Alias Target for a Global Accelerator instance.
     * <p>
     * @param accelerator This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GlobalAcceleratorTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.IAccelerator accelerator) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(accelerator, "accelerator is required") });
    }
}
