package software.amazon.awscdk.services.s3;

/**
 * The <code>AWS::S3::AccessGrant</code> resource creates an access grant that gives a grantee access to your S3 data.
 * <p>
 * The grantee can be an IAM user or role or a directory user, or group. Before you can create a grant, you must have an S3 Access Grants instance in the same Region as the S3 data. You can create an S3 Access Grants instance using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrantsinstance.html">AWS::S3::AccessGrantsInstance</a> . You must also have registered at least one S3 data location in your S3 Access Grants instance using <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrantslocation.html">AWS::S3::AccessGrantsLocation</a> .
 * <p>
 * <ul>
 * <li><strong>Permissions</strong> - You must have the <code>s3:CreateAccessGrant</code> permission to use this resource.</li>
 * <li><strong>Additional Permissions</strong> - For any directory identity - <code>sso:DescribeInstance</code> and <code>sso:DescribeApplication</code></li>
 * </ul>
 * <p>
 * For directory users - <code>identitystore:DescribeUser</code>
 * <p>
 * For directory groups - <code>identitystore:DescribeGroup</code>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * CfnAccessGrant cfnAccessGrant = CfnAccessGrant.Builder.create(this, "MyCfnAccessGrant")
 *         .accessGrantsLocationId("accessGrantsLocationId")
 *         .grantee(GranteeProperty.builder()
 *                 .granteeIdentifier("granteeIdentifier")
 *                 .granteeType("granteeType")
 *                 .build())
 *         .permission("permission")
 *         // the properties below are optional
 *         .accessGrantsLocationConfiguration(AccessGrantsLocationConfigurationProperty.builder()
 *                 .s3SubPrefix("s3SubPrefix")
 *                 .build())
 *         .applicationArn("applicationArn")
 *         .s3PrefixType("s3PrefixType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:26.370Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnAccessGrant")
public class CfnAccessGrant extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnAccessGrant(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAccessGrant(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnAccessGrant.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAccessGrant(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnAccessGrantProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the access grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAccessGrantArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAccessGrantArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the access grant.
     * <p>
     * S3 Access Grants auto-generates this ID when you create the access grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAccessGrantId() {
        return software.amazon.jsii.Kernel.get(this, "attrAccessGrantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The S3 path of the data to which you are granting access.
     * <p>
     * It is the result of appending the <code>Subprefix</code> to the location scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGrantScope() {
        return software.amazon.jsii.Kernel.get(this, "attrGrantScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the registered location to which you are granting access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessGrantsLocationId() {
        return software.amazon.jsii.Kernel.get(this, "accessGrantsLocationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the registered location to which you are granting access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessGrantsLocationId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accessGrantsLocationId", java.util.Objects.requireNonNull(value, "accessGrantsLocationId is required"));
    }

    /**
     * The user, group, or role to which you are granting access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getGrantee() {
        return software.amazon.jsii.Kernel.get(this, "grantee", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The user, group, or role to which you are granting access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGrantee(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "grantee", java.util.Objects.requireNonNull(value, "grantee is required"));
    }

    /**
     * The user, group, or role to which you are granting access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGrantee(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnAccessGrant.GranteeProperty value) {
        software.amazon.jsii.Kernel.set(this, "grantee", java.util.Objects.requireNonNull(value, "grantee is required"));
    }

    /**
     * The type of access that you are granting to your S3 data, which can be set to one of the following values:  - <code>READ</code> – Grant read-only access to the S3 data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPermission() {
        return software.amazon.jsii.Kernel.get(this, "permission", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of access that you are granting to your S3 data, which can be set to one of the following values:  - <code>READ</code> – Grant read-only access to the S3 data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermission(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "permission", java.util.Objects.requireNonNull(value, "permission is required"));
    }

    /**
     * The configuration options of the grant location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessGrantsLocationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "accessGrantsLocationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration options of the grant location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessGrantsLocationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accessGrantsLocationConfiguration", value);
    }

    /**
     * The configuration options of the grant location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessGrantsLocationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.CfnAccessGrant.AccessGrantsLocationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "accessGrantsLocationConfiguration", value);
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS IAM Identity Center application associated with your Identity Center instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS IAM Identity Center application associated with your Identity Center instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationArn", value);
    }

    /**
     * The type of <code>S3SubPrefix</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getS3PrefixType() {
        return software.amazon.jsii.Kernel.get(this, "s3PrefixType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of <code>S3SubPrefix</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3PrefixType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3PrefixType", value);
    }

    /**
     * The AWS resource tags that you are adding to the access grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The AWS resource tags that you are adding to the access grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The configuration options of the S3 Access Grants location.
     * <p>
     * It contains the <code>S3SubPrefix</code> field. The grant scope, the data to which you are granting access, is the result of appending the <code>Subprefix</code> field to the scope of the registered location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AccessGrantsLocationConfigurationProperty accessGrantsLocationConfigurationProperty = AccessGrantsLocationConfigurationProperty.builder()
     *         .s3SubPrefix("s3SubPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-accessgrantslocationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-accessgrantslocationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnAccessGrant.AccessGrantsLocationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessGrantsLocationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessGrantsLocationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <code>S3SubPrefix</code> is appended to the location scope creating the grant scope.
         * <p>
         * Use this field to narrow the scope of the grant to a subset of the location scope. This field is required if the location scope is the default location <code>s3://</code> because you cannot create a grant for all of your S3 data in the Region and must narrow the scope. For example, if the location scope is the default location <code>s3://</code> , the <code>S3SubPrefx</code> can be a <code>&lt;bucket-name&gt;/*</code> , so the full grant scope path would be <code>s3://&lt;bucket-name&gt;/*</code> . Or the <code>S3SubPrefx</code> can be <code>&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code> , so the full grant scope path would be <code>s3://&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code> .
         * <p>
         * If the <code>S3SubPrefix</code> includes a prefix, append the wildcard character <code>*</code> after the prefix to indicate that you want to include all object key names in the bucket that start with that prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-accessgrantslocationconfiguration.html#cfn-s3-accessgrant-accessgrantslocationconfiguration-s3subprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-accessgrantslocationconfiguration.html#cfn-s3-accessgrant-accessgrantslocationconfiguration-s3subprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3SubPrefix();

        /**
         * @return a {@link Builder} of {@link AccessGrantsLocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessGrantsLocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessGrantsLocationConfigurationProperty> {
            java.lang.String s3SubPrefix;

            /**
             * Sets the value of {@link AccessGrantsLocationConfigurationProperty#getS3SubPrefix}
             * @param s3SubPrefix The <code>S3SubPrefix</code> is appended to the location scope creating the grant scope. This parameter is required.
             *                    Use this field to narrow the scope of the grant to a subset of the location scope. This field is required if the location scope is the default location <code>s3://</code> because you cannot create a grant for all of your S3 data in the Region and must narrow the scope. For example, if the location scope is the default location <code>s3://</code> , the <code>S3SubPrefx</code> can be a <code>&lt;bucket-name&gt;/*</code> , so the full grant scope path would be <code>s3://&lt;bucket-name&gt;/*</code> . Or the <code>S3SubPrefx</code> can be <code>&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code> , so the full grant scope path would be <code>s3://&lt;bucket-name&gt;/&lt;prefix-name&gt;*</code> .
             *                    <p>
             *                    If the <code>S3SubPrefix</code> includes a prefix, append the wildcard character <code>*</code> after the prefix to indicate that you want to include all object key names in the bucket that start with that prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3SubPrefix(java.lang.String s3SubPrefix) {
                this.s3SubPrefix = s3SubPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessGrantsLocationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessGrantsLocationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessGrantsLocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessGrantsLocationConfigurationProperty {
            private final java.lang.String s3SubPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3SubPrefix = software.amazon.jsii.Kernel.get(this, "s3SubPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3SubPrefix = java.util.Objects.requireNonNull(builder.s3SubPrefix, "s3SubPrefix is required");
            }

            @Override
            public final java.lang.String getS3SubPrefix() {
                return this.s3SubPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3SubPrefix", om.valueToTree(this.getS3SubPrefix()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnAccessGrant.AccessGrantsLocationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessGrantsLocationConfigurationProperty.Jsii$Proxy that = (AccessGrantsLocationConfigurationProperty.Jsii$Proxy) o;

                return this.s3SubPrefix.equals(that.s3SubPrefix);
            }

            @Override
            public final int hashCode() {
                int result = this.s3SubPrefix.hashCode();
                return result;
            }
        }
    }
    /**
     * The user, group, or role to which you are granting access.
     * <p>
     * You can grant access to an IAM user or role. If you have added your corporate directory to AWS IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * GranteeProperty granteeProperty = GranteeProperty.builder()
     *         .granteeIdentifier("granteeIdentifier")
     *         .granteeType("granteeType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-grantee.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-grantee.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnAccessGrant.GranteeProperty")
    @software.amazon.jsii.Jsii.Proxy(GranteeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GranteeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the <code>Grantee</code> .
         * <p>
         * If the grantee type is <code>IAM</code> , the identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the identifier is 128-bit universally unique identifier (UUID) in the format <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code> . You can obtain this UUID from your AWS IAM Identity Center instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-grantee.html#cfn-s3-accessgrant-grantee-granteeidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-grantee.html#cfn-s3-accessgrant-grantee-granteeidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGranteeIdentifier();

        /**
         * The type of the grantee to which access has been granted. It can be one of the following values:.
         * <p>
         * <ul>
         * <li><code>IAM</code> - An IAM user or role.</li>
         * <li><code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.</li>
         * <li><code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-grantee.html#cfn-s3-accessgrant-grantee-granteetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accessgrant-grantee.html#cfn-s3-accessgrant-grantee-granteetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGranteeType();

        /**
         * @return a {@link Builder} of {@link GranteeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GranteeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GranteeProperty> {
            java.lang.String granteeIdentifier;
            java.lang.String granteeType;

            /**
             * Sets the value of {@link GranteeProperty#getGranteeIdentifier}
             * @param granteeIdentifier The unique identifier of the <code>Grantee</code> . This parameter is required.
             *                          If the grantee type is <code>IAM</code> , the identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the identifier is 128-bit universally unique identifier (UUID) in the format <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code> . You can obtain this UUID from your AWS IAM Identity Center instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder granteeIdentifier(java.lang.String granteeIdentifier) {
                this.granteeIdentifier = granteeIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link GranteeProperty#getGranteeType}
             * @param granteeType The type of the grantee to which access has been granted. It can be one of the following values:. This parameter is required.
             *                    <ul>
             *                    <li><code>IAM</code> - An IAM user or role.</li>
             *                    <li><code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.</li>
             *                    <li><code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3 Access Grants instance.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder granteeType(java.lang.String granteeType) {
                this.granteeType = granteeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GranteeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GranteeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GranteeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GranteeProperty {
            private final java.lang.String granteeIdentifier;
            private final java.lang.String granteeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.granteeIdentifier = software.amazon.jsii.Kernel.get(this, "granteeIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.granteeType = software.amazon.jsii.Kernel.get(this, "granteeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.granteeIdentifier = java.util.Objects.requireNonNull(builder.granteeIdentifier, "granteeIdentifier is required");
                this.granteeType = java.util.Objects.requireNonNull(builder.granteeType, "granteeType is required");
            }

            @Override
            public final java.lang.String getGranteeIdentifier() {
                return this.granteeIdentifier;
            }

            @Override
            public final java.lang.String getGranteeType() {
                return this.granteeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("granteeIdentifier", om.valueToTree(this.getGranteeIdentifier()));
                data.set("granteeType", om.valueToTree(this.getGranteeType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnAccessGrant.GranteeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GranteeProperty.Jsii$Proxy that = (GranteeProperty.Jsii$Proxy) o;

                if (!granteeIdentifier.equals(that.granteeIdentifier)) return false;
                return this.granteeType.equals(that.granteeType);
            }

            @Override
            public final int hashCode() {
                int result = this.granteeIdentifier.hashCode();
                result = 31 * result + (this.granteeType.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.CfnAccessGrant}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.CfnAccessGrant> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3.CfnAccessGrantProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3.CfnAccessGrantProps.Builder();
        }

        /**
         * The ID of the registered location to which you are granting access.
         * <p>
         * S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationid</a>
         * @param accessGrantsLocationId The ID of the registered location to which you are granting access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantsLocationId(final java.lang.String accessGrantsLocationId) {
            this.props.accessGrantsLocationId(accessGrantsLocationId);
            return this;
        }

        /**
         * The user, group, or role to which you are granting access.
         * <p>
         * You can grant access to an IAM user or role. If you have added your corporate directory to AWS IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-grantee">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-grantee</a>
         * @param grantee The user, group, or role to which you are granting access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantee(final software.amazon.awscdk.IResolvable grantee) {
            this.props.grantee(grantee);
            return this;
        }
        /**
         * The user, group, or role to which you are granting access.
         * <p>
         * You can grant access to an IAM user or role. If you have added your corporate directory to AWS IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-grantee">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-grantee</a>
         * @param grantee The user, group, or role to which you are granting access. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantee(final software.amazon.awscdk.services.s3.CfnAccessGrant.GranteeProperty grantee) {
            this.props.grantee(grantee);
            return this;
        }

        /**
         * The type of access that you are granting to your S3 data, which can be set to one of the following values:  - <code>READ</code> – Grant read-only access to the S3 data.
         * <p>
         * <ul>
         * <li><code>WRITE</code> – Grant write-only access to the S3 data.</li>
         * <li><code>READWRITE</code> – Grant both read and write access to the S3 data.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-permission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-permission</a>
         * @param permission The type of access that you are granting to your S3 data, which can be set to one of the following values:  - <code>READ</code> – Grant read-only access to the S3 data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permission(final java.lang.String permission) {
            this.props.permission(permission);
            return this;
        }

        /**
         * The configuration options of the grant location.
         * <p>
         * The grant location is the S3 path to the data to which you are granting access. It contains the <code>S3SubPrefix</code> field. The grant scope is the result of appending the subprefix to the location scope of the registered location.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationconfiguration</a>
         * @param accessGrantsLocationConfiguration The configuration options of the grant location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantsLocationConfiguration(final software.amazon.awscdk.IResolvable accessGrantsLocationConfiguration) {
            this.props.accessGrantsLocationConfiguration(accessGrantsLocationConfiguration);
            return this;
        }
        /**
         * The configuration options of the grant location.
         * <p>
         * The grant location is the S3 path to the data to which you are granting access. It contains the <code>S3SubPrefix</code> field. The grant scope is the result of appending the subprefix to the location scope of the registered location.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationconfiguration</a>
         * @param accessGrantsLocationConfiguration The configuration options of the grant location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantsLocationConfiguration(final software.amazon.awscdk.services.s3.CfnAccessGrant.AccessGrantsLocationConfigurationProperty accessGrantsLocationConfiguration) {
            this.props.accessGrantsLocationConfiguration(accessGrantsLocationConfiguration);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an AWS IAM Identity Center application associated with your Identity Center instance.
         * <p>
         * If the grant includes an application ARN, the grantee can only access the S3 data through this application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-applicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-applicationarn</a>
         * @param applicationArn The Amazon Resource Name (ARN) of an AWS IAM Identity Center application associated with your Identity Center instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationArn(final java.lang.String applicationArn) {
            this.props.applicationArn(applicationArn);
            return this;
        }

        /**
         * The type of <code>S3SubPrefix</code> .
         * <p>
         * The only possible value is <code>Object</code> . Pass this value if the access grant scope is an object. Do not pass this value if the access grant scope is a bucket or a bucket and a prefix.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-s3prefixtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-s3prefixtype</a>
         * @param s3PrefixType The type of <code>S3SubPrefix</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3PrefixType(final java.lang.String s3PrefixType) {
            this.props.s3PrefixType(s3PrefixType);
            return this;
        }

        /**
         * The AWS resource tags that you are adding to the access grant.
         * <p>
         * Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-tags</a>
         * @param tags The AWS resource tags that you are adding to the access grant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3.CfnAccessGrant}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.CfnAccessGrant build() {
            return new software.amazon.awscdk.services.s3.CfnAccessGrant(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
