package software.amazon.awscdk.services.s3;

/**
 * Properties for defining a <code>CfnAccessGrant</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * CfnAccessGrantProps cfnAccessGrantProps = CfnAccessGrantProps.builder()
 *         .accessGrantsLocationId("accessGrantsLocationId")
 *         .grantee(GranteeProperty.builder()
 *                 .granteeIdentifier("granteeIdentifier")
 *                 .granteeType("granteeType")
 *                 .build())
 *         .permission("permission")
 *         // the properties below are optional
 *         .accessGrantsLocationConfiguration(AccessGrantsLocationConfigurationProperty.builder()
 *                 .s3SubPrefix("s3SubPrefix")
 *                 .build())
 *         .applicationArn("applicationArn")
 *         .s3PrefixType("s3PrefixType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:26.382Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnAccessGrantProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccessGrantProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccessGrantProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the registered location to which you are granting access.
     * <p>
     * S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessGrantsLocationId();

    /**
     * The user, group, or role to which you are granting access.
     * <p>
     * You can grant access to an IAM user or role. If you have added your corporate directory to AWS IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-grantee">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-grantee</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getGrantee();

    /**
     * The type of access that you are granting to your S3 data, which can be set to one of the following values:  - <code>READ</code> – Grant read-only access to the S3 data.
     * <p>
     * <ul>
     * <li><code>WRITE</code> – Grant write-only access to the S3 data.</li>
     * <li><code>READWRITE</code> – Grant both read and write access to the S3 data.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-permission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-permission</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPermission();

    /**
     * The configuration options of the grant location.
     * <p>
     * The grant location is the S3 path to the data to which you are granting access. It contains the <code>S3SubPrefix</code> field. The grant scope is the result of appending the subprefix to the location scope of the registered location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-accessgrantslocationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessGrantsLocationConfiguration() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS IAM Identity Center application associated with your Identity Center instance.
     * <p>
     * If the grant includes an application ARN, the grantee can only access the S3 data through this application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-applicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-applicationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationArn() {
        return null;
    }

    /**
     * The type of <code>S3SubPrefix</code> .
     * <p>
     * The only possible value is <code>Object</code> . Pass this value if the access grant scope is an object. Do not pass this value if the access grant scope is a bucket or a bucket and a prefix.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-s3prefixtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-s3prefixtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3PrefixType() {
        return null;
    }

    /**
     * The AWS resource tags that you are adding to the access grant.
     * <p>
     * Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accessgrant.html#cfn-s3-accessgrant-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAccessGrantProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccessGrantProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccessGrantProps> {
        java.lang.String accessGrantsLocationId;
        java.lang.Object grantee;
        java.lang.String permission;
        java.lang.Object accessGrantsLocationConfiguration;
        java.lang.String applicationArn;
        java.lang.String s3PrefixType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAccessGrantProps#getAccessGrantsLocationId}
         * @param accessGrantsLocationId The ID of the registered location to which you are granting access. This parameter is required.
         *                               S3 Access Grants assigns this ID when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantsLocationId(java.lang.String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessGrantProps#getGrantee}
         * @param grantee The user, group, or role to which you are granting access. This parameter is required.
         *                You can grant access to an IAM user or role. If you have added your corporate directory to AWS IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantee(software.amazon.awscdk.IResolvable grantee) {
            this.grantee = grantee;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessGrantProps#getGrantee}
         * @param grantee The user, group, or role to which you are granting access. This parameter is required.
         *                You can grant access to an IAM user or role. If you have added your corporate directory to AWS IAM Identity Center and associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantee(software.amazon.awscdk.services.s3.CfnAccessGrant.GranteeProperty grantee) {
            this.grantee = grantee;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessGrantProps#getPermission}
         * @param permission The type of access that you are granting to your S3 data, which can be set to one of the following values:  - <code>READ</code> – Grant read-only access to the S3 data. This parameter is required.
         *                   <ul>
         *                   <li><code>WRITE</code> – Grant write-only access to the S3 data.</li>
         *                   <li><code>READWRITE</code> – Grant both read and write access to the S3 data.</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permission(java.lang.String permission) {
            this.permission = permission;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessGrantProps#getAccessGrantsLocationConfiguration}
         * @param accessGrantsLocationConfiguration The configuration options of the grant location.
         *                                          The grant location is the S3 path to the data to which you are granting access. It contains the <code>S3SubPrefix</code> field. The grant scope is the result of appending the subprefix to the location scope of the registered location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantsLocationConfiguration(software.amazon.awscdk.IResolvable accessGrantsLocationConfiguration) {
            this.accessGrantsLocationConfiguration = accessGrantsLocationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessGrantProps#getAccessGrantsLocationConfiguration}
         * @param accessGrantsLocationConfiguration The configuration options of the grant location.
         *                                          The grant location is the S3 path to the data to which you are granting access. It contains the <code>S3SubPrefix</code> field. The grant scope is the result of appending the subprefix to the location scope of the registered location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantsLocationConfiguration(software.amazon.awscdk.services.s3.CfnAccessGrant.AccessGrantsLocationConfigurationProperty accessGrantsLocationConfiguration) {
            this.accessGrantsLocationConfiguration = accessGrantsLocationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessGrantProps#getApplicationArn}
         * @param applicationArn The Amazon Resource Name (ARN) of an AWS IAM Identity Center application associated with your Identity Center instance.
         *                       If the grant includes an application ARN, the grantee can only access the S3 data through this application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationArn(java.lang.String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessGrantProps#getS3PrefixType}
         * @param s3PrefixType The type of <code>S3SubPrefix</code> .
         *                     The only possible value is <code>Object</code> . Pass this value if the access grant scope is an object. Do not pass this value if the access grant scope is a bucket or a bucket and a prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3PrefixType(java.lang.String s3PrefixType) {
            this.s3PrefixType = s3PrefixType;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessGrantProps#getTags}
         * @param tags The AWS resource tags that you are adding to the access grant.
         *             Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccessGrantProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccessGrantProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAccessGrantProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccessGrantProps {
        private final java.lang.String accessGrantsLocationId;
        private final java.lang.Object grantee;
        private final java.lang.String permission;
        private final java.lang.Object accessGrantsLocationConfiguration;
        private final java.lang.String applicationArn;
        private final java.lang.String s3PrefixType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessGrantsLocationId = software.amazon.jsii.Kernel.get(this, "accessGrantsLocationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.grantee = software.amazon.jsii.Kernel.get(this, "grantee", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.permission = software.amazon.jsii.Kernel.get(this, "permission", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessGrantsLocationConfiguration = software.amazon.jsii.Kernel.get(this, "accessGrantsLocationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applicationArn = software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3PrefixType = software.amazon.jsii.Kernel.get(this, "s3PrefixType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessGrantsLocationId = java.util.Objects.requireNonNull(builder.accessGrantsLocationId, "accessGrantsLocationId is required");
            this.grantee = java.util.Objects.requireNonNull(builder.grantee, "grantee is required");
            this.permission = java.util.Objects.requireNonNull(builder.permission, "permission is required");
            this.accessGrantsLocationConfiguration = builder.accessGrantsLocationConfiguration;
            this.applicationArn = builder.applicationArn;
            this.s3PrefixType = builder.s3PrefixType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAccessGrantsLocationId() {
            return this.accessGrantsLocationId;
        }

        @Override
        public final java.lang.Object getGrantee() {
            return this.grantee;
        }

        @Override
        public final java.lang.String getPermission() {
            return this.permission;
        }

        @Override
        public final java.lang.Object getAccessGrantsLocationConfiguration() {
            return this.accessGrantsLocationConfiguration;
        }

        @Override
        public final java.lang.String getApplicationArn() {
            return this.applicationArn;
        }

        @Override
        public final java.lang.String getS3PrefixType() {
            return this.s3PrefixType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessGrantsLocationId", om.valueToTree(this.getAccessGrantsLocationId()));
            data.set("grantee", om.valueToTree(this.getGrantee()));
            data.set("permission", om.valueToTree(this.getPermission()));
            if (this.getAccessGrantsLocationConfiguration() != null) {
                data.set("accessGrantsLocationConfiguration", om.valueToTree(this.getAccessGrantsLocationConfiguration()));
            }
            if (this.getApplicationArn() != null) {
                data.set("applicationArn", om.valueToTree(this.getApplicationArn()));
            }
            if (this.getS3PrefixType() != null) {
                data.set("s3PrefixType", om.valueToTree(this.getS3PrefixType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnAccessGrantProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccessGrantProps.Jsii$Proxy that = (CfnAccessGrantProps.Jsii$Proxy) o;

            if (!accessGrantsLocationId.equals(that.accessGrantsLocationId)) return false;
            if (!grantee.equals(that.grantee)) return false;
            if (!permission.equals(that.permission)) return false;
            if (this.accessGrantsLocationConfiguration != null ? !this.accessGrantsLocationConfiguration.equals(that.accessGrantsLocationConfiguration) : that.accessGrantsLocationConfiguration != null) return false;
            if (this.applicationArn != null ? !this.applicationArn.equals(that.applicationArn) : that.applicationArn != null) return false;
            if (this.s3PrefixType != null ? !this.s3PrefixType.equals(that.s3PrefixType) : that.s3PrefixType != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessGrantsLocationId.hashCode();
            result = 31 * result + (this.grantee.hashCode());
            result = 31 * result + (this.permission.hashCode());
            result = 31 * result + (this.accessGrantsLocationConfiguration != null ? this.accessGrantsLocationConfiguration.hashCode() : 0);
            result = 31 * result + (this.applicationArn != null ? this.applicationArn.hashCode() : 0);
            result = 31 * result + (this.s3PrefixType != null ? this.s3PrefixType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
