package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnModelCard</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * Object value;
 * CfnModelCardProps cfnModelCardProps = CfnModelCardProps.builder()
 *         .content(ContentProperty.builder()
 *                 .additionalInformation(AdditionalInformationProperty.builder()
 *                         .caveatsAndRecommendations("caveatsAndRecommendations")
 *                         .customDetails(Map.of(
 *                                 "customDetailsKey", "customDetails"))
 *                         .ethicalConsiderations("ethicalConsiderations")
 *                         .build())
 *                 .businessDetails(BusinessDetailsProperty.builder()
 *                         .businessProblem("businessProblem")
 *                         .businessStakeholders("businessStakeholders")
 *                         .lineOfBusiness("lineOfBusiness")
 *                         .build())
 *                 .evaluationDetails(List.of(EvaluationDetailProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .datasets(List.of("datasets"))
 *                         .evaluationJobArn("evaluationJobArn")
 *                         .evaluationObservation("evaluationObservation")
 *                         .metadata(Map.of(
 *                                 "metadataKey", "metadata"))
 *                         .metricGroups(List.of(MetricGroupProperty.builder()
 *                                 .metricData(List.of(MetricDataItemsProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         .value(value)
 *                                         // the properties below are optional
 *                                         .notes("notes")
 *                                         .xAxisName(List.of("xAxisName"))
 *                                         .yAxisName(List.of("yAxisName"))
 *                                         .build()))
 *                                 .name("name")
 *                                 .build()))
 *                         .build()))
 *                 .intendedUses(IntendedUsesProperty.builder()
 *                         .explanationsForRiskRating("explanationsForRiskRating")
 *                         .factorsAffectingModelEfficiency("factorsAffectingModelEfficiency")
 *                         .intendedUses("intendedUses")
 *                         .purposeOfModel("purposeOfModel")
 *                         .riskRating("riskRating")
 *                         .build())
 *                 .modelOverview(ModelOverviewProperty.builder()
 *                         .algorithmType("algorithmType")
 *                         .inferenceEnvironment(InferenceEnvironmentProperty.builder()
 *                                 .containerImage(List.of("containerImage"))
 *                                 .build())
 *                         .modelArtifact(List.of("modelArtifact"))
 *                         .modelCreator("modelCreator")
 *                         .modelDescription("modelDescription")
 *                         .modelId("modelId")
 *                         .modelName("modelName")
 *                         .modelOwner("modelOwner")
 *                         .modelVersion(123)
 *                         .problemType("problemType")
 *                         .build())
 *                 .modelPackageDetails(ModelPackageDetailsProperty.builder()
 *                         .approvalDescription("approvalDescription")
 *                         .createdBy(ModelPackageCreatorProperty.builder()
 *                                 .userProfileName("userProfileName")
 *                                 .build())
 *                         .domain("domain")
 *                         .inferenceSpecification(InferenceSpecificationProperty.builder()
 *                                 .containers(List.of(ContainerProperty.builder()
 *                                         .image("image")
 *                                         // the properties below are optional
 *                                         .modelDataUrl("modelDataUrl")
 *                                         .nearestModelName("nearestModelName")
 *                                         .build()))
 *                                 .build())
 *                         .modelApprovalStatus("modelApprovalStatus")
 *                         .modelPackageArn("modelPackageArn")
 *                         .modelPackageDescription("modelPackageDescription")
 *                         .modelPackageGroupName("modelPackageGroupName")
 *                         .modelPackageName("modelPackageName")
 *                         .modelPackageStatus("modelPackageStatus")
 *                         .modelPackageVersion(123)
 *                         .sourceAlgorithms(List.of(SourceAlgorithmProperty.builder()
 *                                 .algorithmName("algorithmName")
 *                                 // the properties below are optional
 *                                 .modelDataUrl("modelDataUrl")
 *                                 .build()))
 *                         .task("task")
 *                         .build())
 *                 .trainingDetails(TrainingDetailsProperty.builder()
 *                         .objectiveFunction(ObjectiveFunctionProperty.builder()
 *                                 .function(FunctionProperty.builder()
 *                                         .condition("condition")
 *                                         .facet("facet")
 *                                         .function("function")
 *                                         .build())
 *                                 .notes("notes")
 *                                 .build())
 *                         .trainingJobDetails(TrainingJobDetailsProperty.builder()
 *                                 .hyperParameters(List.of(TrainingHyperParameterProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .trainingArn("trainingArn")
 *                                 .trainingDatasets(List.of("trainingDatasets"))
 *                                 .trainingEnvironment(TrainingEnvironmentProperty.builder()
 *                                         .containerImage(List.of("containerImage"))
 *                                         .build())
 *                                 .trainingMetrics(List.of(TrainingMetricProperty.builder()
 *                                         .name("name")
 *                                         .value(123)
 *                                         // the properties below are optional
 *                                         .notes("notes")
 *                                         .build()))
 *                                 .userProvidedHyperParameters(List.of(TrainingHyperParameterProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .userProvidedTrainingMetrics(List.of(TrainingMetricProperty.builder()
 *                                         .name("name")
 *                                         .value(123)
 *                                         // the properties below are optional
 *                                         .notes("notes")
 *                                         .build()))
 *                                 .build())
 *                         .trainingObservations("trainingObservations")
 *                         .build())
 *                 .build())
 *         .modelCardName("modelCardName")
 *         .modelCardStatus("modelCardStatus")
 *         // the properties below are optional
 *         .createdBy(UserContextProperty.builder()
 *                 .domainId("domainId")
 *                 .userProfileArn("userProfileArn")
 *                 .userProfileName("userProfileName")
 *                 .build())
 *         .lastModifiedBy(UserContextProperty.builder()
 *                 .domainId("domainId")
 *                 .userProfileArn("userProfileArn")
 *                 .userProfileName("userProfileName")
 *                 .build())
 *         .securityConfig(SecurityConfigProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:26.743Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelCardProps")
@software.amazon.jsii.Jsii.Proxy(CfnModelCardProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnModelCardProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The content of the model card.
     * <p>
     * Content uses the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model card JSON schema</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-content</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getContent();

    /**
     * The unique name of the model card.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-modelcardname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-modelcardname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelCardName();

    /**
     * The approval status of the model card within your organization.
     * <p>
     * Different organizations might have different criteria for model card review and approval.
     * <p>
     * <ul>
     * <li><code>Draft</code> : The model card is a work in progress.</li>
     * <li><code>PendingReview</code> : The model card is pending review.</li>
     * <li><code>Approved</code> : The model card is approved.</li>
     * <li><code>Archived</code> : The model card is archived. No more updates should be made to the model card, but it can still be exported.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-modelcardstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-modelcardstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelCardStatus();

    /**
     * Information about the user who created or modified one or more of the following:.
     * <p>
     * <ul>
     * <li>Experiment</li>
     * <li>Trial</li>
     * <li>Trial component</li>
     * <li>Lineage group</li>
     * <li>Project</li>
     * <li>Model Card</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-createdby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-createdby</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreatedBy() {
        return null;
    }

    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-lastmodifiedby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-lastmodifiedby</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLastModifiedBy() {
        return null;
    }

    /**
     * The security configuration used to protect model card data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-securityconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-securityconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityConfig() {
        return null;
    }

    /**
     * Key-value pairs used to manage metadata for the model card.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelcard.html#cfn-sagemaker-modelcard-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnModelCardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnModelCardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnModelCardProps> {
        java.lang.Object content;
        java.lang.String modelCardName;
        java.lang.String modelCardStatus;
        java.lang.Object createdBy;
        java.lang.Object lastModifiedBy;
        java.lang.Object securityConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnModelCardProps#getContent}
         * @param content The content of the model card. This parameter is required.
         *                Content uses the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model card JSON schema</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.IResolvable content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getContent}
         * @param content The content of the model card. This parameter is required.
         *                Content uses the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model card JSON schema</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.services.sagemaker.CfnModelCard.ContentProperty content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getModelCardName}
         * @param modelCardName The unique name of the model card. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelCardName(java.lang.String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getModelCardStatus}
         * @param modelCardStatus The approval status of the model card within your organization. This parameter is required.
         *                        Different organizations might have different criteria for model card review and approval.
         *                        <p>
         *                        <ul>
         *                        <li><code>Draft</code> : The model card is a work in progress.</li>
         *                        <li><code>PendingReview</code> : The model card is pending review.</li>
         *                        <li><code>Approved</code> : The model card is approved.</li>
         *                        <li><code>Archived</code> : The model card is archived. No more updates should be made to the model card, but it can still be exported.</li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelCardStatus(java.lang.String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getCreatedBy}
         * @param createdBy Information about the user who created or modified one or more of the following:.
         *                  <ul>
         *                  <li>Experiment</li>
         *                  <li>Trial</li>
         *                  <li>Trial component</li>
         *                  <li>Lineage group</li>
         *                  <li>Project</li>
         *                  <li>Model Card</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdBy(software.amazon.awscdk.IResolvable createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getCreatedBy}
         * @param createdBy Information about the user who created or modified one or more of the following:.
         *                  <ul>
         *                  <li>Experiment</li>
         *                  <li>Trial</li>
         *                  <li>Trial component</li>
         *                  <li>Lineage group</li>
         *                  <li>Project</li>
         *                  <li>Model Card</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdBy(software.amazon.awscdk.services.sagemaker.CfnModelCard.UserContextProperty createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getLastModifiedBy}
         * @param lastModifiedBy Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastModifiedBy(software.amazon.awscdk.IResolvable lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getLastModifiedBy}
         * @param lastModifiedBy Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastModifiedBy(software.amazon.awscdk.services.sagemaker.CfnModelCard.UserContextProperty lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getSecurityConfig}
         * @param securityConfig The security configuration used to protect model card data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfig(software.amazon.awscdk.IResolvable securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getSecurityConfig}
         * @param securityConfig The security configuration used to protect model card data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfig(software.amazon.awscdk.services.sagemaker.CfnModelCard.SecurityConfigProperty securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelCardProps#getTags}
         * @param tags Key-value pairs used to manage metadata for the model card.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnModelCardProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnModelCardProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnModelCardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnModelCardProps {
        private final java.lang.Object content;
        private final java.lang.String modelCardName;
        private final java.lang.String modelCardStatus;
        private final java.lang.Object createdBy;
        private final java.lang.Object lastModifiedBy;
        private final java.lang.Object securityConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelCardName = software.amazon.jsii.Kernel.get(this, "modelCardName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelCardStatus = software.amazon.jsii.Kernel.get(this, "modelCardStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.createdBy = software.amazon.jsii.Kernel.get(this, "createdBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lastModifiedBy = software.amazon.jsii.Kernel.get(this, "lastModifiedBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityConfig = software.amazon.jsii.Kernel.get(this, "securityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
            this.modelCardName = java.util.Objects.requireNonNull(builder.modelCardName, "modelCardName is required");
            this.modelCardStatus = java.util.Objects.requireNonNull(builder.modelCardStatus, "modelCardStatus is required");
            this.createdBy = builder.createdBy;
            this.lastModifiedBy = builder.lastModifiedBy;
            this.securityConfig = builder.securityConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getContent() {
            return this.content;
        }

        @Override
        public final java.lang.String getModelCardName() {
            return this.modelCardName;
        }

        @Override
        public final java.lang.String getModelCardStatus() {
            return this.modelCardStatus;
        }

        @Override
        public final java.lang.Object getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final java.lang.Object getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final java.lang.Object getSecurityConfig() {
            return this.securityConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("content", om.valueToTree(this.getContent()));
            data.set("modelCardName", om.valueToTree(this.getModelCardName()));
            data.set("modelCardStatus", om.valueToTree(this.getModelCardStatus()));
            if (this.getCreatedBy() != null) {
                data.set("createdBy", om.valueToTree(this.getCreatedBy()));
            }
            if (this.getLastModifiedBy() != null) {
                data.set("lastModifiedBy", om.valueToTree(this.getLastModifiedBy()));
            }
            if (this.getSecurityConfig() != null) {
                data.set("securityConfig", om.valueToTree(this.getSecurityConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelCardProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnModelCardProps.Jsii$Proxy that = (CfnModelCardProps.Jsii$Proxy) o;

            if (!content.equals(that.content)) return false;
            if (!modelCardName.equals(that.modelCardName)) return false;
            if (!modelCardStatus.equals(that.modelCardStatus)) return false;
            if (this.createdBy != null ? !this.createdBy.equals(that.createdBy) : that.createdBy != null) return false;
            if (this.lastModifiedBy != null ? !this.lastModifiedBy.equals(that.lastModifiedBy) : that.lastModifiedBy != null) return false;
            if (this.securityConfig != null ? !this.securityConfig.equals(that.securityConfig) : that.securityConfig != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.content.hashCode();
            result = 31 * result + (this.modelCardName.hashCode());
            result = 31 * result + (this.modelCardStatus.hashCode());
            result = 31 * result + (this.createdBy != null ? this.createdBy.hashCode() : 0);
            result = 31 * result + (this.lastModifiedBy != null ? this.lastModifiedBy.hashCode() : 0);
            result = 31 * result + (this.securityConfig != null ? this.securityConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
