package software.amazon.awscdk.services.sagemaker;

/**
 * Creates a private space or a space used for real time collaboration in a domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnSpace cfnSpace = CfnSpace.Builder.create(this, "MyCfnSpace")
 *         .domainId("domainId")
 *         .spaceName("spaceName")
 *         // the properties below are optional
 *         .ownershipSettings(OwnershipSettingsProperty.builder()
 *                 .ownerUserProfileName("ownerUserProfileName")
 *                 .build())
 *         .spaceDisplayName("spaceDisplayName")
 *         .spaceSettings(SpaceSettingsProperty.builder()
 *                 .appType("appType")
 *                 .codeEditorAppSettings(SpaceCodeEditorAppSettingsProperty.builder()
 *                         .appLifecycleManagement(SpaceAppLifecycleManagementProperty.builder()
 *                                 .idleSettings(SpaceIdleSettingsProperty.builder()
 *                                         .idleTimeoutInMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .customFileSystems(List.of(CustomFileSystemProperty.builder()
 *                         .efsFileSystem(EFSFileSystemProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 .build())
 *                         .build()))
 *                 .jupyterLabAppSettings(SpaceJupyterLabAppSettingsProperty.builder()
 *                         .appLifecycleManagement(SpaceAppLifecycleManagementProperty.builder()
 *                                 .idleSettings(SpaceIdleSettingsProperty.builder()
 *                                         .idleTimeoutInMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .codeRepositories(List.of(CodeRepositoryProperty.builder()
 *                                 .repositoryUrl("repositoryUrl")
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .spaceStorageSettings(SpaceStorageSettingsProperty.builder()
 *                         .ebsStorageSettings(EbsStorageSettingsProperty.builder()
 *                                 .ebsVolumeSizeInGb(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .spaceSharingSettings(SpaceSharingSettingsProperty.builder()
 *                 .sharingType("sharingType")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:26.862Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace")
public class CfnSpace extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnSpace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSpace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnSpace.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSpace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnSpaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The space's Amazon Resource Name (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSpaceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSpaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the URL of the space.
     * <p>
     * If the space is created with AWS IAM Identity Center (Successor to AWS Single Sign-On) authentication, users can navigate to the URL after appending the respective redirect parameter for the application type to be federated through AWS IAM Identity Center.
     * <p>
     * The following application types are supported:
     * <p>
     * <ul>
     * <li>Studio Classic: <code>&amp;redirect=JupyterServer</code></li>
     * <li>JupyterLab: <code>&amp;redirect=JupyterLab</code></li>
     * <li>Code Editor, based on Code-OSS, Visual Studio Code - Open Source: <code>&amp;redirect=CodeEditor</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the associated domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainId() {
        return software.amazon.jsii.Kernel.get(this, "domainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the associated domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainId", java.util.Objects.requireNonNull(value, "domainId is required"));
    }

    /**
     * The name of the space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSpaceName() {
        return software.amazon.jsii.Kernel.get(this, "spaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpaceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "spaceName", java.util.Objects.requireNonNull(value, "spaceName is required"));
    }

    /**
     * The collection of ownership settings for a space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOwnershipSettings() {
        return software.amazon.jsii.Kernel.get(this, "ownershipSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The collection of ownership settings for a space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOwnershipSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ownershipSettings", value);
    }

    /**
     * The collection of ownership settings for a space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOwnershipSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnSpace.OwnershipSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "ownershipSettings", value);
    }

    /**
     * The name of the space that appears in the Studio UI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSpaceDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "spaceDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the space that appears in the Studio UI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpaceDisplayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "spaceDisplayName", value);
    }

    /**
     * A collection of space settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSpaceSettings() {
        return software.amazon.jsii.Kernel.get(this, "spaceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A collection of space settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpaceSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spaceSettings", value);
    }

    /**
     * A collection of space settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpaceSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "spaceSettings", value);
    }

    /**
     * A collection of space sharing settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSpaceSharingSettings() {
        return software.amazon.jsii.Kernel.get(this, "spaceSharingSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A collection of space sharing settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpaceSharingSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spaceSharingSettings", value);
    }

    /**
     * A collection of space sharing settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpaceSharingSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceSharingSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "spaceSharingSettings", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A Git repository that SageMaker automatically displays to users for cloning in the JupyterServer application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CodeRepositoryProperty codeRepositoryProperty = CodeRepositoryProperty.builder()
     *         .repositoryUrl("repositoryUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-coderepository.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-coderepository.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.CodeRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL of the Git repository.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-coderepository.html#cfn-sagemaker-space-coderepository-repositoryurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-coderepository.html#cfn-sagemaker-space-coderepository-repositoryurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUrl();

        /**
         * @return a {@link Builder} of {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeRepositoryProperty> {
            java.lang.String repositoryUrl;

            /**
             * Sets the value of {@link CodeRepositoryProperty#getRepositoryUrl}
             * @param repositoryUrl The URL of the Git repository. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryUrl(java.lang.String repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeRepositoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeRepositoryProperty {
            private final java.lang.String repositoryUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repositoryUrl = software.amazon.jsii.Kernel.get(this, "repositoryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repositoryUrl = java.util.Objects.requireNonNull(builder.repositoryUrl, "repositoryUrl is required");
            }

            @Override
            public final java.lang.String getRepositoryUrl() {
                return this.repositoryUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("repositoryUrl", om.valueToTree(this.getRepositoryUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.CodeRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeRepositoryProperty.Jsii$Proxy that = (CodeRepositoryProperty.Jsii$Proxy) o;

                return this.repositoryUrl.equals(that.repositoryUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.repositoryUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * A file system, created by you, that you assign to a user profile or space for an Amazon SageMaker Domain.
     * <p>
     * Permitted users can access this file system in Amazon SageMaker Studio.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomFileSystemProperty customFileSystemProperty = CustomFileSystemProperty.builder()
     *         .efsFileSystem(EFSFileSystemProperty.builder()
     *                 .fileSystemId("fileSystemId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customfilesystem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customfilesystem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.CustomFileSystemProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomFileSystemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomFileSystemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A custom file system in Amazon EFS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customfilesystem.html#cfn-sagemaker-space-customfilesystem-efsfilesystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customfilesystem.html#cfn-sagemaker-space-customfilesystem-efsfilesystem</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEfsFileSystem() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomFileSystemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomFileSystemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomFileSystemProperty> {
            java.lang.Object efsFileSystem;

            /**
             * Sets the value of {@link CustomFileSystemProperty#getEfsFileSystem}
             * @param efsFileSystem A custom file system in Amazon EFS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsFileSystem(software.amazon.awscdk.IResolvable efsFileSystem) {
                this.efsFileSystem = efsFileSystem;
                return this;
            }

            /**
             * Sets the value of {@link CustomFileSystemProperty#getEfsFileSystem}
             * @param efsFileSystem A custom file system in Amazon EFS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsFileSystem(software.amazon.awscdk.services.sagemaker.CfnSpace.EFSFileSystemProperty efsFileSystem) {
                this.efsFileSystem = efsFileSystem;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomFileSystemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomFileSystemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomFileSystemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomFileSystemProperty {
            private final java.lang.Object efsFileSystem;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.efsFileSystem = software.amazon.jsii.Kernel.get(this, "efsFileSystem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.efsFileSystem = builder.efsFileSystem;
            }

            @Override
            public final java.lang.Object getEfsFileSystem() {
                return this.efsFileSystem;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEfsFileSystem() != null) {
                    data.set("efsFileSystem", om.valueToTree(this.getEfsFileSystem()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.CustomFileSystemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomFileSystemProperty.Jsii$Proxy that = (CustomFileSystemProperty.Jsii$Proxy) o;

                return this.efsFileSystem != null ? this.efsFileSystem.equals(that.efsFileSystem) : that.efsFileSystem == null;
            }

            @Override
            public final int hashCode() {
                int result = this.efsFileSystem != null ? this.efsFileSystem.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A custom SageMaker image.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomImageProperty customImageProperty = CustomImageProperty.builder()
     *         .appImageConfigName("appImageConfigName")
     *         .imageName("imageName")
     *         // the properties below are optional
     *         .imageVersionNumber(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customimage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customimage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.CustomImageProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomImageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomImageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AppImageConfig.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customimage.html#cfn-sagemaker-space-customimage-appimageconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customimage.html#cfn-sagemaker-space-customimage-appimageconfigname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppImageConfigName();

        /**
         * The name of the CustomImage.
         * <p>
         * Must be unique to your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customimage.html#cfn-sagemaker-space-customimage-imagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customimage.html#cfn-sagemaker-space-customimage-imagename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageName();

        /**
         * The version number of the CustomImage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customimage.html#cfn-sagemaker-space-customimage-imageversionnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-customimage.html#cfn-sagemaker-space-customimage-imageversionnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getImageVersionNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomImageProperty> {
            java.lang.String appImageConfigName;
            java.lang.String imageName;
            java.lang.Number imageVersionNumber;

            /**
             * Sets the value of {@link CustomImageProperty#getAppImageConfigName}
             * @param appImageConfigName The name of the AppImageConfig. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appImageConfigName(java.lang.String appImageConfigName) {
                this.appImageConfigName = appImageConfigName;
                return this;
            }

            /**
             * Sets the value of {@link CustomImageProperty#getImageName}
             * @param imageName The name of the CustomImage. This parameter is required.
             *                  Must be unique to your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageName(java.lang.String imageName) {
                this.imageName = imageName;
                return this;
            }

            /**
             * Sets the value of {@link CustomImageProperty#getImageVersionNumber}
             * @param imageVersionNumber The version number of the CustomImage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageVersionNumber(java.lang.Number imageVersionNumber) {
                this.imageVersionNumber = imageVersionNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomImageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomImageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomImageProperty {
            private final java.lang.String appImageConfigName;
            private final java.lang.String imageName;
            private final java.lang.Number imageVersionNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appImageConfigName = software.amazon.jsii.Kernel.get(this, "appImageConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageName = software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageVersionNumber = software.amazon.jsii.Kernel.get(this, "imageVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appImageConfigName = java.util.Objects.requireNonNull(builder.appImageConfigName, "appImageConfigName is required");
                this.imageName = java.util.Objects.requireNonNull(builder.imageName, "imageName is required");
                this.imageVersionNumber = builder.imageVersionNumber;
            }

            @Override
            public final java.lang.String getAppImageConfigName() {
                return this.appImageConfigName;
            }

            @Override
            public final java.lang.String getImageName() {
                return this.imageName;
            }

            @Override
            public final java.lang.Number getImageVersionNumber() {
                return this.imageVersionNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appImageConfigName", om.valueToTree(this.getAppImageConfigName()));
                data.set("imageName", om.valueToTree(this.getImageName()));
                if (this.getImageVersionNumber() != null) {
                    data.set("imageVersionNumber", om.valueToTree(this.getImageVersionNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.CustomImageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomImageProperty.Jsii$Proxy that = (CustomImageProperty.Jsii$Proxy) o;

                if (!appImageConfigName.equals(that.appImageConfigName)) return false;
                if (!imageName.equals(that.imageName)) return false;
                return this.imageVersionNumber != null ? this.imageVersionNumber.equals(that.imageVersionNumber) : that.imageVersionNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appImageConfigName.hashCode();
                result = 31 * result + (this.imageName.hashCode());
                result = 31 * result + (this.imageVersionNumber != null ? this.imageVersionNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A file system, created by you in Amazon EFS, that you assign to a user profile or space for an Amazon SageMaker Domain.
     * <p>
     * Permitted users can access this file system in Amazon SageMaker Studio.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * EFSFileSystemProperty eFSFileSystemProperty = EFSFileSystemProperty.builder()
     *         .fileSystemId("fileSystemId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-efsfilesystem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-efsfilesystem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.EFSFileSystemProperty")
    @software.amazon.jsii.Jsii.Proxy(EFSFileSystemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EFSFileSystemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of your Amazon EFS file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-efsfilesystem.html#cfn-sagemaker-space-efsfilesystem-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-efsfilesystem.html#cfn-sagemaker-space-efsfilesystem-filesystemid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

        /**
         * @return a {@link Builder} of {@link EFSFileSystemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EFSFileSystemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EFSFileSystemProperty> {
            java.lang.String fileSystemId;

            /**
             * Sets the value of {@link EFSFileSystemProperty#getFileSystemId}
             * @param fileSystemId The ID of your Amazon EFS file system. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemId(java.lang.String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EFSFileSystemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EFSFileSystemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EFSFileSystemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EFSFileSystemProperty {
            private final java.lang.String fileSystemId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
            }

            @Override
            public final java.lang.String getFileSystemId() {
                return this.fileSystemId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.EFSFileSystemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EFSFileSystemProperty.Jsii$Proxy that = (EFSFileSystemProperty.Jsii$Proxy) o;

                return this.fileSystemId.equals(that.fileSystemId);
            }

            @Override
            public final int hashCode() {
                int result = this.fileSystemId.hashCode();
                return result;
            }
        }
    }
    /**
     * A collection of EBS storage settings that apply to both private and shared spaces.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * EbsStorageSettingsProperty ebsStorageSettingsProperty = EbsStorageSettingsProperty.builder()
     *         .ebsVolumeSizeInGb(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-ebsstoragesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-ebsstoragesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.EbsStorageSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsStorageSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsStorageSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The size of an EBS storage volume for a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-ebsstoragesettings.html#cfn-sagemaker-space-ebsstoragesettings-ebsvolumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-ebsstoragesettings.html#cfn-sagemaker-space-ebsstoragesettings-ebsvolumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getEbsVolumeSizeInGb();

        /**
         * @return a {@link Builder} of {@link EbsStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsStorageSettingsProperty> {
            java.lang.Number ebsVolumeSizeInGb;

            /**
             * Sets the value of {@link EbsStorageSettingsProperty#getEbsVolumeSizeInGb}
             * @param ebsVolumeSizeInGb The size of an EBS storage volume for a space. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsVolumeSizeInGb(java.lang.Number ebsVolumeSizeInGb) {
                this.ebsVolumeSizeInGb = ebsVolumeSizeInGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsStorageSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsStorageSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsStorageSettingsProperty {
            private final java.lang.Number ebsVolumeSizeInGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsVolumeSizeInGb = software.amazon.jsii.Kernel.get(this, "ebsVolumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsVolumeSizeInGb = java.util.Objects.requireNonNull(builder.ebsVolumeSizeInGb, "ebsVolumeSizeInGb is required");
            }

            @Override
            public final java.lang.Number getEbsVolumeSizeInGb() {
                return this.ebsVolumeSizeInGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ebsVolumeSizeInGb", om.valueToTree(this.getEbsVolumeSizeInGb()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.EbsStorageSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsStorageSettingsProperty.Jsii$Proxy that = (EbsStorageSettingsProperty.Jsii$Proxy) o;

                return this.ebsVolumeSizeInGb.equals(that.ebsVolumeSizeInGb);
            }

            @Override
            public final int hashCode() {
                int result = this.ebsVolumeSizeInGb.hashCode();
                return result;
            }
        }
    }
    /**
     * The JupyterServer app settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * JupyterServerAppSettingsProperty jupyterServerAppSettingsProperty = JupyterServerAppSettingsProperty.builder()
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-jupyterserverappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-jupyterserverappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.JupyterServerAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(JupyterServerAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JupyterServerAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
         * <p>
         * If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-jupyterserverappsettings.html#cfn-sagemaker-space-jupyterserverappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-jupyterserverappsettings.html#cfn-sagemaker-space-jupyterserverappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp.
         * <p>
         * If you use this parameter, the <code>DefaultResourceSpec</code> parameter is also required.
         * <p>
         * <blockquote>
         * <p>
         * To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-jupyterserverappsettings.html#cfn-sagemaker-space-jupyterserverappsettings-lifecycleconfigarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-jupyterserverappsettings.html#cfn-sagemaker-space-jupyterserverappsettings-lifecycleconfigarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLifecycleConfigArns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JupyterServerAppSettingsProperty> {
            java.lang.Object defaultResourceSpec;
            java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Sets the value of {@link JupyterServerAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
             *                            If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link JupyterServerAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
             *                            If you use the <code>LifecycleConfigArns</code> parameter, then this parameter is also required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnSpace.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link JupyterServerAppSettingsProperty#getLifecycleConfigArns}
             * @param lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp.
             *                            If you use this parameter, the <code>DefaultResourceSpec</code> parameter is also required.
             *                            <p>
             *                            <blockquote>
             *                            <p>
             *                            To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycleConfigArns(java.util.List<java.lang.String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JupyterServerAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JupyterServerAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JupyterServerAppSettingsProperty {
            private final java.lang.Object defaultResourceSpec;
            private final java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lifecycleConfigArns = software.amazon.jsii.Kernel.get(this, "lifecycleConfigArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultResourceSpec = builder.defaultResourceSpec;
                this.lifecycleConfigArns = builder.lifecycleConfigArns;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            public final java.util.List<java.lang.String> getLifecycleConfigArns() {
                return this.lifecycleConfigArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }
                if (this.getLifecycleConfigArns() != null) {
                    data.set("lifecycleConfigArns", om.valueToTree(this.getLifecycleConfigArns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.JupyterServerAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JupyterServerAppSettingsProperty.Jsii$Proxy that = (JupyterServerAppSettingsProperty.Jsii$Proxy) o;

                if (this.defaultResourceSpec != null ? !this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec != null) return false;
                return this.lifecycleConfigArns != null ? this.lifecycleConfigArns.equals(that.lifecycleConfigArns) : that.lifecycleConfigArns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0;
                result = 31 * result + (this.lifecycleConfigArns != null ? this.lifecycleConfigArns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The KernelGateway app settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * KernelGatewayAppSettingsProperty kernelGatewayAppSettingsProperty = KernelGatewayAppSettingsProperty.builder()
     *         .customImages(List.of(CustomImageProperty.builder()
     *                 .appImageConfigName("appImageConfigName")
     *                 .imageName("imageName")
     *                 // the properties below are optional
     *                 .imageVersionNumber(123)
     *                 .build()))
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-kernelgatewayappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-kernelgatewayappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.KernelGatewayAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KernelGatewayAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KernelGatewayAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of custom SageMaker images that are configured to run as a KernelGateway app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-kernelgatewayappsettings.html#cfn-sagemaker-space-kernelgatewayappsettings-customimages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-kernelgatewayappsettings.html#cfn-sagemaker-space-kernelgatewayappsettings-customimages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomImages() {
            return null;
        }

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
         * <p>
         * <blockquote>
         * <p>
         * The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-kernelgatewayappsettings.html#cfn-sagemaker-space-kernelgatewayappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-kernelgatewayappsettings.html#cfn-sagemaker-space-kernelgatewayappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.
         * <p>
         * <blockquote>
         * <p>
         * To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-kernelgatewayappsettings.html#cfn-sagemaker-space-kernelgatewayappsettings-lifecycleconfigarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-kernelgatewayappsettings.html#cfn-sagemaker-space-kernelgatewayappsettings-lifecycleconfigarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLifecycleConfigArns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KernelGatewayAppSettingsProperty> {
            java.lang.Object customImages;
            java.lang.Object defaultResourceSpec;
            java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a KernelGateway app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(software.amazon.awscdk.IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a KernelGateway app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(java.util.List<? extends java.lang.Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
             *                            <blockquote>
             *                            <p>
             *                            The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
             *                            <blockquote>
             *                            <p>
             *                            The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnSpace.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getLifecycleConfigArns}
             * @param lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.
             *                            <blockquote>
             *                            <p>
             *                            To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycleConfigArns(java.util.List<java.lang.String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KernelGatewayAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KernelGatewayAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KernelGatewayAppSettingsProperty {
            private final java.lang.Object customImages;
            private final java.lang.Object defaultResourceSpec;
            private final java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customImages = software.amazon.jsii.Kernel.get(this, "customImages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lifecycleConfigArns = software.amazon.jsii.Kernel.get(this, "lifecycleConfigArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customImages = builder.customImages;
                this.defaultResourceSpec = builder.defaultResourceSpec;
                this.lifecycleConfigArns = builder.lifecycleConfigArns;
            }

            @Override
            public final java.lang.Object getCustomImages() {
                return this.customImages;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            public final java.util.List<java.lang.String> getLifecycleConfigArns() {
                return this.lifecycleConfigArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomImages() != null) {
                    data.set("customImages", om.valueToTree(this.getCustomImages()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }
                if (this.getLifecycleConfigArns() != null) {
                    data.set("lifecycleConfigArns", om.valueToTree(this.getLifecycleConfigArns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.KernelGatewayAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KernelGatewayAppSettingsProperty.Jsii$Proxy that = (KernelGatewayAppSettingsProperty.Jsii$Proxy) o;

                if (this.customImages != null ? !this.customImages.equals(that.customImages) : that.customImages != null) return false;
                if (this.defaultResourceSpec != null ? !this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec != null) return false;
                return this.lifecycleConfigArns != null ? this.lifecycleConfigArns.equals(that.lifecycleConfigArns) : that.lifecycleConfigArns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customImages != null ? this.customImages.hashCode() : 0;
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                result = 31 * result + (this.lifecycleConfigArns != null ? this.lifecycleConfigArns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The collection of ownership settings for a space.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * OwnershipSettingsProperty ownershipSettingsProperty = OwnershipSettingsProperty.builder()
     *         .ownerUserProfileName("ownerUserProfileName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-ownershipsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-ownershipsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.OwnershipSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(OwnershipSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OwnershipSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The user profile who is the owner of the space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-ownershipsettings.html#cfn-sagemaker-space-ownershipsettings-owneruserprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-ownershipsettings.html#cfn-sagemaker-space-ownershipsettings-owneruserprofilename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOwnerUserProfileName();

        /**
         * @return a {@link Builder} of {@link OwnershipSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OwnershipSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OwnershipSettingsProperty> {
            java.lang.String ownerUserProfileName;

            /**
             * Sets the value of {@link OwnershipSettingsProperty#getOwnerUserProfileName}
             * @param ownerUserProfileName The user profile who is the owner of the space. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ownerUserProfileName(java.lang.String ownerUserProfileName) {
                this.ownerUserProfileName = ownerUserProfileName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OwnershipSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OwnershipSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OwnershipSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OwnershipSettingsProperty {
            private final java.lang.String ownerUserProfileName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ownerUserProfileName = software.amazon.jsii.Kernel.get(this, "ownerUserProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ownerUserProfileName = java.util.Objects.requireNonNull(builder.ownerUserProfileName, "ownerUserProfileName is required");
            }

            @Override
            public final java.lang.String getOwnerUserProfileName() {
                return this.ownerUserProfileName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ownerUserProfileName", om.valueToTree(this.getOwnerUserProfileName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.OwnershipSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OwnershipSettingsProperty.Jsii$Proxy that = (OwnershipSettingsProperty.Jsii$Proxy) o;

                return this.ownerUserProfileName.equals(that.ownerUserProfileName);
            }

            @Override
            public final int hashCode() {
                int result = this.ownerUserProfileName.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ResourceSpecProperty resourceSpecProperty = ResourceSpecProperty.builder()
     *         .instanceType("instanceType")
     *         .lifecycleConfigArn("lifecycleConfigArn")
     *         .sageMakerImageArn("sageMakerImageArn")
     *         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.ResourceSpecProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceSpecProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceSpecProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The instance type that the image version runs on.
         * <p>
         * <blockquote>
         * <p>
         * <em>JupyterServer apps</em> only support the <code>system</code> value.
         * <p>
         * For <em>KernelGateway apps</em> , the <code>system</code> value is translated to <code>ml.t3.medium</code> . KernelGateway apps also support all other values for available instance types.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html#cfn-sagemaker-space-resourcespec-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html#cfn-sagemaker-space-resourcespec-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html#cfn-sagemaker-space-resourcespec-lifecycleconfigarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html#cfn-sagemaker-space-resourcespec-lifecycleconfigarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLifecycleConfigArn() {
            return null;
        }

        /**
         * The ARN of the SageMaker image that the image version belongs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html#cfn-sagemaker-space-resourcespec-sagemakerimagearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html#cfn-sagemaker-space-resourcespec-sagemakerimagearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSageMakerImageArn() {
            return null;
        }

        /**
         * The ARN of the image version created on the instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html#cfn-sagemaker-space-resourcespec-sagemakerimageversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-resourcespec.html#cfn-sagemaker-space-resourcespec-sagemakerimageversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSageMakerImageVersionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceSpecProperty> {
            java.lang.String instanceType;
            java.lang.String lifecycleConfigArn;
            java.lang.String sageMakerImageArn;
            java.lang.String sageMakerImageVersionArn;

            /**
             * Sets the value of {@link ResourceSpecProperty#getInstanceType}
             * @param instanceType The instance type that the image version runs on.
             *                     <blockquote>
             *                     <p>
             *                     <em>JupyterServer apps</em> only support the <code>system</code> value.
             *                     <p>
             *                     For <em>KernelGateway apps</em> , the <code>system</code> value is translated to <code>ml.t3.medium</code> . KernelGateway apps also support all other values for available instance types.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getLifecycleConfigArn}
             * @param lifecycleConfigArn The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycleConfigArn(java.lang.String lifecycleConfigArn) {
                this.lifecycleConfigArn = lifecycleConfigArn;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getSageMakerImageArn}
             * @param sageMakerImageArn The ARN of the SageMaker image that the image version belongs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerImageArn(java.lang.String sageMakerImageArn) {
                this.sageMakerImageArn = sageMakerImageArn;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getSageMakerImageVersionArn}
             * @param sageMakerImageVersionArn The ARN of the image version created on the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerImageVersionArn(java.lang.String sageMakerImageVersionArn) {
                this.sageMakerImageVersionArn = sageMakerImageVersionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceSpecProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceSpecProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceSpecProperty {
            private final java.lang.String instanceType;
            private final java.lang.String lifecycleConfigArn;
            private final java.lang.String sageMakerImageArn;
            private final java.lang.String sageMakerImageVersionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lifecycleConfigArn = software.amazon.jsii.Kernel.get(this, "lifecycleConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sageMakerImageArn = software.amazon.jsii.Kernel.get(this, "sageMakerImageArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sageMakerImageVersionArn = software.amazon.jsii.Kernel.get(this, "sageMakerImageVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceType = builder.instanceType;
                this.lifecycleConfigArn = builder.lifecycleConfigArn;
                this.sageMakerImageArn = builder.sageMakerImageArn;
                this.sageMakerImageVersionArn = builder.sageMakerImageVersionArn;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getLifecycleConfigArn() {
                return this.lifecycleConfigArn;
            }

            @Override
            public final java.lang.String getSageMakerImageArn() {
                return this.sageMakerImageArn;
            }

            @Override
            public final java.lang.String getSageMakerImageVersionArn() {
                return this.sageMakerImageVersionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getLifecycleConfigArn() != null) {
                    data.set("lifecycleConfigArn", om.valueToTree(this.getLifecycleConfigArn()));
                }
                if (this.getSageMakerImageArn() != null) {
                    data.set("sageMakerImageArn", om.valueToTree(this.getSageMakerImageArn()));
                }
                if (this.getSageMakerImageVersionArn() != null) {
                    data.set("sageMakerImageVersionArn", om.valueToTree(this.getSageMakerImageVersionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.ResourceSpecProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceSpecProperty.Jsii$Proxy that = (ResourceSpecProperty.Jsii$Proxy) o;

                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.lifecycleConfigArn != null ? !this.lifecycleConfigArn.equals(that.lifecycleConfigArn) : that.lifecycleConfigArn != null) return false;
                if (this.sageMakerImageArn != null ? !this.sageMakerImageArn.equals(that.sageMakerImageArn) : that.sageMakerImageArn != null) return false;
                return this.sageMakerImageVersionArn != null ? this.sageMakerImageVersionArn.equals(that.sageMakerImageVersionArn) : that.sageMakerImageVersionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceType != null ? this.instanceType.hashCode() : 0;
                result = 31 * result + (this.lifecycleConfigArn != null ? this.lifecycleConfigArn.hashCode() : 0);
                result = 31 * result + (this.sageMakerImageArn != null ? this.sageMakerImageArn.hashCode() : 0);
                result = 31 * result + (this.sageMakerImageVersionArn != null ? this.sageMakerImageVersionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings that are used to configure and manage the lifecycle of Amazon SageMaker Studio applications in a space.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SpaceAppLifecycleManagementProperty spaceAppLifecycleManagementProperty = SpaceAppLifecycleManagementProperty.builder()
     *         .idleSettings(SpaceIdleSettingsProperty.builder()
     *                 .idleTimeoutInMinutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spaceapplifecyclemanagement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spaceapplifecyclemanagement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceAppLifecycleManagementProperty")
    @software.amazon.jsii.Jsii.Proxy(SpaceAppLifecycleManagementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpaceAppLifecycleManagementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings related to idle shutdown of Studio applications.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spaceapplifecyclemanagement.html#cfn-sagemaker-space-spaceapplifecyclemanagement-idlesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spaceapplifecyclemanagement.html#cfn-sagemaker-space-spaceapplifecyclemanagement-idlesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdleSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpaceAppLifecycleManagementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpaceAppLifecycleManagementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpaceAppLifecycleManagementProperty> {
            java.lang.Object idleSettings;

            /**
             * Sets the value of {@link SpaceAppLifecycleManagementProperty#getIdleSettings}
             * @param idleSettings Settings related to idle shutdown of Studio applications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleSettings(software.amazon.awscdk.IResolvable idleSettings) {
                this.idleSettings = idleSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceAppLifecycleManagementProperty#getIdleSettings}
             * @param idleSettings Settings related to idle shutdown of Studio applications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceIdleSettingsProperty idleSettings) {
                this.idleSettings = idleSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpaceAppLifecycleManagementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpaceAppLifecycleManagementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpaceAppLifecycleManagementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpaceAppLifecycleManagementProperty {
            private final java.lang.Object idleSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idleSettings = software.amazon.jsii.Kernel.get(this, "idleSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idleSettings = builder.idleSettings;
            }

            @Override
            public final java.lang.Object getIdleSettings() {
                return this.idleSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdleSettings() != null) {
                    data.set("idleSettings", om.valueToTree(this.getIdleSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceAppLifecycleManagementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpaceAppLifecycleManagementProperty.Jsii$Proxy that = (SpaceAppLifecycleManagementProperty.Jsii$Proxy) o;

                return this.idleSettings != null ? this.idleSettings.equals(that.idleSettings) : that.idleSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idleSettings != null ? this.idleSettings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The application settings for a Code Editor space.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SpaceCodeEditorAppSettingsProperty spaceCodeEditorAppSettingsProperty = SpaceCodeEditorAppSettingsProperty.builder()
     *         .appLifecycleManagement(SpaceAppLifecycleManagementProperty.builder()
     *                 .idleSettings(SpaceIdleSettingsProperty.builder()
     *                         .idleTimeoutInMinutes(123)
     *                         .build())
     *                 .build())
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacecodeeditorappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacecodeeditorappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceCodeEditorAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SpaceCodeEditorAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpaceCodeEditorAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacecodeeditorappsettings.html#cfn-sagemaker-space-spacecodeeditorappsettings-applifecyclemanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacecodeeditorappsettings.html#cfn-sagemaker-space-spacecodeeditorappsettings-applifecyclemanagement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAppLifecycleManagement() {
            return null;
        }

        /**
         * Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacecodeeditorappsettings.html#cfn-sagemaker-space-spacecodeeditorappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacecodeeditorappsettings.html#cfn-sagemaker-space-spacecodeeditorappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpaceCodeEditorAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpaceCodeEditorAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpaceCodeEditorAppSettingsProperty> {
            java.lang.Object appLifecycleManagement;
            java.lang.Object defaultResourceSpec;

            /**
             * Sets the value of {@link SpaceCodeEditorAppSettingsProperty#getAppLifecycleManagement}
             * @param appLifecycleManagement Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appLifecycleManagement(software.amazon.awscdk.IResolvable appLifecycleManagement) {
                this.appLifecycleManagement = appLifecycleManagement;
                return this;
            }

            /**
             * Sets the value of {@link SpaceCodeEditorAppSettingsProperty#getAppLifecycleManagement}
             * @param appLifecycleManagement Settings that are used to configure and manage the lifecycle of CodeEditor applications in a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appLifecycleManagement(software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceAppLifecycleManagementProperty appLifecycleManagement) {
                this.appLifecycleManagement = appLifecycleManagement;
                return this;
            }

            /**
             * Sets the value of {@link SpaceCodeEditorAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link SpaceCodeEditorAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnSpace.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpaceCodeEditorAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpaceCodeEditorAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpaceCodeEditorAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpaceCodeEditorAppSettingsProperty {
            private final java.lang.Object appLifecycleManagement;
            private final java.lang.Object defaultResourceSpec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appLifecycleManagement = software.amazon.jsii.Kernel.get(this, "appLifecycleManagement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appLifecycleManagement = builder.appLifecycleManagement;
                this.defaultResourceSpec = builder.defaultResourceSpec;
            }

            @Override
            public final java.lang.Object getAppLifecycleManagement() {
                return this.appLifecycleManagement;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppLifecycleManagement() != null) {
                    data.set("appLifecycleManagement", om.valueToTree(this.getAppLifecycleManagement()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceCodeEditorAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpaceCodeEditorAppSettingsProperty.Jsii$Proxy that = (SpaceCodeEditorAppSettingsProperty.Jsii$Proxy) o;

                if (this.appLifecycleManagement != null ? !this.appLifecycleManagement.equals(that.appLifecycleManagement) : that.appLifecycleManagement != null) return false;
                return this.defaultResourceSpec != null ? this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appLifecycleManagement != null ? this.appLifecycleManagement.hashCode() : 0;
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings related to idle shutdown of Studio applications in a space.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SpaceIdleSettingsProperty spaceIdleSettingsProperty = SpaceIdleSettingsProperty.builder()
     *         .idleTimeoutInMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spaceidlesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spaceidlesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceIdleSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SpaceIdleSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpaceIdleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time that SageMaker waits after the application becomes idle before shutting it down.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spaceidlesettings.html#cfn-sagemaker-space-spaceidlesettings-idletimeoutinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spaceidlesettings.html#cfn-sagemaker-space-spaceidlesettings-idletimeoutinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIdleTimeoutInMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpaceIdleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpaceIdleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpaceIdleSettingsProperty> {
            java.lang.Number idleTimeoutInMinutes;

            /**
             * Sets the value of {@link SpaceIdleSettingsProperty#getIdleTimeoutInMinutes}
             * @param idleTimeoutInMinutes The time that SageMaker waits after the application becomes idle before shutting it down.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleTimeoutInMinutes(java.lang.Number idleTimeoutInMinutes) {
                this.idleTimeoutInMinutes = idleTimeoutInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpaceIdleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpaceIdleSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpaceIdleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpaceIdleSettingsProperty {
            private final java.lang.Number idleTimeoutInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idleTimeoutInMinutes = software.amazon.jsii.Kernel.get(this, "idleTimeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idleTimeoutInMinutes = builder.idleTimeoutInMinutes;
            }

            @Override
            public final java.lang.Number getIdleTimeoutInMinutes() {
                return this.idleTimeoutInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdleTimeoutInMinutes() != null) {
                    data.set("idleTimeoutInMinutes", om.valueToTree(this.getIdleTimeoutInMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceIdleSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpaceIdleSettingsProperty.Jsii$Proxy that = (SpaceIdleSettingsProperty.Jsii$Proxy) o;

                return this.idleTimeoutInMinutes != null ? this.idleTimeoutInMinutes.equals(that.idleTimeoutInMinutes) : that.idleTimeoutInMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idleTimeoutInMinutes != null ? this.idleTimeoutInMinutes.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings for the JupyterLab application within a space.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SpaceJupyterLabAppSettingsProperty spaceJupyterLabAppSettingsProperty = SpaceJupyterLabAppSettingsProperty.builder()
     *         .appLifecycleManagement(SpaceAppLifecycleManagementProperty.builder()
     *                 .idleSettings(SpaceIdleSettingsProperty.builder()
     *                         .idleTimeoutInMinutes(123)
     *                         .build())
     *                 .build())
     *         .codeRepositories(List.of(CodeRepositoryProperty.builder()
     *                 .repositoryUrl("repositoryUrl")
     *                 .build()))
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacejupyterlabappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacejupyterlabappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceJupyterLabAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SpaceJupyterLabAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpaceJupyterLabAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacejupyterlabappsettings.html#cfn-sagemaker-space-spacejupyterlabappsettings-applifecyclemanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacejupyterlabappsettings.html#cfn-sagemaker-space-spacejupyterlabappsettings-applifecyclemanagement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAppLifecycleManagement() {
            return null;
        }

        /**
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacejupyterlabappsettings.html#cfn-sagemaker-space-spacejupyterlabappsettings-coderepositories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacejupyterlabappsettings.html#cfn-sagemaker-space-spacejupyterlabappsettings-coderepositories</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeRepositories() {
            return null;
        }

        /**
         * Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacejupyterlabappsettings.html#cfn-sagemaker-space-spacejupyterlabappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacejupyterlabappsettings.html#cfn-sagemaker-space-spacejupyterlabappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpaceJupyterLabAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpaceJupyterLabAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpaceJupyterLabAppSettingsProperty> {
            java.lang.Object appLifecycleManagement;
            java.lang.Object codeRepositories;
            java.lang.Object defaultResourceSpec;

            /**
             * Sets the value of {@link SpaceJupyterLabAppSettingsProperty#getAppLifecycleManagement}
             * @param appLifecycleManagement Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appLifecycleManagement(software.amazon.awscdk.IResolvable appLifecycleManagement) {
                this.appLifecycleManagement = appLifecycleManagement;
                return this;
            }

            /**
             * Sets the value of {@link SpaceJupyterLabAppSettingsProperty#getAppLifecycleManagement}
             * @param appLifecycleManagement Settings that are used to configure and manage the lifecycle of JupyterLab applications in a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appLifecycleManagement(software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceAppLifecycleManagementProperty appLifecycleManagement) {
                this.appLifecycleManagement = appLifecycleManagement;
                return this;
            }

            /**
             * Sets the value of {@link SpaceJupyterLabAppSettingsProperty#getCodeRepositories}
             * @param codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepositories(software.amazon.awscdk.IResolvable codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            /**
             * Sets the value of {@link SpaceJupyterLabAppSettingsProperty#getCodeRepositories}
             * @param codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepositories(java.util.List<? extends java.lang.Object> codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            /**
             * Sets the value of {@link SpaceJupyterLabAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link SpaceJupyterLabAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnSpace.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpaceJupyterLabAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpaceJupyterLabAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpaceJupyterLabAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpaceJupyterLabAppSettingsProperty {
            private final java.lang.Object appLifecycleManagement;
            private final java.lang.Object codeRepositories;
            private final java.lang.Object defaultResourceSpec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appLifecycleManagement = software.amazon.jsii.Kernel.get(this, "appLifecycleManagement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeRepositories = software.amazon.jsii.Kernel.get(this, "codeRepositories", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appLifecycleManagement = builder.appLifecycleManagement;
                this.codeRepositories = builder.codeRepositories;
                this.defaultResourceSpec = builder.defaultResourceSpec;
            }

            @Override
            public final java.lang.Object getAppLifecycleManagement() {
                return this.appLifecycleManagement;
            }

            @Override
            public final java.lang.Object getCodeRepositories() {
                return this.codeRepositories;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppLifecycleManagement() != null) {
                    data.set("appLifecycleManagement", om.valueToTree(this.getAppLifecycleManagement()));
                }
                if (this.getCodeRepositories() != null) {
                    data.set("codeRepositories", om.valueToTree(this.getCodeRepositories()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceJupyterLabAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpaceJupyterLabAppSettingsProperty.Jsii$Proxy that = (SpaceJupyterLabAppSettingsProperty.Jsii$Proxy) o;

                if (this.appLifecycleManagement != null ? !this.appLifecycleManagement.equals(that.appLifecycleManagement) : that.appLifecycleManagement != null) return false;
                if (this.codeRepositories != null ? !this.codeRepositories.equals(that.codeRepositories) : that.codeRepositories != null) return false;
                return this.defaultResourceSpec != null ? this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appLifecycleManagement != null ? this.appLifecycleManagement.hashCode() : 0;
                result = 31 * result + (this.codeRepositories != null ? this.codeRepositories.hashCode() : 0);
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of space settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SpaceSettingsProperty spaceSettingsProperty = SpaceSettingsProperty.builder()
     *         .appType("appType")
     *         .codeEditorAppSettings(SpaceCodeEditorAppSettingsProperty.builder()
     *                 .appLifecycleManagement(SpaceAppLifecycleManagementProperty.builder()
     *                         .idleSettings(SpaceIdleSettingsProperty.builder()
     *                                 .idleTimeoutInMinutes(123)
     *                                 .build())
     *                         .build())
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .customFileSystems(List.of(CustomFileSystemProperty.builder()
     *                 .efsFileSystem(EFSFileSystemProperty.builder()
     *                         .fileSystemId("fileSystemId")
     *                         .build())
     *                 .build()))
     *         .jupyterLabAppSettings(SpaceJupyterLabAppSettingsProperty.builder()
     *                 .appLifecycleManagement(SpaceAppLifecycleManagementProperty.builder()
     *                         .idleSettings(SpaceIdleSettingsProperty.builder()
     *                                 .idleTimeoutInMinutes(123)
     *                                 .build())
     *                         .build())
     *                 .codeRepositories(List.of(CodeRepositoryProperty.builder()
     *                         .repositoryUrl("repositoryUrl")
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *                 .build())
     *         .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *                 .build())
     *         .spaceStorageSettings(SpaceStorageSettingsProperty.builder()
     *                 .ebsStorageSettings(EbsStorageSettingsProperty.builder()
     *                         .ebsVolumeSizeInGb(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SpaceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpaceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of app created within the space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-apptype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-apptype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppType() {
            return null;
        }

        /**
         * The Code Editor application settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-codeeditorappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-codeeditorappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeEditorAppSettings() {
            return null;
        }

        /**
         * A file system, created by you, that you assign to a space for an Amazon SageMaker Domain.
         * <p>
         * Permitted users can access this file system in Amazon SageMaker Studio.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-customfilesystems">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-customfilesystems</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomFileSystems() {
            return null;
        }

        /**
         * The settings for the JupyterLab application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-jupyterlabappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-jupyterlabappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJupyterLabAppSettings() {
            return null;
        }

        /**
         * The JupyterServer app settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-jupyterserverappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-jupyterserverappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJupyterServerAppSettings() {
            return null;
        }

        /**
         * The KernelGateway app settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-kernelgatewayappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-kernelgatewayappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKernelGatewayAppSettings() {
            return null;
        }

        /**
         * The storage settings for a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-spacestoragesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesettings.html#cfn-sagemaker-space-spacesettings-spacestoragesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpaceStorageSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpaceSettingsProperty> {
            java.lang.String appType;
            java.lang.Object codeEditorAppSettings;
            java.lang.Object customFileSystems;
            java.lang.Object jupyterLabAppSettings;
            java.lang.Object jupyterServerAppSettings;
            java.lang.Object kernelGatewayAppSettings;
            java.lang.Object spaceStorageSettings;

            /**
             * Sets the value of {@link SpaceSettingsProperty#getAppType}
             * @param appType The type of app created within the space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appType(java.lang.String appType) {
                this.appType = appType;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getCodeEditorAppSettings}
             * @param codeEditorAppSettings The Code Editor application settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeEditorAppSettings(software.amazon.awscdk.IResolvable codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getCodeEditorAppSettings}
             * @param codeEditorAppSettings The Code Editor application settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeEditorAppSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceCodeEditorAppSettingsProperty codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getCustomFileSystems}
             * @param customFileSystems A file system, created by you, that you assign to a space for an Amazon SageMaker Domain.
             *                          Permitted users can access this file system in Amazon SageMaker Studio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFileSystems(software.amazon.awscdk.IResolvable customFileSystems) {
                this.customFileSystems = customFileSystems;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getCustomFileSystems}
             * @param customFileSystems A file system, created by you, that you assign to a space for an Amazon SageMaker Domain.
             *                          Permitted users can access this file system in Amazon SageMaker Studio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFileSystems(java.util.List<? extends java.lang.Object> customFileSystems) {
                this.customFileSystems = customFileSystems;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getJupyterLabAppSettings}
             * @param jupyterLabAppSettings The settings for the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterLabAppSettings(software.amazon.awscdk.IResolvable jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getJupyterLabAppSettings}
             * @param jupyterLabAppSettings The settings for the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterLabAppSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceJupyterLabAppSettingsProperty jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The JupyterServer app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.IResolvable jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The JupyterServer app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.JupyterServerAppSettingsProperty jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The KernelGateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.IResolvable kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The KernelGateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.KernelGatewayAppSettingsProperty kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getSpaceStorageSettings}
             * @param spaceStorageSettings The storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceStorageSettings(software.amazon.awscdk.IResolvable spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceSettingsProperty#getSpaceStorageSettings}
             * @param spaceStorageSettings The storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceStorageSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceStorageSettingsProperty spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpaceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpaceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpaceSettingsProperty {
            private final java.lang.String appType;
            private final java.lang.Object codeEditorAppSettings;
            private final java.lang.Object customFileSystems;
            private final java.lang.Object jupyterLabAppSettings;
            private final java.lang.Object jupyterServerAppSettings;
            private final java.lang.Object kernelGatewayAppSettings;
            private final java.lang.Object spaceStorageSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appType = software.amazon.jsii.Kernel.get(this, "appType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.codeEditorAppSettings = software.amazon.jsii.Kernel.get(this, "codeEditorAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customFileSystems = software.amazon.jsii.Kernel.get(this, "customFileSystems", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jupyterLabAppSettings = software.amazon.jsii.Kernel.get(this, "jupyterLabAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jupyterServerAppSettings = software.amazon.jsii.Kernel.get(this, "jupyterServerAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kernelGatewayAppSettings = software.amazon.jsii.Kernel.get(this, "kernelGatewayAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spaceStorageSettings = software.amazon.jsii.Kernel.get(this, "spaceStorageSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appType = builder.appType;
                this.codeEditorAppSettings = builder.codeEditorAppSettings;
                this.customFileSystems = builder.customFileSystems;
                this.jupyterLabAppSettings = builder.jupyterLabAppSettings;
                this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
                this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
                this.spaceStorageSettings = builder.spaceStorageSettings;
            }

            @Override
            public final java.lang.String getAppType() {
                return this.appType;
            }

            @Override
            public final java.lang.Object getCodeEditorAppSettings() {
                return this.codeEditorAppSettings;
            }

            @Override
            public final java.lang.Object getCustomFileSystems() {
                return this.customFileSystems;
            }

            @Override
            public final java.lang.Object getJupyterLabAppSettings() {
                return this.jupyterLabAppSettings;
            }

            @Override
            public final java.lang.Object getJupyterServerAppSettings() {
                return this.jupyterServerAppSettings;
            }

            @Override
            public final java.lang.Object getKernelGatewayAppSettings() {
                return this.kernelGatewayAppSettings;
            }

            @Override
            public final java.lang.Object getSpaceStorageSettings() {
                return this.spaceStorageSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppType() != null) {
                    data.set("appType", om.valueToTree(this.getAppType()));
                }
                if (this.getCodeEditorAppSettings() != null) {
                    data.set("codeEditorAppSettings", om.valueToTree(this.getCodeEditorAppSettings()));
                }
                if (this.getCustomFileSystems() != null) {
                    data.set("customFileSystems", om.valueToTree(this.getCustomFileSystems()));
                }
                if (this.getJupyterLabAppSettings() != null) {
                    data.set("jupyterLabAppSettings", om.valueToTree(this.getJupyterLabAppSettings()));
                }
                if (this.getJupyterServerAppSettings() != null) {
                    data.set("jupyterServerAppSettings", om.valueToTree(this.getJupyterServerAppSettings()));
                }
                if (this.getKernelGatewayAppSettings() != null) {
                    data.set("kernelGatewayAppSettings", om.valueToTree(this.getKernelGatewayAppSettings()));
                }
                if (this.getSpaceStorageSettings() != null) {
                    data.set("spaceStorageSettings", om.valueToTree(this.getSpaceStorageSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpaceSettingsProperty.Jsii$Proxy that = (SpaceSettingsProperty.Jsii$Proxy) o;

                if (this.appType != null ? !this.appType.equals(that.appType) : that.appType != null) return false;
                if (this.codeEditorAppSettings != null ? !this.codeEditorAppSettings.equals(that.codeEditorAppSettings) : that.codeEditorAppSettings != null) return false;
                if (this.customFileSystems != null ? !this.customFileSystems.equals(that.customFileSystems) : that.customFileSystems != null) return false;
                if (this.jupyterLabAppSettings != null ? !this.jupyterLabAppSettings.equals(that.jupyterLabAppSettings) : that.jupyterLabAppSettings != null) return false;
                if (this.jupyterServerAppSettings != null ? !this.jupyterServerAppSettings.equals(that.jupyterServerAppSettings) : that.jupyterServerAppSettings != null) return false;
                if (this.kernelGatewayAppSettings != null ? !this.kernelGatewayAppSettings.equals(that.kernelGatewayAppSettings) : that.kernelGatewayAppSettings != null) return false;
                return this.spaceStorageSettings != null ? this.spaceStorageSettings.equals(that.spaceStorageSettings) : that.spaceStorageSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appType != null ? this.appType.hashCode() : 0;
                result = 31 * result + (this.codeEditorAppSettings != null ? this.codeEditorAppSettings.hashCode() : 0);
                result = 31 * result + (this.customFileSystems != null ? this.customFileSystems.hashCode() : 0);
                result = 31 * result + (this.jupyterLabAppSettings != null ? this.jupyterLabAppSettings.hashCode() : 0);
                result = 31 * result + (this.jupyterServerAppSettings != null ? this.jupyterServerAppSettings.hashCode() : 0);
                result = 31 * result + (this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.hashCode() : 0);
                result = 31 * result + (this.spaceStorageSettings != null ? this.spaceStorageSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of space sharing settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SpaceSharingSettingsProperty spaceSharingSettingsProperty = SpaceSharingSettingsProperty.builder()
     *         .sharingType("sharingType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesharingsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesharingsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceSharingSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SpaceSharingSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpaceSharingSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the sharing type of the space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesharingsettings.html#cfn-sagemaker-space-spacesharingsettings-sharingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacesharingsettings.html#cfn-sagemaker-space-spacesharingsettings-sharingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSharingType();

        /**
         * @return a {@link Builder} of {@link SpaceSharingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpaceSharingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpaceSharingSettingsProperty> {
            java.lang.String sharingType;

            /**
             * Sets the value of {@link SpaceSharingSettingsProperty#getSharingType}
             * @param sharingType Specifies the sharing type of the space. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharingType(java.lang.String sharingType) {
                this.sharingType = sharingType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpaceSharingSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpaceSharingSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpaceSharingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpaceSharingSettingsProperty {
            private final java.lang.String sharingType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sharingType = software.amazon.jsii.Kernel.get(this, "sharingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sharingType = java.util.Objects.requireNonNull(builder.sharingType, "sharingType is required");
            }

            @Override
            public final java.lang.String getSharingType() {
                return this.sharingType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sharingType", om.valueToTree(this.getSharingType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceSharingSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpaceSharingSettingsProperty.Jsii$Proxy that = (SpaceSharingSettingsProperty.Jsii$Proxy) o;

                return this.sharingType.equals(that.sharingType);
            }

            @Override
            public final int hashCode() {
                int result = this.sharingType.hashCode();
                return result;
            }
        }
    }
    /**
     * The storage settings for a space.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SpaceStorageSettingsProperty spaceStorageSettingsProperty = SpaceStorageSettingsProperty.builder()
     *         .ebsStorageSettings(EbsStorageSettingsProperty.builder()
     *                 .ebsVolumeSizeInGb(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacestoragesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacestoragesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceStorageSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SpaceStorageSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpaceStorageSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A collection of EBS storage settings for a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacestoragesettings.html#cfn-sagemaker-space-spacestoragesettings-ebsstoragesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-space-spacestoragesettings.html#cfn-sagemaker-space-spacestoragesettings-ebsstoragesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsStorageSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpaceStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpaceStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpaceStorageSettingsProperty> {
            java.lang.Object ebsStorageSettings;

            /**
             * Sets the value of {@link SpaceStorageSettingsProperty#getEbsStorageSettings}
             * @param ebsStorageSettings A collection of EBS storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsStorageSettings(software.amazon.awscdk.IResolvable ebsStorageSettings) {
                this.ebsStorageSettings = ebsStorageSettings;
                return this;
            }

            /**
             * Sets the value of {@link SpaceStorageSettingsProperty#getEbsStorageSettings}
             * @param ebsStorageSettings A collection of EBS storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsStorageSettings(software.amazon.awscdk.services.sagemaker.CfnSpace.EbsStorageSettingsProperty ebsStorageSettings) {
                this.ebsStorageSettings = ebsStorageSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpaceStorageSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpaceStorageSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpaceStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpaceStorageSettingsProperty {
            private final java.lang.Object ebsStorageSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsStorageSettings = software.amazon.jsii.Kernel.get(this, "ebsStorageSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsStorageSettings = builder.ebsStorageSettings;
            }

            @Override
            public final java.lang.Object getEbsStorageSettings() {
                return this.ebsStorageSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsStorageSettings() != null) {
                    data.set("ebsStorageSettings", om.valueToTree(this.getEbsStorageSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceStorageSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpaceStorageSettingsProperty.Jsii$Proxy that = (SpaceStorageSettingsProperty.Jsii$Proxy) o;

                return this.ebsStorageSettings != null ? this.ebsStorageSettings.equals(that.ebsStorageSettings) : that.ebsStorageSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsStorageSettings != null ? this.ebsStorageSettings.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnSpace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnSpace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnSpaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnSpaceProps.Builder();
        }

        /**
         * The ID of the associated domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-domainid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-domainid</a>
         * @param domainId The ID of the associated domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainId(final java.lang.String domainId) {
            this.props.domainId(domainId);
            return this;
        }

        /**
         * The name of the space.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacename</a>
         * @param spaceName The name of the space. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceName(final java.lang.String spaceName) {
            this.props.spaceName(spaceName);
            return this;
        }

        /**
         * The collection of ownership settings for a space.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-ownershipsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-ownershipsettings</a>
         * @param ownershipSettings The collection of ownership settings for a space. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipSettings(final software.amazon.awscdk.IResolvable ownershipSettings) {
            this.props.ownershipSettings(ownershipSettings);
            return this;
        }
        /**
         * The collection of ownership settings for a space.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-ownershipsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-ownershipsettings</a>
         * @param ownershipSettings The collection of ownership settings for a space. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipSettings(final software.amazon.awscdk.services.sagemaker.CfnSpace.OwnershipSettingsProperty ownershipSettings) {
            this.props.ownershipSettings(ownershipSettings);
            return this;
        }

        /**
         * The name of the space that appears in the Studio UI.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacedisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacedisplayname</a>
         * @param spaceDisplayName The name of the space that appears in the Studio UI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceDisplayName(final java.lang.String spaceDisplayName) {
            this.props.spaceDisplayName(spaceDisplayName);
            return this;
        }

        /**
         * A collection of space settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesettings</a>
         * @param spaceSettings A collection of space settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSettings(final software.amazon.awscdk.IResolvable spaceSettings) {
            this.props.spaceSettings(spaceSettings);
            return this;
        }
        /**
         * A collection of space settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesettings</a>
         * @param spaceSettings A collection of space settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSettings(final software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceSettingsProperty spaceSettings) {
            this.props.spaceSettings(spaceSettings);
            return this;
        }

        /**
         * A collection of space sharing settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesharingsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesharingsettings</a>
         * @param spaceSharingSettings A collection of space sharing settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSharingSettings(final software.amazon.awscdk.IResolvable spaceSharingSettings) {
            this.props.spaceSharingSettings(spaceSharingSettings);
            return this;
        }
        /**
         * A collection of space sharing settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesharingsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-spacesharingsettings</a>
         * @param spaceSharingSettings A collection of space sharing settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spaceSharingSettings(final software.amazon.awscdk.services.sagemaker.CfnSpace.SpaceSharingSettingsProperty spaceSharingSettings) {
            this.props.spaceSharingSettings(spaceSharingSettings);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-space.html#cfn-sagemaker-space-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnSpace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnSpace build() {
            return new software.amazon.awscdk.services.sagemaker.CfnSpace(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
