package software.amazon.awscdk.services.ses;

/**
 * Properties for defining a <code>CfnMailManagerRelay</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * Object noAuthentication;
 * CfnMailManagerRelayProps cfnMailManagerRelayProps = CfnMailManagerRelayProps.builder()
 *         .authentication(RelayAuthenticationProperty.builder()
 *                 .noAuthentication(noAuthentication)
 *                 .secretArn("secretArn")
 *                 .build())
 *         .serverName("serverName")
 *         .serverPort(123)
 *         // the properties below are optional
 *         .relayName("relayName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:27.322Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRelayProps")
@software.amazon.jsii.Jsii.Proxy(CfnMailManagerRelayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMailManagerRelayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-authentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-authentication</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAuthentication();

    /**
     * The destination relay server address.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-servername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerName();

    /**
     * The destination relay server port.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-serverport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-serverport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getServerPort();

    /**
     * The unique relay name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-relayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-relayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRelayName() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for the resource.
     * <p>
     * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerrelay.html#cfn-ses-mailmanagerrelay-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMailManagerRelayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMailManagerRelayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMailManagerRelayProps> {
        java.lang.Object authentication;
        java.lang.String serverName;
        java.lang.Number serverPort;
        java.lang.String relayName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMailManagerRelayProps#getAuthentication}
         * @param authentication Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authentication(software.amazon.awscdk.IResolvable authentication) {
            this.authentication = authentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerRelayProps#getAuthentication}
         * @param authentication Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authentication(software.amazon.awscdk.services.ses.CfnMailManagerRelay.RelayAuthenticationProperty authentication) {
            this.authentication = authentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerRelayProps#getServerName}
         * @param serverName The destination relay server address. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverName(java.lang.String serverName) {
            this.serverName = serverName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerRelayProps#getServerPort}
         * @param serverPort The destination relay server port. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverPort(java.lang.Number serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerRelayProps#getRelayName}
         * @param relayName The unique relay name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relayName(java.lang.String relayName) {
            this.relayName = relayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerRelayProps#getTags}
         * @param tags The tags used to organize, track, or control access for the resource.
         *             For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMailManagerRelayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMailManagerRelayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMailManagerRelayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMailManagerRelayProps {
        private final java.lang.Object authentication;
        private final java.lang.String serverName;
        private final java.lang.Number serverPort;
        private final java.lang.String relayName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authentication = software.amazon.jsii.Kernel.get(this, "authentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverPort = software.amazon.jsii.Kernel.get(this, "serverPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.relayName = software.amazon.jsii.Kernel.get(this, "relayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authentication = java.util.Objects.requireNonNull(builder.authentication, "authentication is required");
            this.serverName = java.util.Objects.requireNonNull(builder.serverName, "serverName is required");
            this.serverPort = java.util.Objects.requireNonNull(builder.serverPort, "serverPort is required");
            this.relayName = builder.relayName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAuthentication() {
            return this.authentication;
        }

        @Override
        public final java.lang.String getServerName() {
            return this.serverName;
        }

        @Override
        public final java.lang.Number getServerPort() {
            return this.serverPort;
        }

        @Override
        public final java.lang.String getRelayName() {
            return this.relayName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authentication", om.valueToTree(this.getAuthentication()));
            data.set("serverName", om.valueToTree(this.getServerName()));
            data.set("serverPort", om.valueToTree(this.getServerPort()));
            if (this.getRelayName() != null) {
                data.set("relayName", om.valueToTree(this.getRelayName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRelayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMailManagerRelayProps.Jsii$Proxy that = (CfnMailManagerRelayProps.Jsii$Proxy) o;

            if (!authentication.equals(that.authentication)) return false;
            if (!serverName.equals(that.serverName)) return false;
            if (!serverPort.equals(that.serverPort)) return false;
            if (this.relayName != null ? !this.relayName.equals(that.relayName) : that.relayName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authentication.hashCode();
            result = 31 * result + (this.serverName.hashCode());
            result = 31 * result + (this.serverPort.hashCode());
            result = 31 * result + (this.relayName != null ? this.relayName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
