package software.amazon.awscdk.services.ses;

/**
 * Construction properties for a ReceiptRule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * ReceiptRule receiptRule;
 * IReceiptRuleAction receiptRuleAction;
 * ReceiptRuleSet receiptRuleSet;
 * ReceiptRuleProps receiptRuleProps = ReceiptRuleProps.builder()
 *         .ruleSet(receiptRuleSet)
 *         // the properties below are optional
 *         .actions(List.of(receiptRuleAction))
 *         .after(receiptRule)
 *         .enabled(false)
 *         .receiptRuleName("receiptRuleName")
 *         .recipients(List.of("recipients"))
 *         .scanEnabled(false)
 *         .tlsPolicy(TlsPolicy.OPTIONAL)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:27.397Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ReceiptRuleProps")
@software.amazon.jsii.Jsii.Proxy(ReceiptRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReceiptRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ses.ReceiptRuleOptions {

    /**
     * The name of the rule set that the receipt rule will be added to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IReceiptRuleSet getRuleSet();

    /**
     * @return a {@link Builder} of {@link ReceiptRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReceiptRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReceiptRuleProps> {
        software.amazon.awscdk.services.ses.IReceiptRuleSet ruleSet;
        java.util.List<software.amazon.awscdk.services.ses.IReceiptRuleAction> actions;
        software.amazon.awscdk.services.ses.IReceiptRule after;
        java.lang.Boolean enabled;
        java.lang.String receiptRuleName;
        java.util.List<java.lang.String> recipients;
        java.lang.Boolean scanEnabled;
        software.amazon.awscdk.services.ses.TlsPolicy tlsPolicy;

        /**
         * Sets the value of {@link ReceiptRuleProps#getRuleSet}
         * @param ruleSet The name of the rule set that the receipt rule will be added to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSet(software.amazon.awscdk.services.ses.IReceiptRuleSet ruleSet) {
            this.ruleSet = ruleSet;
            return this;
        }

        /**
         * Sets the value of {@link ReceiptRuleProps#getActions}
         * @param actions An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder actions(java.util.List<? extends software.amazon.awscdk.services.ses.IReceiptRuleAction> actions) {
            this.actions = (java.util.List<software.amazon.awscdk.services.ses.IReceiptRuleAction>)actions;
            return this;
        }

        /**
         * Sets the value of {@link ReceiptRuleProps#getAfter}
         * @param after An existing rule after which the new rule will be placed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder after(software.amazon.awscdk.services.ses.IReceiptRule after) {
            this.after = after;
            return this;
        }

        /**
         * Sets the value of {@link ReceiptRuleProps#getEnabled}
         * @param enabled Whether the rule is active.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ReceiptRuleProps#getReceiptRuleName}
         * @param receiptRuleName The name for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiptRuleName(java.lang.String receiptRuleName) {
            this.receiptRuleName = receiptRuleName;
            return this;
        }

        /**
         * Sets the value of {@link ReceiptRuleProps#getRecipients}
         * @param recipients The recipient domains and email addresses that the receipt rule applies to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipients(java.util.List<java.lang.String> recipients) {
            this.recipients = recipients;
            return this;
        }

        /**
         * Sets the value of {@link ReceiptRuleProps#getScanEnabled}
         * @param scanEnabled Whether to scan for spam and viruses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanEnabled(java.lang.Boolean scanEnabled) {
            this.scanEnabled = scanEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ReceiptRuleProps#getTlsPolicy}
         * @param tlsPolicy Whether Amazon SES should require that incoming email is delivered over a connection encrypted with Transport Layer Security (TLS).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsPolicy(software.amazon.awscdk.services.ses.TlsPolicy tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReceiptRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReceiptRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReceiptRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReceiptRuleProps {
        private final software.amazon.awscdk.services.ses.IReceiptRuleSet ruleSet;
        private final java.util.List<software.amazon.awscdk.services.ses.IReceiptRuleAction> actions;
        private final software.amazon.awscdk.services.ses.IReceiptRule after;
        private final java.lang.Boolean enabled;
        private final java.lang.String receiptRuleName;
        private final java.util.List<java.lang.String> recipients;
        private final java.lang.Boolean scanEnabled;
        private final software.amazon.awscdk.services.ses.TlsPolicy tlsPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ruleSet = software.amazon.jsii.Kernel.get(this, "ruleSet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IReceiptRuleSet.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IReceiptRuleAction.class)));
            this.after = software.amazon.jsii.Kernel.get(this, "after", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IReceiptRule.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.receiptRuleName = software.amazon.jsii.Kernel.get(this, "receiptRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recipients = software.amazon.jsii.Kernel.get(this, "recipients", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.scanEnabled = software.amazon.jsii.Kernel.get(this, "scanEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.tlsPolicy = software.amazon.jsii.Kernel.get(this, "tlsPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.TlsPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ruleSet = java.util.Objects.requireNonNull(builder.ruleSet, "ruleSet is required");
            this.actions = (java.util.List<software.amazon.awscdk.services.ses.IReceiptRuleAction>)builder.actions;
            this.after = builder.after;
            this.enabled = builder.enabled;
            this.receiptRuleName = builder.receiptRuleName;
            this.recipients = builder.recipients;
            this.scanEnabled = builder.scanEnabled;
            this.tlsPolicy = builder.tlsPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.ses.IReceiptRuleSet getRuleSet() {
            return this.ruleSet;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ses.IReceiptRuleAction> getActions() {
            return this.actions;
        }

        @Override
        public final software.amazon.awscdk.services.ses.IReceiptRule getAfter() {
            return this.after;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getReceiptRuleName() {
            return this.receiptRuleName;
        }

        @Override
        public final java.util.List<java.lang.String> getRecipients() {
            return this.recipients;
        }

        @Override
        public final java.lang.Boolean getScanEnabled() {
            return this.scanEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.ses.TlsPolicy getTlsPolicy() {
            return this.tlsPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ruleSet", om.valueToTree(this.getRuleSet()));
            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getAfter() != null) {
                data.set("after", om.valueToTree(this.getAfter()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getReceiptRuleName() != null) {
                data.set("receiptRuleName", om.valueToTree(this.getReceiptRuleName()));
            }
            if (this.getRecipients() != null) {
                data.set("recipients", om.valueToTree(this.getRecipients()));
            }
            if (this.getScanEnabled() != null) {
                data.set("scanEnabled", om.valueToTree(this.getScanEnabled()));
            }
            if (this.getTlsPolicy() != null) {
                data.set("tlsPolicy", om.valueToTree(this.getTlsPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.ReceiptRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReceiptRuleProps.Jsii$Proxy that = (ReceiptRuleProps.Jsii$Proxy) o;

            if (!ruleSet.equals(that.ruleSet)) return false;
            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            if (this.after != null ? !this.after.equals(that.after) : that.after != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.receiptRuleName != null ? !this.receiptRuleName.equals(that.receiptRuleName) : that.receiptRuleName != null) return false;
            if (this.recipients != null ? !this.recipients.equals(that.recipients) : that.recipients != null) return false;
            if (this.scanEnabled != null ? !this.scanEnabled.equals(that.scanEnabled) : that.scanEnabled != null) return false;
            return this.tlsPolicy != null ? this.tlsPolicy.equals(that.tlsPolicy) : that.tlsPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ruleSet.hashCode();
            result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
            result = 31 * result + (this.after != null ? this.after.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.receiptRuleName != null ? this.receiptRuleName.hashCode() : 0);
            result = 31 * result + (this.recipients != null ? this.recipients.hashCode() : 0);
            result = 31 * result + (this.scanEnabled != null ? this.scanEnabled.hashCode() : 0);
            result = 31 * result + (this.tlsPolicy != null ? this.tlsPolicy.hashCode() : 0);
            return result;
        }
    }
}
