package software.amazon.awscdk.services.sns;

/**
 * Options for customising the delivery of SNS messages to HTTP/S endpoints.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic myTopic = new Topic(this, "MyTopic");
 * myTopic.addSubscription(
 * UrlSubscription.Builder.create("https://foobar.com/")
 *         .deliveryPolicy(DeliveryPolicy.builder()
 *                 .healthyRetryPolicy(HealthyRetryPolicy.builder()
 *                         .minDelayTarget(Duration.seconds(5))
 *                         .maxDelayTarget(Duration.seconds(10))
 *                         .numRetries(6)
 *                         .backoffFunction(BackoffFunction.EXPONENTIAL)
 *                         .build())
 *                 .throttlePolicy(ThrottlePolicy.builder()
 *                         .maxReceivesPerSecond(10)
 *                         .build())
 *                 .requestPolicy(RequestPolicy.builder()
 *                         .headerContentType("application/json")
 *                         .build())
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:27.465Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.DeliveryPolicy")
@software.amazon.jsii.Jsii.Proxy(DeliveryPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeliveryPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * The retry policy of the delivery of SNS messages to HTTP/S endpoints.
     * <p>
     * Default: - Amazon SNS attempts up to three retries with a delay between failed attempts set at 20 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.HealthyRetryPolicy getHealthyRetryPolicy() {
        return null;
    }

    /**
     * The request of the content sent in AWS SNS HTTP/S requests.
     * <p>
     * Default: - The content type is set to 'text/plain; charset=UTF-8'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.RequestPolicy getRequestPolicy() {
        return null;
    }

    /**
     * The throttling policy of the delivery of SNS messages to HTTP/S endpoints.
     * <p>
     * Default: - No throttling
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ThrottlePolicy getThrottlePolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeliveryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeliveryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeliveryPolicy> {
        software.amazon.awscdk.services.sns.HealthyRetryPolicy healthyRetryPolicy;
        software.amazon.awscdk.services.sns.RequestPolicy requestPolicy;
        software.amazon.awscdk.services.sns.ThrottlePolicy throttlePolicy;

        /**
         * Sets the value of {@link DeliveryPolicy#getHealthyRetryPolicy}
         * @param healthyRetryPolicy The retry policy of the delivery of SNS messages to HTTP/S endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthyRetryPolicy(software.amazon.awscdk.services.sns.HealthyRetryPolicy healthyRetryPolicy) {
            this.healthyRetryPolicy = healthyRetryPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryPolicy#getRequestPolicy}
         * @param requestPolicy The request of the content sent in AWS SNS HTTP/S requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestPolicy(software.amazon.awscdk.services.sns.RequestPolicy requestPolicy) {
            this.requestPolicy = requestPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DeliveryPolicy#getThrottlePolicy}
         * @param throttlePolicy The throttling policy of the delivery of SNS messages to HTTP/S endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttlePolicy(software.amazon.awscdk.services.sns.ThrottlePolicy throttlePolicy) {
            this.throttlePolicy = throttlePolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeliveryPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeliveryPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeliveryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryPolicy {
        private final software.amazon.awscdk.services.sns.HealthyRetryPolicy healthyRetryPolicy;
        private final software.amazon.awscdk.services.sns.RequestPolicy requestPolicy;
        private final software.amazon.awscdk.services.sns.ThrottlePolicy throttlePolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.healthyRetryPolicy = software.amazon.jsii.Kernel.get(this, "healthyRetryPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.HealthyRetryPolicy.class));
            this.requestPolicy = software.amazon.jsii.Kernel.get(this, "requestPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.RequestPolicy.class));
            this.throttlePolicy = software.amazon.jsii.Kernel.get(this, "throttlePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ThrottlePolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.healthyRetryPolicy = builder.healthyRetryPolicy;
            this.requestPolicy = builder.requestPolicy;
            this.throttlePolicy = builder.throttlePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.sns.HealthyRetryPolicy getHealthyRetryPolicy() {
            return this.healthyRetryPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.sns.RequestPolicy getRequestPolicy() {
            return this.requestPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ThrottlePolicy getThrottlePolicy() {
            return this.throttlePolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHealthyRetryPolicy() != null) {
                data.set("healthyRetryPolicy", om.valueToTree(this.getHealthyRetryPolicy()));
            }
            if (this.getRequestPolicy() != null) {
                data.set("requestPolicy", om.valueToTree(this.getRequestPolicy()));
            }
            if (this.getThrottlePolicy() != null) {
                data.set("throttlePolicy", om.valueToTree(this.getThrottlePolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.DeliveryPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeliveryPolicy.Jsii$Proxy that = (DeliveryPolicy.Jsii$Proxy) o;

            if (this.healthyRetryPolicy != null ? !this.healthyRetryPolicy.equals(that.healthyRetryPolicy) : that.healthyRetryPolicy != null) return false;
            if (this.requestPolicy != null ? !this.requestPolicy.equals(that.requestPolicy) : that.requestPolicy != null) return false;
            return this.throttlePolicy != null ? this.throttlePolicy.equals(that.throttlePolicy) : that.throttlePolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.healthyRetryPolicy != null ? this.healthyRetryPolicy.hashCode() : 0;
            result = 31 * result + (this.requestPolicy != null ? this.requestPolicy.hashCode() : 0);
            result = 31 * result + (this.throttlePolicy != null ? this.throttlePolicy.hashCode() : 0);
            return result;
        }
    }
}
