package software.amazon.awscdk.services.ssmcontacts;

/**
 * Properties for defining a <code>CfnRotation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmcontacts.*;
 * CfnRotationProps cfnRotationProps = CfnRotationProps.builder()
 *         .contactIds(List.of("contactIds"))
 *         .name("name")
 *         .recurrence(RecurrenceSettingsProperty.builder()
 *                 .numberOfOnCalls(123)
 *                 .recurrenceMultiplier(123)
 *                 // the properties below are optional
 *                 .dailySettings(List.of("dailySettings"))
 *                 .monthlySettings(List.of(MonthlySettingProperty.builder()
 *                         .dayOfMonth(123)
 *                         .handOffTime("handOffTime")
 *                         .build()))
 *                 .shiftCoverages(List.of(ShiftCoverageProperty.builder()
 *                         .coverageTimes(List.of(CoverageTimeProperty.builder()
 *                                 .endTime("endTime")
 *                                 .startTime("startTime")
 *                                 .build()))
 *                         .dayOfWeek("dayOfWeek")
 *                         .build()))
 *                 .weeklySettings(List.of(WeeklySettingProperty.builder()
 *                         .dayOfWeek("dayOfWeek")
 *                         .handOffTime("handOffTime")
 *                         .build()))
 *                 .build())
 *         .startTime("startTime")
 *         .timeZoneId("timeZoneId")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:27.613Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnRotationProps")
@software.amazon.jsii.Jsii.Proxy(CfnRotationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRotationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
     * <p>
     * <blockquote>
     * <p>
     * Only the <code>PERSONAL</code> contact type is supported. The contact types <code>ESCALATION</code> and <code>ONCALL_SCHEDULE</code> are not supported for this operation.
     * <p>
     * </blockquote>
     * <p>
     * The order in which you list the contacts is their shift order in the rotation schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-contactids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-contactids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getContactIds();

    /**
     * The name for the rotation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Information about the rule that specifies when shift team members rotate.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-recurrence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-recurrence</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRecurrence();

    /**
     * The date and time the rotation goes into effect.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-starttime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStartTime();

    /**
     * The time zone to base the rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format.
     * <p>
     * For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://docs.aws.amazon.com/https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
     * <p>
     * <blockquote>
     * <p>
     * Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard Time (PST), are not supported.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-timezoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-timezoneid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTimeZoneId();

    /**
     * Optional metadata to assign to the rotation.
     * <p>
     * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident Manager resources</a> in the <em>Incident Manager User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-rotation.html#cfn-ssmcontacts-rotation-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRotationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRotationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRotationProps> {
        java.util.List<java.lang.String> contactIds;
        java.lang.String name;
        java.lang.Object recurrence;
        java.lang.String startTime;
        java.lang.String timeZoneId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRotationProps#getContactIds}
         * @param contactIds The Amazon Resource Names (ARNs) of the contacts to add to the rotation. This parameter is required.
         *                   <blockquote>
         *                   <p>
         *                   Only the <code>PERSONAL</code> contact type is supported. The contact types <code>ESCALATION</code> and <code>ONCALL_SCHEDULE</code> are not supported for this operation.
         *                   <p>
         *                   </blockquote>
         *                   <p>
         *                   The order in which you list the contacts is their shift order in the rotation schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactIds(java.util.List<java.lang.String> contactIds) {
            this.contactIds = contactIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationProps#getName}
         * @param name The name for the rotation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationProps#getRecurrence}
         * @param recurrence Information about the rule that specifies when shift team members rotate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recurrence(software.amazon.awscdk.IResolvable recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationProps#getRecurrence}
         * @param recurrence Information about the rule that specifies when shift team members rotate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recurrence(software.amazon.awscdk.services.ssmcontacts.CfnRotation.RecurrenceSettingsProperty recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationProps#getStartTime}
         * @param startTime The date and time the rotation goes into effect. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(java.lang.String startTime) {
            this.startTime = startTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationProps#getTimeZoneId}
         * @param timeZoneId The time zone to base the rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format. This parameter is required.
         *                   For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://docs.aws.amazon.com/https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard Time (PST), are not supported.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZoneId(java.lang.String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRotationProps#getTags}
         * @param tags Optional metadata to assign to the rotation.
         *             Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident Manager resources</a> in the <em>Incident Manager User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRotationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRotationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRotationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRotationProps {
        private final java.util.List<java.lang.String> contactIds;
        private final java.lang.String name;
        private final java.lang.Object recurrence;
        private final java.lang.String startTime;
        private final java.lang.String timeZoneId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contactIds = software.amazon.jsii.Kernel.get(this, "contactIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recurrence = software.amazon.jsii.Kernel.get(this, "recurrence", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeZoneId = software.amazon.jsii.Kernel.get(this, "timeZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contactIds = java.util.Objects.requireNonNull(builder.contactIds, "contactIds is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.recurrence = java.util.Objects.requireNonNull(builder.recurrence, "recurrence is required");
            this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
            this.timeZoneId = java.util.Objects.requireNonNull(builder.timeZoneId, "timeZoneId is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getContactIds() {
            return this.contactIds;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRecurrence() {
            return this.recurrence;
        }

        @Override
        public final java.lang.String getStartTime() {
            return this.startTime;
        }

        @Override
        public final java.lang.String getTimeZoneId() {
            return this.timeZoneId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("contactIds", om.valueToTree(this.getContactIds()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("recurrence", om.valueToTree(this.getRecurrence()));
            data.set("startTime", om.valueToTree(this.getStartTime()));
            data.set("timeZoneId", om.valueToTree(this.getTimeZoneId()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnRotationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRotationProps.Jsii$Proxy that = (CfnRotationProps.Jsii$Proxy) o;

            if (!contactIds.equals(that.contactIds)) return false;
            if (!name.equals(that.name)) return false;
            if (!recurrence.equals(that.recurrence)) return false;
            if (!startTime.equals(that.startTime)) return false;
            if (!timeZoneId.equals(that.timeZoneId)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contactIds.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.recurrence.hashCode());
            result = 31 * result + (this.startTime.hashCode());
            result = 31 * result + (this.timeZoneId.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
