package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Location to retrieve the input data, prior to calling Bedrock InvokeModel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * FoundationModel model = FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.AMAZON_TITAN_TEXT_G1_EXPRESS_V1);
 * BedrockInvokeModel task = BedrockInvokeModel.Builder.create(this, "Prompt Model")
 *         .model(model)
 *         .input(BedrockInvokeModelInputProps.builder().s3InputUri(JsonPath.stringAt("$.prompt")).build())
 *         .output(BedrockInvokeModelOutputProps.builder().s3OutputUri(JsonPath.stringAt("$.prompt")).build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-bedrock.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-bedrock.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:27.833Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.BedrockInvokeModelInputProps")
@software.amazon.jsii.Jsii.Proxy(BedrockInvokeModelInputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BedrockInvokeModelInputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The source location where the API response is written.
     * <p>
     * This field can be used to specify s3 URI in the form of token
     * <p>
     * Default: - The API response body is returned in the result.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3InputUri() {
        return null;
    }

    /**
     * S3 object to retrieve the input data from.
     * <p>
     * If the S3 location is not set, then the Body must be set.
     * <p>
     * Default: - Input data is retrieved from the `body` field
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Location getS3Location() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BedrockInvokeModelInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BedrockInvokeModelInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BedrockInvokeModelInputProps> {
        java.lang.String s3InputUri;
        software.amazon.awscdk.services.s3.Location s3Location;

        /**
         * Sets the value of {@link BedrockInvokeModelInputProps#getS3InputUri}
         * @param s3InputUri The source location where the API response is written.
         *                   This field can be used to specify s3 URI in the form of token
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3InputUri(java.lang.String s3InputUri) {
            this.s3InputUri = s3InputUri;
            return this;
        }

        /**
         * Sets the value of {@link BedrockInvokeModelInputProps#getS3Location}
         * @param s3Location S3 object to retrieve the input data from.
         *                   If the S3 location is not set, then the Body must be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Location(software.amazon.awscdk.services.s3.Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BedrockInvokeModelInputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BedrockInvokeModelInputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BedrockInvokeModelInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockInvokeModelInputProps {
        private final java.lang.String s3InputUri;
        private final software.amazon.awscdk.services.s3.Location s3Location;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3InputUri = software.amazon.jsii.Kernel.get(this, "s3InputUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Location.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3InputUri = builder.s3InputUri;
            this.s3Location = builder.s3Location;
        }

        @Override
        public final java.lang.String getS3InputUri() {
            return this.s3InputUri;
        }

        @Override
        public final software.amazon.awscdk.services.s3.Location getS3Location() {
            return this.s3Location;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getS3InputUri() != null) {
                data.set("s3InputUri", om.valueToTree(this.getS3InputUri()));
            }
            if (this.getS3Location() != null) {
                data.set("s3Location", om.valueToTree(this.getS3Location()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.BedrockInvokeModelInputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BedrockInvokeModelInputProps.Jsii$Proxy that = (BedrockInvokeModelInputProps.Jsii$Proxy) o;

            if (this.s3InputUri != null ? !this.s3InputUri.equals(that.s3InputUri) : that.s3InputUri != null) return false;
            return this.s3Location != null ? this.s3Location.equals(that.s3Location) : that.s3Location == null;
        }

        @Override
        public final int hashCode() {
            int result = this.s3InputUri != null ? this.s3InputUri.hashCode() : 0;
            result = 31 * result + (this.s3Location != null ? this.s3Location.hashCode() : 0);
            return result;
        }
    }
}
