package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The type of predefined worker that is allocated when a job runs.
 * <p>
 * If you need to use a WorkerType that doesn't exist as a static member, you
 * can instantiate a <code>WorkerType</code> object, e.g: <code>WorkerType.of('other type')</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GlueStartJobRun.Builder.create(this, "Task")
 *         .glueJobName("my-glue-job")
 *         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                 .workerType(WorkerType.G_1X) // Worker type
 *                 .numberOfWorkers(2)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:28.040Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.WorkerType")
public enum WorkerType {
    /**
     * Each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB disk), and provides 1 executor per worker. Suitable for low volume streaming jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G_025X,
    /**
     * Each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker.
     * <p>
     * Suitable for memory-intensive jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G_1X,
    /**
     * Each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker.
     * <p>
     * Suitable for memory-intensive jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G_2X,
    /**
     * Each worker maps to 4 DPU (16 vCPU, 64 GB of memory, 256 GB disk), and provides 1 executor per worker.
     * <p>
     * We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G_4X,
    /**
     * Each worker maps to 8 DPU (32 vCPU, 128 GB of memory, 512 GB disk), and provides 1 executor per worker.
     * <p>
     * We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G_8X,
    /**
     * Each worker maps to 2 high-memory DPU [M-DPU] (8 vCPU, 64 GB of memory, 128 GB disk).
     * <p>
     * Supported in Ray jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    Z_2X,
}
