package software.amazon.awscdk.services.synthetics;

/**
 * Schedule for canary runs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_6_2)
 *         .activeTracing(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:28.082Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.Schedule")
public class Schedule extends software.amazon.jsii.JsiiObject {

    protected Schedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Schedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a schedule from a set of cron fields.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.Schedule cron(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CronOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Schedule.class, "cron", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Schedule.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Construct a schedule from a literal schedule expression.
     * <p>
     * The expression must be in a <code>rate(number units)</code> format.
     * For example, <code>Schedule.expression('rate(10 minutes)')</code>
     * <p>
     * @param expression The expression to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.Schedule expression(final @org.jetbrains.annotations.NotNull java.lang.String expression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Schedule.class, "expression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Schedule.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required") });
    }

    /**
     * The canary will be executed once.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.Schedule once() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Schedule.class, "once", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Schedule.class));
    }

    /**
     * Construct a schedule from an interval.
     * <p>
     * Allowed values: 0 (for a single run) or between 1 and 60 minutes.
     * To specify a single run, you can use <code>Schedule.once()</code>.
     * <p>
     * @param interval The interval at which to run the canary. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.Schedule rate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration interval) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Schedule.class, "rate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Schedule.class), new Object[] { java.util.Objects.requireNonNull(interval, "interval is required") });
    }

    /**
     * The Schedule expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExpressionString() {
        return software.amazon.jsii.Kernel.get(this, "expressionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
