package software.amazon.awscdk.services.transfer;

/**
 * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in AWS .
 * <p>
 * When you make updates to your file transfer protocol-enabled server or when you work with users, use the service-generated <code>ServerId</code> property that is assigned to the newly created server.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnServer cfnServer = CfnServer.Builder.create(this, "MyCfnServer")
 *         .certificate("certificate")
 *         .domain("domain")
 *         .endpointDetails(EndpointDetailsProperty.builder()
 *                 .addressAllocationIds(List.of("addressAllocationIds"))
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .vpcEndpointId("vpcEndpointId")
 *                 .vpcId("vpcId")
 *                 .build())
 *         .endpointType("endpointType")
 *         .identityProviderDetails(IdentityProviderDetailsProperty.builder()
 *                 .directoryId("directoryId")
 *                 .function("function")
 *                 .invocationRole("invocationRole")
 *                 .sftpAuthenticationMethods("sftpAuthenticationMethods")
 *                 .url("url")
 *                 .build())
 *         .identityProviderType("identityProviderType")
 *         .loggingRole("loggingRole")
 *         .postAuthenticationLoginBanner("postAuthenticationLoginBanner")
 *         .preAuthenticationLoginBanner("preAuthenticationLoginBanner")
 *         .protocolDetails(ProtocolDetailsProperty.builder()
 *                 .as2Transports(List.of("as2Transports"))
 *                 .passiveIp("passiveIp")
 *                 .setStatOption("setStatOption")
 *                 .tlsSessionResumptionMode("tlsSessionResumptionMode")
 *                 .build())
 *         .protocols(List.of("protocols"))
 *         .s3StorageOptions(S3StorageOptionsProperty.builder()
 *                 .directoryListingOptimization("directoryListingOptimization")
 *                 .build())
 *         .securityPolicyName("securityPolicyName")
 *         .structuredLogDestinations(List.of("structuredLogDestinations"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workflowDetails(WorkflowDetailsProperty.builder()
 *                 .onPartialUpload(List.of(WorkflowDetailProperty.builder()
 *                         .executionRole("executionRole")
 *                         .workflowId("workflowId")
 *                         .build()))
 *                 .onUpload(List.of(WorkflowDetailProperty.builder()
 *                         .executionRole("executionRole")
 *                         .workflowId("workflowId")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:28.137Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnServer")
public class CfnServer extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnServer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnServer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnServer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnServer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name associated with the server, in the form <code>arn:aws:transfer:region: *account-id* :server/ *server-id* /</code> .
     * <p>
     * An example of a server ARN is: <code>arn:aws:transfer:us-east-1:123456789012:server/s-01234567890abcdef</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The list of egress IP addresses of this server.
     * <p>
     * These IP addresses are only relevant for servers that use the AS2 protocol. They are used for sending asynchronous MDNs. These IP addresses are assigned automatically when you create an AS2 server. Additionally, if you update an existing server and add the AS2 protocol, static IP addresses are assigned as well.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrAs2ServiceManagedEgressIpAddresses() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrAs2ServiceManagedEgressIpAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The service-assigned ID of the server that is created.
     * <p>
     * An example <code>ServerId</code> is <code>s-01234567890abcdef</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServerId() {
        return software.amazon.jsii.Kernel.get(this, "attrServerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificate() {
        return software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificate", value);
    }

    /**
     * Specifies the domain of the storage system that is used for file transfers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the domain of the storage system that is used for file transfers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domain", value);
    }

    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEndpointDetails() {
        return software.amazon.jsii.Kernel.get(this, "endpointDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "endpointDetails", value);
    }

    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServer.EndpointDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "endpointDetails", value);
    }

    /**
     * The type of endpoint that you want your server to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointType() {
        return software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of endpoint that you want your server to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointType", value);
    }

    /**
     * Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS _LAMBDA</code> or <code>API_GATEWAY</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIdentityProviderDetails() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS _LAMBDA</code> or <code>API_GATEWAY</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderDetails", value);
    }

    /**
     * Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS _LAMBDA</code> or <code>API_GATEWAY</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServer.IdentityProviderDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderDetails", value);
    }

    /**
     * The mode of authentication for a server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentityProviderType() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The mode of authentication for a server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderType", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLoggingRole() {
        return software.amazon.jsii.Kernel.get(this, "loggingRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "loggingRole", value);
    }

    /**
     * Specifies a string to display when users connect to a server.
     * <p>
     * This string is displayed after the user authenticates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPostAuthenticationLoginBanner() {
        return software.amazon.jsii.Kernel.get(this, "postAuthenticationLoginBanner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies a string to display when users connect to a server.
     * <p>
     * This string is displayed after the user authenticates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostAuthenticationLoginBanner(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "postAuthenticationLoginBanner", value);
    }

    /**
     * Specifies a string to display when users connect to a server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreAuthenticationLoginBanner() {
        return software.amazon.jsii.Kernel.get(this, "preAuthenticationLoginBanner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies a string to display when users connect to a server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreAuthenticationLoginBanner(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preAuthenticationLoginBanner", value);
    }

    /**
     * The protocol settings that are configured for your server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProtocolDetails() {
        return software.amazon.jsii.Kernel.get(this, "protocolDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The protocol settings that are configured for your server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocolDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "protocolDetails", value);
    }

    /**
     * The protocol settings that are configured for your server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocolDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServer.ProtocolDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "protocolDetails", value);
    }

    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProtocols() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "protocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocols(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "protocols", value);
    }

    /**
     * Specifies whether or not performance for your Amazon S3 directories is optimized.
     * <p>
     * This is disabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3StorageOptions() {
        return software.amazon.jsii.Kernel.get(this, "s3StorageOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether or not performance for your Amazon S3 directories is optimized.
     * <p>
     * This is disabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3StorageOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3StorageOptions", value);
    }

    /**
     * Specifies whether or not performance for your Amazon S3 directories is optimized.
     * <p>
     * This is disabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3StorageOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServer.S3StorageOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "s3StorageOptions", value);
    }

    /**
     * Specifies the name of the security policy for the server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "securityPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the security policy for the server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityPolicyName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityPolicyName", value);
    }

    /**
     * Specifies the log groups to which your server logs are sent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStructuredLogDestinations() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "structuredLogDestinations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the log groups to which your server logs are sent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStructuredLogDestinations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "structuredLogDestinations", value);
    }

    /**
     * Key-value pairs that can be used to group and search for servers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Key-value pairs that can be used to group and search for servers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkflowDetails() {
        return software.amazon.jsii.Kernel.get(this, "workflowDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflowDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workflowDetails", value);
    }

    /**
     * Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflowDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServer.WorkflowDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "workflowDetails", value);
    }
    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     * <p>
     * When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * EndpointDetailsProperty endpointDetailsProperty = EndpointDetailsProperty.builder()
     *         .addressAllocationIds(List.of("addressAllocationIds"))
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .vpcEndpointId("vpcEndpointId")
     *         .vpcId("vpcId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnServer.EndpointDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
         * <p>
         * An address allocation ID corresponds to the allocation ID of an Elastic IP address. This value can be retrieved from the <code>allocationId</code> field from the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Address.html">Address</a> data type. One way to retrieve this value is by calling the EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html">DescribeAddresses</a> API.
         * <p>
         * This parameter is optional. Set this parameter if you want to make your VPC endpoint public-facing. For details, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#create-internet-facing-endpoint">Create an internet-facing endpoint for your server</a> .
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set as follows:
         * <p>
         * <ul>
         * <li><code>EndpointType</code> must be set to <code>VPC</code></li>
         * <li>The Transfer Family server must be offline.</li>
         * <li>You cannot set this parameter for Transfer Family servers that use the FTP protocol.</li>
         * <li>The server must already have <code>SubnetIds</code> populated ( <code>SubnetIds</code> and <code>AddressAllocationIds</code> cannot be updated simultaneously).</li>
         * <li><code>AddressAllocationIds</code> can't contain duplicates, and must be equal in length to <code>SubnetIds</code> . For example, if you have three subnet IDs, you must also specify three address allocation IDs.</li>
         * <li>Call the <code>UpdateServer</code> API to set or change this parameter.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-addressallocationids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-addressallocationids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAddressAllocationIds() {
            return null;
        }

        /**
         * A list of security groups IDs that are available to attach to your server's endpoint.
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
         * <p>
         * You can edit the <code>SecurityGroupIds</code> property in the <a href="https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html">UpdateServer</a> API only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to <code>VPC</code> . To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html">ModifyVpcEndpoint</a> API.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * A list of subnet IDs that are required to host your server endpoint in your VPC.
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
            return null;
        }

        /**
         * The ID of the VPC endpoint.
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-vpcendpointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-vpcendpointid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointId() {
            return null;
        }

        /**
         * The VPC ID of the virtual private cloud in which the server's endpoint will be hosted.
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-vpcid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointDetailsProperty> {
            java.util.List<java.lang.String> addressAllocationIds;
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;
            java.lang.String vpcEndpointId;
            java.lang.String vpcId;

            /**
             * Sets the value of {@link EndpointDetailsProperty#getAddressAllocationIds}
             * @param addressAllocationIds A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
             *                             An address allocation ID corresponds to the allocation ID of an Elastic IP address. This value can be retrieved from the <code>allocationId</code> field from the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Address.html">Address</a> data type. One way to retrieve this value is by calling the EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html">DescribeAddresses</a> API.
             *                             <p>
             *                             This parameter is optional. Set this parameter if you want to make your VPC endpoint public-facing. For details, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#create-internet-facing-endpoint">Create an internet-facing endpoint for your server</a> .
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             This property can only be set as follows:
             *                             <p>
             *                             <ul>
             *                             <li><code>EndpointType</code> must be set to <code>VPC</code></li>
             *                             <li>The Transfer Family server must be offline.</li>
             *                             <li>You cannot set this parameter for Transfer Family servers that use the FTP protocol.</li>
             *                             <li>The server must already have <code>SubnetIds</code> populated ( <code>SubnetIds</code> and <code>AddressAllocationIds</code> cannot be updated simultaneously).</li>
             *                             <li><code>AddressAllocationIds</code> can't contain duplicates, and must be equal in length to <code>SubnetIds</code> . For example, if you have three subnet IDs, you must also specify three address allocation IDs.</li>
             *                             <li>Call the <code>UpdateServer</code> API to set or change this parameter.</li>
             *                             </ul>
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addressAllocationIds(java.util.List<java.lang.String> addressAllocationIds) {
                this.addressAllocationIds = addressAllocationIds;
                return this;
            }

            /**
             * Sets the value of {@link EndpointDetailsProperty#getSecurityGroupIds}
             * @param securityGroupIds A list of security groups IDs that are available to attach to your server's endpoint.
             *                         <blockquote>
             *                         <p>
             *                         This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
             *                         <p>
             *                         You can edit the <code>SecurityGroupIds</code> property in the <a href="https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html">UpdateServer</a> API only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to <code>VPC</code> . To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html">ModifyVpcEndpoint</a> API.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link EndpointDetailsProperty#getSubnetIds}
             * @param subnetIds A list of subnet IDs that are required to host your server endpoint in your VPC.
             *                  <blockquote>
             *                  <p>
             *                  This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Sets the value of {@link EndpointDetailsProperty#getVpcEndpointId}
             * @param vpcEndpointId The ID of the VPC endpoint.
             *                      <blockquote>
             *                      <p>
             *                      This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointId(java.lang.String vpcEndpointId) {
                this.vpcEndpointId = vpcEndpointId;
                return this;
            }

            /**
             * Sets the value of {@link EndpointDetailsProperty#getVpcId}
             * @param vpcId The VPC ID of the virtual private cloud in which the server's endpoint will be hosted.
             *              <blockquote>
             *              <p>
             *              This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointDetailsProperty {
            private final java.util.List<java.lang.String> addressAllocationIds;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;
            private final java.lang.String vpcEndpointId;
            private final java.lang.String vpcId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addressAllocationIds = software.amazon.jsii.Kernel.get(this, "addressAllocationIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpcEndpointId = software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addressAllocationIds = builder.addressAllocationIds;
                this.securityGroupIds = builder.securityGroupIds;
                this.subnetIds = builder.subnetIds;
                this.vpcEndpointId = builder.vpcEndpointId;
                this.vpcId = builder.vpcId;
            }

            @Override
            public final java.util.List<java.lang.String> getAddressAllocationIds() {
                return this.addressAllocationIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public final java.lang.String getVpcEndpointId() {
                return this.vpcEndpointId;
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddressAllocationIds() != null) {
                    data.set("addressAllocationIds", om.valueToTree(this.getAddressAllocationIds()));
                }
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnetIds() != null) {
                    data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                }
                if (this.getVpcEndpointId() != null) {
                    data.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
                }
                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnServer.EndpointDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointDetailsProperty.Jsii$Proxy that = (EndpointDetailsProperty.Jsii$Proxy) o;

                if (this.addressAllocationIds != null ? !this.addressAllocationIds.equals(that.addressAllocationIds) : that.addressAllocationIds != null) return false;
                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
                if (this.vpcEndpointId != null ? !this.vpcEndpointId.equals(that.vpcEndpointId) : that.vpcEndpointId != null) return false;
                return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addressAllocationIds != null ? this.addressAllocationIds.hashCode() : 0;
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
                result = 31 * result + (this.vpcEndpointId != null ? this.vpcEndpointId.hashCode() : 0);
                result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS _LAMBDA</code> or <code>API_GATEWAY</code> .
     * <p>
     * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Cannot be specified when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * IdentityProviderDetailsProperty identityProviderDetailsProperty = IdentityProviderDetailsProperty.builder()
     *         .directoryId("directoryId")
     *         .function("function")
     *         .invocationRole("invocationRole")
     *         .sftpAuthenticationMethods("sftpAuthenticationMethods")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnServer.IdentityProviderDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentityProviderDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentityProviderDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the AWS Directory Service directory that you want to use as your identity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-directoryid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-directoryid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDirectoryId() {
            return null;
        }

        /**
         * The ARN for a Lambda function to use for the Identity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-function">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-function</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFunction() {
            return null;
        }

        /**
         * This parameter is only applicable if your <code>IdentityProviderType</code> is <code>API_GATEWAY</code> .
         * <p>
         * Provides the type of <code>InvocationRole</code> used to authenticate the user account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-invocationrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-invocationrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvocationRole() {
            return null;
        }

        /**
         * For SFTP-enabled servers, and for custom identity providers <em>only</em> , you can specify whether to authenticate using a password, SSH key pair, or both.
         * <p>
         * <ul>
         * <li><code>PASSWORD</code> - users must provide their password to connect.</li>
         * <li><code>PUBLIC_KEY</code> - users must provide their private key to connect.</li>
         * <li><code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key. This is the default value.</li>
         * <li><code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to connect. The server checks the key first, and then if the key is valid, the system prompts for a password. If the private key provided does not match the public key that is stored, authentication fails.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-sftpauthenticationmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-sftpauthenticationmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSftpAuthenticationMethods() {
            return null;
        }

        /**
         * Provides the location of the service endpoint used to authenticate users.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdentityProviderDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentityProviderDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentityProviderDetailsProperty> {
            java.lang.String directoryId;
            java.lang.String function;
            java.lang.String invocationRole;
            java.lang.String sftpAuthenticationMethods;
            java.lang.String url;

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getDirectoryId}
             * @param directoryId The identifier of the AWS Directory Service directory that you want to use as your identity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directoryId(java.lang.String directoryId) {
                this.directoryId = directoryId;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getFunction}
             * @param function The ARN for a Lambda function to use for the Identity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder function(java.lang.String function) {
                this.function = function;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getInvocationRole}
             * @param invocationRole This parameter is only applicable if your <code>IdentityProviderType</code> is <code>API_GATEWAY</code> .
             *                       Provides the type of <code>InvocationRole</code> used to authenticate the user account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationRole(java.lang.String invocationRole) {
                this.invocationRole = invocationRole;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getSftpAuthenticationMethods}
             * @param sftpAuthenticationMethods For SFTP-enabled servers, and for custom identity providers <em>only</em> , you can specify whether to authenticate using a password, SSH key pair, or both.
             *                                  <ul>
             *                                  <li><code>PASSWORD</code> - users must provide their password to connect.</li>
             *                                  <li><code>PUBLIC_KEY</code> - users must provide their private key to connect.</li>
             *                                  <li><code>PUBLIC_KEY_OR_PASSWORD</code> - users can authenticate with either their password or their key. This is the default value.</li>
             *                                  <li><code>PUBLIC_KEY_AND_PASSWORD</code> - users must provide both their private key and their password to connect. The server checks the key first, and then if the key is valid, the system prompts for a password. If the private key provided does not match the public key that is stored, authentication fails.</li>
             *                                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sftpAuthenticationMethods(java.lang.String sftpAuthenticationMethods) {
                this.sftpAuthenticationMethods = sftpAuthenticationMethods;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getUrl}
             * @param url Provides the location of the service endpoint used to authenticate users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentityProviderDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentityProviderDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentityProviderDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityProviderDetailsProperty {
            private final java.lang.String directoryId;
            private final java.lang.String function;
            private final java.lang.String invocationRole;
            private final java.lang.String sftpAuthenticationMethods;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.directoryId = software.amazon.jsii.Kernel.get(this, "directoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.function = software.amazon.jsii.Kernel.get(this, "function", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invocationRole = software.amazon.jsii.Kernel.get(this, "invocationRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sftpAuthenticationMethods = software.amazon.jsii.Kernel.get(this, "sftpAuthenticationMethods", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.directoryId = builder.directoryId;
                this.function = builder.function;
                this.invocationRole = builder.invocationRole;
                this.sftpAuthenticationMethods = builder.sftpAuthenticationMethods;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getDirectoryId() {
                return this.directoryId;
            }

            @Override
            public final java.lang.String getFunction() {
                return this.function;
            }

            @Override
            public final java.lang.String getInvocationRole() {
                return this.invocationRole;
            }

            @Override
            public final java.lang.String getSftpAuthenticationMethods() {
                return this.sftpAuthenticationMethods;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDirectoryId() != null) {
                    data.set("directoryId", om.valueToTree(this.getDirectoryId()));
                }
                if (this.getFunction() != null) {
                    data.set("function", om.valueToTree(this.getFunction()));
                }
                if (this.getInvocationRole() != null) {
                    data.set("invocationRole", om.valueToTree(this.getInvocationRole()));
                }
                if (this.getSftpAuthenticationMethods() != null) {
                    data.set("sftpAuthenticationMethods", om.valueToTree(this.getSftpAuthenticationMethods()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnServer.IdentityProviderDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentityProviderDetailsProperty.Jsii$Proxy that = (IdentityProviderDetailsProperty.Jsii$Proxy) o;

                if (this.directoryId != null ? !this.directoryId.equals(that.directoryId) : that.directoryId != null) return false;
                if (this.function != null ? !this.function.equals(that.function) : that.function != null) return false;
                if (this.invocationRole != null ? !this.invocationRole.equals(that.invocationRole) : that.invocationRole != null) return false;
                if (this.sftpAuthenticationMethods != null ? !this.sftpAuthenticationMethods.equals(that.sftpAuthenticationMethods) : that.sftpAuthenticationMethods != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.directoryId != null ? this.directoryId.hashCode() : 0;
                result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
                result = 31 * result + (this.invocationRole != null ? this.invocationRole.hashCode() : 0);
                result = 31 * result + (this.sftpAuthenticationMethods != null ? this.sftpAuthenticationMethods.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The protocol settings that are configured for your server.
     * <p>
     * <ul>
     * <li>To indicate passive mode (for FTP and FTPS protocols), use the <code>PassiveIp</code> parameter. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.</li>
     * <li>To ignore the error that is generated when the client attempts to use the <code>SETSTAT</code> command on a file that you are uploading to an Amazon S3 bucket, use the <code>SetStatOption</code> parameter. To have the AWS Transfer Family server ignore the <code>SETSTAT</code> command and upload files without needing to make any changes to your SFTP client, set the value to <code>ENABLE_NO_OP</code> . If you set the <code>SetStatOption</code> parameter to <code>ENABLE_NO_OP</code> , Transfer Family generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client is making a <code>SETSTAT</code> call.</li>
     * <li>To determine whether your AWS Transfer Family server resumes recent, negotiated sessions through a unique session ID, use the <code>TlsSessionResumptionMode</code> parameter.</li>
     * <li><code>As2Transports</code> indicates the transport method for the AS2 messages. Currently, only HTTP is supported.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * ProtocolDetailsProperty protocolDetailsProperty = ProtocolDetailsProperty.builder()
     *         .as2Transports(List.of("as2Transports"))
     *         .passiveIp("passiveIp")
     *         .setStatOption("setStatOption")
     *         .tlsSessionResumptionMode("tlsSessionResumptionMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnServer.ProtocolDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(ProtocolDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProtocolDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of <code>As2Transport</code> objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html#cfn-transfer-server-protocoldetails-as2transports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html#cfn-transfer-server-protocoldetails-as2transports</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAs2Transports() {
            return null;
        }

        /**
         * Indicates passive mode, for FTP and FTPS protocols.
         * <p>
         * Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:
         * <p>
         * <code>aws transfer update-server --protocol-details PassiveIp=0.0.0.0</code>
         * <p>
         * Replace <code>0.0.0.0</code> in the example above with the actual IP address you want to use.
         * <p>
         * <blockquote>
         * <p>
         * If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see <a href="https://docs.aws.amazon.com/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with AWS Transfer Family</a> .
         * <p>
         * </blockquote>
         * <p>
         * <em>Special values</em>
         * <p>
         * The <code>AUTO</code> and <code>0.0.0.0</code> are special values for the <code>PassiveIp</code> parameter. The value <code>PassiveIp=AUTO</code> is assigned by default to FTP and FTPS type servers. In this case, the server automatically responds with one of the endpoint IPs within the PASV response. <code>PassiveIp=0.0.0.0</code> has a more unique application for its usage. For example, if you have a High Availability (HA) Network Load Balancer (NLB) environment, where you have 3 subnets, you can only specify a single IP address using the <code>PassiveIp</code> parameter. This reduces the effectiveness of having High Availability. In this case, you can specify <code>PassiveIp=0.0.0.0</code> . This tells the client to use the same IP address as the Control connection and utilize all AZs for their connections. Note, however, that not all FTP clients support the <code>PassiveIp=0.0.0.0</code> response. FileZilla and WinSCP do support it. If you are using other clients, check to see if your client supports the <code>PassiveIp=0.0.0.0</code> response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html#cfn-transfer-server-protocoldetails-passiveip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html#cfn-transfer-server-protocoldetails-passiveip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassiveIp() {
            return null;
        }

        /**
         * Use the <code>SetStatOption</code> to ignore the error that is generated when the client attempts to use <code>SETSTAT</code> on a file you are uploading to an S3 bucket.
         * <p>
         * Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as <code>SETSTAT</code> when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.
         * <p>
         * Set the value to <code>ENABLE_NO_OP</code> to have the Transfer Family server ignore the <code>SETSTAT</code> command, and upload files without needing to make any changes to your SFTP client. While the <code>SetStatOption</code> <code>ENABLE_NO_OP</code> setting ignores the error, it does generate a log entry in Amazon CloudWatch Logs, so you can determine when the client is making a <code>SETSTAT</code> call.
         * <p>
         * <blockquote>
         * <p>
         * If you want to preserve the original timestamp for your file, and modify other file attributes using <code>SETSTAT</code> , you can use Amazon EFS as backend storage with Transfer Family.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html#cfn-transfer-server-protocoldetails-setstatoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html#cfn-transfer-server-protocoldetails-setstatoption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSetStatOption() {
            return null;
        }

        /**
         * A property used with Transfer Family servers that use the FTPS protocol.
         * <p>
         * TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. <code>TlsSessionResumptionMode</code> determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during <code>CreateServer</code> and <code>UpdateServer</code> calls. If a <code>TlsSessionResumptionMode</code> value is not specified during <code>CreateServer</code> , it is set to <code>ENFORCED</code> by default.
         * <p>
         * <ul>
         * <li><code>DISABLED</code> : the server does not process TLS session resumption client requests and creates a new TLS session for each request.</li>
         * <li><code>ENABLED</code> : the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.</li>
         * <li><code>ENFORCED</code> : the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to <code>ENFORCED</code> , test your clients.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the <code>ENFORCED</code> value, you need to test your clients.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html#cfn-transfer-server-protocoldetails-tlssessionresumptionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-protocoldetails.html#cfn-transfer-server-protocoldetails-tlssessionresumptionmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTlsSessionResumptionMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProtocolDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProtocolDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProtocolDetailsProperty> {
            java.util.List<java.lang.String> as2Transports;
            java.lang.String passiveIp;
            java.lang.String setStatOption;
            java.lang.String tlsSessionResumptionMode;

            /**
             * Sets the value of {@link ProtocolDetailsProperty#getAs2Transports}
             * @param as2Transports List of <code>As2Transport</code> objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder as2Transports(java.util.List<java.lang.String> as2Transports) {
                this.as2Transports = as2Transports;
                return this;
            }

            /**
             * Sets the value of {@link ProtocolDetailsProperty#getPassiveIp}
             * @param passiveIp Indicates passive mode, for FTP and FTPS protocols.
             *                  Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:
             *                  <p>
             *                  <code>aws transfer update-server --protocol-details PassiveIp=0.0.0.0</code>
             *                  <p>
             *                  Replace <code>0.0.0.0</code> in the example above with the actual IP address you want to use.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see <a href="https://docs.aws.amazon.com/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with AWS Transfer Family</a> .
             *                  <p>
             *                  </blockquote>
             *                  <p>
             *                  <em>Special values</em>
             *                  <p>
             *                  The <code>AUTO</code> and <code>0.0.0.0</code> are special values for the <code>PassiveIp</code> parameter. The value <code>PassiveIp=AUTO</code> is assigned by default to FTP and FTPS type servers. In this case, the server automatically responds with one of the endpoint IPs within the PASV response. <code>PassiveIp=0.0.0.0</code> has a more unique application for its usage. For example, if you have a High Availability (HA) Network Load Balancer (NLB) environment, where you have 3 subnets, you can only specify a single IP address using the <code>PassiveIp</code> parameter. This reduces the effectiveness of having High Availability. In this case, you can specify <code>PassiveIp=0.0.0.0</code> . This tells the client to use the same IP address as the Control connection and utilize all AZs for their connections. Note, however, that not all FTP clients support the <code>PassiveIp=0.0.0.0</code> response. FileZilla and WinSCP do support it. If you are using other clients, check to see if your client supports the <code>PassiveIp=0.0.0.0</code> response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passiveIp(java.lang.String passiveIp) {
                this.passiveIp = passiveIp;
                return this;
            }

            /**
             * Sets the value of {@link ProtocolDetailsProperty#getSetStatOption}
             * @param setStatOption Use the <code>SetStatOption</code> to ignore the error that is generated when the client attempts to use <code>SETSTAT</code> on a file you are uploading to an S3 bucket.
             *                      Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as <code>SETSTAT</code> when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.
             *                      <p>
             *                      Set the value to <code>ENABLE_NO_OP</code> to have the Transfer Family server ignore the <code>SETSTAT</code> command, and upload files without needing to make any changes to your SFTP client. While the <code>SetStatOption</code> <code>ENABLE_NO_OP</code> setting ignores the error, it does generate a log entry in Amazon CloudWatch Logs, so you can determine when the client is making a <code>SETSTAT</code> call.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      If you want to preserve the original timestamp for your file, and modify other file attributes using <code>SETSTAT</code> , you can use Amazon EFS as backend storage with Transfer Family.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setStatOption(java.lang.String setStatOption) {
                this.setStatOption = setStatOption;
                return this;
            }

            /**
             * Sets the value of {@link ProtocolDetailsProperty#getTlsSessionResumptionMode}
             * @param tlsSessionResumptionMode A property used with Transfer Family servers that use the FTPS protocol.
             *                                 TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. <code>TlsSessionResumptionMode</code> determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during <code>CreateServer</code> and <code>UpdateServer</code> calls. If a <code>TlsSessionResumptionMode</code> value is not specified during <code>CreateServer</code> , it is set to <code>ENFORCED</code> by default.
             *                                 <p>
             *                                 <ul>
             *                                 <li><code>DISABLED</code> : the server does not process TLS session resumption client requests and creates a new TLS session for each request.</li>
             *                                 <li><code>ENABLED</code> : the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.</li>
             *                                 <li><code>ENFORCED</code> : the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to <code>ENFORCED</code> , test your clients.</li>
             *                                 </ul>
             *                                 <p>
             *                                 <blockquote>
             *                                 <p>
             *                                 Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the <code>ENFORCED</code> value, you need to test your clients.
             *                                 <p>
             *                                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlsSessionResumptionMode(java.lang.String tlsSessionResumptionMode) {
                this.tlsSessionResumptionMode = tlsSessionResumptionMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProtocolDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProtocolDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProtocolDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProtocolDetailsProperty {
            private final java.util.List<java.lang.String> as2Transports;
            private final java.lang.String passiveIp;
            private final java.lang.String setStatOption;
            private final java.lang.String tlsSessionResumptionMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.as2Transports = software.amazon.jsii.Kernel.get(this, "as2Transports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.passiveIp = software.amazon.jsii.Kernel.get(this, "passiveIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.setStatOption = software.amazon.jsii.Kernel.get(this, "setStatOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tlsSessionResumptionMode = software.amazon.jsii.Kernel.get(this, "tlsSessionResumptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.as2Transports = builder.as2Transports;
                this.passiveIp = builder.passiveIp;
                this.setStatOption = builder.setStatOption;
                this.tlsSessionResumptionMode = builder.tlsSessionResumptionMode;
            }

            @Override
            public final java.util.List<java.lang.String> getAs2Transports() {
                return this.as2Transports;
            }

            @Override
            public final java.lang.String getPassiveIp() {
                return this.passiveIp;
            }

            @Override
            public final java.lang.String getSetStatOption() {
                return this.setStatOption;
            }

            @Override
            public final java.lang.String getTlsSessionResumptionMode() {
                return this.tlsSessionResumptionMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAs2Transports() != null) {
                    data.set("as2Transports", om.valueToTree(this.getAs2Transports()));
                }
                if (this.getPassiveIp() != null) {
                    data.set("passiveIp", om.valueToTree(this.getPassiveIp()));
                }
                if (this.getSetStatOption() != null) {
                    data.set("setStatOption", om.valueToTree(this.getSetStatOption()));
                }
                if (this.getTlsSessionResumptionMode() != null) {
                    data.set("tlsSessionResumptionMode", om.valueToTree(this.getTlsSessionResumptionMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnServer.ProtocolDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProtocolDetailsProperty.Jsii$Proxy that = (ProtocolDetailsProperty.Jsii$Proxy) o;

                if (this.as2Transports != null ? !this.as2Transports.equals(that.as2Transports) : that.as2Transports != null) return false;
                if (this.passiveIp != null ? !this.passiveIp.equals(that.passiveIp) : that.passiveIp != null) return false;
                if (this.setStatOption != null ? !this.setStatOption.equals(that.setStatOption) : that.setStatOption != null) return false;
                return this.tlsSessionResumptionMode != null ? this.tlsSessionResumptionMode.equals(that.tlsSessionResumptionMode) : that.tlsSessionResumptionMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.as2Transports != null ? this.as2Transports.hashCode() : 0;
                result = 31 * result + (this.passiveIp != null ? this.passiveIp.hashCode() : 0);
                result = 31 * result + (this.setStatOption != null ? this.setStatOption.hashCode() : 0);
                result = 31 * result + (this.tlsSessionResumptionMode != null ? this.tlsSessionResumptionMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon S3 storage options that are configured for your server.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * S3StorageOptionsProperty s3StorageOptionsProperty = S3StorageOptionsProperty.builder()
     *         .directoryListingOptimization("directoryListingOptimization")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-s3storageoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-s3storageoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnServer.S3StorageOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(S3StorageOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3StorageOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
         * <p>
         * By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code> . If you enable this option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code> <code>Type</code> to <code>FILE</code> if you want a mapping to have a file target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-s3storageoptions.html#cfn-transfer-server-s3storageoptions-directorylistingoptimization">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-s3storageoptions.html#cfn-transfer-server-s3storageoptions-directorylistingoptimization</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDirectoryListingOptimization() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3StorageOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3StorageOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3StorageOptionsProperty> {
            java.lang.String directoryListingOptimization;

            /**
             * Sets the value of {@link S3StorageOptionsProperty#getDirectoryListingOptimization}
             * @param directoryListingOptimization Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
             *                                     By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code> . If you enable this option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code> <code>Type</code> to <code>FILE</code> if you want a mapping to have a file target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directoryListingOptimization(java.lang.String directoryListingOptimization) {
                this.directoryListingOptimization = directoryListingOptimization;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3StorageOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3StorageOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3StorageOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3StorageOptionsProperty {
            private final java.lang.String directoryListingOptimization;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.directoryListingOptimization = software.amazon.jsii.Kernel.get(this, "directoryListingOptimization", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.directoryListingOptimization = builder.directoryListingOptimization;
            }

            @Override
            public final java.lang.String getDirectoryListingOptimization() {
                return this.directoryListingOptimization;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDirectoryListingOptimization() != null) {
                    data.set("directoryListingOptimization", om.valueToTree(this.getDirectoryListingOptimization()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnServer.S3StorageOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3StorageOptionsProperty.Jsii$Proxy that = (S3StorageOptionsProperty.Jsii$Proxy) o;

                return this.directoryListingOptimization != null ? this.directoryListingOptimization.equals(that.directoryListingOptimization) : that.directoryListingOptimization == null;
            }

            @Override
            public final int hashCode() {
                int result = this.directoryListingOptimization != null ? this.directoryListingOptimization.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
     * <p>
     * In addition to a workflow to execute when a file is uploaded completely, <code>WorkflowDetails</code> can also contain a workflow ID (and execution role) for a workflow to execute on partial upload. A partial upload occurs when a file is open when the session disconnects.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * WorkflowDetailProperty workflowDetailProperty = WorkflowDetailProperty.builder()
     *         .executionRole("executionRole")
     *         .workflowId("workflowId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnServer.WorkflowDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetail.html#cfn-transfer-server-workflowdetail-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetail.html#cfn-transfer-server-workflowdetail-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

        /**
         * A unique identifier for the workflow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetail.html#cfn-transfer-server-workflowdetail-workflowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetail.html#cfn-transfer-server-workflowdetail-workflowid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWorkflowId();

        /**
         * @return a {@link Builder} of {@link WorkflowDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowDetailProperty> {
            java.lang.String executionRole;
            java.lang.String workflowId;

            /**
             * Sets the value of {@link WorkflowDetailProperty#getExecutionRole}
             * @param executionRole Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowDetailProperty#getWorkflowId}
             * @param workflowId A unique identifier for the workflow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowId(java.lang.String workflowId) {
                this.workflowId = workflowId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowDetailProperty {
            private final java.lang.String executionRole;
            private final java.lang.String workflowId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workflowId = software.amazon.jsii.Kernel.get(this, "workflowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
                this.workflowId = java.util.Objects.requireNonNull(builder.workflowId, "workflowId is required");
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.String getWorkflowId() {
                return this.workflowId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                data.set("workflowId", om.valueToTree(this.getWorkflowId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnServer.WorkflowDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowDetailProperty.Jsii$Proxy that = (WorkflowDetailProperty.Jsii$Proxy) o;

                if (!executionRole.equals(that.executionRole)) return false;
                return this.workflowId.equals(that.workflowId);
            }

            @Override
            public final int hashCode() {
                int result = this.executionRole.hashCode();
                result = 31 * result + (this.workflowId.hashCode());
                return result;
            }
        }
    }
    /**
     * Container for the <code>WorkflowDetail</code> data type.
     * <p>
     * It is used by actions that trigger a workflow to begin execution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * WorkflowDetailsProperty workflowDetailsProperty = WorkflowDetailsProperty.builder()
     *         .onPartialUpload(List.of(WorkflowDetailProperty.builder()
     *                 .executionRole("executionRole")
     *                 .workflowId("workflowId")
     *                 .build()))
     *         .onUpload(List.of(WorkflowDetailProperty.builder()
     *                 .executionRole("executionRole")
     *                 .workflowId("workflowId")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnServer.WorkflowDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A trigger that starts a workflow if a file is only partially uploaded.
         * <p>
         * You can attach a workflow to a server that executes whenever there is a partial upload.
         * <p>
         * A <em>partial upload</em> occurs when a file is open when the session disconnects.
         * <p>
         * <blockquote>
         * <p>
         * <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetails.html#cfn-transfer-server-workflowdetails-onpartialupload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetails.html#cfn-transfer-server-workflowdetails-onpartialupload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnPartialUpload() {
            return null;
        }

        /**
         * A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
         * <p>
         * To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in the following example.
         * <p>
         * <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
         * <p>
         * <blockquote>
         * <p>
         * <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetails.html#cfn-transfer-server-workflowdetails-onupload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-workflowdetails.html#cfn-transfer-server-workflowdetails-onupload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnUpload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkflowDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowDetailsProperty> {
            java.lang.Object onPartialUpload;
            java.lang.Object onUpload;

            /**
             * Sets the value of {@link WorkflowDetailsProperty#getOnPartialUpload}
             * @param onPartialUpload A trigger that starts a workflow if a file is only partially uploaded.
             *                        You can attach a workflow to a server that executes whenever there is a partial upload.
             *                        <p>
             *                        A <em>partial upload</em> occurs when a file is open when the session disconnects.
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onPartialUpload(software.amazon.awscdk.IResolvable onPartialUpload) {
                this.onPartialUpload = onPartialUpload;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowDetailsProperty#getOnPartialUpload}
             * @param onPartialUpload A trigger that starts a workflow if a file is only partially uploaded.
             *                        You can attach a workflow to a server that executes whenever there is a partial upload.
             *                        <p>
             *                        A <em>partial upload</em> occurs when a file is open when the session disconnects.
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onPartialUpload(java.util.List<? extends java.lang.Object> onPartialUpload) {
                this.onPartialUpload = onPartialUpload;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowDetailsProperty#getOnUpload}
             * @param onUpload A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
             *                 To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in the following example.
             *                 <p>
             *                 <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUpload(software.amazon.awscdk.IResolvable onUpload) {
                this.onUpload = onUpload;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowDetailsProperty#getOnUpload}
             * @param onUpload A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
             *                 To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in the following example.
             *                 <p>
             *                 <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUpload(java.util.List<? extends java.lang.Object> onUpload) {
                this.onUpload = onUpload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowDetailsProperty {
            private final java.lang.Object onPartialUpload;
            private final java.lang.Object onUpload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onPartialUpload = software.amazon.jsii.Kernel.get(this, "onPartialUpload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onUpload = software.amazon.jsii.Kernel.get(this, "onUpload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onPartialUpload = builder.onPartialUpload;
                this.onUpload = builder.onUpload;
            }

            @Override
            public final java.lang.Object getOnPartialUpload() {
                return this.onPartialUpload;
            }

            @Override
            public final java.lang.Object getOnUpload() {
                return this.onUpload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOnPartialUpload() != null) {
                    data.set("onPartialUpload", om.valueToTree(this.getOnPartialUpload()));
                }
                if (this.getOnUpload() != null) {
                    data.set("onUpload", om.valueToTree(this.getOnUpload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnServer.WorkflowDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowDetailsProperty.Jsii$Proxy that = (WorkflowDetailsProperty.Jsii$Proxy) o;

                if (this.onPartialUpload != null ? !this.onPartialUpload.equals(that.onPartialUpload) : that.onPartialUpload != null) return false;
                return this.onUpload != null ? this.onUpload.equals(that.onUpload) : that.onUpload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.onPartialUpload != null ? this.onPartialUpload.hashCode() : 0;
                result = 31 * result + (this.onUpload != null ? this.onUpload.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.transfer.CfnServer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.transfer.CfnServer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.transfer.CfnServerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
         * <p>
         * Required when <code>Protocols</code> is set to <code>FTPS</code> .
         * <p>
         * To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * Certificates with the following cryptographic algorithms and key sizes are supported:
         * <p>
         * <ul>
         * <li>2048-bit RSA (RSA_2048)</li>
         * <li>4096-bit RSA (RSA_4096)</li>
         * <li>Elliptic Prime Curve 256 bit (EC_prime256v1)</li>
         * <li>Elliptic Prime Curve 384 bit (EC_secp384r1)</li>
         * <li>Elliptic Prime Curve 521 bit (EC_secp521r1)</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-certificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-certificate</a>
         * @param certificate The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(final java.lang.String certificate) {
            this.props().certificate(certificate);
            return this;
        }

        /**
         * Specifies the domain of the storage system that is used for file transfers.
         * <p>
         * There are two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The default value is S3.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-domain</a>
         * @param domain Specifies the domain of the storage system that is used for file transfers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props().domain(domain);
            return this;
        }

        /**
         * The virtual private cloud (VPC) endpoint settings that are configured for your server.
         * <p>
         * When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointdetails</a>
         * @param endpointDetails The virtual private cloud (VPC) endpoint settings that are configured for your server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointDetails(final software.amazon.awscdk.IResolvable endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }
        /**
         * The virtual private cloud (VPC) endpoint settings that are configured for your server.
         * <p>
         * When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointdetails</a>
         * @param endpointDetails The virtual private cloud (VPC) endpoint settings that are configured for your server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointDetails(final software.amazon.awscdk.services.transfer.CfnServer.EndpointDetailsProperty endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }

        /**
         * The type of endpoint that you want your server to use.
         * <p>
         * You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
         * <p>
         * <blockquote>
         * <p>
         * After May 19, 2021, you won't be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your AWS account if your account hasn't already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your AWS account on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code> = <code>VPC</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com//transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint">Discontinuing the use of VPC_ENDPOINT</a> .
         * <p>
         * It is recommended that you use <code>VPC</code> as the <code>EndpointType</code> . With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointtype</a>
         * @param endpointType The type of endpoint that you want your server to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(final java.lang.String endpointType) {
            this.props().endpointType(endpointType);
            return this;
        }

        /**
         * Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS _LAMBDA</code> or <code>API_GATEWAY</code> .
         * <p>
         * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Cannot be specified when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityproviderdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityproviderdetails</a>
         * @param identityProviderDetails Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS _LAMBDA</code> or <code>API_GATEWAY</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(final software.amazon.awscdk.IResolvable identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }
        /**
         * Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS _LAMBDA</code> or <code>API_GATEWAY</code> .
         * <p>
         * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Cannot be specified when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityproviderdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityproviderdetails</a>
         * @param identityProviderDetails Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS _LAMBDA</code> or <code>API_GATEWAY</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(final software.amazon.awscdk.services.transfer.CfnServer.IdentityProviderDetailsProperty identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }

        /**
         * The mode of authentication for a server.
         * <p>
         * The default value is <code>SERVICE_MANAGED</code> , which allows you to store and access user credentials within the AWS Transfer Family service.
         * <p>
         * Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in AWS Directory Service for Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connector. This option also requires you to provide a Directory ID by using the <code>IdentityProviderDetails</code> parameter.
         * <p>
         * Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an Amazon API Gateway endpoint URL to call for authentication by using the <code>IdentityProviderDetails</code> parameter.
         * <p>
         * Use the <code>AWS_LAMBDA</code> value to directly use an AWS Lambda function as your identity provider. If you choose this value, you must specify the ARN for the Lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityprovidertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityprovidertype</a>
         * @param identityProviderType The mode of authentication for a server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderType(final java.lang.String identityProviderType) {
            this.props().identityProviderType(identityProviderType);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents.
         * <p>
         * When set, you can view user activity in your CloudWatch logs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-loggingrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-loggingrole</a>
         * @param loggingRole The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingRole(final java.lang.String loggingRole) {
            this.props().loggingRole(loggingRole);
            return this;
        }

        /**
         * Specifies a string to display when users connect to a server. This string is displayed after the user authenticates.
         * <p>
         * <blockquote>
         * <p>
         * The SFTP protocol does not support post-authentication display banners.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-postauthenticationloginbanner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-postauthenticationloginbanner</a>
         * @param postAuthenticationLoginBanner Specifies a string to display when users connect to a server. This string is displayed after the user authenticates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postAuthenticationLoginBanner(final java.lang.String postAuthenticationLoginBanner) {
            this.props().postAuthenticationLoginBanner(postAuthenticationLoginBanner);
            return this;
        }

        /**
         * Specifies a string to display when users connect to a server.
         * <p>
         * This string is displayed before the user authenticates. For example, the following banner displays details about using the system:
         * <p>
         * <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-preauthenticationloginbanner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-preauthenticationloginbanner</a>
         * @param preAuthenticationLoginBanner Specifies a string to display when users connect to a server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preAuthenticationLoginBanner(final java.lang.String preAuthenticationLoginBanner) {
            this.props().preAuthenticationLoginBanner(preAuthenticationLoginBanner);
            return this;
        }

        /**
         * The protocol settings that are configured for your server.
         * <p>
         * <ul>
         * <li>To indicate passive mode (for FTP and FTPS protocols), use the <code>PassiveIp</code> parameter. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.</li>
         * <li>To ignore the error that is generated when the client attempts to use the <code>SETSTAT</code> command on a file that you are uploading to an Amazon S3 bucket, use the <code>SetStatOption</code> parameter. To have the AWS Transfer Family server ignore the <code>SETSTAT</code> command and upload files without needing to make any changes to your SFTP client, set the value to <code>ENABLE_NO_OP</code> . If you set the <code>SetStatOption</code> parameter to <code>ENABLE_NO_OP</code> , Transfer Family generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client is making a <code>SETSTAT</code> call.</li>
         * <li>To determine whether your AWS Transfer Family server resumes recent, negotiated sessions through a unique session ID, use the <code>TlsSessionResumptionMode</code> parameter.</li>
         * <li><code>As2Transports</code> indicates the transport method for the AS2 messages. Currently, only HTTP is supported.</li>
         * </ul>
         * <p>
         * The <code>Protocols</code> parameter is an array of strings.
         * <p>
         * <em>Allowed values</em> : One or more of <code>SFTP</code> , <code>FTPS</code> , <code>FTP</code> , <code>AS2</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-protocoldetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-protocoldetails</a>
         * @param protocolDetails The protocol settings that are configured for your server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolDetails(final software.amazon.awscdk.IResolvable protocolDetails) {
            this.props().protocolDetails(protocolDetails);
            return this;
        }
        /**
         * The protocol settings that are configured for your server.
         * <p>
         * <ul>
         * <li>To indicate passive mode (for FTP and FTPS protocols), use the <code>PassiveIp</code> parameter. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.</li>
         * <li>To ignore the error that is generated when the client attempts to use the <code>SETSTAT</code> command on a file that you are uploading to an Amazon S3 bucket, use the <code>SetStatOption</code> parameter. To have the AWS Transfer Family server ignore the <code>SETSTAT</code> command and upload files without needing to make any changes to your SFTP client, set the value to <code>ENABLE_NO_OP</code> . If you set the <code>SetStatOption</code> parameter to <code>ENABLE_NO_OP</code> , Transfer Family generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client is making a <code>SETSTAT</code> call.</li>
         * <li>To determine whether your AWS Transfer Family server resumes recent, negotiated sessions through a unique session ID, use the <code>TlsSessionResumptionMode</code> parameter.</li>
         * <li><code>As2Transports</code> indicates the transport method for the AS2 messages. Currently, only HTTP is supported.</li>
         * </ul>
         * <p>
         * The <code>Protocols</code> parameter is an array of strings.
         * <p>
         * <em>Allowed values</em> : One or more of <code>SFTP</code> , <code>FTPS</code> , <code>FTP</code> , <code>AS2</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-protocoldetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-protocoldetails</a>
         * @param protocolDetails The protocol settings that are configured for your server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolDetails(final software.amazon.awscdk.services.transfer.CfnServer.ProtocolDetailsProperty protocolDetails) {
            this.props().protocolDetails(protocolDetails);
            return this;
        }

        /**
         * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint.
         * <p>
         * The available protocols are:
         * <p>
         * <ul>
         * <li><code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</li>
         * <li><code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</li>
         * <li><code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</li>
         * <li><code>AS2</code> (Applicability Statement 2): used for transporting structured business-to-business data</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>If you select <code>FTPS</code> , you must choose a certificate stored in AWS Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.</li>
         * <li>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code> , then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be either <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS_LAMBDA</code> , or <code>API_GATEWAY</code> .</li>
         * <li>If <code>Protocol</code> includes <code>FTP</code> , then <code>AddressAllocationIds</code> cannot be associated.</li>
         * <li>If <code>Protocol</code> is set only to <code>SFTP</code> , the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set any of the supported identity types: <code>SERVICE_MANAGED</code> , <code>AWS_DIRECTORY_SERVICE</code> , <code>AWS_LAMBDA</code> , or <code>API_GATEWAY</code> .</li>
         * <li>If <code>Protocol</code> includes <code>AS2</code> , then the <code>EndpointType</code> must be <code>VPC</code> , and domain must be Amazon S3.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * The <code>Protocols</code> parameter is an array of strings.
         * <p>
         * <em>Allowed values</em> : One or more of <code>SFTP</code> , <code>FTPS</code> , <code>FTP</code> , <code>AS2</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-protocols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-protocols</a>
         * @param protocols Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocols(final java.util.List<java.lang.String> protocols) {
            this.props().protocols(protocols);
            return this;
        }

        /**
         * Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
         * <p>
         * By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code> . If you enable this option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code> <code>Type</code> to <code>FILE</code> if you want a mapping to have a file target.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-s3storageoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-s3storageoptions</a>
         * @param s3StorageOptions Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3StorageOptions(final software.amazon.awscdk.IResolvable s3StorageOptions) {
            this.props().s3StorageOptions(s3StorageOptions);
            return this;
        }
        /**
         * Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
         * <p>
         * By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code> . If you enable this option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code> <code>Type</code> to <code>FILE</code> if you want a mapping to have a file target.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-s3storageoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-s3storageoptions</a>
         * @param s3StorageOptions Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3StorageOptions(final software.amazon.awscdk.services.transfer.CfnServer.S3StorageOptionsProperty s3StorageOptions) {
            this.props().s3StorageOptions(s3StorageOptions);
            return this;
        }

        /**
         * Specifies the name of the security policy for the server.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-securitypolicyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-securitypolicyname</a>
         * @param securityPolicyName Specifies the name of the security policy for the server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicyName(final java.lang.String securityPolicyName) {
            this.props().securityPolicyName(securityPolicyName);
            return this;
        }

        /**
         * Specifies the log groups to which your server logs are sent.
         * <p>
         * To specify a log group, you must provide the ARN for an existing log group. In this case, the format of the log group is as follows:
         * <p>
         * <code>arn:aws:logs:region-name:amazon-account-id:log-group:log-group-name:*</code>
         * <p>
         * For example, <code>arn:aws:logs:us-east-1:111122223333:log-group:mytestgroup:*</code>
         * <p>
         * If you have previously specified a log group for a server, you can clear it, and in effect turn off structured logging, by providing an empty value for this parameter in an <code>update-server</code> call. For example:
         * <p>
         * <code>update-server --server-id s-1234567890abcdef0 --structured-log-destinations</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-structuredlogdestinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-structuredlogdestinations</a>
         * @param structuredLogDestinations Specifies the log groups to which your server logs are sent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder structuredLogDestinations(final java.util.List<java.lang.String> structuredLogDestinations) {
            this.props().structuredLogDestinations(structuredLogDestinations);
            return this;
        }

        /**
         * Key-value pairs that can be used to group and search for servers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-tags</a>
         * @param tags Key-value pairs that can be used to group and search for servers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
         * <p>
         * In addition to a workflow to execute when a file is uploaded completely, <code>WorkflowDetails</code> can also contain a workflow ID (and execution role) for a workflow to execute on partial upload. A partial upload occurs when a file is open when the session disconnects.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-workflowdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-workflowdetails</a>
         * @param workflowDetails Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowDetails(final software.amazon.awscdk.IResolvable workflowDetails) {
            this.props().workflowDetails(workflowDetails);
            return this;
        }
        /**
         * Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
         * <p>
         * In addition to a workflow to execute when a file is uploaded completely, <code>WorkflowDetails</code> can also contain a workflow ID (and execution role) for a workflow to execute on partial upload. A partial upload occurs when a file is open when the session disconnects.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-workflowdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-workflowdetails</a>
         * @param workflowDetails Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowDetails(final software.amazon.awscdk.services.transfer.CfnServer.WorkflowDetailsProperty workflowDetails) {
            this.props().workflowDetails(workflowDetails);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.transfer.CfnServer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.transfer.CfnServer build() {
            return new software.amazon.awscdk.services.transfer.CfnServer(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.transfer.CfnServerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.transfer.CfnServerProps.Builder();
            }
            return this.props;
        }
    }
}
