package software.amazon.awscdk.services.wafv2;

/**
 * Properties for defining a <code>CfnLoggingConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wafv2.*;
 * Object jsonBody;
 * Object loggingFilter;
 * Object method;
 * Object queryString;
 * Object singleHeader;
 * Object uriPath;
 * CfnLoggingConfigurationProps cfnLoggingConfigurationProps = CfnLoggingConfigurationProps.builder()
 *         .logDestinationConfigs(List.of("logDestinationConfigs"))
 *         .resourceArn("resourceArn")
 *         // the properties below are optional
 *         .loggingFilter(loggingFilter)
 *         .redactedFields(List.of(FieldToMatchProperty.builder()
 *                 .jsonBody(jsonBody)
 *                 .method(method)
 *                 .queryString(queryString)
 *                 .singleHeader(singleHeader)
 *                 .uriPath(uriPath)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:28.312Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnLoggingConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLoggingConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The logging destination configuration that you want to associate with the web ACL.
     * <p>
     * <blockquote>
     * <p>
     * You can associate one logging destination to a web ACL.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-logdestinationconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-logdestinationconfigs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLogDestinationConfigs();

    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-resourcearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

    /**
     * Filtering that specifies which web requests are kept in the logs and which are dropped.
     * <p>
     * You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-loggingfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-loggingfilter</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingFilter() {
        return null;
    }

    /**
     * The parts of the request that you want to keep out of the logs.
     * <p>
     * For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the logs will be <code>REDACTED</code> for all rules that use the <code>SingleHeader</code> <code>FieldToMatch</code> setting.
     * <p>
     * Redaction applies only to the component that's specified in the rule's <code>FieldToMatch</code> setting, so the <code>SingleHeader</code> redaction doesn't apply to rules that use the <code>Headers</code> <code>FieldToMatch</code> .
     * <p>
     * <blockquote>
     * <p>
     * You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , and <code>Method</code> . &gt; This setting has no impact on request sampling. With request sampling, the only way to exclude fields is by disabling sampling in the web ACL visibility configuration.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedactedFields() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLoggingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLoggingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLoggingConfigurationProps> {
        java.util.List<java.lang.String> logDestinationConfigs;
        java.lang.String resourceArn;
        java.lang.Object loggingFilter;
        java.lang.Object redactedFields;

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getLogDestinationConfigs}
         * @param logDestinationConfigs The logging destination configuration that you want to associate with the web ACL. This parameter is required.
         *                              <blockquote>
         *                              <p>
         *                              You can associate one logging destination to a web ACL.
         *                              <p>
         *                              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationConfigs(java.util.List<java.lang.String> logDestinationConfigs) {
            this.logDestinationConfigs = logDestinationConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getResourceArn}
         * @param resourceArn The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArn(java.lang.String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getLoggingFilter}
         * @param loggingFilter Filtering that specifies which web requests are kept in the logs and which are dropped.
         *                      You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingFilter(java.lang.Object loggingFilter) {
            this.loggingFilter = loggingFilter;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getRedactedFields}
         * @param redactedFields The parts of the request that you want to keep out of the logs.
         *                       For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the logs will be <code>REDACTED</code> for all rules that use the <code>SingleHeader</code> <code>FieldToMatch</code> setting.
         *                       <p>
         *                       Redaction applies only to the component that's specified in the rule's <code>FieldToMatch</code> setting, so the <code>SingleHeader</code> redaction doesn't apply to rules that use the <code>Headers</code> <code>FieldToMatch</code> .
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , and <code>Method</code> . &gt; This setting has no impact on request sampling. With request sampling, the only way to exclude fields is by disabling sampling in the web ACL visibility configuration.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redactedFields(software.amazon.awscdk.IResolvable redactedFields) {
            this.redactedFields = redactedFields;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoggingConfigurationProps#getRedactedFields}
         * @param redactedFields The parts of the request that you want to keep out of the logs.
         *                       For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the logs will be <code>REDACTED</code> for all rules that use the <code>SingleHeader</code> <code>FieldToMatch</code> setting.
         *                       <p>
         *                       Redaction applies only to the component that's specified in the rule's <code>FieldToMatch</code> setting, so the <code>SingleHeader</code> redaction doesn't apply to rules that use the <code>Headers</code> <code>FieldToMatch</code> .
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , and <code>Method</code> . &gt; This setting has no impact on request sampling. With request sampling, the only way to exclude fields is by disabling sampling in the web ACL visibility configuration.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redactedFields(java.util.List<? extends java.lang.Object> redactedFields) {
            this.redactedFields = redactedFields;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLoggingConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLoggingConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLoggingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLoggingConfigurationProps {
        private final java.util.List<java.lang.String> logDestinationConfigs;
        private final java.lang.String resourceArn;
        private final java.lang.Object loggingFilter;
        private final java.lang.Object redactedFields;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logDestinationConfigs = software.amazon.jsii.Kernel.get(this, "logDestinationConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingFilter = software.amazon.jsii.Kernel.get(this, "loggingFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.redactedFields = software.amazon.jsii.Kernel.get(this, "redactedFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logDestinationConfigs = java.util.Objects.requireNonNull(builder.logDestinationConfigs, "logDestinationConfigs is required");
            this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            this.loggingFilter = builder.loggingFilter;
            this.redactedFields = builder.redactedFields;
        }

        @Override
        public final java.util.List<java.lang.String> getLogDestinationConfigs() {
            return this.logDestinationConfigs;
        }

        @Override
        public final java.lang.String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final java.lang.Object getLoggingFilter() {
            return this.loggingFilter;
        }

        @Override
        public final java.lang.Object getRedactedFields() {
            return this.redactedFields;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logDestinationConfigs", om.valueToTree(this.getLogDestinationConfigs()));
            data.set("resourceArn", om.valueToTree(this.getResourceArn()));
            if (this.getLoggingFilter() != null) {
                data.set("loggingFilter", om.valueToTree(this.getLoggingFilter()));
            }
            if (this.getRedactedFields() != null) {
                data.set("redactedFields", om.valueToTree(this.getRedactedFields()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLoggingConfigurationProps.Jsii$Proxy that = (CfnLoggingConfigurationProps.Jsii$Proxy) o;

            if (!logDestinationConfigs.equals(that.logDestinationConfigs)) return false;
            if (!resourceArn.equals(that.resourceArn)) return false;
            if (this.loggingFilter != null ? !this.loggingFilter.equals(that.loggingFilter) : that.loggingFilter != null) return false;
            return this.redactedFields != null ? this.redactedFields.equals(that.redactedFields) : that.redactedFields == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logDestinationConfigs.hashCode();
            result = 31 * result + (this.resourceArn.hashCode());
            result = 31 * result + (this.loggingFilter != null ? this.loggingFilter.hashCode() : 0);
            result = 31 * result + (this.redactedFields != null ? this.redactedFields.hashCode() : 0);
            return result;
        }
    }
}
