package software.amazon.awscdk.services.workspacesthinclient;

/**
 * Describes an environment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesthinclient.*;
 * CfnEnvironment cfnEnvironment = CfnEnvironment.Builder.create(this, "MyCfnEnvironment")
 *         .desktopArn("desktopArn")
 *         // the properties below are optional
 *         .desiredSoftwareSetId("desiredSoftwareSetId")
 *         .desktopEndpoint("desktopEndpoint")
 *         .deviceCreationTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .kmsKeyArn("kmsKeyArn")
 *         .maintenanceWindow(MaintenanceWindowProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .applyTimeOf("applyTimeOf")
 *                 .daysOfTheWeek(List.of("daysOfTheWeek"))
 *                 .endTimeHour(123)
 *                 .endTimeMinute(123)
 *                 .startTimeHour(123)
 *                 .startTimeMinute(123)
 *                 .build())
 *         .name("name")
 *         .softwareSetUpdateMode("softwareSetUpdateMode")
 *         .softwareSetUpdateSchedule("softwareSetUpdateSchedule")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:28.550Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesthinclient.CfnEnvironment")
public class CfnEnvironment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.workspacesthinclient.CfnEnvironment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.workspacesthinclient.CfnEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The activation code to register a device to the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrActivationCode() {
        return software.amazon.jsii.Kernel.get(this, "attrActivationCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp of when the environment was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of streaming desktop for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDesktopType() {
        return software.amazon.jsii.Kernel.get(this, "attrDesktopType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Unique identifier of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the software set that is pending to be installed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPendingSoftwareSetId() {
        return software.amazon.jsii.Kernel.get(this, "attrPendingSoftwareSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the software set that is pending to be installed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPendingSoftwareSetVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrPendingSoftwareSetVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of devices registered to the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrRegisteredDevicesCount() {
        return software.amazon.jsii.Kernel.get(this, "attrRegisteredDevicesCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Describes if the software currently installed on all devices in the environment is a supported version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSoftwareSetComplianceStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrSoftwareSetComplianceStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp of when the device was updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream 2.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDesktopArn() {
        return software.amazon.jsii.Kernel.get(this, "desktopArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream 2.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDesktopArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "desktopArn", java.util.Objects.requireNonNull(value, "desktopArn is required"));
    }

    /**
     * The ID of the software set to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDesiredSoftwareSetId() {
        return software.amazon.jsii.Kernel.get(this, "desiredSoftwareSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the software set to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDesiredSoftwareSetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "desiredSoftwareSetId", value);
    }

    /**
     * The URL for the identity provider login (only for environments that use AppStream 2.0).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDesktopEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "desktopEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL for the identity provider login (only for environments that use AppStream 2.0).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDesktopEndpoint(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "desktopEndpoint", value);
    }

    /**
     * The tag keys and optional values for the newly created devices for this environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeviceCreationTags() {
        return software.amazon.jsii.Kernel.get(this, "deviceCreationTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tag keys and optional values for the newly created devices for this environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceCreationTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deviceCreationTags", value);
    }

    /**
     * The tag keys and optional values for the newly created devices for this environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceCreationTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnTag)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnTag; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "deviceCreationTags", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Key Management Service key used to encrypt the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Key Management Service key used to encrypt the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyArn", value);
    }

    /**
     * A specification for a time window to apply software updates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "maintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A specification for a time window to apply software updates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceWindow", value);
    }

    /**
     * A specification for a time window to apply software updates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.workspacesthinclient.CfnEnvironment.MaintenanceWindowProperty value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceWindow", value);
    }

    /**
     * The name of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * An option to define which software updates to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSoftwareSetUpdateMode() {
        return software.amazon.jsii.Kernel.get(this, "softwareSetUpdateMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An option to define which software updates to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSoftwareSetUpdateMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "softwareSetUpdateMode", value);
    }

    /**
     * An option to define if software updates should be applied within a maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSoftwareSetUpdateSchedule() {
        return software.amazon.jsii.Kernel.get(this, "softwareSetUpdateSchedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An option to define if software updates should be applied within a maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSoftwareSetUpdateSchedule(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "softwareSetUpdateSchedule", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Describes the maintenance window for a thin client device.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.workspacesthinclient.*;
     * MaintenanceWindowProperty maintenanceWindowProperty = MaintenanceWindowProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .applyTimeOf("applyTimeOf")
     *         .daysOfTheWeek(List.of("daysOfTheWeek"))
     *         .endTimeHour(123)
     *         .endTimeMinute(123)
     *         .startTimeHour(123)
     *         .startTimeMinute(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesthinclient.CfnEnvironment.MaintenanceWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An option to select the default or custom maintenance window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The option to set the maintenance window during the device local time or Universal Coordinated Time (UTC).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-applytimeof">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-applytimeof</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplyTimeOf() {
            return null;
        }

        /**
         * The days of the week during which the maintenance window is open.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-daysoftheweek">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-daysoftheweek</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDaysOfTheWeek() {
            return null;
        }

        /**
         * The hour for the maintenance window end ( <code>00</code> - <code>23</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-endtimehour">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-endtimehour</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEndTimeHour() {
            return null;
        }

        /**
         * The minutes for the maintenance window end ( <code>00</code> - <code>59</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-endtimeminute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-endtimeminute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEndTimeMinute() {
            return null;
        }

        /**
         * The hour for the maintenance window start ( <code>00</code> - <code>23</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-starttimehour">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-starttimehour</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartTimeHour() {
            return null;
        }

        /**
         * The minutes past the hour for the maintenance window start ( <code>00</code> - <code>59</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-starttimeminute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesthinclient-environment-maintenancewindow.html#cfn-workspacesthinclient-environment-maintenancewindow-starttimeminute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartTimeMinute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceWindowProperty> {
            java.lang.String type;
            java.lang.String applyTimeOf;
            java.util.List<java.lang.String> daysOfTheWeek;
            java.lang.Number endTimeHour;
            java.lang.Number endTimeMinute;
            java.lang.Number startTimeHour;
            java.lang.Number startTimeMinute;

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getType}
             * @param type An option to select the default or custom maintenance window. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getApplyTimeOf}
             * @param applyTimeOf The option to set the maintenance window during the device local time or Universal Coordinated Time (UTC).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applyTimeOf(java.lang.String applyTimeOf) {
                this.applyTimeOf = applyTimeOf;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getDaysOfTheWeek}
             * @param daysOfTheWeek The days of the week during which the maintenance window is open.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daysOfTheWeek(java.util.List<java.lang.String> daysOfTheWeek) {
                this.daysOfTheWeek = daysOfTheWeek;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getEndTimeHour}
             * @param endTimeHour The hour for the maintenance window end ( <code>00</code> - <code>23</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTimeHour(java.lang.Number endTimeHour) {
                this.endTimeHour = endTimeHour;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getEndTimeMinute}
             * @param endTimeMinute The minutes for the maintenance window end ( <code>00</code> - <code>59</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTimeMinute(java.lang.Number endTimeMinute) {
                this.endTimeMinute = endTimeMinute;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getStartTimeHour}
             * @param startTimeHour The hour for the maintenance window start ( <code>00</code> - <code>23</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTimeHour(java.lang.Number startTimeHour) {
                this.startTimeHour = startTimeHour;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getStartTimeMinute}
             * @param startTimeMinute The minutes past the hour for the maintenance window start ( <code>00</code> - <code>59</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTimeMinute(java.lang.Number startTimeMinute) {
                this.startTimeMinute = startTimeMinute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceWindowProperty {
            private final java.lang.String type;
            private final java.lang.String applyTimeOf;
            private final java.util.List<java.lang.String> daysOfTheWeek;
            private final java.lang.Number endTimeHour;
            private final java.lang.Number endTimeMinute;
            private final java.lang.Number startTimeHour;
            private final java.lang.Number startTimeMinute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applyTimeOf = software.amazon.jsii.Kernel.get(this, "applyTimeOf", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.daysOfTheWeek = software.amazon.jsii.Kernel.get(this, "daysOfTheWeek", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.endTimeHour = software.amazon.jsii.Kernel.get(this, "endTimeHour", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.endTimeMinute = software.amazon.jsii.Kernel.get(this, "endTimeMinute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startTimeHour = software.amazon.jsii.Kernel.get(this, "startTimeHour", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startTimeMinute = software.amazon.jsii.Kernel.get(this, "startTimeMinute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.applyTimeOf = builder.applyTimeOf;
                this.daysOfTheWeek = builder.daysOfTheWeek;
                this.endTimeHour = builder.endTimeHour;
                this.endTimeMinute = builder.endTimeMinute;
                this.startTimeHour = builder.startTimeHour;
                this.startTimeMinute = builder.startTimeMinute;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getApplyTimeOf() {
                return this.applyTimeOf;
            }

            @Override
            public final java.util.List<java.lang.String> getDaysOfTheWeek() {
                return this.daysOfTheWeek;
            }

            @Override
            public final java.lang.Number getEndTimeHour() {
                return this.endTimeHour;
            }

            @Override
            public final java.lang.Number getEndTimeMinute() {
                return this.endTimeMinute;
            }

            @Override
            public final java.lang.Number getStartTimeHour() {
                return this.startTimeHour;
            }

            @Override
            public final java.lang.Number getStartTimeMinute() {
                return this.startTimeMinute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getApplyTimeOf() != null) {
                    data.set("applyTimeOf", om.valueToTree(this.getApplyTimeOf()));
                }
                if (this.getDaysOfTheWeek() != null) {
                    data.set("daysOfTheWeek", om.valueToTree(this.getDaysOfTheWeek()));
                }
                if (this.getEndTimeHour() != null) {
                    data.set("endTimeHour", om.valueToTree(this.getEndTimeHour()));
                }
                if (this.getEndTimeMinute() != null) {
                    data.set("endTimeMinute", om.valueToTree(this.getEndTimeMinute()));
                }
                if (this.getStartTimeHour() != null) {
                    data.set("startTimeHour", om.valueToTree(this.getStartTimeHour()));
                }
                if (this.getStartTimeMinute() != null) {
                    data.set("startTimeMinute", om.valueToTree(this.getStartTimeMinute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesthinclient.CfnEnvironment.MaintenanceWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceWindowProperty.Jsii$Proxy that = (MaintenanceWindowProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.applyTimeOf != null ? !this.applyTimeOf.equals(that.applyTimeOf) : that.applyTimeOf != null) return false;
                if (this.daysOfTheWeek != null ? !this.daysOfTheWeek.equals(that.daysOfTheWeek) : that.daysOfTheWeek != null) return false;
                if (this.endTimeHour != null ? !this.endTimeHour.equals(that.endTimeHour) : that.endTimeHour != null) return false;
                if (this.endTimeMinute != null ? !this.endTimeMinute.equals(that.endTimeMinute) : that.endTimeMinute != null) return false;
                if (this.startTimeHour != null ? !this.startTimeHour.equals(that.startTimeHour) : that.startTimeHour != null) return false;
                return this.startTimeMinute != null ? this.startTimeMinute.equals(that.startTimeMinute) : that.startTimeMinute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.applyTimeOf != null ? this.applyTimeOf.hashCode() : 0);
                result = 31 * result + (this.daysOfTheWeek != null ? this.daysOfTheWeek.hashCode() : 0);
                result = 31 * result + (this.endTimeHour != null ? this.endTimeHour.hashCode() : 0);
                result = 31 * result + (this.endTimeMinute != null ? this.endTimeMinute.hashCode() : 0);
                result = 31 * result + (this.startTimeHour != null ? this.startTimeHour.hashCode() : 0);
                result = 31 * result + (this.startTimeMinute != null ? this.startTimeMinute.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.workspacesthinclient.CfnEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.workspacesthinclient.CfnEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.workspacesthinclient.CfnEnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.workspacesthinclient.CfnEnvironmentProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream 2.0.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desktoparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desktoparn</a>
         * @param desktopArn The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream 2.0. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desktopArn(final java.lang.String desktopArn) {
            this.props.desktopArn(desktopArn);
            return this;
        }

        /**
         * The ID of the software set to apply.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desiredsoftwaresetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desiredsoftwaresetid</a>
         * @param desiredSoftwareSetId The ID of the software set to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredSoftwareSetId(final java.lang.String desiredSoftwareSetId) {
            this.props.desiredSoftwareSetId(desiredSoftwareSetId);
            return this;
        }

        /**
         * The URL for the identity provider login (only for environments that use AppStream 2.0).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desktopendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-desktopendpoint</a>
         * @param desktopEndpoint The URL for the identity provider login (only for environments that use AppStream 2.0). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desktopEndpoint(final java.lang.String desktopEndpoint) {
            this.props.desktopEndpoint(desktopEndpoint);
            return this;
        }

        /**
         * The tag keys and optional values for the newly created devices for this environment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-devicecreationtags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-devicecreationtags</a>
         * @param deviceCreationTags The tag keys and optional values for the newly created devices for this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceCreationTags(final software.amazon.awscdk.IResolvable deviceCreationTags) {
            this.props.deviceCreationTags(deviceCreationTags);
            return this;
        }
        /**
         * The tag keys and optional values for the newly created devices for this environment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-devicecreationtags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-devicecreationtags</a>
         * @param deviceCreationTags The tag keys and optional values for the newly created devices for this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceCreationTags(final java.util.List<? extends java.lang.Object> deviceCreationTags) {
            this.props.deviceCreationTags(deviceCreationTags);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Key Management Service key used to encrypt the environment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-kmskeyarn</a>
         * @param kmsKeyArn The Amazon Resource Name (ARN) of the AWS Key Management Service key used to encrypt the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(final java.lang.String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        /**
         * A specification for a time window to apply software updates.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-maintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-maintenancewindow</a>
         * @param maintenanceWindow A specification for a time window to apply software updates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(final software.amazon.awscdk.IResolvable maintenanceWindow) {
            this.props.maintenanceWindow(maintenanceWindow);
            return this;
        }
        /**
         * A specification for a time window to apply software updates.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-maintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-maintenancewindow</a>
         * @param maintenanceWindow A specification for a time window to apply software updates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(final software.amazon.awscdk.services.workspacesthinclient.CfnEnvironment.MaintenanceWindowProperty maintenanceWindow) {
            this.props.maintenanceWindow(maintenanceWindow);
            return this;
        }

        /**
         * The name of the environment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-name</a>
         * @param name The name of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An option to define which software updates to apply.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-softwaresetupdatemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-softwaresetupdatemode</a>
         * @param softwareSetUpdateMode An option to define which software updates to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder softwareSetUpdateMode(final java.lang.String softwareSetUpdateMode) {
            this.props.softwareSetUpdateMode(softwareSetUpdateMode);
            return this;
        }

        /**
         * An option to define if software updates should be applied within a maintenance window.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-softwaresetupdateschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-softwaresetupdateschedule</a>
         * @param softwareSetUpdateSchedule An option to define if software updates should be applied within a maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder softwareSetUpdateSchedule(final java.lang.String softwareSetUpdateSchedule) {
            this.props.softwareSetUpdateSchedule(softwareSetUpdateSchedule);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesthinclient-environment.html#cfn-workspacesthinclient-environment-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.workspacesthinclient.CfnEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.workspacesthinclient.CfnEnvironment build() {
            return new software.amazon.awscdk.services.workspacesthinclient.CfnEnvironment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
