package software.amazon.awscdk.services.workspacesweb;

/**
 * Properties for defining a <code>CfnUserSettings</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesweb.*;
 * CfnUserSettingsProps cfnUserSettingsProps = CfnUserSettingsProps.builder()
 *         .copyAllowed("copyAllowed")
 *         .downloadAllowed("downloadAllowed")
 *         .pasteAllowed("pasteAllowed")
 *         .printAllowed("printAllowed")
 *         .uploadAllowed("uploadAllowed")
 *         // the properties below are optional
 *         .additionalEncryptionContext(Map.of(
 *                 "additionalEncryptionContextKey", "additionalEncryptionContext"))
 *         .cookieSynchronizationConfiguration(CookieSynchronizationConfigurationProperty.builder()
 *                 .allowlist(List.of(CookieSpecificationProperty.builder()
 *                         .domain("domain")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .path("path")
 *                         .build()))
 *                 // the properties below are optional
 *                 .blocklist(List.of(CookieSpecificationProperty.builder()
 *                         .domain("domain")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .path("path")
 *                         .build()))
 *                 .build())
 *         .customerManagedKey("customerManagedKey")
 *         .deepLinkAllowed("deepLinkAllowed")
 *         .disconnectTimeoutInMinutes(123)
 *         .idleDisconnectTimeoutInMinutes(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:28.587Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnUserSettingsProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserSettingsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserSettingsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the user can copy text from the streaming session to the local device.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-copyallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-copyallowed</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCopyAllowed();

    /**
     * Specifies whether the user can download files from the streaming session to the local device.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-downloadallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-downloadallowed</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDownloadAllowed();

    /**
     * Specifies whether the user can paste text from the local device to the streaming session.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-pasteallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-pasteallowed</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPasteAllowed();

    /**
     * Specifies whether the user can print to the local device.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-printallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-printallowed</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrintAllowed();

    /**
     * Specifies whether the user can upload files from the local device to the streaming session.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-uploadallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-uploadallowed</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUploadAllowed();

    /**
     * The additional encryption context of the user settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-additionalencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-additionalencryptioncontext</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalEncryptionContext() {
        return null;
    }

    /**
     * The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-cookiesynchronizationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-cookiesynchronizationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCookieSynchronizationConfiguration() {
        return null;
    }

    /**
     * The customer managed key used to encrypt sensitive information in the user settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-customermanagedkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-customermanagedkey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomerManagedKey() {
        return null;
    }

    /**
     * Specifies whether the user can use deep links that open automatically when connecting to a session.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-deeplinkallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-deeplinkallowed</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeepLinkAllowed() {
        return null;
    }

    /**
     * The amount of time that a streaming session remains active after users disconnect.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-disconnecttimeoutinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-disconnecttimeoutinminutes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDisconnectTimeoutInMinutes() {
        return null;
    }

    /**
     * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-idledisconnecttimeoutinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-idledisconnecttimeoutinminutes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIdleDisconnectTimeoutInMinutes() {
        return null;
    }

    /**
     * The tags to add to the user settings resource.
     * <p>
     * A tag is a key-value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-usersettings.html#cfn-workspacesweb-usersettings-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserSettingsProps> {
        java.lang.String copyAllowed;
        java.lang.String downloadAllowed;
        java.lang.String pasteAllowed;
        java.lang.String printAllowed;
        java.lang.String uploadAllowed;
        java.lang.Object additionalEncryptionContext;
        java.lang.Object cookieSynchronizationConfiguration;
        java.lang.String customerManagedKey;
        java.lang.String deepLinkAllowed;
        java.lang.Number disconnectTimeoutInMinutes;
        java.lang.Number idleDisconnectTimeoutInMinutes;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnUserSettingsProps#getCopyAllowed}
         * @param copyAllowed Specifies whether the user can copy text from the streaming session to the local device. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyAllowed(java.lang.String copyAllowed) {
            this.copyAllowed = copyAllowed;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getDownloadAllowed}
         * @param downloadAllowed Specifies whether the user can download files from the streaming session to the local device. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder downloadAllowed(java.lang.String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getPasteAllowed}
         * @param pasteAllowed Specifies whether the user can paste text from the local device to the streaming session. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pasteAllowed(java.lang.String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getPrintAllowed}
         * @param printAllowed Specifies whether the user can print to the local device. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder printAllowed(java.lang.String printAllowed) {
            this.printAllowed = printAllowed;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getUploadAllowed}
         * @param uploadAllowed Specifies whether the user can upload files from the local device to the streaming session. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uploadAllowed(java.lang.String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getAdditionalEncryptionContext}
         * @param additionalEncryptionContext The additional encryption context of the user settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(software.amazon.awscdk.IResolvable additionalEncryptionContext) {
            this.additionalEncryptionContext = additionalEncryptionContext;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getAdditionalEncryptionContext}
         * @param additionalEncryptionContext The additional encryption context of the user settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(java.util.Map<java.lang.String, java.lang.String> additionalEncryptionContext) {
            this.additionalEncryptionContext = additionalEncryptionContext;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getCookieSynchronizationConfiguration}
         * @param cookieSynchronizationConfiguration The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cookieSynchronizationConfiguration(software.amazon.awscdk.IResolvable cookieSynchronizationConfiguration) {
            this.cookieSynchronizationConfiguration = cookieSynchronizationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getCookieSynchronizationConfiguration}
         * @param cookieSynchronizationConfiguration The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cookieSynchronizationConfiguration(software.amazon.awscdk.services.workspacesweb.CfnUserSettings.CookieSynchronizationConfigurationProperty cookieSynchronizationConfiguration) {
            this.cookieSynchronizationConfiguration = cookieSynchronizationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getCustomerManagedKey}
         * @param customerManagedKey The customer managed key used to encrypt sensitive information in the user settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerManagedKey(java.lang.String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getDeepLinkAllowed}
         * @param deepLinkAllowed Specifies whether the user can use deep links that open automatically when connecting to a session.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deepLinkAllowed(java.lang.String deepLinkAllowed) {
            this.deepLinkAllowed = deepLinkAllowed;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getDisconnectTimeoutInMinutes}
         * @param disconnectTimeoutInMinutes The amount of time that a streaming session remains active after users disconnect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disconnectTimeoutInMinutes(java.lang.Number disconnectTimeoutInMinutes) {
            this.disconnectTimeoutInMinutes = disconnectTimeoutInMinutes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getIdleDisconnectTimeoutInMinutes}
         * @param idleDisconnectTimeoutInMinutes The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleDisconnectTimeoutInMinutes(java.lang.Number idleDisconnectTimeoutInMinutes) {
            this.idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserSettingsProps#getTags}
         * @param tags The tags to add to the user settings resource.
         *             A tag is a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserSettingsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserSettingsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserSettingsProps {
        private final java.lang.String copyAllowed;
        private final java.lang.String downloadAllowed;
        private final java.lang.String pasteAllowed;
        private final java.lang.String printAllowed;
        private final java.lang.String uploadAllowed;
        private final java.lang.Object additionalEncryptionContext;
        private final java.lang.Object cookieSynchronizationConfiguration;
        private final java.lang.String customerManagedKey;
        private final java.lang.String deepLinkAllowed;
        private final java.lang.Number disconnectTimeoutInMinutes;
        private final java.lang.Number idleDisconnectTimeoutInMinutes;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.copyAllowed = software.amazon.jsii.Kernel.get(this, "copyAllowed", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.downloadAllowed = software.amazon.jsii.Kernel.get(this, "downloadAllowed", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pasteAllowed = software.amazon.jsii.Kernel.get(this, "pasteAllowed", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.printAllowed = software.amazon.jsii.Kernel.get(this, "printAllowed", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.uploadAllowed = software.amazon.jsii.Kernel.get(this, "uploadAllowed", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalEncryptionContext = software.amazon.jsii.Kernel.get(this, "additionalEncryptionContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cookieSynchronizationConfiguration = software.amazon.jsii.Kernel.get(this, "cookieSynchronizationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customerManagedKey = software.amazon.jsii.Kernel.get(this, "customerManagedKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deepLinkAllowed = software.amazon.jsii.Kernel.get(this, "deepLinkAllowed", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disconnectTimeoutInMinutes = software.amazon.jsii.Kernel.get(this, "disconnectTimeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.idleDisconnectTimeoutInMinutes = software.amazon.jsii.Kernel.get(this, "idleDisconnectTimeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.copyAllowed = java.util.Objects.requireNonNull(builder.copyAllowed, "copyAllowed is required");
            this.downloadAllowed = java.util.Objects.requireNonNull(builder.downloadAllowed, "downloadAllowed is required");
            this.pasteAllowed = java.util.Objects.requireNonNull(builder.pasteAllowed, "pasteAllowed is required");
            this.printAllowed = java.util.Objects.requireNonNull(builder.printAllowed, "printAllowed is required");
            this.uploadAllowed = java.util.Objects.requireNonNull(builder.uploadAllowed, "uploadAllowed is required");
            this.additionalEncryptionContext = builder.additionalEncryptionContext;
            this.cookieSynchronizationConfiguration = builder.cookieSynchronizationConfiguration;
            this.customerManagedKey = builder.customerManagedKey;
            this.deepLinkAllowed = builder.deepLinkAllowed;
            this.disconnectTimeoutInMinutes = builder.disconnectTimeoutInMinutes;
            this.idleDisconnectTimeoutInMinutes = builder.idleDisconnectTimeoutInMinutes;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCopyAllowed() {
            return this.copyAllowed;
        }

        @Override
        public final java.lang.String getDownloadAllowed() {
            return this.downloadAllowed;
        }

        @Override
        public final java.lang.String getPasteAllowed() {
            return this.pasteAllowed;
        }

        @Override
        public final java.lang.String getPrintAllowed() {
            return this.printAllowed;
        }

        @Override
        public final java.lang.String getUploadAllowed() {
            return this.uploadAllowed;
        }

        @Override
        public final java.lang.Object getAdditionalEncryptionContext() {
            return this.additionalEncryptionContext;
        }

        @Override
        public final java.lang.Object getCookieSynchronizationConfiguration() {
            return this.cookieSynchronizationConfiguration;
        }

        @Override
        public final java.lang.String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        @Override
        public final java.lang.String getDeepLinkAllowed() {
            return this.deepLinkAllowed;
        }

        @Override
        public final java.lang.Number getDisconnectTimeoutInMinutes() {
            return this.disconnectTimeoutInMinutes;
        }

        @Override
        public final java.lang.Number getIdleDisconnectTimeoutInMinutes() {
            return this.idleDisconnectTimeoutInMinutes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("copyAllowed", om.valueToTree(this.getCopyAllowed()));
            data.set("downloadAllowed", om.valueToTree(this.getDownloadAllowed()));
            data.set("pasteAllowed", om.valueToTree(this.getPasteAllowed()));
            data.set("printAllowed", om.valueToTree(this.getPrintAllowed()));
            data.set("uploadAllowed", om.valueToTree(this.getUploadAllowed()));
            if (this.getAdditionalEncryptionContext() != null) {
                data.set("additionalEncryptionContext", om.valueToTree(this.getAdditionalEncryptionContext()));
            }
            if (this.getCookieSynchronizationConfiguration() != null) {
                data.set("cookieSynchronizationConfiguration", om.valueToTree(this.getCookieSynchronizationConfiguration()));
            }
            if (this.getCustomerManagedKey() != null) {
                data.set("customerManagedKey", om.valueToTree(this.getCustomerManagedKey()));
            }
            if (this.getDeepLinkAllowed() != null) {
                data.set("deepLinkAllowed", om.valueToTree(this.getDeepLinkAllowed()));
            }
            if (this.getDisconnectTimeoutInMinutes() != null) {
                data.set("disconnectTimeoutInMinutes", om.valueToTree(this.getDisconnectTimeoutInMinutes()));
            }
            if (this.getIdleDisconnectTimeoutInMinutes() != null) {
                data.set("idleDisconnectTimeoutInMinutes", om.valueToTree(this.getIdleDisconnectTimeoutInMinutes()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesweb.CfnUserSettingsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserSettingsProps.Jsii$Proxy that = (CfnUserSettingsProps.Jsii$Proxy) o;

            if (!copyAllowed.equals(that.copyAllowed)) return false;
            if (!downloadAllowed.equals(that.downloadAllowed)) return false;
            if (!pasteAllowed.equals(that.pasteAllowed)) return false;
            if (!printAllowed.equals(that.printAllowed)) return false;
            if (!uploadAllowed.equals(that.uploadAllowed)) return false;
            if (this.additionalEncryptionContext != null ? !this.additionalEncryptionContext.equals(that.additionalEncryptionContext) : that.additionalEncryptionContext != null) return false;
            if (this.cookieSynchronizationConfiguration != null ? !this.cookieSynchronizationConfiguration.equals(that.cookieSynchronizationConfiguration) : that.cookieSynchronizationConfiguration != null) return false;
            if (this.customerManagedKey != null ? !this.customerManagedKey.equals(that.customerManagedKey) : that.customerManagedKey != null) return false;
            if (this.deepLinkAllowed != null ? !this.deepLinkAllowed.equals(that.deepLinkAllowed) : that.deepLinkAllowed != null) return false;
            if (this.disconnectTimeoutInMinutes != null ? !this.disconnectTimeoutInMinutes.equals(that.disconnectTimeoutInMinutes) : that.disconnectTimeoutInMinutes != null) return false;
            if (this.idleDisconnectTimeoutInMinutes != null ? !this.idleDisconnectTimeoutInMinutes.equals(that.idleDisconnectTimeoutInMinutes) : that.idleDisconnectTimeoutInMinutes != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.copyAllowed.hashCode();
            result = 31 * result + (this.downloadAllowed.hashCode());
            result = 31 * result + (this.pasteAllowed.hashCode());
            result = 31 * result + (this.printAllowed.hashCode());
            result = 31 * result + (this.uploadAllowed.hashCode());
            result = 31 * result + (this.additionalEncryptionContext != null ? this.additionalEncryptionContext.hashCode() : 0);
            result = 31 * result + (this.cookieSynchronizationConfiguration != null ? this.cookieSynchronizationConfiguration.hashCode() : 0);
            result = 31 * result + (this.customerManagedKey != null ? this.customerManagedKey.hashCode() : 0);
            result = 31 * result + (this.deepLinkAllowed != null ? this.deepLinkAllowed.hashCode() : 0);
            result = 31 * result + (this.disconnectTimeoutInMinutes != null ? this.disconnectTimeoutInMinutes.hashCode() : 0);
            result = 31 * result + (this.idleDisconnectTimeoutInMinutes != null ? this.idleDisconnectTimeoutInMinutes.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
