/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigatewayv2;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.apigatewayv2.ContentHandling;
import software.amazon.awscdk.services.apigatewayv2.IWebSocketApi;
import software.amazon.awscdk.services.apigatewayv2.IWebSocketIntegration;
import software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior;
import software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationProps;
import software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apigatewayv2.WebSocketIntegration")
public class WebSocketIntegration
extends Resource
implements IWebSocketIntegration {
    protected WebSocketIntegration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketIntegration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public WebSocketIntegration(@NotNull Construct scope, @NotNull String id, @NotNull WebSocketIntegrationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public String getIntegrationId() {
        return (String)Kernel.get((Object)this, (String)"integrationId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IWebSocketApi getWebSocketApi() {
        return (IWebSocketApi)Kernel.get((Object)this, (String)"webSocketApi", (NativeType)NativeType.forClass(IWebSocketApi.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<WebSocketIntegration> {
        private final Construct scope;
        private final String id;
        private final WebSocketIntegrationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new WebSocketIntegrationProps.Builder();
        }

        public Builder integrationType(WebSocketIntegrationType integrationType) {
            this.props.integrationType(integrationType);
            return this;
        }

        public Builder integrationUri(String integrationUri) {
            this.props.integrationUri(integrationUri);
            return this;
        }

        public Builder webSocketApi(IWebSocketApi webSocketApi) {
            this.props.webSocketApi(webSocketApi);
            return this;
        }

        public Builder contentHandling(ContentHandling contentHandling) {
            this.props.contentHandling(contentHandling);
            return this;
        }

        public Builder credentialsRole(IRole credentialsRole) {
            this.props.credentialsRole(credentialsRole);
            return this;
        }

        public Builder integrationMethod(String integrationMethod) {
            this.props.integrationMethod(integrationMethod);
            return this;
        }

        public Builder passthroughBehavior(PassthroughBehavior passthroughBehavior) {
            this.props.passthroughBehavior(passthroughBehavior);
            return this;
        }

        public Builder requestParameters(Map<String, String> requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        public Builder requestTemplates(Map<String, String> requestTemplates) {
            this.props.requestTemplates(requestTemplates);
            return this;
        }

        public Builder templateSelectionExpression(String templateSelectionExpression) {
            this.props.templateSelectionExpression(templateSelectionExpression);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public WebSocketIntegration build() {
            return new WebSocketIntegration(this.scope, this.id, this.props.build());
        }
    }
}

