/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudtrail;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.cloudtrail.CfnDashboard;
import software.amazon.awscdk.services.cloudtrail.CfnDashboardProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudtrail.CfnDashboard")
public class CfnDashboard
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDashboard.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDashboard(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDashboard(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDashboard(@NotNull Construct scope, @NotNull String id, @Nullable CfnDashboardProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnDashboard(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreatedTimestamp() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedTimestamp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDashboardArn() {
        return (String)Kernel.get((Object)this, (String)"attrDashboardArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrType() {
        return (String)Kernel.get((Object)this, (String)"attrType", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUpdatedTimestamp() {
        return (String)Kernel.get((Object)this, (String)"attrUpdatedTimestamp", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getRefreshSchedule() {
        return Kernel.get((Object)this, (String)"refreshSchedule", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRefreshSchedule(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"refreshSchedule", (Object)value);
    }

    public void setRefreshSchedule(@Nullable RefreshScheduleProperty value) {
        Kernel.set((Object)this, (String)"refreshSchedule", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Nullable
    public Object getTerminationProtectionEnabled() {
        return Kernel.get((Object)this, (String)"terminationProtectionEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTerminationProtectionEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"terminationProtectionEnabled", (Object)value);
    }

    public void setTerminationProtectionEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"terminationProtectionEnabled", (Object)value);
    }

    @Nullable
    public Object getWidgets() {
        return Kernel.get((Object)this, (String)"widgets", (NativeType)NativeType.forClass(Object.class));
    }

    public void setWidgets(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"widgets", (Object)value);
    }

    public void setWidgets(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof WidgetProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cloudtrail.CfnDashboard.WidgetProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"widgets", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudtrail.CfnDashboard.WidgetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WidgetProperty
    extends JsiiSerializable {
        @NotNull
        public String getQueryStatement();

        @Nullable
        default public List<String> getQueryParameters() {
            return null;
        }

        @Nullable
        default public Object getViewProperties() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WidgetProperty> {
            String queryStatement;
            List<String> queryParameters;
            Object viewProperties;

            public Builder queryStatement(String queryStatement) {
                this.queryStatement = queryStatement;
                return this;
            }

            public Builder queryParameters(List<String> queryParameters) {
                this.queryParameters = queryParameters;
                return this;
            }

            public Builder viewProperties(IResolvable viewProperties) {
                this.viewProperties = viewProperties;
                return this;
            }

            public Builder viewProperties(Map<String, String> viewProperties) {
                this.viewProperties = viewProperties;
                return this;
            }

            public WidgetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDashboard> {
        private final Construct scope;
        private final String id;
        private CfnDashboardProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder refreshSchedule(IResolvable refreshSchedule) {
            this.props().refreshSchedule(refreshSchedule);
            return this;
        }

        public Builder refreshSchedule(RefreshScheduleProperty refreshSchedule) {
            this.props().refreshSchedule(refreshSchedule);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }

        public Builder terminationProtectionEnabled(IResolvable terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }

        public Builder widgets(IResolvable widgets) {
            this.props().widgets(widgets);
            return this;
        }

        public Builder widgets(List<? extends Object> widgets) {
            this.props().widgets(widgets);
            return this;
        }

        public CfnDashboard build() {
            return new CfnDashboard(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnDashboardProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnDashboardProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudtrail.CfnDashboard.RefreshScheduleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RefreshScheduleProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFrequency() {
            return null;
        }

        @Nullable
        default public String getStatus() {
            return null;
        }

        @Nullable
        default public String getTimeOfDay() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RefreshScheduleProperty> {
            Object frequency;
            String status;
            String timeOfDay;

            public Builder frequency(IResolvable frequency) {
                this.frequency = frequency;
                return this;
            }

            public Builder frequency(FrequencyProperty frequency) {
                this.frequency = frequency;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder timeOfDay(String timeOfDay) {
                this.timeOfDay = timeOfDay;
                return this;
            }

            public RefreshScheduleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudtrail.CfnDashboard.FrequencyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FrequencyProperty
    extends JsiiSerializable {
        @NotNull
        public String getUnit();

        @NotNull
        public Number getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FrequencyProperty> {
            String unit;
            Number value;

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public FrequencyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

