/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.config;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.config.CustomRuleProps;
import software.amazon.awscdk.services.config.EvaluationMode;
import software.amazon.awscdk.services.config.IRule;
import software.amazon.awscdk.services.config.MaximumExecutionFrequency;
import software.amazon.awscdk.services.config.RuleScope;
import software.amazon.awscdk.services.events.OnEventOptions;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_config.CustomRule")
public class CustomRule
extends Resource
implements IRule {
    protected CustomRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CustomRule(@NotNull Construct scope, @NotNull String id, @NotNull CustomRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IRule fromConfigRuleName(@NotNull Construct scope, @NotNull String id, @NotNull String configRuleName) {
        return (IRule)JsiiObject.jsiiStaticCall(CustomRule.class, (String)"fromConfigRuleName", (NativeType)NativeType.forClass(IRule.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(configRuleName, "configRuleName is required")});
    }

    @Override
    @NotNull
    public Rule onComplianceChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onComplianceChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onComplianceChange(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onComplianceChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onReEvaluationStatus(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onReEvaluationStatus", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onReEvaluationStatus(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onReEvaluationStatus", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public String getConfigRuleArn() {
        return (String)Kernel.get((Object)this, (String)"configRuleArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getConfigRuleComplianceType() {
        return (String)Kernel.get((Object)this, (String)"configRuleComplianceType", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getConfigRuleId() {
        return (String)Kernel.get((Object)this, (String)"configRuleId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getConfigRuleName() {
        return (String)Kernel.get((Object)this, (String)"configRuleName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected Boolean getIsCustomWithChanges() {
        return (Boolean)Kernel.get((Object)this, (String)"isCustomWithChanges", (NativeType)NativeType.forClass(Boolean.class));
    }

    protected void setIsCustomWithChanges(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"isCustomWithChanges", (Object)value);
    }

    @Nullable
    protected Boolean getIsManaged() {
        return (Boolean)Kernel.get((Object)this, (String)"isManaged", (NativeType)NativeType.forClass(Boolean.class));
    }

    protected void setIsManaged(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"isManaged", (Object)value);
    }

    @Nullable
    protected RuleScope getRuleScope() {
        return (RuleScope)((Object)Kernel.get((Object)this, (String)"ruleScope", (NativeType)NativeType.forClass(RuleScope.class)));
    }

    protected void setRuleScope(@Nullable RuleScope value) {
        Kernel.set((Object)this, (String)"ruleScope", (Object)((Object)value));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CustomRule> {
        private final Construct scope;
        private final String id;
        private final CustomRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CustomRuleProps.Builder();
        }

        public Builder configRuleName(String configRuleName) {
            this.props.configRuleName(configRuleName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder evaluationModes(EvaluationMode evaluationModes) {
            this.props.evaluationModes(evaluationModes);
            return this;
        }

        public Builder inputParameters(Map<String, ? extends Object> inputParameters) {
            this.props.inputParameters(inputParameters);
            return this;
        }

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.props.maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        public Builder ruleScope(RuleScope ruleScope) {
            this.props.ruleScope(ruleScope);
            return this;
        }

        public Builder lambdaFunction(IFunction lambdaFunction) {
            this.props.lambdaFunction(lambdaFunction);
            return this;
        }

        public Builder configurationChanges(Boolean configurationChanges) {
            this.props.configurationChanges(configurationChanges);
            return this;
        }

        public Builder periodic(Boolean periodic) {
            this.props.periodic(periodic);
            return this;
        }

        public CustomRule build() {
            return new CustomRule(this.scope, this.id, this.props.build());
        }
    }
}

