/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.ecs.ContainerDefinition;
import software.amazon.awscdk.services.ecs.ContainerMountPoint;
import software.amazon.awscdk.services.ecs.ServiceManagedEBSVolumeConfiguration;
import software.amazon.awscdk.services.ecs.ServiceManagedVolumeProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecs.ServiceManagedVolume")
public class ServiceManagedVolume
extends Construct {
    protected ServiceManagedVolume(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServiceManagedVolume(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ServiceManagedVolume(@NotNull Construct scope, @NotNull String id, @NotNull ServiceManagedVolumeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void mountIn(@NotNull ContainerDefinition container, @NotNull ContainerMountPoint mountPoint) {
        Kernel.call((Object)((Object)this), (String)"mountIn", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(container, "container is required"), Objects.requireNonNull(mountPoint, "mountPoint is required")});
    }

    @NotNull
    public Boolean getConfiguredAtLaunch() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"configuredAtLaunch", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)((Object)this), (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Nullable
    public ServiceManagedEBSVolumeConfiguration getConfig() {
        return (ServiceManagedEBSVolumeConfiguration)Kernel.get((Object)((Object)this), (String)"config", (NativeType)NativeType.forClass(ServiceManagedEBSVolumeConfiguration.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ServiceManagedVolume> {
        private final Construct scope;
        private final String id;
        private final ServiceManagedVolumeProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ServiceManagedVolumeProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder managedEbsVolume(ServiceManagedEBSVolumeConfiguration managedEbsVolume) {
            this.props.managedEbsVolume(managedEbsVolume);
            return this;
        }

        public ServiceManagedVolume build() {
            return new ServiceManagedVolume(this.scope, this.id, this.props.build());
        }
    }
}

