package software.amazon.awscdk;

/**
 * To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
 * <p>
 * Rolling updates enable you to specify whether AWS CloudFormation updates instances that are in an Auto Scaling
 * group in batches or all at once.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnAutoScalingRollingUpdate cfnAutoScalingRollingUpdate = CfnAutoScalingRollingUpdate.builder()
 *         .maxBatchSize(123)
 *         .minInstancesInService(123)
 *         .minSuccessfulInstancesPercent(123)
 *         .pauseTime("pauseTime")
 *         .suspendProcesses(List.of("suspendProcesses"))
 *         .waitOnResourceSignals(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:16.131Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnAutoScalingRollingUpdate")
@software.amazon.jsii.Jsii.Proxy(CfnAutoScalingRollingUpdate.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAutoScalingRollingUpdate extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the maximum number of instances that AWS CloudFormation updates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBatchSize() {
        return null;
    }

    /**
     * Specifies the minimum number of instances that must be in service within the Auto Scaling group while AWS CloudFormation updates old instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinInstancesInService() {
        return null;
    }

    /**
     * Specifies the percentage of instances in an Auto Scaling rolling update that must signal success for an update to succeed.
     * <p>
     * You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent. For example, if you
     * update five instances with a minimum successful percentage of 50, three instances must signal success.
     * <p>
     * If an instance doesn't send a signal within the time specified in the PauseTime property, AWS CloudFormation assumes
     * that the instance wasn't updated.
     * <p>
     * If you specify this property, you must also enable the WaitOnResourceSignals and PauseTime properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSuccessfulInstancesPercent() {
        return null;
    }

    /**
     * The amount of time that AWS CloudFormation pauses after making a change to a batch of instances to give those instances time to start software applications.
     * <p>
     * For example, you might need to specify PauseTime when scaling up the number of
     * instances in an Auto Scaling group.
     * <p>
     * If you enable the WaitOnResourceSignals property, PauseTime is the amount of time that AWS CloudFormation should wait
     * for the Auto Scaling group to receive the required number of valid signals from added or replaced instances. If the
     * PauseTime is exceeded before the Auto Scaling group receives the required number of signals, the update fails. For best
     * results, specify a time period that gives your applications sufficient time to get started. If the update needs to be
     * rolled back, a short PauseTime can cause the rollback to fail.
     * <p>
     * Specify PauseTime in the ISO8601 duration format (in the format PT#H#M#S, where each # is the number of hours, minutes,
     * and seconds, respectively). The maximum PauseTime is one hour (PT1H).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPauseTime() {
        return null;
    }

    /**
     * Specifies the Auto Scaling processes to suspend during a stack update.
     * <p>
     * Suspending processes prevents Auto Scaling from
     * interfering with a stack update. For example, you can suspend alarming so that Auto Scaling doesn't execute scaling
     * policies associated with an alarm. For valid values, see the ScalingProcesses.member.N parameter for the SuspendProcesses
     * action in the Auto Scaling API Reference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSuspendProcesses() {
        return null;
    }

    /**
     * Specifies whether the Auto Scaling group waits on signals from new instances during an update.
     * <p>
     * Use this property to
     * ensure that instances have completed installing and configuring applications before the Auto Scaling group update proceeds.
     * AWS CloudFormation suspends the update of an Auto Scaling group after new EC2 instances are launched into the group.
     * AWS CloudFormation must receive a signal from each new instance within the specified PauseTime before continuing the update.
     * To signal the Auto Scaling group, use the cfn-signal helper script or SignalResource API.
     * <p>
     * To have instances wait for an Elastic Load Balancing health check before they signal success, add a health-check
     * verification by using the cfn-init helper script. For an example, see the verify_instance_health command in the Auto Scaling
     * rolling updates sample template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWaitOnResourceSignals() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAutoScalingRollingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAutoScalingRollingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAutoScalingRollingUpdate> {
        java.lang.Number maxBatchSize;
        java.lang.Number minInstancesInService;
        java.lang.Number minSuccessfulInstancesPercent;
        java.lang.String pauseTime;
        java.util.List<java.lang.String> suspendProcesses;
        java.lang.Boolean waitOnResourceSignals;

        /**
         * Sets the value of {@link CfnAutoScalingRollingUpdate#getMaxBatchSize}
         * @param maxBatchSize Specifies the maximum number of instances that AWS CloudFormation updates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchSize(java.lang.Number maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingRollingUpdate#getMinInstancesInService}
         * @param minInstancesInService Specifies the minimum number of instances that must be in service within the Auto Scaling group while AWS CloudFormation updates old instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minInstancesInService(java.lang.Number minInstancesInService) {
            this.minInstancesInService = minInstancesInService;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingRollingUpdate#getMinSuccessfulInstancesPercent}
         * @param minSuccessfulInstancesPercent Specifies the percentage of instances in an Auto Scaling rolling update that must signal success for an update to succeed.
         *                                      You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent. For example, if you
         *                                      update five instances with a minimum successful percentage of 50, three instances must signal success.
         *                                      <p>
         *                                      If an instance doesn't send a signal within the time specified in the PauseTime property, AWS CloudFormation assumes
         *                                      that the instance wasn't updated.
         *                                      <p>
         *                                      If you specify this property, you must also enable the WaitOnResourceSignals and PauseTime properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSuccessfulInstancesPercent(java.lang.Number minSuccessfulInstancesPercent) {
            this.minSuccessfulInstancesPercent = minSuccessfulInstancesPercent;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingRollingUpdate#getPauseTime}
         * @param pauseTime The amount of time that AWS CloudFormation pauses after making a change to a batch of instances to give those instances time to start software applications.
         *                  For example, you might need to specify PauseTime when scaling up the number of
         *                  instances in an Auto Scaling group.
         *                  <p>
         *                  If you enable the WaitOnResourceSignals property, PauseTime is the amount of time that AWS CloudFormation should wait
         *                  for the Auto Scaling group to receive the required number of valid signals from added or replaced instances. If the
         *                  PauseTime is exceeded before the Auto Scaling group receives the required number of signals, the update fails. For best
         *                  results, specify a time period that gives your applications sufficient time to get started. If the update needs to be
         *                  rolled back, a short PauseTime can cause the rollback to fail.
         *                  <p>
         *                  Specify PauseTime in the ISO8601 duration format (in the format PT#H#M#S, where each # is the number of hours, minutes,
         *                  and seconds, respectively). The maximum PauseTime is one hour (PT1H).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pauseTime(java.lang.String pauseTime) {
            this.pauseTime = pauseTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingRollingUpdate#getSuspendProcesses}
         * @param suspendProcesses Specifies the Auto Scaling processes to suspend during a stack update.
         *                         Suspending processes prevents Auto Scaling from
         *                         interfering with a stack update. For example, you can suspend alarming so that Auto Scaling doesn't execute scaling
         *                         policies associated with an alarm. For valid values, see the ScalingProcesses.member.N parameter for the SuspendProcesses
         *                         action in the Auto Scaling API Reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspendProcesses(java.util.List<java.lang.String> suspendProcesses) {
            this.suspendProcesses = suspendProcesses;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingRollingUpdate#getWaitOnResourceSignals}
         * @param waitOnResourceSignals Specifies whether the Auto Scaling group waits on signals from new instances during an update.
         *                              Use this property to
         *                              ensure that instances have completed installing and configuring applications before the Auto Scaling group update proceeds.
         *                              AWS CloudFormation suspends the update of an Auto Scaling group after new EC2 instances are launched into the group.
         *                              AWS CloudFormation must receive a signal from each new instance within the specified PauseTime before continuing the update.
         *                              To signal the Auto Scaling group, use the cfn-signal helper script or SignalResource API.
         *                              <p>
         *                              To have instances wait for an Elastic Load Balancing health check before they signal success, add a health-check
         *                              verification by using the cfn-init helper script. For an example, see the verify_instance_health command in the Auto Scaling
         *                              rolling updates sample template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitOnResourceSignals(java.lang.Boolean waitOnResourceSignals) {
            this.waitOnResourceSignals = waitOnResourceSignals;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAutoScalingRollingUpdate}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAutoScalingRollingUpdate build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAutoScalingRollingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAutoScalingRollingUpdate {
        private final java.lang.Number maxBatchSize;
        private final java.lang.Number minInstancesInService;
        private final java.lang.Number minSuccessfulInstancesPercent;
        private final java.lang.String pauseTime;
        private final java.util.List<java.lang.String> suspendProcesses;
        private final java.lang.Boolean waitOnResourceSignals;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxBatchSize = software.amazon.jsii.Kernel.get(this, "maxBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minInstancesInService = software.amazon.jsii.Kernel.get(this, "minInstancesInService", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minSuccessfulInstancesPercent = software.amazon.jsii.Kernel.get(this, "minSuccessfulInstancesPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.pauseTime = software.amazon.jsii.Kernel.get(this, "pauseTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.suspendProcesses = software.amazon.jsii.Kernel.get(this, "suspendProcesses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.waitOnResourceSignals = software.amazon.jsii.Kernel.get(this, "waitOnResourceSignals", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxBatchSize = builder.maxBatchSize;
            this.minInstancesInService = builder.minInstancesInService;
            this.minSuccessfulInstancesPercent = builder.minSuccessfulInstancesPercent;
            this.pauseTime = builder.pauseTime;
            this.suspendProcesses = builder.suspendProcesses;
            this.waitOnResourceSignals = builder.waitOnResourceSignals;
        }

        @Override
        public final java.lang.Number getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final java.lang.Number getMinInstancesInService() {
            return this.minInstancesInService;
        }

        @Override
        public final java.lang.Number getMinSuccessfulInstancesPercent() {
            return this.minSuccessfulInstancesPercent;
        }

        @Override
        public final java.lang.String getPauseTime() {
            return this.pauseTime;
        }

        @Override
        public final java.util.List<java.lang.String> getSuspendProcesses() {
            return this.suspendProcesses;
        }

        @Override
        public final java.lang.Boolean getWaitOnResourceSignals() {
            return this.waitOnResourceSignals;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxBatchSize() != null) {
                data.set("maxBatchSize", om.valueToTree(this.getMaxBatchSize()));
            }
            if (this.getMinInstancesInService() != null) {
                data.set("minInstancesInService", om.valueToTree(this.getMinInstancesInService()));
            }
            if (this.getMinSuccessfulInstancesPercent() != null) {
                data.set("minSuccessfulInstancesPercent", om.valueToTree(this.getMinSuccessfulInstancesPercent()));
            }
            if (this.getPauseTime() != null) {
                data.set("pauseTime", om.valueToTree(this.getPauseTime()));
            }
            if (this.getSuspendProcesses() != null) {
                data.set("suspendProcesses", om.valueToTree(this.getSuspendProcesses()));
            }
            if (this.getWaitOnResourceSignals() != null) {
                data.set("waitOnResourceSignals", om.valueToTree(this.getWaitOnResourceSignals()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnAutoScalingRollingUpdate"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAutoScalingRollingUpdate.Jsii$Proxy that = (CfnAutoScalingRollingUpdate.Jsii$Proxy) o;

            if (this.maxBatchSize != null ? !this.maxBatchSize.equals(that.maxBatchSize) : that.maxBatchSize != null) return false;
            if (this.minInstancesInService != null ? !this.minInstancesInService.equals(that.minInstancesInService) : that.minInstancesInService != null) return false;
            if (this.minSuccessfulInstancesPercent != null ? !this.minSuccessfulInstancesPercent.equals(that.minSuccessfulInstancesPercent) : that.minSuccessfulInstancesPercent != null) return false;
            if (this.pauseTime != null ? !this.pauseTime.equals(that.pauseTime) : that.pauseTime != null) return false;
            if (this.suspendProcesses != null ? !this.suspendProcesses.equals(that.suspendProcesses) : that.suspendProcesses != null) return false;
            return this.waitOnResourceSignals != null ? this.waitOnResourceSignals.equals(that.waitOnResourceSignals) : that.waitOnResourceSignals == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxBatchSize != null ? this.maxBatchSize.hashCode() : 0;
            result = 31 * result + (this.minInstancesInService != null ? this.minInstancesInService.hashCode() : 0);
            result = 31 * result + (this.minSuccessfulInstancesPercent != null ? this.minSuccessfulInstancesPercent.hashCode() : 0);
            result = 31 * result + (this.pauseTime != null ? this.pauseTime.hashCode() : 0);
            result = 31 * result + (this.suspendProcesses != null ? this.suspendProcesses.hashCode() : 0);
            result = 31 * result + (this.waitOnResourceSignals != null ? this.waitOnResourceSignals.hashCode() : 0);
            return result;
        }
    }
}
