package software.amazon.awscdk;

/**
 * Modernized version of ITaggable.
 * <p>
 * <code>ITaggable</code> has a problem: for a number of L1 resources, we failed to generate
 * <code>tags: TagManager</code>, and generated <code>tags: CfnSomeResource.TagProperty[]</code> instead.
 * <p>
 * To mark these resources as taggable, we need to put the <code>TagManager</code> in a new property
 * whose name is unlikely to conflict with any existing properties. Hence, a new interface
 * for that purpose. All future resources will implement <code>ITaggableV2</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:16.307Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.ITaggableV2")
@software.amazon.jsii.Jsii.Proxy(ITaggableV2.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ITaggableV2 extends software.amazon.jsii.JsiiSerializable {

    /**
     * TagManager to set, remove and format tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.ITaggableV2.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * TagManager to set, remove and format tags.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
            return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
        }
    }

    /**
     * Internal default implementation for {@link ITaggableV2}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ITaggableV2 {

        /**
         * TagManager to set, remove and format tags.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
            return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
        }
    }
}
