package software.amazon.awscdk;

/**
 * Canonical names of the IANA time zones, derived from the IANA Time Zone Database.
 * <p>
 * For more information, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaInvoke target;
 * Schedule rateBasedSchedule = Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.minutes(10)))
 *         .target(target)
 *         .description("This is a test rate-based schedule")
 *         .build();
 * Schedule cronBasedSchedule = Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.cron(CronOptionsWithTimezone.builder()
 *                 .minute("0")
 *                 .hour("23")
 *                 .day("20")
 *                 .month("11")
 *                 .timeZone(TimeZone.AMERICA_NEW_YORK)
 *                 .build()))
 *         .target(target)
 *         .description("This is a test cron-based schedule that will run at 11:00 PM, on day 20 of the month, only in November in New York timezone")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:16.357Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.TimeZone")
public class TimeZone extends software.amazon.jsii.JsiiObject {

    protected TimeZone(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TimeZone(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AFRICA_ABIDJAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_ABIDJAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_ALGIERS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_ALGIERS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_BISSAU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_BISSAU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_CAIRO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_CAIRO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_CASABLANCA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_CASABLANCA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_CEUTA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_CEUTA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_EL_AAIUN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_EL_AAIUN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_JOHANNESBURG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_JOHANNESBURG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_JUBA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_JUBA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_KHARTOUM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_KHARTOUM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_LAGOS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_LAGOS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_MAPUTO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_MAPUTO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_MONROVIA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_MONROVIA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_NAIROBI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_NAIROBI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_NDJAMENA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_NDJAMENA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_SAO_TOME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_SAO_TOME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_TRIPOLI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_TRIPOLI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_TUNIS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_TUNIS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AFRICA_WINDHOEK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AFRICA_WINDHOEK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ADAK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ADAK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ANCHORAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ANCHORAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARAGUAINA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARAGUAINA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_BUENOS_AIRES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_BUENOS_AIRES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_CATAMARCA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_CATAMARCA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_CORDOBA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_CORDOBA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_JUJUY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_JUJUY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_LA_RIOJA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_LA_RIOJA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_MENDOZA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_MENDOZA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_RIO_GALLEGOS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_RIO_GALLEGOS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_SALTA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_SALTA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_SAN_JUAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_SAN_JUAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_SAN_LUIS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_SAN_LUIS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_TUCUMAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_TUCUMAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ARGENTINA_USHUAIA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ARGENTINA_USHUAIA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ASUNCION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ASUNCION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_BAHIA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_BAHIA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_BAHIA_BANDERAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_BAHIA_BANDERAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_BARBADOS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_BARBADOS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_BELEM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_BELEM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_BELIZE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_BELIZE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_BOA_VISTA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_BOA_VISTA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_BOGOTA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_BOGOTA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_BOISE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_BOISE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_CAMBRIDGE_BAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_CAMBRIDGE_BAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_CAMPO_GRANDE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_CAMPO_GRANDE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_CANCUN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_CANCUN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_CARACAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_CARACAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_CAYENNE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_CAYENNE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_CHICAGO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_CHICAGO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_CHIHUAHUA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_CHIHUAHUA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_CIUDAD_JUAREZ = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_CIUDAD_JUAREZ", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_COSTA_RICA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_COSTA_RICA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_CUIABA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_CUIABA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_DANMARKSHAVN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_DANMARKSHAVN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_DAWSON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_DAWSON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_DAWSON_CREEK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_DAWSON_CREEK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_DENVER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_DENVER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_DETROIT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_DETROIT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_EDMONTON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_EDMONTON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_EIRUNEPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_EIRUNEPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_EL_SALVADOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_EL_SALVADOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_FORT_NELSON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_FORT_NELSON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_FORTALEZA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_FORTALEZA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_GLACE_BAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_GLACE_BAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_GOOSE_BAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_GOOSE_BAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_GRAND_TURK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_GRAND_TURK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_GUATEMALA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_GUATEMALA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_GUAYAQUIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_GUAYAQUIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_GUYANA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_GUYANA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_HALIFAX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_HALIFAX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_HAVANA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_HAVANA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_HERMOSILLO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_HERMOSILLO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_INDIANA_INDIANAPOLIS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_INDIANA_INDIANAPOLIS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_INDIANA_KNOX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_INDIANA_KNOX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_INDIANA_MARENGO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_INDIANA_MARENGO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_INDIANA_PETERSBURG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_INDIANA_PETERSBURG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_INDIANA_TELL_CITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_INDIANA_TELL_CITY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_INDIANA_VEVAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_INDIANA_VEVAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_INDIANA_VINCENNES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_INDIANA_VINCENNES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_INDIANA_WINAMAC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_INDIANA_WINAMAC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_INUVIK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_INUVIK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_IQALUIT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_IQALUIT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_JAMAICA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_JAMAICA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_JUNEAU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_JUNEAU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_KENTUCKY_LOUISVILLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_KENTUCKY_LOUISVILLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_KENTUCKY_MONTICELLO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_KENTUCKY_MONTICELLO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_LA_PAZ = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_LA_PAZ", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_LIMA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_LIMA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_LOS_ANGELES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_LOS_ANGELES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MACEIO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MACEIO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MANAGUA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MANAGUA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MANAUS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MANAUS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MARTINIQUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MARTINIQUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MATAMOROS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MATAMOROS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MAZATLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MAZATLAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MENOMINEE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MENOMINEE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MERIDA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MERIDA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_METLAKATLA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_METLAKATLA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MEXICO_CITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MEXICO_CITY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MIQUELON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MIQUELON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MONCTON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MONCTON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MONTERREY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MONTERREY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_MONTEVIDEO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_MONTEVIDEO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_NEW_YORK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_NEW_YORK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_NOME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_NOME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_NORONHA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_NORONHA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_NORTH_DAKOTA_BEULAH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_NORTH_DAKOTA_BEULAH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_NORTH_DAKOTA_CENTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_NORTH_DAKOTA_CENTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_NORTH_DAKOTA_NEW_SALEM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_NORTH_DAKOTA_NEW_SALEM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_NUUK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_NUUK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_OJINAGA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_OJINAGA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_PANAMA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_PANAMA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_PARAMARIBO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_PARAMARIBO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_PHOENIX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_PHOENIX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_PORT_MINUS_AU_MINUS_PRINCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_PORT_MINUS_AU_MINUS_PRINCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_PORTO_VELHO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_PORTO_VELHO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_PUERTO_RICO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_PUERTO_RICO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_PUNTA_ARENAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_PUNTA_ARENAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_RANKIN_INLET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_RANKIN_INLET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_RECIFE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_RECIFE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_REGINA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_REGINA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_RESOLUTE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_RESOLUTE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_RIO_BRANCO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_RIO_BRANCO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_SANTAREM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_SANTAREM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_SANTIAGO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_SANTIAGO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_SANTO_DOMINGO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_SANTO_DOMINGO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_SAO_PAULO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_SAO_PAULO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_SCORESBYSUND = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_SCORESBYSUND", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_SITKA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_SITKA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_ST_JOHNS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_ST_JOHNS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_SWIFT_CURRENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_SWIFT_CURRENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_TEGUCIGALPA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_TEGUCIGALPA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_THULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_THULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_TIJUANA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_TIJUANA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_TORONTO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_TORONTO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_VANCOUVER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_VANCOUVER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_WHITEHORSE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_WHITEHORSE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_WINNIPEG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_WINNIPEG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_YAKUTAT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_YAKUTAT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AMERICA_YELLOWKNIFE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AMERICA_YELLOWKNIFE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ANTARCTICA_CASEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ANTARCTICA_CASEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ANTARCTICA_DAVIS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ANTARCTICA_DAVIS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ANTARCTICA_MACQUARIE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ANTARCTICA_MACQUARIE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ANTARCTICA_MAWSON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ANTARCTICA_MAWSON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ANTARCTICA_PALMER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ANTARCTICA_PALMER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ANTARCTICA_ROTHERA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ANTARCTICA_ROTHERA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ANTARCTICA_TROLL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ANTARCTICA_TROLL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_ALMATY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_ALMATY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_AMMAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_AMMAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_ANADYR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_ANADYR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_AQTAU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_AQTAU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_AQTOBE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_AQTOBE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_ASHGABAT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_ASHGABAT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_ATYRAU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_ATYRAU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_BAGHDAD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_BAGHDAD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_BAKU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_BAKU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_BANGKOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_BANGKOK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_BARNAUL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_BARNAUL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_BEIRUT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_BEIRUT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_BISHKEK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_BISHKEK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_CHITA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_CHITA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_CHOIBALSAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_CHOIBALSAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_COLOMBO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_COLOMBO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_DAMASCUS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_DAMASCUS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_DHAKA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_DHAKA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_DILI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_DILI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_DUBAI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_DUBAI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_DUSHANBE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_DUSHANBE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_FAMAGUSTA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_FAMAGUSTA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_GAZA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_GAZA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_HEBRON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_HEBRON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_HO_CHI_MINH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_HO_CHI_MINH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_HONG_KONG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_HONG_KONG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_HOVD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_HOVD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_IRKUTSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_IRKUTSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_JAKARTA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_JAKARTA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_JAYAPURA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_JAYAPURA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_JERUSALEM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_JERUSALEM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_KABUL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_KABUL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_KAMCHATKA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_KAMCHATKA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_KARACHI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_KARACHI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_KATHMANDU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_KATHMANDU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_KHANDYGA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_KHANDYGA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_KOLKATA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_KOLKATA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_KRASNOYARSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_KRASNOYARSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_KUCHING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_KUCHING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_MACAU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_MACAU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_MAGADAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_MAGADAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_MAKASSAR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_MAKASSAR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_MANILA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_MANILA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_NICOSIA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_NICOSIA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_NOVOKUZNETSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_NOVOKUZNETSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_NOVOSIBIRSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_NOVOSIBIRSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_OMSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_OMSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_ORAL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_ORAL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_PONTIANAK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_PONTIANAK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_PYONGYANG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_PYONGYANG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_QATAR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_QATAR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_QOSTANAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_QOSTANAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_QYZYLORDA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_QYZYLORDA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_RIYADH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_RIYADH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_SAKHALIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_SAKHALIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_SAMARKAND = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_SAMARKAND", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_SEOUL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_SEOUL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_SHANGHAI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_SHANGHAI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_SINGAPORE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_SINGAPORE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_SREDNEKOLYMSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_SREDNEKOLYMSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_TAIPEI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_TAIPEI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_TASHKENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_TASHKENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_TBILISI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_TBILISI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_TEHRAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_TEHRAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_THIMPHU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_THIMPHU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_TOKYO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_TOKYO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_TOMSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_TOMSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_ULAANBAATAR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_ULAANBAATAR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_URUMQI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_URUMQI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_UST_MINUS_NERA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_UST_MINUS_NERA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_VLADIVOSTOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_VLADIVOSTOK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_YAKUTSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_YAKUTSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_YANGON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_YANGON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_YEKATERINBURG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_YEKATERINBURG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ASIA_YEREVAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ASIA_YEREVAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ATLANTIC_AZORES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ATLANTIC_AZORES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ATLANTIC_BERMUDA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ATLANTIC_BERMUDA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ATLANTIC_CANARY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ATLANTIC_CANARY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ATLANTIC_CAPE_VERDE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ATLANTIC_CAPE_VERDE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ATLANTIC_FAROE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ATLANTIC_FAROE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ATLANTIC_MADEIRA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ATLANTIC_MADEIRA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ATLANTIC_SOUTH_GEORGIA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ATLANTIC_SOUTH_GEORGIA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ATLANTIC_STANLEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ATLANTIC_STANLEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_ADELAIDE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_ADELAIDE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_BRISBANE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_BRISBANE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_BROKEN_HILL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_BROKEN_HILL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_DARWIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_DARWIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_EUCLA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_EUCLA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_HOBART = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_HOBART", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_LINDEMAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_LINDEMAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_LORD_HOWE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_LORD_HOWE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_MELBOURNE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_MELBOURNE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_PERTH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_PERTH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        AUSTRALIA_SYDNEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "AUSTRALIA_SYDNEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        CET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "CET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        CST6_CDT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "CST6CDT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EST5_EDT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EST5EDT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_MINUS_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_MINUS_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_GMT_PLUS_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_GMT_PLUS_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        ETC_UTC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "ETC_UTC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_ANDORRA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_ANDORRA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_ASTRAKHAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_ASTRAKHAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_ATHENS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_ATHENS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_BELGRADE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_BELGRADE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_BERLIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_BERLIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_BRUSSELS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_BRUSSELS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_BUCHAREST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_BUCHAREST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_BUDAPEST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_BUDAPEST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_CHISINAU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_CHISINAU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_DUBLIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_DUBLIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_GIBRALTAR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_GIBRALTAR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_HELSINKI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_HELSINKI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_ISTANBUL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_ISTANBUL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_KALININGRAD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_KALININGRAD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_KIROV = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_KIROV", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_KYIV = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_KYIV", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_LISBON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_LISBON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_LONDON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_LONDON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_MADRID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_MADRID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_MALTA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_MALTA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_MINSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_MINSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_MOSCOW = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_MOSCOW", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_PARIS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_PARIS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_PRAGUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_PRAGUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_RIGA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_RIGA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_ROME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_ROME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_SAMARA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_SAMARA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_SARATOV = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_SARATOV", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_SIMFEROPOL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_SIMFEROPOL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_SOFIA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_SOFIA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_TALLINN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_TALLINN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_TIRANE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_TIRANE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_ULYANOVSK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_ULYANOVSK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_VIENNA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_VIENNA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_VILNIUS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_VILNIUS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_VOLGOGRAD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_VOLGOGRAD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_WARSAW = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_WARSAW", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        EUROPE_ZURICH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "EUROPE_ZURICH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        FACTORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "FACTORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        HST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "HST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        INDIAN_CHAGOS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "INDIAN_CHAGOS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        INDIAN_MALDIVES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "INDIAN_MALDIVES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        INDIAN_MAURITIUS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "INDIAN_MAURITIUS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        MET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "MET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        MST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "MST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        MST7_MDT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "MST7MDT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_APIA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_APIA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_AUCKLAND = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_AUCKLAND", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_BOUGAINVILLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_BOUGAINVILLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_CHATHAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_CHATHAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_EASTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_EASTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_EFATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_EFATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_FAKAOFO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_FAKAOFO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_FIJI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_FIJI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_GALAPAGOS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_GALAPAGOS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_GAMBIER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_GAMBIER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_GUADALCANAL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_GUADALCANAL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_GUAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_GUAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_HONOLULU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_HONOLULU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_KANTON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_KANTON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_KIRITIMATI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_KIRITIMATI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_KOSRAE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_KOSRAE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_KWAJALEIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_KWAJALEIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_MARQUESAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_MARQUESAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_NAURU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_NAURU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_NIUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_NIUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_NORFOLK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_NORFOLK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_NOUMEA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_NOUMEA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_PAGO_PAGO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_PAGO_PAGO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_PALAU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_PALAU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_PITCAIRN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_PITCAIRN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_PORT_MORESBY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_PORT_MORESBY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_RAROTONGA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_RAROTONGA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_TAHITI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_TAHITI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_TARAWA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_TARAWA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PACIFIC_TONGATAPU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PACIFIC_TONGATAPU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        PST8_PDT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "PST8PDT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
        WET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.TimeZone.class, "WET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
    }

    /**
     * Use this to add a timezone not in this class.
     * <p>
     * @return a new Timezone
     * @param timezoneName the name of the timezone. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.TimeZone of(final @org.jetbrains.annotations.NotNull java.lang.String timezoneName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.TimeZone.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class), new Object[] { java.util.Objects.requireNonNull(timezoneName, "timezoneName is required") });
    }

    /**
     * IANA Time Zone database entry for Africa/Abidjan.
     * <p>
     * UTC offset +00:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_ABIDJAN;

    /**
     * IANA Time Zone database entry for Africa/Algiers.
     * <p>
     * UTC offset +01:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_ALGIERS;

    /**
     * IANA Time Zone database entry for Africa/Bissau.
     * <p>
     * UTC offset +00:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_BISSAU;

    /**
     * IANA Time Zone database entry for Africa/Cairo.
     * <p>
     * UTC offset +02:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_CAIRO;

    /**
     * IANA Time Zone database entry for Africa/Casablanca.
     * <p>
     * UTC offset +01:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_CASABLANCA;

    /**
     * IANA Time Zone database entry for Africa/Ceuta.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_CEUTA;

    /**
     * IANA Time Zone database entry for Africa/El_Aaiun.
     * <p>
     * UTC offset +01:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_EL_AAIUN;

    /**
     * IANA Time Zone database entry for Africa/Johannesburg.
     * <p>
     * UTC offset +02:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_JOHANNESBURG;

    /**
     * IANA Time Zone database entry for Africa/Juba.
     * <p>
     * UTC offset +02:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_JUBA;

    /**
     * IANA Time Zone database entry for Africa/Khartoum.
     * <p>
     * UTC offset +02:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_KHARTOUM;

    /**
     * IANA Time Zone database entry for Africa/Lagos.
     * <p>
     * UTC offset +01:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_LAGOS;

    /**
     * IANA Time Zone database entry for Africa/Maputo.
     * <p>
     * UTC offset +02:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_MAPUTO;

    /**
     * IANA Time Zone database entry for Africa/Monrovia.
     * <p>
     * UTC offset +00:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_MONROVIA;

    /**
     * IANA Time Zone database entry for Africa/Nairobi.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_NAIROBI;

    /**
     * IANA Time Zone database entry for Africa/Ndjamena.
     * <p>
     * UTC offset +01:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_NDJAMENA;

    /**
     * IANA Time Zone database entry for Africa/Sao_Tome.
     * <p>
     * UTC offset +00:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_SAO_TOME;

    /**
     * IANA Time Zone database entry for Africa/Tripoli.
     * <p>
     * UTC offset +02:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_TRIPOLI;

    /**
     * IANA Time Zone database entry for Africa/Tunis.
     * <p>
     * UTC offset +01:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_TUNIS;

    /**
     * IANA Time Zone database entry for Africa/Windhoek.
     * <p>
     * UTC offset +02:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AFRICA_WINDHOEK;

    /**
     * IANA Time Zone database entry for America/Adak.
     * <p>
     * UTC offset −10:00/−09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ADAK;

    /**
     * IANA Time Zone database entry for America/Anchorage.
     * <p>
     * UTC offset −09:00/−08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ANCHORAGE;

    /**
     * IANA Time Zone database entry for America/Araguaina.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARAGUAINA;

    /**
     * IANA Time Zone database entry for America/Argentina/Buenos_Aires.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_BUENOS_AIRES;

    /**
     * IANA Time Zone database entry for America/Argentina/Catamarca.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_CATAMARCA;

    /**
     * IANA Time Zone database entry for America/Argentina/Cordoba.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_CORDOBA;

    /**
     * IANA Time Zone database entry for America/Argentina/Jujuy.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_JUJUY;

    /**
     * IANA Time Zone database entry for America/Argentina/La_Rioja.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_LA_RIOJA;

    /**
     * IANA Time Zone database entry for America/Argentina/Mendoza.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_MENDOZA;

    /**
     * IANA Time Zone database entry for America/Argentina/Rio_Gallegos.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_RIO_GALLEGOS;

    /**
     * IANA Time Zone database entry for America/Argentina/Salta.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_SALTA;

    /**
     * IANA Time Zone database entry for America/Argentina/San_Juan.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_SAN_JUAN;

    /**
     * IANA Time Zone database entry for America/Argentina/San_Luis.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_SAN_LUIS;

    /**
     * IANA Time Zone database entry for America/Argentina/Tucuman.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_TUCUMAN;

    /**
     * IANA Time Zone database entry for America/Argentina/Ushuaia.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ARGENTINA_USHUAIA;

    /**
     * IANA Time Zone database entry for America/Asuncion.
     * <p>
     * UTC offset −04:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ASUNCION;

    /**
     * IANA Time Zone database entry for America/Bahia.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_BAHIA;

    /**
     * IANA Time Zone database entry for America/Bahia_Banderas.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_BAHIA_BANDERAS;

    /**
     * IANA Time Zone database entry for America/Barbados.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_BARBADOS;

    /**
     * IANA Time Zone database entry for America/Belem.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_BELEM;

    /**
     * IANA Time Zone database entry for America/Belize.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_BELIZE;

    /**
     * IANA Time Zone database entry for America/Boa_Vista.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_BOA_VISTA;

    /**
     * IANA Time Zone database entry for America/Bogota.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_BOGOTA;

    /**
     * IANA Time Zone database entry for America/Boise.
     * <p>
     * UTC offset −07:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_BOISE;

    /**
     * IANA Time Zone database entry for America/Cambridge_Bay.
     * <p>
     * UTC offset −07:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_CAMBRIDGE_BAY;

    /**
     * IANA Time Zone database entry for America/Campo_Grande.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_CAMPO_GRANDE;

    /**
     * IANA Time Zone database entry for America/Cancun.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_CANCUN;

    /**
     * IANA Time Zone database entry for America/Caracas.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_CARACAS;

    /**
     * IANA Time Zone database entry for America/Cayenne.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_CAYENNE;

    /**
     * IANA Time Zone database entry for America/Chicago.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_CHICAGO;

    /**
     * IANA Time Zone database entry for America/Chihuahua.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_CHIHUAHUA;

    /**
     * IANA Time Zone database entry for America/Ciudad_Juarez.
     * <p>
     * UTC offset −07:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_CIUDAD_JUAREZ;

    /**
     * IANA Time Zone database entry for America/Costa_Rica.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_COSTA_RICA;

    /**
     * IANA Time Zone database entry for America/Cuiaba.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_CUIABA;

    /**
     * IANA Time Zone database entry for America/Danmarkshavn.
     * <p>
     * UTC offset +00:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_DANMARKSHAVN;

    /**
     * IANA Time Zone database entry for America/Dawson.
     * <p>
     * UTC offset −07:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_DAWSON;

    /**
     * IANA Time Zone database entry for America/Dawson_Creek.
     * <p>
     * UTC offset −07:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_DAWSON_CREEK;

    /**
     * IANA Time Zone database entry for America/Denver.
     * <p>
     * UTC offset −07:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_DENVER;

    /**
     * IANA Time Zone database entry for America/Detroit.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_DETROIT;

    /**
     * IANA Time Zone database entry for America/Edmonton.
     * <p>
     * UTC offset −07:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_EDMONTON;

    /**
     * IANA Time Zone database entry for America/Eirunepe.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_EIRUNEPE;

    /**
     * IANA Time Zone database entry for America/El_Salvador.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_EL_SALVADOR;

    /**
     * IANA Time Zone database entry for America/Fort_Nelson.
     * <p>
     * UTC offset −07:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_FORT_NELSON;

    /**
     * IANA Time Zone database entry for America/Fortaleza.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_FORTALEZA;

    /**
     * IANA Time Zone database entry for America/Glace_Bay.
     * <p>
     * UTC offset −04:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_GLACE_BAY;

    /**
     * IANA Time Zone database entry for America/Goose_Bay.
     * <p>
     * UTC offset −04:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_GOOSE_BAY;

    /**
     * IANA Time Zone database entry for America/Grand_Turk.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_GRAND_TURK;

    /**
     * IANA Time Zone database entry for America/Guatemala.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_GUATEMALA;

    /**
     * IANA Time Zone database entry for America/Guayaquil.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_GUAYAQUIL;

    /**
     * IANA Time Zone database entry for America/Guyana.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_GUYANA;

    /**
     * IANA Time Zone database entry for America/Halifax.
     * <p>
     * UTC offset −04:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_HALIFAX;

    /**
     * IANA Time Zone database entry for America/Havana.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_HAVANA;

    /**
     * IANA Time Zone database entry for America/Hermosillo.
     * <p>
     * UTC offset −07:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_HERMOSILLO;

    /**
     * IANA Time Zone database entry for America/Indiana/Indianapolis.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_INDIANA_INDIANAPOLIS;

    /**
     * IANA Time Zone database entry for America/Indiana/Knox.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_INDIANA_KNOX;

    /**
     * IANA Time Zone database entry for America/Indiana/Marengo.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_INDIANA_MARENGO;

    /**
     * IANA Time Zone database entry for America/Indiana/Petersburg.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_INDIANA_PETERSBURG;

    /**
     * IANA Time Zone database entry for America/Indiana/Tell_City.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_INDIANA_TELL_CITY;

    /**
     * IANA Time Zone database entry for America/Indiana/Vevay.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_INDIANA_VEVAY;

    /**
     * IANA Time Zone database entry for America/Indiana/Vincennes.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_INDIANA_VINCENNES;

    /**
     * IANA Time Zone database entry for America/Indiana/Winamac.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_INDIANA_WINAMAC;

    /**
     * IANA Time Zone database entry for America/Inuvik.
     * <p>
     * UTC offset −07:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_INUVIK;

    /**
     * IANA Time Zone database entry for America/Iqaluit.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_IQALUIT;

    /**
     * IANA Time Zone database entry for America/Jamaica.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_JAMAICA;

    /**
     * IANA Time Zone database entry for America/Juneau.
     * <p>
     * UTC offset −09:00/−08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_JUNEAU;

    /**
     * IANA Time Zone database entry for America/Kentucky/Louisville.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_KENTUCKY_LOUISVILLE;

    /**
     * IANA Time Zone database entry for America/Kentucky/Monticello.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_KENTUCKY_MONTICELLO;

    /**
     * IANA Time Zone database entry for America/La_Paz.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_LA_PAZ;

    /**
     * IANA Time Zone database entry for America/Lima.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_LIMA;

    /**
     * IANA Time Zone database entry for America/Los_Angeles.
     * <p>
     * UTC offset −08:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_LOS_ANGELES;

    /**
     * IANA Time Zone database entry for America/Maceio.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MACEIO;

    /**
     * IANA Time Zone database entry for America/Managua.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MANAGUA;

    /**
     * IANA Time Zone database entry for America/Manaus.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MANAUS;

    /**
     * IANA Time Zone database entry for America/Martinique.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MARTINIQUE;

    /**
     * IANA Time Zone database entry for America/Matamoros.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MATAMOROS;

    /**
     * IANA Time Zone database entry for America/Mazatlan.
     * <p>
     * UTC offset −07:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MAZATLAN;

    /**
     * IANA Time Zone database entry for America/Menominee.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MENOMINEE;

    /**
     * IANA Time Zone database entry for America/Merida.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MERIDA;

    /**
     * IANA Time Zone database entry for America/Metlakatla.
     * <p>
     * UTC offset −09:00/−08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_METLAKATLA;

    /**
     * IANA Time Zone database entry for America/Mexico_City.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MEXICO_CITY;

    /**
     * IANA Time Zone database entry for America/Miquelon.
     * <p>
     * UTC offset −03:00/−02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MIQUELON;

    /**
     * IANA Time Zone database entry for America/Moncton.
     * <p>
     * UTC offset −04:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MONCTON;

    /**
     * IANA Time Zone database entry for America/Monterrey.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MONTERREY;

    /**
     * IANA Time Zone database entry for America/Montevideo.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_MONTEVIDEO;

    /**
     * IANA Time Zone database entry for America/New_York.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_NEW_YORK;

    /**
     * IANA Time Zone database entry for America/Nome.
     * <p>
     * UTC offset −09:00/−08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_NOME;

    /**
     * IANA Time Zone database entry for America/Noronha.
     * <p>
     * UTC offset −02:00/−02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_NORONHA;

    /**
     * IANA Time Zone database entry for America/North_Dakota/Beulah.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_NORTH_DAKOTA_BEULAH;

    /**
     * IANA Time Zone database entry for America/North_Dakota/Center.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_NORTH_DAKOTA_CENTER;

    /**
     * IANA Time Zone database entry for America/North_Dakota/New_Salem.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_NORTH_DAKOTA_NEW_SALEM;

    /**
     * IANA Time Zone database entry for America/Nuuk.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_NUUK;

    /**
     * IANA Time Zone database entry for America/Ojinaga.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_OJINAGA;

    /**
     * IANA Time Zone database entry for America/Panama.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_PANAMA;

    /**
     * IANA Time Zone database entry for America/Paramaribo.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_PARAMARIBO;

    /**
     * IANA Time Zone database entry for America/Phoenix.
     * <p>
     * UTC offset −07:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_PHOENIX;

    /**
     * IANA Time Zone database entry for America/Port-au-Prince.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_PORT_MINUS_AU_MINUS_PRINCE;

    /**
     * IANA Time Zone database entry for America/Porto_Velho.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_PORTO_VELHO;

    /**
     * IANA Time Zone database entry for America/Puerto_Rico.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_PUERTO_RICO;

    /**
     * IANA Time Zone database entry for America/Punta_Arenas.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_PUNTA_ARENAS;

    /**
     * IANA Time Zone database entry for America/Rankin_Inlet.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_RANKIN_INLET;

    /**
     * IANA Time Zone database entry for America/Recife.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_RECIFE;

    /**
     * IANA Time Zone database entry for America/Regina.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_REGINA;

    /**
     * IANA Time Zone database entry for America/Resolute.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_RESOLUTE;

    /**
     * IANA Time Zone database entry for America/Rio_Branco.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_RIO_BRANCO;

    /**
     * IANA Time Zone database entry for America/Santarem.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_SANTAREM;

    /**
     * IANA Time Zone database entry for America/Santiago.
     * <p>
     * UTC offset −04:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_SANTIAGO;

    /**
     * IANA Time Zone database entry for America/Santo_Domingo.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_SANTO_DOMINGO;

    /**
     * IANA Time Zone database entry for America/Sao_Paulo.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_SAO_PAULO;

    /**
     * IANA Time Zone database entry for America/Scoresbysund.
     * <p>
     * UTC offset −01:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_SCORESBYSUND;

    /**
     * IANA Time Zone database entry for America/Sitka.
     * <p>
     * UTC offset −09:00/−08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_SITKA;

    /**
     * IANA Time Zone database entry for America/St_Johns.
     * <p>
     * UTC offset −03:30/−02:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_ST_JOHNS;

    /**
     * IANA Time Zone database entry for America/Swift_Current.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_SWIFT_CURRENT;

    /**
     * IANA Time Zone database entry for America/Tegucigalpa.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_TEGUCIGALPA;

    /**
     * IANA Time Zone database entry for America/Thule.
     * <p>
     * UTC offset −04:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_THULE;

    /**
     * IANA Time Zone database entry for America/Tijuana.
     * <p>
     * UTC offset −08:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_TIJUANA;

    /**
     * IANA Time Zone database entry for America/Toronto.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_TORONTO;

    /**
     * IANA Time Zone database entry for America/Vancouver.
     * <p>
     * UTC offset −08:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_VANCOUVER;

    /**
     * IANA Time Zone database entry for America/Whitehorse.
     * <p>
     * UTC offset −07:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_WHITEHORSE;

    /**
     * IANA Time Zone database entry for America/Winnipeg.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_WINNIPEG;

    /**
     * IANA Time Zone database entry for America/Yakutat.
     * <p>
     * UTC offset −09:00/−08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_YAKUTAT;

    /**
     * IANA Time Zone database entry for America/Yellowknife.
     * <p>
     * UTC offset −07:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AMERICA_YELLOWKNIFE;

    /**
     * IANA Time Zone database entry for Antarctica/Casey.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ANTARCTICA_CASEY;

    /**
     * IANA Time Zone database entry for Antarctica/Davis.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ANTARCTICA_DAVIS;

    /**
     * IANA Time Zone database entry for Antarctica/Macquarie.
     * <p>
     * UTC offset +10:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ANTARCTICA_MACQUARIE;

    /**
     * IANA Time Zone database entry for Antarctica/Mawson.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ANTARCTICA_MAWSON;

    /**
     * IANA Time Zone database entry for Antarctica/Palmer.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ANTARCTICA_PALMER;

    /**
     * IANA Time Zone database entry for Antarctica/Rothera.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ANTARCTICA_ROTHERA;

    /**
     * IANA Time Zone database entry for Antarctica/Troll.
     * <p>
     * UTC offset +00:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ANTARCTICA_TROLL;

    /**
     * IANA Time Zone database entry for Asia/Almaty.
     * <p>
     * UTC offset +06:00/+06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_ALMATY;

    /**
     * IANA Time Zone database entry for Asia/Amman.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_AMMAN;

    /**
     * IANA Time Zone database entry for Asia/Anadyr.
     * <p>
     * UTC offset +12:00/+12:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_ANADYR;

    /**
     * IANA Time Zone database entry for Asia/Aqtau.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_AQTAU;

    /**
     * IANA Time Zone database entry for Asia/Aqtobe.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_AQTOBE;

    /**
     * IANA Time Zone database entry for Asia/Ashgabat.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_ASHGABAT;

    /**
     * IANA Time Zone database entry for Asia/Atyrau.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_ATYRAU;

    /**
     * IANA Time Zone database entry for Asia/Baghdad.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_BAGHDAD;

    /**
     * IANA Time Zone database entry for Asia/Baku.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_BAKU;

    /**
     * IANA Time Zone database entry for Asia/Bangkok.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_BANGKOK;

    /**
     * IANA Time Zone database entry for Asia/Barnaul.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_BARNAUL;

    /**
     * IANA Time Zone database entry for Asia/Beirut.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_BEIRUT;

    /**
     * IANA Time Zone database entry for Asia/Bishkek.
     * <p>
     * UTC offset +06:00/+06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_BISHKEK;

    /**
     * IANA Time Zone database entry for Asia/Chita.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_CHITA;

    /**
     * IANA Time Zone database entry for Asia/Choibalsan.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_CHOIBALSAN;

    /**
     * IANA Time Zone database entry for Asia/Colombo.
     * <p>
     * UTC offset +05:30/+05:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_COLOMBO;

    /**
     * IANA Time Zone database entry for Asia/Damascus.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_DAMASCUS;

    /**
     * IANA Time Zone database entry for Asia/Dhaka.
     * <p>
     * UTC offset +06:00/+06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_DHAKA;

    /**
     * IANA Time Zone database entry for Asia/Dili.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_DILI;

    /**
     * IANA Time Zone database entry for Asia/Dubai.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_DUBAI;

    /**
     * IANA Time Zone database entry for Asia/Dushanbe.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_DUSHANBE;

    /**
     * IANA Time Zone database entry for Asia/Famagusta.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_FAMAGUSTA;

    /**
     * IANA Time Zone database entry for Asia/Gaza.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_GAZA;

    /**
     * IANA Time Zone database entry for Asia/Hebron.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_HEBRON;

    /**
     * IANA Time Zone database entry for Asia/Ho_Chi_Minh.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_HO_CHI_MINH;

    /**
     * IANA Time Zone database entry for Asia/Hong_Kong.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_HONG_KONG;

    /**
     * IANA Time Zone database entry for Asia/Hovd.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_HOVD;

    /**
     * IANA Time Zone database entry for Asia/Irkutsk.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_IRKUTSK;

    /**
     * IANA Time Zone database entry for Asia/Jakarta.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_JAKARTA;

    /**
     * IANA Time Zone database entry for Asia/Jayapura.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_JAYAPURA;

    /**
     * IANA Time Zone database entry for Asia/Jerusalem.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_JERUSALEM;

    /**
     * IANA Time Zone database entry for Asia/Kabul.
     * <p>
     * UTC offset +04:30/+04:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_KABUL;

    /**
     * IANA Time Zone database entry for Asia/Kamchatka.
     * <p>
     * UTC offset +12:00/+12:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_KAMCHATKA;

    /**
     * IANA Time Zone database entry for Asia/Karachi.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_KARACHI;

    /**
     * IANA Time Zone database entry for Asia/Kathmandu.
     * <p>
     * UTC offset +05:45/+05:45.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_KATHMANDU;

    /**
     * IANA Time Zone database entry for Asia/Khandyga.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_KHANDYGA;

    /**
     * IANA Time Zone database entry for Asia/Kolkata.
     * <p>
     * UTC offset +05:30/+05:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_KOLKATA;

    /**
     * IANA Time Zone database entry for Asia/Krasnoyarsk.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_KRASNOYARSK;

    /**
     * IANA Time Zone database entry for Asia/Kuching.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_KUCHING;

    /**
     * IANA Time Zone database entry for Asia/Macau.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_MACAU;

    /**
     * IANA Time Zone database entry for Asia/Magadan.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_MAGADAN;

    /**
     * IANA Time Zone database entry for Asia/Makassar.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_MAKASSAR;

    /**
     * IANA Time Zone database entry for Asia/Manila.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_MANILA;

    /**
     * IANA Time Zone database entry for Asia/Nicosia.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_NICOSIA;

    /**
     * IANA Time Zone database entry for Asia/Novokuznetsk.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_NOVOKUZNETSK;

    /**
     * IANA Time Zone database entry for Asia/Novosibirsk.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_NOVOSIBIRSK;

    /**
     * IANA Time Zone database entry for Asia/Omsk.
     * <p>
     * UTC offset +06:00/+06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_OMSK;

    /**
     * IANA Time Zone database entry for Asia/Oral.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_ORAL;

    /**
     * IANA Time Zone database entry for Asia/Pontianak.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_PONTIANAK;

    /**
     * IANA Time Zone database entry for Asia/Pyongyang.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_PYONGYANG;

    /**
     * IANA Time Zone database entry for Asia/Qatar.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_QATAR;

    /**
     * IANA Time Zone database entry for Asia/Qostanay.
     * <p>
     * UTC offset +06:00/+06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_QOSTANAY;

    /**
     * IANA Time Zone database entry for Asia/Qyzylorda.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_QYZYLORDA;

    /**
     * IANA Time Zone database entry for Asia/Riyadh.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_RIYADH;

    /**
     * IANA Time Zone database entry for Asia/Sakhalin.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_SAKHALIN;

    /**
     * IANA Time Zone database entry for Asia/Samarkand.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_SAMARKAND;

    /**
     * IANA Time Zone database entry for Asia/Seoul.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_SEOUL;

    /**
     * IANA Time Zone database entry for Asia/Shanghai.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_SHANGHAI;

    /**
     * IANA Time Zone database entry for Asia/Singapore.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_SINGAPORE;

    /**
     * IANA Time Zone database entry for Asia/Srednekolymsk.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_SREDNEKOLYMSK;

    /**
     * IANA Time Zone database entry for Asia/Taipei.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_TAIPEI;

    /**
     * IANA Time Zone database entry for Asia/Tashkent.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_TASHKENT;

    /**
     * IANA Time Zone database entry for Asia/Tbilisi.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_TBILISI;

    /**
     * IANA Time Zone database entry for Asia/Tehran.
     * <p>
     * UTC offset +03:30/+03:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_TEHRAN;

    /**
     * IANA Time Zone database entry for Asia/Thimphu.
     * <p>
     * UTC offset +06:00/+06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_THIMPHU;

    /**
     * IANA Time Zone database entry for Asia/Tokyo.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_TOKYO;

    /**
     * IANA Time Zone database entry for Asia/Tomsk.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_TOMSK;

    /**
     * IANA Time Zone database entry for Asia/Ulaanbaatar.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_ULAANBAATAR;

    /**
     * IANA Time Zone database entry for Asia/Urumqi.
     * <p>
     * UTC offset +06:00/+06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_URUMQI;

    /**
     * IANA Time Zone database entry for Asia/Ust-Nera.
     * <p>
     * UTC offset +10:00/+10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_UST_MINUS_NERA;

    /**
     * IANA Time Zone database entry for Asia/Vladivostok.
     * <p>
     * UTC offset +10:00/+10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_VLADIVOSTOK;

    /**
     * IANA Time Zone database entry for Asia/Yakutsk.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_YAKUTSK;

    /**
     * IANA Time Zone database entry for Asia/Yangon.
     * <p>
     * UTC offset +06:30/+06:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_YANGON;

    /**
     * IANA Time Zone database entry for Asia/Yekaterinburg.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_YEKATERINBURG;

    /**
     * IANA Time Zone database entry for Asia/Yerevan.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ASIA_YEREVAN;

    /**
     * IANA Time Zone database entry for Atlantic/Azores.
     * <p>
     * UTC offset −01:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ATLANTIC_AZORES;

    /**
     * IANA Time Zone database entry for Atlantic/Bermuda.
     * <p>
     * UTC offset −04:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ATLANTIC_BERMUDA;

    /**
     * IANA Time Zone database entry for Atlantic/Canary.
     * <p>
     * UTC offset +00:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ATLANTIC_CANARY;

    /**
     * IANA Time Zone database entry for Atlantic/Cape_Verde.
     * <p>
     * UTC offset −01:00/−01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ATLANTIC_CAPE_VERDE;

    /**
     * IANA Time Zone database entry for Atlantic/Faroe.
     * <p>
     * UTC offset +00:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ATLANTIC_FAROE;

    /**
     * IANA Time Zone database entry for Atlantic/Madeira.
     * <p>
     * UTC offset +00:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ATLANTIC_MADEIRA;

    /**
     * IANA Time Zone database entry for Atlantic/South_Georgia.
     * <p>
     * UTC offset −02:00/−02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ATLANTIC_SOUTH_GEORGIA;

    /**
     * IANA Time Zone database entry for Atlantic/Stanley.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ATLANTIC_STANLEY;

    /**
     * IANA Time Zone database entry for Australia/Adelaide.
     * <p>
     * UTC offset +09:30/+10:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_ADELAIDE;

    /**
     * IANA Time Zone database entry for Australia/Brisbane.
     * <p>
     * UTC offset +10:00/+10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_BRISBANE;

    /**
     * IANA Time Zone database entry for Australia/Broken_Hill.
     * <p>
     * UTC offset +09:30/+10:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_BROKEN_HILL;

    /**
     * IANA Time Zone database entry for Australia/Darwin.
     * <p>
     * UTC offset +09:30/+09:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_DARWIN;

    /**
     * IANA Time Zone database entry for Australia/Eucla.
     * <p>
     * UTC offset +08:45/+08:45.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_EUCLA;

    /**
     * IANA Time Zone database entry for Australia/Hobart.
     * <p>
     * UTC offset +10:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_HOBART;

    /**
     * IANA Time Zone database entry for Australia/Lindeman.
     * <p>
     * UTC offset +10:00/+10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_LINDEMAN;

    /**
     * IANA Time Zone database entry for Australia/Lord_Howe.
     * <p>
     * UTC offset +10:30/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_LORD_HOWE;

    /**
     * IANA Time Zone database entry for Australia/Melbourne.
     * <p>
     * UTC offset +10:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_MELBOURNE;

    /**
     * IANA Time Zone database entry for Australia/Perth.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_PERTH;

    /**
     * IANA Time Zone database entry for Australia/Sydney.
     * <p>
     * UTC offset +10:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone AUSTRALIA_SYDNEY;

    /**
     * IANA Time Zone database entry for CET.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone CET;

    /**
     * IANA Time Zone database entry for CST6CDT.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone CST6_CDT;

    /**
     * IANA Time Zone database entry for EET.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EET;

    /**
     * IANA Time Zone database entry for EST.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EST;

    /**
     * IANA Time Zone database entry for EST5EDT.
     * <p>
     * UTC offset −05:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EST5_EDT;

    /**
     * IANA Time Zone database entry for Etc/GMT.
     * <p>
     * UTC offset +00:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT;

    /**
     * IANA Time Zone database entry for Etc/GMT-1.
     * <p>
     * UTC offset +01:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_1;

    /**
     * IANA Time Zone database entry for Etc/GMT-10.
     * <p>
     * UTC offset +10:00/+10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_10;

    /**
     * IANA Time Zone database entry for Etc/GMT-11.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_11;

    /**
     * IANA Time Zone database entry for Etc/GMT-12.
     * <p>
     * UTC offset +12:00/+12:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_12;

    /**
     * IANA Time Zone database entry for Etc/GMT-13.
     * <p>
     * UTC offset +13:00/+13:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_13;

    /**
     * IANA Time Zone database entry for Etc/GMT-14.
     * <p>
     * UTC offset +14:00/+14:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_14;

    /**
     * IANA Time Zone database entry for Etc/GMT-2.
     * <p>
     * UTC offset +02:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_2;

    /**
     * IANA Time Zone database entry for Etc/GMT-3.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_3;

    /**
     * IANA Time Zone database entry for Etc/GMT-4.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_4;

    /**
     * IANA Time Zone database entry for Etc/GMT-5.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_5;

    /**
     * IANA Time Zone database entry for Etc/GMT-6.
     * <p>
     * UTC offset +06:00/+06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_6;

    /**
     * IANA Time Zone database entry for Etc/GMT-7.
     * <p>
     * UTC offset +07:00/+07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_7;

    /**
     * IANA Time Zone database entry for Etc/GMT-8.
     * <p>
     * UTC offset +08:00/+08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_8;

    /**
     * IANA Time Zone database entry for Etc/GMT-9.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_MINUS_9;

    /**
     * IANA Time Zone database entry for Etc/GMT+1.
     * <p>
     * UTC offset −01:00/−01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_1;

    /**
     * IANA Time Zone database entry for Etc/GMT+10.
     * <p>
     * UTC offset −10:00/−10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_10;

    /**
     * IANA Time Zone database entry for Etc/GMT+11.
     * <p>
     * UTC offset −11:00/−11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_11;

    /**
     * IANA Time Zone database entry for Etc/GMT+12.
     * <p>
     * UTC offset −12:00/−12:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_12;

    /**
     * IANA Time Zone database entry for Etc/GMT+2.
     * <p>
     * UTC offset −02:00/−02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_2;

    /**
     * IANA Time Zone database entry for Etc/GMT+3.
     * <p>
     * UTC offset −03:00/−03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_3;

    /**
     * IANA Time Zone database entry for Etc/GMT+4.
     * <p>
     * UTC offset −04:00/−04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_4;

    /**
     * IANA Time Zone database entry for Etc/GMT+5.
     * <p>
     * UTC offset −05:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_5;

    /**
     * IANA Time Zone database entry for Etc/GMT+6.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_6;

    /**
     * IANA Time Zone database entry for Etc/GMT+7.
     * <p>
     * UTC offset −07:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_7;

    /**
     * IANA Time Zone database entry for Etc/GMT+8.
     * <p>
     * UTC offset −08:00/−08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_8;

    /**
     * IANA Time Zone database entry for Etc/GMT+9.
     * <p>
     * UTC offset −09:00/−09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_GMT_PLUS_9;

    /**
     * IANA Time Zone database entry for Etc/UTC.
     * <p>
     * UTC offset +00:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone ETC_UTC;

    /**
     * IANA Time Zone database entry for Europe/Andorra.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_ANDORRA;

    /**
     * IANA Time Zone database entry for Europe/Astrakhan.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_ASTRAKHAN;

    /**
     * IANA Time Zone database entry for Europe/Athens.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_ATHENS;

    /**
     * IANA Time Zone database entry for Europe/Belgrade.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_BELGRADE;

    /**
     * IANA Time Zone database entry for Europe/Berlin.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_BERLIN;

    /**
     * IANA Time Zone database entry for Europe/Brussels.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_BRUSSELS;

    /**
     * IANA Time Zone database entry for Europe/Bucharest.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_BUCHAREST;

    /**
     * IANA Time Zone database entry for Europe/Budapest.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_BUDAPEST;

    /**
     * IANA Time Zone database entry for Europe/Chisinau.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_CHISINAU;

    /**
     * IANA Time Zone database entry for Europe/Dublin.
     * <p>
     * UTC offset +01:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_DUBLIN;

    /**
     * IANA Time Zone database entry for Europe/Gibraltar.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_GIBRALTAR;

    /**
     * IANA Time Zone database entry for Europe/Helsinki.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_HELSINKI;

    /**
     * IANA Time Zone database entry for Europe/Istanbul.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_ISTANBUL;

    /**
     * IANA Time Zone database entry for Europe/Kaliningrad.
     * <p>
     * UTC offset +02:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_KALININGRAD;

    /**
     * IANA Time Zone database entry for Europe/Kirov.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_KIROV;

    /**
     * IANA Time Zone database entry for Europe/Kyiv.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_KYIV;

    /**
     * IANA Time Zone database entry for Europe/Lisbon.
     * <p>
     * UTC offset +00:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_LISBON;

    /**
     * IANA Time Zone database entry for Europe/London.
     * <p>
     * UTC offset +00:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_LONDON;

    /**
     * IANA Time Zone database entry for Europe/Madrid.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_MADRID;

    /**
     * IANA Time Zone database entry for Europe/Malta.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_MALTA;

    /**
     * IANA Time Zone database entry for Europe/Minsk.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_MINSK;

    /**
     * IANA Time Zone database entry for Europe/Moscow.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_MOSCOW;

    /**
     * IANA Time Zone database entry for Europe/Paris.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_PARIS;

    /**
     * IANA Time Zone database entry for Europe/Prague.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_PRAGUE;

    /**
     * IANA Time Zone database entry for Europe/Riga.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_RIGA;

    /**
     * IANA Time Zone database entry for Europe/Rome.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_ROME;

    /**
     * IANA Time Zone database entry for Europe/Samara.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_SAMARA;

    /**
     * IANA Time Zone database entry for Europe/Saratov.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_SARATOV;

    /**
     * IANA Time Zone database entry for Europe/Simferopol.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_SIMFEROPOL;

    /**
     * IANA Time Zone database entry for Europe/Sofia.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_SOFIA;

    /**
     * IANA Time Zone database entry for Europe/Tallinn.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_TALLINN;

    /**
     * IANA Time Zone database entry for Europe/Tirane.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_TIRANE;

    /**
     * IANA Time Zone database entry for Europe/Ulyanovsk.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_ULYANOVSK;

    /**
     * IANA Time Zone database entry for Europe/Vienna.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_VIENNA;

    /**
     * IANA Time Zone database entry for Europe/Vilnius.
     * <p>
     * UTC offset +02:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_VILNIUS;

    /**
     * IANA Time Zone database entry for Europe/Volgograd.
     * <p>
     * UTC offset +03:00/+03:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_VOLGOGRAD;

    /**
     * IANA Time Zone database entry for Europe/Warsaw.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_WARSAW;

    /**
     * IANA Time Zone database entry for Europe/Zurich.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone EUROPE_ZURICH;

    /**
     * IANA Time Zone database entry for Factory.
     * <p>
     * UTC offset +00:00/+00:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone FACTORY;

    /**
     * IANA Time Zone database entry for HST.
     * <p>
     * UTC offset −10:00/−10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone HST;

    /**
     * IANA Time Zone database entry for Indian/Chagos.
     * <p>
     * UTC offset +06:00/+06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone INDIAN_CHAGOS;

    /**
     * IANA Time Zone database entry for Indian/Maldives.
     * <p>
     * UTC offset +05:00/+05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone INDIAN_MALDIVES;

    /**
     * IANA Time Zone database entry for Indian/Mauritius.
     * <p>
     * UTC offset +04:00/+04:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone INDIAN_MAURITIUS;

    /**
     * IANA Time Zone database entry for MET.
     * <p>
     * UTC offset +01:00/+02:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone MET;

    /**
     * IANA Time Zone database entry for MST.
     * <p>
     * UTC offset −07:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone MST;

    /**
     * IANA Time Zone database entry for MST7MDT.
     * <p>
     * UTC offset −07:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone MST7_MDT;

    /**
     * IANA Time Zone database entry for Pacific/Apia.
     * <p>
     * UTC offset +13:00/+13:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_APIA;

    /**
     * IANA Time Zone database entry for Pacific/Auckland.
     * <p>
     * UTC offset +12:00/+13:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_AUCKLAND;

    /**
     * IANA Time Zone database entry for Pacific/Bougainville.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_BOUGAINVILLE;

    /**
     * IANA Time Zone database entry for Pacific/Chatham.
     * <p>
     * UTC offset +12:45/+13:45.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_CHATHAM;

    /**
     * IANA Time Zone database entry for Pacific/Easter.
     * <p>
     * UTC offset −06:00/−05:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_EASTER;

    /**
     * IANA Time Zone database entry for Pacific/Efate.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_EFATE;

    /**
     * IANA Time Zone database entry for Pacific/Fakaofo.
     * <p>
     * UTC offset +13:00/+13:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_FAKAOFO;

    /**
     * IANA Time Zone database entry for Pacific/Fiji.
     * <p>
     * UTC offset +12:00/+12:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_FIJI;

    /**
     * IANA Time Zone database entry for Pacific/Galapagos.
     * <p>
     * UTC offset −06:00/−06:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_GALAPAGOS;

    /**
     * IANA Time Zone database entry for Pacific/Gambier.
     * <p>
     * UTC offset −09:00/−09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_GAMBIER;

    /**
     * IANA Time Zone database entry for Pacific/Guadalcanal.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_GUADALCANAL;

    /**
     * IANA Time Zone database entry for Pacific/Guam.
     * <p>
     * UTC offset +10:00/+10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_GUAM;

    /**
     * IANA Time Zone database entry for Pacific/Honolulu.
     * <p>
     * UTC offset −10:00/−10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_HONOLULU;

    /**
     * IANA Time Zone database entry for Pacific/Kanton.
     * <p>
     * UTC offset +13:00/+13:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_KANTON;

    /**
     * IANA Time Zone database entry for Pacific/Kiritimati.
     * <p>
     * UTC offset +14:00/+14:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_KIRITIMATI;

    /**
     * IANA Time Zone database entry for Pacific/Kosrae.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_KOSRAE;

    /**
     * IANA Time Zone database entry for Pacific/Kwajalein.
     * <p>
     * UTC offset +12:00/+12:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_KWAJALEIN;

    /**
     * IANA Time Zone database entry for Pacific/Marquesas.
     * <p>
     * UTC offset −09:30/−09:30.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_MARQUESAS;

    /**
     * IANA Time Zone database entry for Pacific/Nauru.
     * <p>
     * UTC offset +12:00/+12:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_NAURU;

    /**
     * IANA Time Zone database entry for Pacific/Niue.
     * <p>
     * UTC offset −11:00/−11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_NIUE;

    /**
     * IANA Time Zone database entry for Pacific/Norfolk.
     * <p>
     * UTC offset +11:00/+12:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_NORFOLK;

    /**
     * IANA Time Zone database entry for Pacific/Noumea.
     * <p>
     * UTC offset +11:00/+11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_NOUMEA;

    /**
     * IANA Time Zone database entry for Pacific/Pago_Pago.
     * <p>
     * UTC offset −11:00/−11:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_PAGO_PAGO;

    /**
     * IANA Time Zone database entry for Pacific/Palau.
     * <p>
     * UTC offset +09:00/+09:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_PALAU;

    /**
     * IANA Time Zone database entry for Pacific/Pitcairn.
     * <p>
     * UTC offset −08:00/−08:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_PITCAIRN;

    /**
     * IANA Time Zone database entry for Pacific/Port_Moresby.
     * <p>
     * UTC offset +10:00/+10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_PORT_MORESBY;

    /**
     * IANA Time Zone database entry for Pacific/Rarotonga.
     * <p>
     * UTC offset −10:00/−10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_RAROTONGA;

    /**
     * IANA Time Zone database entry for Pacific/Tahiti.
     * <p>
     * UTC offset −10:00/−10:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_TAHITI;

    /**
     * IANA Time Zone database entry for Pacific/Tarawa.
     * <p>
     * UTC offset +12:00/+12:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_TARAWA;

    /**
     * IANA Time Zone database entry for Pacific/Tongatapu.
     * <p>
     * UTC offset +13:00/+13:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PACIFIC_TONGATAPU;

    /**
     * IANA Time Zone database entry for PST8PDT.
     * <p>
     * UTC offset −08:00/−07:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone PST8_PDT;

    /**
     * IANA Time Zone database entry for WET.
     * <p>
     * UTC offset +00:00/+01:00.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.TimeZone WET;

    /**
     * The name of the timezone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTimezoneName() {
        return software.amazon.jsii.Kernel.get(this, "timezoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
