package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * Base options for private integration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.*;
 * ParameterMapping parameterMapping;
 * VpcLink vpcLink;
 * HttpPrivateIntegrationOptions httpPrivateIntegrationOptions = HttpPrivateIntegrationOptions.builder()
 *         .method(HttpMethod.ANY)
 *         .parameterMapping(parameterMapping)
 *         .secureServerName("secureServerName")
 *         .timeout(Duration.minutes(30))
 *         .vpcLink(vpcLink)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:16.969Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.HttpPrivateIntegrationOptions")
@software.amazon.jsii.Jsii.Proxy(HttpPrivateIntegrationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpPrivateIntegrationOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HTTP method that must be used to invoke the underlying HTTP proxy.
     * <p>
     * Default: HttpMethod.ANY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpMethod getMethod() {
        return null;
    }

    /**
     * Specifies how to transform HTTP requests before sending them to the backend.
     * <p>
     * Default: undefined requests are sent to the backend unmodified
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
        return null;
    }

    /**
     * Specifies the server name to verified by HTTPS when calling the backend integration.
     * <p>
     * Default: undefined private integration traffic will use HTTP protocol
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-tlsconfig.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecureServerName() {
        return null;
    }

    /**
     * The maximum amount of time an integration will run before it returns without a response.
     * <p>
     * Must be between 50 milliseconds and 29 seconds.
     * <p>
     * Default: Duration.seconds(29)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * The vpc link to be used for the private integration.
     * <p>
     * Default: - a new VpcLink is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IVpcLink getVpcLink() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpPrivateIntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpPrivateIntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpPrivateIntegrationOptions> {
        software.amazon.awscdk.services.apigatewayv2.HttpMethod method;
        software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        java.lang.String secureServerName;
        software.amazon.awscdk.Duration timeout;
        software.amazon.awscdk.services.apigatewayv2.IVpcLink vpcLink;

        /**
         * Sets the value of {@link HttpPrivateIntegrationOptions#getMethod}
         * @param method The HTTP method that must be used to invoke the underlying HTTP proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.apigatewayv2.HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link HttpPrivateIntegrationOptions#getParameterMapping}
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.parameterMapping = parameterMapping;
            return this;
        }

        /**
         * Sets the value of {@link HttpPrivateIntegrationOptions#getSecureServerName}
         * @param secureServerName Specifies the server name to verified by HTTPS when calling the backend integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secureServerName(java.lang.String secureServerName) {
            this.secureServerName = secureServerName;
            return this;
        }

        /**
         * Sets the value of {@link HttpPrivateIntegrationOptions#getTimeout}
         * @param timeout The maximum amount of time an integration will run before it returns without a response.
         *                Must be between 50 milliseconds and 29 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link HttpPrivateIntegrationOptions#getVpcLink}
         * @param vpcLink The vpc link to be used for the private integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLink(software.amazon.awscdk.services.apigatewayv2.IVpcLink vpcLink) {
            this.vpcLink = vpcLink;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpPrivateIntegrationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpPrivateIntegrationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpPrivateIntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpPrivateIntegrationOptions {
        private final software.amazon.awscdk.services.apigatewayv2.HttpMethod method;
        private final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        private final java.lang.String secureServerName;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.apigatewayv2.IVpcLink vpcLink;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpMethod.class));
            this.parameterMapping = software.amazon.jsii.Kernel.get(this, "parameterMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class));
            this.secureServerName = software.amazon.jsii.Kernel.get(this, "secureServerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpcLink = software.amazon.jsii.Kernel.get(this, "vpcLink", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IVpcLink.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.method = builder.method;
            this.parameterMapping = builder.parameterMapping;
            this.secureServerName = builder.secureServerName;
            this.timeout = builder.timeout;
            this.vpcLink = builder.vpcLink;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
            return this.parameterMapping;
        }

        @Override
        public final java.lang.String getSecureServerName() {
            return this.secureServerName;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IVpcLink getVpcLink() {
            return this.vpcLink;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMethod() != null) {
                data.set("method", om.valueToTree(this.getMethod()));
            }
            if (this.getParameterMapping() != null) {
                data.set("parameterMapping", om.valueToTree(this.getParameterMapping()));
            }
            if (this.getSecureServerName() != null) {
                data.set("secureServerName", om.valueToTree(this.getSecureServerName()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVpcLink() != null) {
                data.set("vpcLink", om.valueToTree(this.getVpcLink()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2_integrations.HttpPrivateIntegrationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpPrivateIntegrationOptions.Jsii$Proxy that = (HttpPrivateIntegrationOptions.Jsii$Proxy) o;

            if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
            if (this.parameterMapping != null ? !this.parameterMapping.equals(that.parameterMapping) : that.parameterMapping != null) return false;
            if (this.secureServerName != null ? !this.secureServerName.equals(that.secureServerName) : that.secureServerName != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.vpcLink != null ? this.vpcLink.equals(that.vpcLink) : that.vpcLink == null;
        }

        @Override
        public final int hashCode() {
            int result = this.method != null ? this.method.hashCode() : 0;
            result = 31 * result + (this.parameterMapping != null ? this.parameterMapping.hashCode() : 0);
            result = 31 * result + (this.secureServerName != null ? this.secureServerName.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.vpcLink != null ? this.vpcLink.hashCode() : 0);
            return result;
        }
    }
}
