package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Options for specific cdk commands that are run as part of the integration test workflow.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * CdkCommands cdkCommands = CdkCommands.builder()
 *         .deploy(DeployCommand.builder()
 *                 .args(DeployOptions.builder()
 *                         .all(false)
 *                         .app("app")
 *                         .assetMetadata(false)
 *                         .caBundlePath("caBundlePath")
 *                         .changeSetName("changeSetName")
 *                         .ci(false)
 *                         .color(false)
 *                         .concurrency(123)
 *                         .context(Map.of(
 *                                 "contextKey", "context"))
 *                         .debug(false)
 *                         .ec2Creds(false)
 *                         .exclusively(false)
 *                         .execute(false)
 *                         .force(false)
 *                         .ignoreErrors(false)
 *                         .json(false)
 *                         .lookups(false)
 *                         .notices(false)
 *                         .notificationArns(List.of("notificationArns"))
 *                         .output("output")
 *                         .outputsFile("outputsFile")
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .pathMetadata(false)
 *                         .profile("profile")
 *                         .proxy("proxy")
 *                         .requireApproval(RequireApproval.NEVER)
 *                         .reuseAssets(List.of("reuseAssets"))
 *                         .roleArn("roleArn")
 *                         .rollback(false)
 *                         .stacks(List.of("stacks"))
 *                         .staging(false)
 *                         .strict(false)
 *                         .toolkitStackName("toolkitStackName")
 *                         .trace(false)
 *                         .usePreviousParameters(false)
 *                         .verbose(false)
 *                         .versionReporting(false)
 *                         .build())
 *                 .enabled(false)
 *                 .expectedMessage("expectedMessage")
 *                 .expectError(false)
 *                 .build())
 *         .destroy(DestroyCommand.builder()
 *                 .args(DestroyOptions.builder()
 *                         .all(false)
 *                         .app("app")
 *                         .assetMetadata(false)
 *                         .caBundlePath("caBundlePath")
 *                         .color(false)
 *                         .context(Map.of(
 *                                 "contextKey", "context"))
 *                         .debug(false)
 *                         .ec2Creds(false)
 *                         .exclusively(false)
 *                         .force(false)
 *                         .ignoreErrors(false)
 *                         .json(false)
 *                         .lookups(false)
 *                         .notices(false)
 *                         .output("output")
 *                         .pathMetadata(false)
 *                         .profile("profile")
 *                         .proxy("proxy")
 *                         .roleArn("roleArn")
 *                         .stacks(List.of("stacks"))
 *                         .staging(false)
 *                         .strict(false)
 *                         .trace(false)
 *                         .verbose(false)
 *                         .versionReporting(false)
 *                         .build())
 *                 .enabled(false)
 *                 .expectedMessage("expectedMessage")
 *                 .expectError(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:32.381Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.CdkCommands")
@software.amazon.jsii.Jsii.Proxy(CdkCommands.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CdkCommands extends software.amazon.jsii.JsiiSerializable {

    /**
     * Options to for the cdk deploy command.
     * <p>
     * Default: - default deploy options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloud_assembly_schema.DeployCommand getDeploy() {
        return null;
    }

    /**
     * Options to for the cdk destroy command.
     * <p>
     * Default: - default destroy options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloud_assembly_schema.DestroyCommand getDestroy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CdkCommands}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CdkCommands}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CdkCommands> {
        software.amazon.awscdk.cloud_assembly_schema.DeployCommand deploy;
        software.amazon.awscdk.cloud_assembly_schema.DestroyCommand destroy;

        /**
         * Sets the value of {@link CdkCommands#getDeploy}
         * @param deploy Options to for the cdk deploy command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(software.amazon.awscdk.cloud_assembly_schema.DeployCommand deploy) {
            this.deploy = deploy;
            return this;
        }

        /**
         * Sets the value of {@link CdkCommands#getDestroy}
         * @param destroy Options to for the cdk destroy command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destroy(software.amazon.awscdk.cloud_assembly_schema.DestroyCommand destroy) {
            this.destroy = destroy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CdkCommands}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CdkCommands build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CdkCommands}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CdkCommands {
        private final software.amazon.awscdk.cloud_assembly_schema.DeployCommand deploy;
        private final software.amazon.awscdk.cloud_assembly_schema.DestroyCommand destroy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploy = software.amazon.jsii.Kernel.get(this, "deploy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.DeployCommand.class));
            this.destroy = software.amazon.jsii.Kernel.get(this, "destroy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.DestroyCommand.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploy = builder.deploy;
            this.destroy = builder.destroy;
        }

        @Override
        public final software.amazon.awscdk.cloud_assembly_schema.DeployCommand getDeploy() {
            return this.deploy;
        }

        @Override
        public final software.amazon.awscdk.cloud_assembly_schema.DestroyCommand getDestroy() {
            return this.destroy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeploy() != null) {
                data.set("deploy", om.valueToTree(this.getDeploy()));
            }
            if (this.getDestroy() != null) {
                data.set("destroy", om.valueToTree(this.getDestroy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.CdkCommands"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CdkCommands.Jsii$Proxy that = (CdkCommands.Jsii$Proxy) o;

            if (this.deploy != null ? !this.deploy.equals(that.deploy) : that.deploy != null) return false;
            return this.destroy != null ? this.destroy.equals(that.destroy) : that.destroy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploy != null ? this.deploy.hashCode() : 0;
            result = 31 * result + (this.destroy != null ? this.destroy.hashCode() : 0);
            return result;
        }
    }
}
