package software.amazon.awscdk.cloudformation.include;

/**
 * Construction properties of <code>CfnInclude</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnInclude parentTemplate = CfnInclude.Builder.create(this, "ParentStack")
 *         .templateFile("path/to/my-parent-template.json")
 *         .loadNestedStacks(Map.of(
 *                 "ChildStack", CfnIncludeProps.builder()
 *                         .templateFile("path/to/my-nested-template.json")
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:32.428Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloudformation_include.CfnIncludeProps")
@software.amazon.jsii.Jsii.Proxy(CfnIncludeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIncludeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Path to the template file.
     * <p>
     * Both JSON and YAML template formats are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile();

    /**
     * Specifies whether to allow cyclical references, effectively disregarding safeguards meant to avoid undeployable templates.
     * <p>
     * This should only be set to true in the case of templates utilizing cloud transforms (e.g. SAM) that
     * after processing the transform will no longer contain any circular references.
     * <p>
     * Default: - will throw an error on detecting any cyclical references
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowCyclicalReferences() {
        return null;
    }

    /**
     * Specifies a list of LogicalIDs for resources that will be included in the CDK Stack, but will not be parsed and converted to CDK types.
     * <p>
     * This allows you to use CFN templates
     * that rely on Intrinsic placement that <code>cfn-include</code>
     * would otherwise reject, such as non-primitive values in resource update policies.
     * <p>
     * Default: - All resources are hydrated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDehydratedResources() {
        return null;
    }

    /**
     * Specifies the template files that define nested stacks that should be included.
     * <p>
     * If your template specifies a stack that isn't included here, it won't be created as a NestedStack
     * resource, and it won't be accessible from the <code>CfnInclude.getNestedStack</code> method
     * (but will still be accessible from the <code>CfnInclude.getResource</code> method).
     * <p>
     * If you include a stack here with an ID that isn't in the template,
     * or is in the template but is not a nested stack,
     * template creation will fail and an error will be thrown.
     * <p>
     * Default: - no nested stacks will be included
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps> getLoadNestedStacks() {
        return null;
    }

    /**
     * Specifies parameters to be replaced by the values in this mapping.
     * <p>
     * Any parameters in the template that aren't specified here will be left unmodified.
     * If you include a parameter here with an ID that isn't in the template,
     * template creation will fail and an error will be thrown.
     * <p>
     * If you are importing a parameter from a live stack, we cannot know the value of that
     * parameter. You will need to supply a value for your parameters, else the default
     * value will be used.
     * <p>
     * Default: - parameters will retain their original definitions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return null;
    }

    /**
     * Whether the resources should have the same logical IDs in the resulting CDK template as they did in the original CloudFormation template file.
     * <p>
     * If you're vending a Construct using an existing CloudFormation template,
     * make sure to pass this as <code>false</code>.
     * <p>
     * <strong>Note</strong>: regardless of whether this option is true or false,
     * the <code>CfnInclude.getResource</code> and related methods always uses the original logical ID of the resource/element,
     * as specified in the template file.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreserveLogicalIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIncludeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIncludeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIncludeProps> {
        java.lang.String templateFile;
        java.lang.Boolean allowCyclicalReferences;
        java.util.List<java.lang.String> dehydratedResources;
        java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps> loadNestedStacks;
        java.util.Map<java.lang.String, java.lang.Object> parameters;
        java.lang.Boolean preserveLogicalIds;

        /**
         * Sets the value of {@link CfnIncludeProps#getTemplateFile}
         * @param templateFile Path to the template file. This parameter is required.
         *                     Both JSON and YAML template formats are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateFile(java.lang.String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        /**
         * Sets the value of {@link CfnIncludeProps#getAllowCyclicalReferences}
         * @param allowCyclicalReferences Specifies whether to allow cyclical references, effectively disregarding safeguards meant to avoid undeployable templates.
         *                                This should only be set to true in the case of templates utilizing cloud transforms (e.g. SAM) that
         *                                after processing the transform will no longer contain any circular references.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowCyclicalReferences(java.lang.Boolean allowCyclicalReferences) {
            this.allowCyclicalReferences = allowCyclicalReferences;
            return this;
        }

        /**
         * Sets the value of {@link CfnIncludeProps#getDehydratedResources}
         * @param dehydratedResources Specifies a list of LogicalIDs for resources that will be included in the CDK Stack, but will not be parsed and converted to CDK types.
         *                            This allows you to use CFN templates
         *                            that rely on Intrinsic placement that <code>cfn-include</code>
         *                            would otherwise reject, such as non-primitive values in resource update policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dehydratedResources(java.util.List<java.lang.String> dehydratedResources) {
            this.dehydratedResources = dehydratedResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnIncludeProps#getLoadNestedStacks}
         * @param loadNestedStacks Specifies the template files that define nested stacks that should be included.
         *                         If your template specifies a stack that isn't included here, it won't be created as a NestedStack
         *                         resource, and it won't be accessible from the <code>CfnInclude.getNestedStack</code> method
         *                         (but will still be accessible from the <code>CfnInclude.getResource</code> method).
         *                         <p>
         *                         If you include a stack here with an ID that isn't in the template,
         *                         or is in the template but is not a nested stack,
         *                         template creation will fail and an error will be thrown.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder loadNestedStacks(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.cloudformation.include.CfnIncludeProps> loadNestedStacks) {
            this.loadNestedStacks = (java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps>)loadNestedStacks;
            return this;
        }

        /**
         * Sets the value of {@link CfnIncludeProps#getParameters}
         * @param parameters Specifies parameters to be replaced by the values in this mapping.
         *                   Any parameters in the template that aren't specified here will be left unmodified.
         *                   If you include a parameter here with an ID that isn't in the template,
         *                   template creation will fail and an error will be thrown.
         *                   <p>
         *                   If you are importing a parameter from a live stack, we cannot know the value of that
         *                   parameter. You will need to supply a value for your parameters, else the default
         *                   value will be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnIncludeProps#getPreserveLogicalIds}
         * @param preserveLogicalIds Whether the resources should have the same logical IDs in the resulting CDK template as they did in the original CloudFormation template file.
         *                           If you're vending a Construct using an existing CloudFormation template,
         *                           make sure to pass this as <code>false</code>.
         *                           <p>
         *                           <strong>Note</strong>: regardless of whether this option is true or false,
         *                           the <code>CfnInclude.getResource</code> and related methods always uses the original logical ID of the resource/element,
         *                           as specified in the template file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveLogicalIds(java.lang.Boolean preserveLogicalIds) {
            this.preserveLogicalIds = preserveLogicalIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIncludeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIncludeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIncludeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIncludeProps {
        private final java.lang.String templateFile;
        private final java.lang.Boolean allowCyclicalReferences;
        private final java.util.List<java.lang.String> dehydratedResources;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps> loadNestedStacks;
        private final java.util.Map<java.lang.String, java.lang.Object> parameters;
        private final java.lang.Boolean preserveLogicalIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.templateFile = software.amazon.jsii.Kernel.get(this, "templateFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowCyclicalReferences = software.amazon.jsii.Kernel.get(this, "allowCyclicalReferences", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dehydratedResources = software.amazon.jsii.Kernel.get(this, "dehydratedResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.loadNestedStacks = software.amazon.jsii.Kernel.get(this, "loadNestedStacks", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudformation.include.CfnIncludeProps.class)));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.preserveLogicalIds = software.amazon.jsii.Kernel.get(this, "preserveLogicalIds", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.templateFile = java.util.Objects.requireNonNull(builder.templateFile, "templateFile is required");
            this.allowCyclicalReferences = builder.allowCyclicalReferences;
            this.dehydratedResources = builder.dehydratedResources;
            this.loadNestedStacks = (java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps>)builder.loadNestedStacks;
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.parameters;
            this.preserveLogicalIds = builder.preserveLogicalIds;
        }

        @Override
        public final java.lang.String getTemplateFile() {
            return this.templateFile;
        }

        @Override
        public final java.lang.Boolean getAllowCyclicalReferences() {
            return this.allowCyclicalReferences;
        }

        @Override
        public final java.util.List<java.lang.String> getDehydratedResources() {
            return this.dehydratedResources;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps> getLoadNestedStacks() {
            return this.loadNestedStacks;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Boolean getPreserveLogicalIds() {
            return this.preserveLogicalIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("templateFile", om.valueToTree(this.getTemplateFile()));
            if (this.getAllowCyclicalReferences() != null) {
                data.set("allowCyclicalReferences", om.valueToTree(this.getAllowCyclicalReferences()));
            }
            if (this.getDehydratedResources() != null) {
                data.set("dehydratedResources", om.valueToTree(this.getDehydratedResources()));
            }
            if (this.getLoadNestedStacks() != null) {
                data.set("loadNestedStacks", om.valueToTree(this.getLoadNestedStacks()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPreserveLogicalIds() != null) {
                data.set("preserveLogicalIds", om.valueToTree(this.getPreserveLogicalIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloudformation_include.CfnIncludeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIncludeProps.Jsii$Proxy that = (CfnIncludeProps.Jsii$Proxy) o;

            if (!templateFile.equals(that.templateFile)) return false;
            if (this.allowCyclicalReferences != null ? !this.allowCyclicalReferences.equals(that.allowCyclicalReferences) : that.allowCyclicalReferences != null) return false;
            if (this.dehydratedResources != null ? !this.dehydratedResources.equals(that.dehydratedResources) : that.dehydratedResources != null) return false;
            if (this.loadNestedStacks != null ? !this.loadNestedStacks.equals(that.loadNestedStacks) : that.loadNestedStacks != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            return this.preserveLogicalIds != null ? this.preserveLogicalIds.equals(that.preserveLogicalIds) : that.preserveLogicalIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.templateFile.hashCode();
            result = 31 * result + (this.allowCyclicalReferences != null ? this.allowCyclicalReferences.hashCode() : 0);
            result = 31 * result + (this.dehydratedResources != null ? this.dehydratedResources.hashCode() : 0);
            result = 31 * result + (this.loadNestedStacks != null ? this.loadNestedStacks.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.preserveLogicalIds != null ? this.preserveLogicalIds.hashCode() : 0);
            return result;
        }
    }
}
