package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaIntegration integration;
 * RestApi api = new RestApi(this, "hello-api");
 * Resource v1 = api.root.addResource("v1");
 * Resource echo = v1.addResource("echo");
 * Method echoMethod = echo.addMethod("GET", integration, MethodOptions.builder().apiKeyRequired(true).build());
 * UsagePlan plan = api.addUsagePlan("UsagePlan", UsagePlanProps.builder()
 *         .name("Easy")
 *         .throttle(ThrottleSettings.builder()
 *                 .rateLimit(10)
 *                 .burstLimit(2)
 *                 .build())
 *         .build());
 * IApiKey key = api.addApiKey("ApiKey");
 * plan.addApiKey(key);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:16.725Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.Method")
public class Method extends software.amazon.awscdk.Resource {

    protected Method(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Method(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Method(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.MethodProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a method response to this method.
     * <p>
     * You should only add one method reponse for every status code. The API allows it
     * for historical reasons, but will add a warning if this happens. If you do, your Method
     * will nondeterministically use one of the responses, and ignore the rest.
     * <p>
     * @param methodResponse This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMethodResponse(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.MethodResponse methodResponse) {
        software.amazon.jsii.Kernel.call(this, "addMethodResponse", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(methodResponse, "methodResponse is required") });
    }

    /**
     * Grants an IAM principal permission to invoke this method.
     * <p>
     * @param grantee the principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantExecute(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantExecute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Returns the given named metric for this API method.
     * <p>
     * @param metricName This parameter is required.
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * Returns the given named metric for this API method.
     * <p>
     * @param metricName This parameter is required.
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * Metric for the number of requests served from the API cache in a given period.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheHitCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCacheHitCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * Metric for the number of requests served from the API cache in a given period.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheHitCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage) {
        return software.amazon.jsii.Kernel.call(this, "metricCacheHitCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * Metric for the number of requests served from the backend in a given period, when API caching is enabled.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheMissCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCacheMissCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * Metric for the number of requests served from the backend in a given period, when API caching is enabled.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheMissCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage) {
        return software.amazon.jsii.Kernel.call(this, "metricCacheMissCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * Metric for the number of client-side errors captured in a given period.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientError(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricClientError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * Metric for the number of client-side errors captured in a given period.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientError(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage) {
        return software.amazon.jsii.Kernel.call(this, "metricClientError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * Metric for the total number API requests in a given period.
     * <p>
     * Default: - sample count over 5 minutes
     * <p>
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * Metric for the total number API requests in a given period.
     * <p>
     * Default: - sample count over 5 minutes
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage) {
        return software.amazon.jsii.Kernel.call(this, "metricCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     * <p>
     * Default: - average over 5 minutes.
     * <p>
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIntegrationLatency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIntegrationLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     * <p>
     * Default: - average over 5 minutes.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIntegrationLatency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage) {
        return software.amazon.jsii.Kernel.call(this, "metricIntegrationLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * The time between when API Gateway receives a request from a client and when it returns a response to the client.
     * <p>
     * The latency includes the integration latency and other API Gateway overhead.
     * <p>
     * Default: - average over 5 minutes.
     * <p>
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLatency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * The time between when API Gateway receives a request from a client and when it returns a response to the client.
     * <p>
     * The latency includes the integration latency and other API Gateway overhead.
     * <p>
     * Default: - average over 5 minutes.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLatency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage) {
        return software.amazon.jsii.Kernel.call(this, "metricLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * Metric for the number of server-side errors captured in a given period.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param stage This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricServerError(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricServerError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), props });
    }

    /**
     * Metric for the number of server-side errors captured in a given period.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricServerError(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage stage) {
        return software.amazon.jsii.Kernel.call(this, "metricServerError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * The API Gateway RestApi associated with this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi getApi() {
        return software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHttpMethod() {
        return software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns an execute-api ARN for this method:.
     * <p>
     * arn:aws:execute-api:{region}:{account}:{restApiId}/{stage}/{method}/{path}
     * <p>
     * NOTE: {stage} will refer to the <code>restApi.deploymentStage</code>, which will
     * automatically set if auto-deploy is enabled, or can be explicitly assigned.
     * When not configured, {stage} will be set to '*', as a shorthand for 'all stages'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMethodArn() {
        return software.amazon.jsii.Kernel.get(this, "methodArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMethodId() {
        return software.amazon.jsii.Kernel.get(this, "methodId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IResource getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IResource.class));
    }

    /**
     * Returns an execute-api ARN for this method's "test-invoke-stage" stage.
     * <p>
     * This stage is used by the AWS Console UI when testing the method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTestMethodArn() {
        return software.amazon.jsii.Kernel.get(this, "testMethodArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.Method}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.Method> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.MethodProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.MethodProps.Builder();
        }

        /**
         * The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method.
         * <p>
         * @return {@code this}
         * @param httpMethod The HTTP method ("GET", "POST", "PUT", ...) that clients use to call this method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(final java.lang.String httpMethod) {
            this.props.httpMethod(httpMethod);
            return this;
        }

        /**
         * The resource this method is associated with.
         * <p>
         * For root resource methods,
         * specify the <code>RestApi</code> object.
         * <p>
         * @return {@code this}
         * @param resource The resource this method is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(final software.amazon.awscdk.services.apigateway.IResource resource) {
            this.props.resource(resource);
            return this;
        }

        /**
         * The backend system that the method calls when it receives a request.
         * <p>
         * Default: - a new `MockIntegration`.
         * <p>
         * @return {@code this}
         * @param integration The backend system that the method calls when it receives a request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(final software.amazon.awscdk.services.apigateway.Integration integration) {
            this.props.integration(integration);
            return this;
        }

        /**
         * Method options.
         * <p>
         * Default: - No options.
         * <p>
         * @return {@code this}
         * @param options Method options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.services.apigateway.MethodOptions options) {
            this.props.options(options);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigateway.Method}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.Method build() {
            return new software.amazon.awscdk.services.apigateway.Method(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
