package software.amazon.awscdk.services.apigateway;

/**
 * Configure what must be included in the <code>requestContext</code>.
 * <p>
 * More details can be found at mapping templates documentation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * StepFunctionsRestApi.Builder.create(this, "StepFunctionsRestApi")
 *         .stateMachine(machine)
 *         .headers(true)
 *         .path(false)
 *         .querystring(false)
 *         .authorizer(false)
 *         .requestContext(RequestContext.builder()
 *                 .caller(true)
 *                 .user(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:16.754Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.RequestContext")
@software.amazon.jsii.Jsii.Proxy(RequestContext.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RequestContext extends software.amazon.jsii.JsiiSerializable {

    /**
     * Represents the information of $context.identity.accountId.
     * <p>
     * Whether the AWS account of the API owner should be included in the request context
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAccountId() {
        return null;
    }

    /**
     * Represents the information of $context.apiId.
     * <p>
     * Whether the identifier API Gateway assigns to your API should be included in the request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getApiId() {
        return null;
    }

    /**
     * Represents the information of $context.identity.apiKey.
     * <p>
     * Whether the API key associated with the request should be included in request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getApiKey() {
        return null;
    }

    /**
     * Represents the information of $context.authorizer.principalId.
     * <p>
     * Whether the principal user identifier associated with the token sent by the client and returned
     * from an API Gateway Lambda authorizer should be included in the request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAuthorizerPrincipalId() {
        return null;
    }

    /**
     * Represents the information of $context.identity.caller.
     * <p>
     * Whether the principal identifier of the caller that signed the request should be included in the request context.
     * Supported for resources that use IAM authorization.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCaller() {
        return null;
    }

    /**
     * Represents the information of $context.identity.cognitoAuthenticationProvider.
     * <p>
     * Whether the list of the Amazon Cognito authentication providers used by the caller making the request should be included in the request context.
     * Available only if the request was signed with Amazon Cognito credentials.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCognitoAuthenticationProvider() {
        return null;
    }

    /**
     * Represents the information of $context.identity.cognitoAuthenticationType.
     * <p>
     * Whether the Amazon Cognito authentication type of the caller making the request should be included in the request context.
     * Available only if the request was signed with Amazon Cognito credentials.
     * Possible values include authenticated for authenticated identities and unauthenticated for unauthenticated identities.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCognitoAuthenticationType() {
        return null;
    }

    /**
     * Represents the information of $context.identity.cognitoIdentityId.
     * <p>
     * Whether the Amazon Cognito identity ID of the caller making the request should be included in the request context.
     * Available only if the request was signed with Amazon Cognito credentials.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCognitoIdentityId() {
        return null;
    }

    /**
     * Represents the information of $context.identity.cognitoIdentityPoolId.
     * <p>
     * Whether the Amazon Cognito identity pool ID of the caller making the request should be included in the request context.
     * Available only if the request was signed with Amazon Cognito credentials.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCognitoIdentityPoolId() {
        return null;
    }

    /**
     * Represents the information of $context.httpMethod.
     * <p>
     * Whether the HTTP method used should be included in the request context.
     * Valid values include: DELETE, GET, HEAD, OPTIONS, PATCH, POST, and PUT.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHttpMethod() {
        return null;
    }

    /**
     * Represents the information of $context.requestId.
     * <p>
     * Whether the ID for the request should be included in the request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequestId() {
        return null;
    }

    /**
     * Represents the information of $context.resourceId.
     * <p>
     * Whether the identifier that API Gateway assigns to your resource should be included in the request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getResourceId() {
        return null;
    }

    /**
     * Represents the information of $context.resourcePath.
     * <p>
     * Whether the path to the resource should be included in the request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getResourcePath() {
        return null;
    }

    /**
     * Represents the information of $context.identity.sourceIp.
     * <p>
     * Whether the source IP address of the immediate TCP connection making the request
     * to API Gateway endpoint should be included in the request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSourceIp() {
        return null;
    }

    /**
     * Represents the information of $context.stage.
     * <p>
     * Whether the deployment stage of the API request should be included in the request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStage() {
        return null;
    }

    /**
     * Represents the information of $context.identity.user.
     * <p>
     * Whether the principal identifier of the user that will be authorized should be included in the request context.
     * Supported for resources that use IAM authorization.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUser() {
        return null;
    }

    /**
     * Represents the information of $context.identity.userAgent.
     * <p>
     * Whether the User-Agent header of the API caller should be included in the request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUserAgent() {
        return null;
    }

    /**
     * Represents the information of $context.identity.userArn.
     * <p>
     * Whether the Amazon Resource Name (ARN) of the effective user identified after authentication should be included in the request context.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUserArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RequestContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RequestContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RequestContext> {
        java.lang.Boolean accountId;
        java.lang.Boolean apiId;
        java.lang.Boolean apiKey;
        java.lang.Boolean authorizerPrincipalId;
        java.lang.Boolean caller;
        java.lang.Boolean cognitoAuthenticationProvider;
        java.lang.Boolean cognitoAuthenticationType;
        java.lang.Boolean cognitoIdentityId;
        java.lang.Boolean cognitoIdentityPoolId;
        java.lang.Boolean httpMethod;
        java.lang.Boolean requestId;
        java.lang.Boolean resourceId;
        java.lang.Boolean resourcePath;
        java.lang.Boolean sourceIp;
        java.lang.Boolean stage;
        java.lang.Boolean user;
        java.lang.Boolean userAgent;
        java.lang.Boolean userArn;

        /**
         * Sets the value of {@link RequestContext#getAccountId}
         * @param accountId Represents the information of $context.identity.accountId.
         *                  Whether the AWS account of the API owner should be included in the request context
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountId(java.lang.Boolean accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getApiId}
         * @param apiId Represents the information of $context.apiId.
         *              Whether the identifier API Gateway assigns to your API should be included in the request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.Boolean apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getApiKey}
         * @param apiKey Represents the information of $context.identity.apiKey.
         *               Whether the API key associated with the request should be included in request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKey(java.lang.Boolean apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getAuthorizerPrincipalId}
         * @param authorizerPrincipalId Represents the information of $context.authorizer.principalId.
         *                              Whether the principal user identifier associated with the token sent by the client and returned
         *                              from an API Gateway Lambda authorizer should be included in the request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerPrincipalId(java.lang.Boolean authorizerPrincipalId) {
            this.authorizerPrincipalId = authorizerPrincipalId;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getCaller}
         * @param caller Represents the information of $context.identity.caller.
         *               Whether the principal identifier of the caller that signed the request should be included in the request context.
         *               Supported for resources that use IAM authorization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caller(java.lang.Boolean caller) {
            this.caller = caller;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getCognitoAuthenticationProvider}
         * @param cognitoAuthenticationProvider Represents the information of $context.identity.cognitoAuthenticationProvider.
         *                                      Whether the list of the Amazon Cognito authentication providers used by the caller making the request should be included in the request context.
         *                                      Available only if the request was signed with Amazon Cognito credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoAuthenticationProvider(java.lang.Boolean cognitoAuthenticationProvider) {
            this.cognitoAuthenticationProvider = cognitoAuthenticationProvider;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getCognitoAuthenticationType}
         * @param cognitoAuthenticationType Represents the information of $context.identity.cognitoAuthenticationType.
         *                                  Whether the Amazon Cognito authentication type of the caller making the request should be included in the request context.
         *                                  Available only if the request was signed with Amazon Cognito credentials.
         *                                  Possible values include authenticated for authenticated identities and unauthenticated for unauthenticated identities.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoAuthenticationType(java.lang.Boolean cognitoAuthenticationType) {
            this.cognitoAuthenticationType = cognitoAuthenticationType;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getCognitoIdentityId}
         * @param cognitoIdentityId Represents the information of $context.identity.cognitoIdentityId.
         *                          Whether the Amazon Cognito identity ID of the caller making the request should be included in the request context.
         *                          Available only if the request was signed with Amazon Cognito credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoIdentityId(java.lang.Boolean cognitoIdentityId) {
            this.cognitoIdentityId = cognitoIdentityId;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getCognitoIdentityPoolId}
         * @param cognitoIdentityPoolId Represents the information of $context.identity.cognitoIdentityPoolId.
         *                              Whether the Amazon Cognito identity pool ID of the caller making the request should be included in the request context.
         *                              Available only if the request was signed with Amazon Cognito credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoIdentityPoolId(java.lang.Boolean cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getHttpMethod}
         * @param httpMethod Represents the information of $context.httpMethod.
         *                   Whether the HTTP method used should be included in the request context.
         *                   Valid values include: DELETE, GET, HEAD, OPTIONS, PATCH, POST, and PUT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(java.lang.Boolean httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getRequestId}
         * @param requestId Represents the information of $context.requestId.
         *                  Whether the ID for the request should be included in the request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestId(java.lang.Boolean requestId) {
            this.requestId = requestId;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getResourceId}
         * @param resourceId Represents the information of $context.resourceId.
         *                   Whether the identifier that API Gateway assigns to your resource should be included in the request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.Boolean resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getResourcePath}
         * @param resourcePath Represents the information of $context.resourcePath.
         *                     Whether the path to the resource should be included in the request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePath(java.lang.Boolean resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getSourceIp}
         * @param sourceIp Represents the information of $context.identity.sourceIp.
         *                 Whether the source IP address of the immediate TCP connection making the request
         *                 to API Gateway endpoint should be included in the request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceIp(java.lang.Boolean sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getStage}
         * @param stage Represents the information of $context.stage.
         *              Whether the deployment stage of the API request should be included in the request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(java.lang.Boolean stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getUser}
         * @param user Represents the information of $context.identity.user.
         *             Whether the principal identifier of the user that will be authorized should be included in the request context.
         *             Supported for resources that use IAM authorization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.Boolean user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getUserAgent}
         * @param userAgent Represents the information of $context.identity.userAgent.
         *                  Whether the User-Agent header of the API caller should be included in the request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAgent(java.lang.Boolean userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        /**
         * Sets the value of {@link RequestContext#getUserArn}
         * @param userArn Represents the information of $context.identity.userArn.
         *                Whether the Amazon Resource Name (ARN) of the effective user identified after authentication should be included in the request context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userArn(java.lang.Boolean userArn) {
            this.userArn = userArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RequestContext}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RequestContext build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RequestContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestContext {
        private final java.lang.Boolean accountId;
        private final java.lang.Boolean apiId;
        private final java.lang.Boolean apiKey;
        private final java.lang.Boolean authorizerPrincipalId;
        private final java.lang.Boolean caller;
        private final java.lang.Boolean cognitoAuthenticationProvider;
        private final java.lang.Boolean cognitoAuthenticationType;
        private final java.lang.Boolean cognitoIdentityId;
        private final java.lang.Boolean cognitoIdentityPoolId;
        private final java.lang.Boolean httpMethod;
        private final java.lang.Boolean requestId;
        private final java.lang.Boolean resourceId;
        private final java.lang.Boolean resourcePath;
        private final java.lang.Boolean sourceIp;
        private final java.lang.Boolean stage;
        private final java.lang.Boolean user;
        private final java.lang.Boolean userAgent;
        private final java.lang.Boolean userArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.apiKey = software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.authorizerPrincipalId = software.amazon.jsii.Kernel.get(this, "authorizerPrincipalId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.caller = software.amazon.jsii.Kernel.get(this, "caller", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cognitoAuthenticationProvider = software.amazon.jsii.Kernel.get(this, "cognitoAuthenticationProvider", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cognitoAuthenticationType = software.amazon.jsii.Kernel.get(this, "cognitoAuthenticationType", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cognitoIdentityId = software.amazon.jsii.Kernel.get(this, "cognitoIdentityId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cognitoIdentityPoolId = software.amazon.jsii.Kernel.get(this, "cognitoIdentityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.requestId = software.amazon.jsii.Kernel.get(this, "requestId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.resourcePath = software.amazon.jsii.Kernel.get(this, "resourcePath", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sourceIp = software.amazon.jsii.Kernel.get(this, "sourceIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.userAgent = software.amazon.jsii.Kernel.get(this, "userAgent", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.userArn = software.amazon.jsii.Kernel.get(this, "userArn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountId = builder.accountId;
            this.apiId = builder.apiId;
            this.apiKey = builder.apiKey;
            this.authorizerPrincipalId = builder.authorizerPrincipalId;
            this.caller = builder.caller;
            this.cognitoAuthenticationProvider = builder.cognitoAuthenticationProvider;
            this.cognitoAuthenticationType = builder.cognitoAuthenticationType;
            this.cognitoIdentityId = builder.cognitoIdentityId;
            this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
            this.httpMethod = builder.httpMethod;
            this.requestId = builder.requestId;
            this.resourceId = builder.resourceId;
            this.resourcePath = builder.resourcePath;
            this.sourceIp = builder.sourceIp;
            this.stage = builder.stage;
            this.user = builder.user;
            this.userAgent = builder.userAgent;
            this.userArn = builder.userArn;
        }

        @Override
        public final java.lang.Boolean getAccountId() {
            return this.accountId;
        }

        @Override
        public final java.lang.Boolean getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.Boolean getApiKey() {
            return this.apiKey;
        }

        @Override
        public final java.lang.Boolean getAuthorizerPrincipalId() {
            return this.authorizerPrincipalId;
        }

        @Override
        public final java.lang.Boolean getCaller() {
            return this.caller;
        }

        @Override
        public final java.lang.Boolean getCognitoAuthenticationProvider() {
            return this.cognitoAuthenticationProvider;
        }

        @Override
        public final java.lang.Boolean getCognitoAuthenticationType() {
            return this.cognitoAuthenticationType;
        }

        @Override
        public final java.lang.Boolean getCognitoIdentityId() {
            return this.cognitoIdentityId;
        }

        @Override
        public final java.lang.Boolean getCognitoIdentityPoolId() {
            return this.cognitoIdentityPoolId;
        }

        @Override
        public final java.lang.Boolean getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final java.lang.Boolean getRequestId() {
            return this.requestId;
        }

        @Override
        public final java.lang.Boolean getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.Boolean getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public final java.lang.Boolean getSourceIp() {
            return this.sourceIp;
        }

        @Override
        public final java.lang.Boolean getStage() {
            return this.stage;
        }

        @Override
        public final java.lang.Boolean getUser() {
            return this.user;
        }

        @Override
        public final java.lang.Boolean getUserAgent() {
            return this.userAgent;
        }

        @Override
        public final java.lang.Boolean getUserArn() {
            return this.userArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccountId() != null) {
                data.set("accountId", om.valueToTree(this.getAccountId()));
            }
            if (this.getApiId() != null) {
                data.set("apiId", om.valueToTree(this.getApiId()));
            }
            if (this.getApiKey() != null) {
                data.set("apiKey", om.valueToTree(this.getApiKey()));
            }
            if (this.getAuthorizerPrincipalId() != null) {
                data.set("authorizerPrincipalId", om.valueToTree(this.getAuthorizerPrincipalId()));
            }
            if (this.getCaller() != null) {
                data.set("caller", om.valueToTree(this.getCaller()));
            }
            if (this.getCognitoAuthenticationProvider() != null) {
                data.set("cognitoAuthenticationProvider", om.valueToTree(this.getCognitoAuthenticationProvider()));
            }
            if (this.getCognitoAuthenticationType() != null) {
                data.set("cognitoAuthenticationType", om.valueToTree(this.getCognitoAuthenticationType()));
            }
            if (this.getCognitoIdentityId() != null) {
                data.set("cognitoIdentityId", om.valueToTree(this.getCognitoIdentityId()));
            }
            if (this.getCognitoIdentityPoolId() != null) {
                data.set("cognitoIdentityPoolId", om.valueToTree(this.getCognitoIdentityPoolId()));
            }
            if (this.getHttpMethod() != null) {
                data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
            }
            if (this.getRequestId() != null) {
                data.set("requestId", om.valueToTree(this.getRequestId()));
            }
            if (this.getResourceId() != null) {
                data.set("resourceId", om.valueToTree(this.getResourceId()));
            }
            if (this.getResourcePath() != null) {
                data.set("resourcePath", om.valueToTree(this.getResourcePath()));
            }
            if (this.getSourceIp() != null) {
                data.set("sourceIp", om.valueToTree(this.getSourceIp()));
            }
            if (this.getStage() != null) {
                data.set("stage", om.valueToTree(this.getStage()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getUserAgent() != null) {
                data.set("userAgent", om.valueToTree(this.getUserAgent()));
            }
            if (this.getUserArn() != null) {
                data.set("userArn", om.valueToTree(this.getUserArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.RequestContext"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RequestContext.Jsii$Proxy that = (RequestContext.Jsii$Proxy) o;

            if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) return false;
            if (this.apiId != null ? !this.apiId.equals(that.apiId) : that.apiId != null) return false;
            if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) return false;
            if (this.authorizerPrincipalId != null ? !this.authorizerPrincipalId.equals(that.authorizerPrincipalId) : that.authorizerPrincipalId != null) return false;
            if (this.caller != null ? !this.caller.equals(that.caller) : that.caller != null) return false;
            if (this.cognitoAuthenticationProvider != null ? !this.cognitoAuthenticationProvider.equals(that.cognitoAuthenticationProvider) : that.cognitoAuthenticationProvider != null) return false;
            if (this.cognitoAuthenticationType != null ? !this.cognitoAuthenticationType.equals(that.cognitoAuthenticationType) : that.cognitoAuthenticationType != null) return false;
            if (this.cognitoIdentityId != null ? !this.cognitoIdentityId.equals(that.cognitoIdentityId) : that.cognitoIdentityId != null) return false;
            if (this.cognitoIdentityPoolId != null ? !this.cognitoIdentityPoolId.equals(that.cognitoIdentityPoolId) : that.cognitoIdentityPoolId != null) return false;
            if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
            if (this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null) return false;
            if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
            if (this.resourcePath != null ? !this.resourcePath.equals(that.resourcePath) : that.resourcePath != null) return false;
            if (this.sourceIp != null ? !this.sourceIp.equals(that.sourceIp) : that.sourceIp != null) return false;
            if (this.stage != null ? !this.stage.equals(that.stage) : that.stage != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            if (this.userAgent != null ? !this.userAgent.equals(that.userAgent) : that.userAgent != null) return false;
            return this.userArn != null ? this.userArn.equals(that.userArn) : that.userArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountId != null ? this.accountId.hashCode() : 0;
            result = 31 * result + (this.apiId != null ? this.apiId.hashCode() : 0);
            result = 31 * result + (this.apiKey != null ? this.apiKey.hashCode() : 0);
            result = 31 * result + (this.authorizerPrincipalId != null ? this.authorizerPrincipalId.hashCode() : 0);
            result = 31 * result + (this.caller != null ? this.caller.hashCode() : 0);
            result = 31 * result + (this.cognitoAuthenticationProvider != null ? this.cognitoAuthenticationProvider.hashCode() : 0);
            result = 31 * result + (this.cognitoAuthenticationType != null ? this.cognitoAuthenticationType.hashCode() : 0);
            result = 31 * result + (this.cognitoIdentityId != null ? this.cognitoIdentityId.hashCode() : 0);
            result = 31 * result + (this.cognitoIdentityPoolId != null ? this.cognitoIdentityPoolId.hashCode() : 0);
            result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
            result = 31 * result + (this.requestId != null ? this.requestId.hashCode() : 0);
            result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
            result = 31 * result + (this.resourcePath != null ? this.resourcePath.hashCode() : 0);
            result = 31 * result + (this.sourceIp != null ? this.sourceIp.hashCode() : 0);
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
            result = 31 * result + (this.userArn != null ? this.userArn.hashCode() : 0);
            return result;
        }
    }
}
