package software.amazon.awscdk.services.apigatewayv2;

/**
 * Options used when configuring multiple routes, at once.
 * <p>
 * The options here are the ones that would be configured for all being set up.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpRouteIntegration httpRouteIntegration;
 * BatchHttpRouteOptions batchHttpRouteOptions = BatchHttpRouteOptions.builder()
 *         .integration(httpRouteIntegration)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:16.813Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.BatchHttpRouteOptions")
@software.amazon.jsii.Jsii.Proxy(BatchHttpRouteOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BatchHttpRouteOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The integration to be configured on this route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration getIntegration();

    /**
     * @return a {@link Builder} of {@link BatchHttpRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BatchHttpRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BatchHttpRouteOptions> {
        software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration;

        /**
         * Sets the value of {@link BatchHttpRouteOptions#getIntegration}
         * @param integration The integration to be configured on this route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BatchHttpRouteOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BatchHttpRouteOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BatchHttpRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchHttpRouteOptions {
        private final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.integration = software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.integration = java.util.Objects.requireNonNull(builder.integration, "integration is required");
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration getIntegration() {
            return this.integration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("integration", om.valueToTree(this.getIntegration()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.BatchHttpRouteOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BatchHttpRouteOptions.Jsii$Proxy that = (BatchHttpRouteOptions.Jsii$Proxy) o;

            return this.integration.equals(that.integration);
        }

        @Override
        public final int hashCode() {
            int result = this.integration.hashCode();
            return result;
        }
    }
}
