package software.amazon.awscdk.services.apigatewayv2;

/**
 * properties for creating a domain name endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * import software.amazon.awscdk.services.certificatemanager.*;
 * Certificate certificate;
 * EndpointOptions endpointOptions = EndpointOptions.builder()
 *         .certificate(certificate)
 *         // the properties below are optional
 *         .certificateName("certificateName")
 *         .endpointType(EndpointType.EDGE)
 *         .ownershipCertificate(certificate)
 *         .securityPolicy(SecurityPolicy.TLS_1_0)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:16.872Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.EndpointOptions")
@software.amazon.jsii.Jsii.Proxy(EndpointOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EndpointOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ACM certificate for this domain name.
     * <p>
     * Certificate can be both ACM issued or imported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate();

    /**
     * The user-friendly name of the certificate that will be used by the endpoint for this domain name.
     * <p>
     * Default: - No friendly certificate name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateName() {
        return null;
    }

    /**
     * The type of endpoint for this DomainName.
     * <p>
     * Default: EndpointType.REGIONAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.EndpointType getEndpointType() {
        return null;
    }

    /**
     * A public certificate issued by ACM to validate that you own a custom domain.
     * <p>
     * This parameter is required
     * only when you configure mutual TLS authentication and you specify an ACM imported or private CA certificate
     * for <code>certificate</code>. The ownership certificate validates that you have permissions to use the domain name.
     * <p>
     * Default: - only required when configuring mTLS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ICertificate getOwnershipCertificate() {
        return null;
    }

    /**
     * The Transport Layer Security (TLS) version + cipher suite for this domain name.
     * <p>
     * Default: SecurityPolicy.TLS_1_2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.SecurityPolicy getSecurityPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EndpointOptions> {
        software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        java.lang.String certificateName;
        software.amazon.awscdk.services.apigatewayv2.EndpointType endpointType;
        software.amazon.awscdk.services.certificatemanager.ICertificate ownershipCertificate;
        software.amazon.awscdk.services.apigatewayv2.SecurityPolicy securityPolicy;

        /**
         * Sets the value of {@link EndpointOptions#getCertificate}
         * @param certificate The ACM certificate for this domain name. This parameter is required.
         *                    Certificate can be both ACM issued or imported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link EndpointOptions#getCertificateName}
         * @param certificateName The user-friendly name of the certificate that will be used by the endpoint for this domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(java.lang.String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        /**
         * Sets the value of {@link EndpointOptions#getEndpointType}
         * @param endpointType The type of endpoint for this DomainName.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(software.amazon.awscdk.services.apigatewayv2.EndpointType endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        /**
         * Sets the value of {@link EndpointOptions#getOwnershipCertificate}
         * @param ownershipCertificate A public certificate issued by ACM to validate that you own a custom domain.
         *                             This parameter is required
         *                             only when you configure mutual TLS authentication and you specify an ACM imported or private CA certificate
         *                             for <code>certificate</code>. The ownership certificate validates that you have permissions to use the domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipCertificate(software.amazon.awscdk.services.certificatemanager.ICertificate ownershipCertificate) {
            this.ownershipCertificate = ownershipCertificate;
            return this;
        }

        /**
         * Sets the value of {@link EndpointOptions#getSecurityPolicy}
         * @param securityPolicy The Transport Layer Security (TLS) version + cipher suite for this domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicy(software.amazon.awscdk.services.apigatewayv2.SecurityPolicy securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EndpointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EndpointOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointOptions {
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.String certificateName;
        private final software.amazon.awscdk.services.apigatewayv2.EndpointType endpointType;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate ownershipCertificate;
        private final software.amazon.awscdk.services.apigatewayv2.SecurityPolicy securityPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.certificateName = software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointType = software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.EndpointType.class));
            this.ownershipCertificate = software.amazon.jsii.Kernel.get(this, "ownershipCertificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.securityPolicy = software.amazon.jsii.Kernel.get(this, "securityPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.SecurityPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificate = java.util.Objects.requireNonNull(builder.certificate, "certificate is required");
            this.certificateName = builder.certificateName;
            this.endpointType = builder.endpointType;
            this.ownershipCertificate = builder.ownershipCertificate;
            this.securityPolicy = builder.securityPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.lang.String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.EndpointType getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getOwnershipCertificate() {
            return this.ownershipCertificate;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.SecurityPolicy getSecurityPolicy() {
            return this.securityPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificate", om.valueToTree(this.getCertificate()));
            if (this.getCertificateName() != null) {
                data.set("certificateName", om.valueToTree(this.getCertificateName()));
            }
            if (this.getEndpointType() != null) {
                data.set("endpointType", om.valueToTree(this.getEndpointType()));
            }
            if (this.getOwnershipCertificate() != null) {
                data.set("ownershipCertificate", om.valueToTree(this.getOwnershipCertificate()));
            }
            if (this.getSecurityPolicy() != null) {
                data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.EndpointOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EndpointOptions.Jsii$Proxy that = (EndpointOptions.Jsii$Proxy) o;

            if (!certificate.equals(that.certificate)) return false;
            if (this.certificateName != null ? !this.certificateName.equals(that.certificateName) : that.certificateName != null) return false;
            if (this.endpointType != null ? !this.endpointType.equals(that.endpointType) : that.endpointType != null) return false;
            if (this.ownershipCertificate != null ? !this.ownershipCertificate.equals(that.ownershipCertificate) : that.ownershipCertificate != null) return false;
            return this.securityPolicy != null ? this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.certificate.hashCode();
            result = 31 * result + (this.certificateName != null ? this.certificateName.hashCode() : 0);
            result = 31 * result + (this.endpointType != null ? this.endpointType.hashCode() : 0);
            result = 31 * result + (this.ownershipCertificate != null ? this.ownershipCertificate.hashCode() : 0);
            result = 31 * result + (this.securityPolicy != null ? this.securityPolicy.hashCode() : 0);
            return result;
        }
    }
}
