package software.amazon.awscdk.services.appmesh;

/**
 * Define a new AppMesh mesh.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // This is the ARN for the mesh from different AWS IAM account ID.
 * // Ensure mesh is properly shared with your account. For more details, see: https://github.com/aws/aws-cdk/issues/15404
 * String arn = "arn:aws:appmesh:us-east-1:123456789012:mesh/testMesh";
 * IMesh sharedMesh = Mesh.fromMeshArn(this, "imported-mesh", arn);
 * // This VirtualNode resource can communicate with the resources in the mesh from different AWS IAM account ID.
 * // This VirtualNode resource can communicate with the resources in the mesh from different AWS IAM account ID.
 * VirtualNode.Builder.create(this, "test-node")
 *         .mesh(sharedMesh)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html">https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:17.478Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.Mesh")
public class Mesh extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appmesh.IMesh {

    protected Mesh(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Mesh(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Mesh(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.MeshProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Mesh(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing mesh by arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param meshArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh fromMeshArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String meshArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.Mesh.class, "fromMeshArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(meshArn, "meshArn is required") });
    }

    /**
     * Import an existing mesh by name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param meshName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh fromMeshName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String meshName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.Mesh.class, "fromMeshName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(meshName, "meshName is required") });
    }

    /**
     * Adds a VirtualGateway to the Mesh.
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGateway addVirtualGateway(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.VirtualGatewayBaseProps props) {
        return software.amazon.jsii.Kernel.call(this, "addVirtualGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGateway.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Adds a VirtualGateway to the Mesh.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGateway addVirtualGateway(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addVirtualGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGateway.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a VirtualNode to the Mesh.
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNode addVirtualNode(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.VirtualNodeBaseProps props) {
        return software.amazon.jsii.Kernel.call(this, "addVirtualNode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNode.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Adds a VirtualNode to the Mesh.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNode addVirtualNode(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addVirtualNode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNode.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a VirtualRouter to the Mesh with the given id and props.
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualRouter addVirtualRouter(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.VirtualRouterBaseProps props) {
        return software.amazon.jsii.Kernel.call(this, "addVirtualRouter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualRouter.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Adds a VirtualRouter to the Mesh with the given id and props.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualRouter addVirtualRouter(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addVirtualRouter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualRouter.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The Amazon Resource Name (ARN) of the AppMesh mesh.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMeshArn() {
        return software.amazon.jsii.Kernel.get(this, "meshArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the AppMesh mesh.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMeshName() {
        return software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appmesh.Mesh}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.Mesh> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.appmesh.MeshProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Egress filter to be applied to the Mesh.
         * <p>
         * Default: DROP_ALL
         * <p>
         * @return {@code this}
         * @param egressFilter Egress filter to be applied to the Mesh. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressFilter(final software.amazon.awscdk.services.appmesh.MeshFilterType egressFilter) {
            this.props().egressFilter(egressFilter);
            return this;
        }

        /**
         * The name of the Mesh being defined.
         * <p>
         * Default: - A name is automatically generated
         * <p>
         * @return {@code this}
         * @param meshName The name of the Mesh being defined. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(final java.lang.String meshName) {
            this.props().meshName(meshName);
            return this;
        }

        /**
         * Defines how upstream clients will discover VirtualNodes in the Mesh.
         * <p>
         * Default: - No Service Discovery
         * <p>
         * @return {@code this}
         * @param serviceDiscovery Defines how upstream clients will discover VirtualNodes in the Mesh. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceDiscovery(final software.amazon.awscdk.services.appmesh.MeshServiceDiscovery serviceDiscovery) {
            this.props().serviceDiscovery(serviceDiscovery);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appmesh.Mesh}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appmesh.Mesh build() {
            return new software.amazon.awscdk.services.appmesh.Mesh(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.appmesh.MeshProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.appmesh.MeshProps.Builder();
            }
            return this.props;
        }
    }
}
