package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a <code>CfnChannelNamespace</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnChannelNamespaceProps cfnChannelNamespaceProps = CfnChannelNamespaceProps.builder()
 *         .apiId("apiId")
 *         .name("name")
 *         // the properties below are optional
 *         .codeHandlers("codeHandlers")
 *         .codeS3Location("codeS3Location")
 *         .publishAuthModes(List.of(AuthModeProperty.builder()
 *                 .authType("authType")
 *                 .build()))
 *         .subscribeAuthModes(List.of(AuthModeProperty.builder()
 *                 .authType("authType")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:17.648Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnChannelNamespaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnChannelNamespaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnChannelNamespaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The <code>Api</code> ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-apiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The name of the channel namespace.
     * <p>
     * This name must be unique within the <code>Api</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The event handler functions that run custom business logic to process published events and subscribe requests.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-codehandlers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-codehandlers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCodeHandlers() {
        return null;
    }

    /**
     * The Amazon S3 endpoint where the code is located.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-codes3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-codes3location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCodeS3Location() {
        return null;
    }

    /**
     * The authorization mode to use for publishing messages on the channel namespace.
     * <p>
     * This configuration overrides the default <code>Api</code> authorization configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-publishauthmodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-publishauthmodes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPublishAuthModes() {
        return null;
    }

    /**
     * The authorization mode to use for subscribing to messages on the channel namespace.
     * <p>
     * This configuration overrides the default <code>Api</code> authorization configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-subscribeauthmodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-subscribeauthmodes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSubscribeAuthModes() {
        return null;
    }

    /**
     * A set of tags (key-value pairs) for this channel namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-channelnamespace.html#cfn-appsync-channelnamespace-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnChannelNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnChannelNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnChannelNamespaceProps> {
        java.lang.String apiId;
        java.lang.String name;
        java.lang.String codeHandlers;
        java.lang.String codeS3Location;
        java.lang.Object publishAuthModes;
        java.lang.Object subscribeAuthModes;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnChannelNamespaceProps#getApiId}
         * @param apiId The <code>Api</code> ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelNamespaceProps#getName}
         * @param name The name of the channel namespace. This parameter is required.
         *             This name must be unique within the <code>Api</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelNamespaceProps#getCodeHandlers}
         * @param codeHandlers The event handler functions that run custom business logic to process published events and subscribe requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeHandlers(java.lang.String codeHandlers) {
            this.codeHandlers = codeHandlers;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelNamespaceProps#getCodeS3Location}
         * @param codeS3Location The Amazon S3 endpoint where the code is located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeS3Location(java.lang.String codeS3Location) {
            this.codeS3Location = codeS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelNamespaceProps#getPublishAuthModes}
         * @param publishAuthModes The authorization mode to use for publishing messages on the channel namespace.
         *                         This configuration overrides the default <code>Api</code> authorization configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishAuthModes(software.amazon.awscdk.IResolvable publishAuthModes) {
            this.publishAuthModes = publishAuthModes;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelNamespaceProps#getPublishAuthModes}
         * @param publishAuthModes The authorization mode to use for publishing messages on the channel namespace.
         *                         This configuration overrides the default <code>Api</code> authorization configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishAuthModes(java.util.List<? extends java.lang.Object> publishAuthModes) {
            this.publishAuthModes = publishAuthModes;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelNamespaceProps#getSubscribeAuthModes}
         * @param subscribeAuthModes The authorization mode to use for subscribing to messages on the channel namespace.
         *                           This configuration overrides the default <code>Api</code> authorization configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribeAuthModes(software.amazon.awscdk.IResolvable subscribeAuthModes) {
            this.subscribeAuthModes = subscribeAuthModes;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelNamespaceProps#getSubscribeAuthModes}
         * @param subscribeAuthModes The authorization mode to use for subscribing to messages on the channel namespace.
         *                           This configuration overrides the default <code>Api</code> authorization configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribeAuthModes(java.util.List<? extends java.lang.Object> subscribeAuthModes) {
            this.subscribeAuthModes = subscribeAuthModes;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelNamespaceProps#getTags}
         * @param tags A set of tags (key-value pairs) for this channel namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnChannelNamespaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnChannelNamespaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnChannelNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnChannelNamespaceProps {
        private final java.lang.String apiId;
        private final java.lang.String name;
        private final java.lang.String codeHandlers;
        private final java.lang.String codeS3Location;
        private final java.lang.Object publishAuthModes;
        private final java.lang.Object subscribeAuthModes;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeHandlers = software.amazon.jsii.Kernel.get(this, "codeHandlers", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeS3Location = software.amazon.jsii.Kernel.get(this, "codeS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publishAuthModes = software.amazon.jsii.Kernel.get(this, "publishAuthModes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subscribeAuthModes = software.amazon.jsii.Kernel.get(this, "subscribeAuthModes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.codeHandlers = builder.codeHandlers;
            this.codeS3Location = builder.codeS3Location;
            this.publishAuthModes = builder.publishAuthModes;
            this.subscribeAuthModes = builder.subscribeAuthModes;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getCodeHandlers() {
            return this.codeHandlers;
        }

        @Override
        public final java.lang.String getCodeS3Location() {
            return this.codeS3Location;
        }

        @Override
        public final java.lang.Object getPublishAuthModes() {
            return this.publishAuthModes;
        }

        @Override
        public final java.lang.Object getSubscribeAuthModes() {
            return this.subscribeAuthModes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getCodeHandlers() != null) {
                data.set("codeHandlers", om.valueToTree(this.getCodeHandlers()));
            }
            if (this.getCodeS3Location() != null) {
                data.set("codeS3Location", om.valueToTree(this.getCodeS3Location()));
            }
            if (this.getPublishAuthModes() != null) {
                data.set("publishAuthModes", om.valueToTree(this.getPublishAuthModes()));
            }
            if (this.getSubscribeAuthModes() != null) {
                data.set("subscribeAuthModes", om.valueToTree(this.getSubscribeAuthModes()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnChannelNamespaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnChannelNamespaceProps.Jsii$Proxy that = (CfnChannelNamespaceProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!name.equals(that.name)) return false;
            if (this.codeHandlers != null ? !this.codeHandlers.equals(that.codeHandlers) : that.codeHandlers != null) return false;
            if (this.codeS3Location != null ? !this.codeS3Location.equals(that.codeS3Location) : that.codeS3Location != null) return false;
            if (this.publishAuthModes != null ? !this.publishAuthModes.equals(that.publishAuthModes) : that.publishAuthModes != null) return false;
            if (this.subscribeAuthModes != null ? !this.subscribeAuthModes.equals(that.subscribeAuthModes) : that.subscribeAuthModes != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.codeHandlers != null ? this.codeHandlers.hashCode() : 0);
            result = 31 * result + (this.codeS3Location != null ? this.codeS3Location.hashCode() : 0);
            result = 31 * result + (this.publishAuthModes != null ? this.publishAuthModes.hashCode() : 0);
            result = 31 * result + (this.subscribeAuthModes != null ? this.subscribeAuthModes.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
