package software.amazon.awscdk.services.batch;

/**
 * Props to configure an EcsEc2ContainerDefinition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * EcsJobDefinition ecsJob = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .build();
 * JobQueue queue = JobQueue.Builder.create(this, "JobQueue")
 *         .computeEnvironments(List.of(OrderedComputeEnvironment.builder()
 *                 .computeEnvironment(ManagedEc2EcsComputeEnvironment.Builder.create(this, "managedEc2CE")
 *                         .vpc(vpc)
 *                         .build())
 *                 .order(1)
 *                 .build()))
 *         .priority(10)
 *         .build();
 * User user = new User(this, "MyUser");
 * ecsJob.grantSubmitJob(user, queue);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:18.232Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EcsEc2ContainerDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(EcsEc2ContainerDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsEc2ContainerDefinitionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.EcsContainerDefinitionProps {

    /**
     * The number of physical GPUs to reserve for the container.
     * <p>
     * Make sure that the number of GPUs reserved for all containers in a job doesn't exceed
     * the number of available GPUs on the compute resource that the job is launched on.
     * <p>
     * Default: - no gpus
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpu() {
        return null;
    }

    /**
     * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
        return null;
    }

    /**
     * Limits to set for the user this docker container will run as.
     * <p>
     * Default: - no ulimits
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.Ulimit> getUlimits() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsEc2ContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsEc2ContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsEc2ContainerDefinitionProps> {
        java.lang.Number gpu;
        java.lang.Boolean privileged;
        java.util.List<software.amazon.awscdk.services.batch.Ulimit> ulimits;
        java.lang.Number cpu;
        software.amazon.awscdk.services.ecs.ContainerImage image;
        software.amazon.awscdk.Size memory;
        java.util.List<java.lang.String> command;
        java.util.Map<java.lang.String, java.lang.String> environment;
        software.amazon.awscdk.services.iam.IRole executionRole;
        software.amazon.awscdk.services.iam.IRole jobRole;
        software.amazon.awscdk.services.batch.LinuxParameters linuxParameters;
        software.amazon.awscdk.services.ecs.LogDriver logging;
        java.lang.Boolean readonlyRootFilesystem;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> secrets;
        java.lang.String user;
        java.util.List<software.amazon.awscdk.services.batch.EcsVolume> volumes;

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getGpu}
         * @param gpu The number of physical GPUs to reserve for the container.
         *            Make sure that the number of GPUs reserved for all containers in a job doesn't exceed
         *            the number of available GPUs on the compute resource that the job is launched on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpu(java.lang.Number gpu) {
            this.gpu = gpu;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getPrivileged}
         * @param privileged When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privileged(java.lang.Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getUlimits}
         * @param ulimits Limits to set for the user this docker container will run as.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder ulimits(java.util.List<? extends software.amazon.awscdk.services.batch.Ulimit> ulimits) {
            this.ulimits = (java.util.List<software.amazon.awscdk.services.batch.Ulimit>)ulimits;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getCpu}
         * @param cpu The number of vCPUs reserved for the container. This parameter is required.
         *            Each vCPU is equivalent to 1,024 CPU shares.
         *            For containers running on EC2 resources, you must specify at least one vCPU.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getImage}
         * @param image The image that this container will run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getMemory}
         * @param memory The memory hard limit present to the container. This parameter is required.
         *               If your container attempts to exceed the memory specified, the container is terminated.
         *               You must specify at least 4 MiB of memory for a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(software.amazon.awscdk.Size memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getCommand}
         * @param command The command that's passed to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getEnvironment}
         * @param environment The environment variables to pass to a container.
         *                    Cannot start with <code>AWS_BATCH</code>.
         *                    We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getExecutionRole}
         * @param executionRole The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(software.amazon.awscdk.services.iam.IRole executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getJobRole}
         * @param jobRole The role that the container can assume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobRole(software.amazon.awscdk.services.iam.IRole jobRole) {
            this.jobRole = jobRole;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getLinuxParameters}
         * @param linuxParameters Linux-specific modifications that are applied to the container, such as details for device mappings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linuxParameters(software.amazon.awscdk.services.batch.LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getLogging}
         * @param logging The loging configuration for this Job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.ecs.LogDriver logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getReadonlyRootFilesystem}
         * @param readonlyRootFilesystem Gives the container readonly access to its root filesystem.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getSecrets}
         * @param secrets A map from environment variable names to the secrets for the container.
         *                Allows your job definitions
         *                to reference the secret by the environment variable name defined in this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secrets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.batch.Secret> secrets) {
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret>)secrets;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getUser}
         * @param user The user name to use inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2ContainerDefinitionProps#getVolumes}
         * @param volumes The volumes to mount to this container.
         *                Automatically added to the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.services.batch.EcsVolume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.services.batch.EcsVolume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsEc2ContainerDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsEc2ContainerDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsEc2ContainerDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsEc2ContainerDefinitionProps {
        private final java.lang.Number gpu;
        private final java.lang.Boolean privileged;
        private final java.util.List<software.amazon.awscdk.services.batch.Ulimit> ulimits;
        private final java.lang.Number cpu;
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final software.amazon.awscdk.Size memory;
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.services.iam.IRole executionRole;
        private final software.amazon.awscdk.services.iam.IRole jobRole;
        private final software.amazon.awscdk.services.batch.LinuxParameters linuxParameters;
        private final software.amazon.awscdk.services.ecs.LogDriver logging;
        private final java.lang.Boolean readonlyRootFilesystem;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> secrets;
        private final java.lang.String user;
        private final java.util.List<software.amazon.awscdk.services.batch.EcsVolume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.gpu = software.amazon.jsii.Kernel.get(this, "gpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ulimits = software.amazon.jsii.Kernel.get(this, "ulimits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Ulimit.class)));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
            this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.jobRole = software.amazon.jsii.Kernel.get(this, "jobRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.linuxParameters = software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LinuxParameters.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
            this.readonlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class)));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EcsVolume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gpu = builder.gpu;
            this.privileged = builder.privileged;
            this.ulimits = (java.util.List<software.amazon.awscdk.services.batch.Ulimit>)builder.ulimits;
            this.cpu = java.util.Objects.requireNonNull(builder.cpu, "cpu is required");
            this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
            this.memory = java.util.Objects.requireNonNull(builder.memory, "memory is required");
            this.command = builder.command;
            this.environment = builder.environment;
            this.executionRole = builder.executionRole;
            this.jobRole = builder.jobRole;
            this.linuxParameters = builder.linuxParameters;
            this.logging = builder.logging;
            this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret>)builder.secrets;
            this.user = builder.user;
            this.volumes = (java.util.List<software.amazon.awscdk.services.batch.EcsVolume>)builder.volumes;
        }

        @Override
        public final java.lang.Number getGpu() {
            return this.gpu;
        }

        @Override
        public final java.lang.Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.Ulimit> getUlimits() {
            return this.ulimits;
        }

        @Override
        public final java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public final software.amazon.awscdk.Size getMemory() {
            return this.memory;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getJobRole() {
            return this.jobRole;
        }

        @Override
        public final software.amazon.awscdk.services.batch.LinuxParameters getLinuxParameters() {
            return this.linuxParameters;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LogDriver getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.EcsVolume> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGpu() != null) {
                data.set("gpu", om.valueToTree(this.getGpu()));
            }
            if (this.getPrivileged() != null) {
                data.set("privileged", om.valueToTree(this.getPrivileged()));
            }
            if (this.getUlimits() != null) {
                data.set("ulimits", om.valueToTree(this.getUlimits()));
            }
            data.set("cpu", om.valueToTree(this.getCpu()));
            data.set("image", om.valueToTree(this.getImage()));
            data.set("memory", om.valueToTree(this.getMemory()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getJobRole() != null) {
                data.set("jobRole", om.valueToTree(this.getJobRole()));
            }
            if (this.getLinuxParameters() != null) {
                data.set("linuxParameters", om.valueToTree(this.getLinuxParameters()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getReadonlyRootFilesystem() != null) {
                data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.EcsEc2ContainerDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsEc2ContainerDefinitionProps.Jsii$Proxy that = (EcsEc2ContainerDefinitionProps.Jsii$Proxy) o;

            if (this.gpu != null ? !this.gpu.equals(that.gpu) : that.gpu != null) return false;
            if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
            if (this.ulimits != null ? !this.ulimits.equals(that.ulimits) : that.ulimits != null) return false;
            if (!cpu.equals(that.cpu)) return false;
            if (!image.equals(that.image)) return false;
            if (!memory.equals(that.memory)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.jobRole != null ? !this.jobRole.equals(that.jobRole) : that.jobRole != null) return false;
            if (this.linuxParameters != null ? !this.linuxParameters.equals(that.linuxParameters) : that.linuxParameters != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
            if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.gpu != null ? this.gpu.hashCode() : 0;
            result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
            result = 31 * result + (this.ulimits != null ? this.ulimits.hashCode() : 0);
            result = 31 * result + (this.cpu.hashCode());
            result = 31 * result + (this.image.hashCode());
            result = 31 * result + (this.memory.hashCode());
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.jobRole != null ? this.jobRole.hashCode() : 0);
            result = 31 * result + (this.linuxParameters != null ? this.linuxParameters.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
