package software.amazon.awscdk.services.batch;

/**
 * The state of the job needed to trigger the action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * JobQueue.Builder.create(this, "JobQueue")
 *         .jobStateTimeLimitActions(List.of(JobStateTimeLimitAction.builder()
 *                 .action(JobStateTimeLimitActionsAction.CANCEL)
 *                 .maxTime(Duration.minutes(10))
 *                 .reason(JobStateTimeLimitActionsReason.INSUFFICIENT_INSTANCE_CAPACITY)
 *                 .state(JobStateTimeLimitActionsState.RUNNABLE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:18.309Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.JobStateTimeLimitActionsState")
public enum JobStateTimeLimitActionsState {
    /**
     * RUNNABLE state triggers the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RUNNABLE,
}
