package software.amazon.awscdk.services.batch;

/**
 * Represents a group of Job Definitions.
 * <p>
 * All Job Definitions that
 * declare a share identifier will be considered members of the Share
 * defined by that share identifier.
 * <p>
 * The Scheduler divides the maximum available vCPUs of the ComputeEnvironment
 * among Jobs in the Queue based on their shareIdentifier and the weightFactor
 * associated with that shareIdentifier.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FairshareSchedulingPolicy fairsharePolicy = new FairshareSchedulingPolicy(this, "myFairsharePolicy");
 * fairsharePolicy.addShare(Share.builder()
 *         .shareIdentifier("A")
 *         .weightFactor(1)
 *         .build());
 * fairsharePolicy.addShare(Share.builder()
 *         .shareIdentifier("B")
 *         .weightFactor(1)
 *         .build());
 * JobQueue.Builder.create(this, "JobQueue")
 *         .schedulingPolicy(fairsharePolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:18.327Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.Share")
@software.amazon.jsii.Jsii.Proxy(Share.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Share extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of this Share.
     * <p>
     * All jobs that specify this share identifier
     * when submitted to the queue will be considered as part of this Share.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getShareIdentifier();

    /**
     * The weight factor given to this Share.
     * <p>
     * The Scheduler decides which jobs to put in the Compute Environment
     * such that the following ratio is equal for each job:
     * <p>
     * <code>sharevCpu / weightFactor</code>,
     * <p>
     * where <code>sharevCpu</code> is the total amount of vCPU given to that particular share; that is,
     * the sum of the vCPU of each job currently in the Compute Environment for that share.
     * <p>
     * See the readme of this module for a detailed example that shows how these are used,
     * how it relates to <code>computeReservation</code>, and how <code>shareDecay</code> affects these calculations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getWeightFactor();

    /**
     * @return a {@link Builder} of {@link Share}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Share}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Share> {
        java.lang.String shareIdentifier;
        java.lang.Number weightFactor;

        /**
         * Sets the value of {@link Share#getShareIdentifier}
         * @param shareIdentifier The identifier of this Share. This parameter is required.
         *                        All jobs that specify this share identifier
         *                        when submitted to the queue will be considered as part of this Share.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shareIdentifier(java.lang.String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link Share#getWeightFactor}
         * @param weightFactor The weight factor given to this Share. This parameter is required.
         *                     The Scheduler decides which jobs to put in the Compute Environment
         *                     such that the following ratio is equal for each job:
         *                     <p>
         *                     <code>sharevCpu / weightFactor</code>,
         *                     <p>
         *                     where <code>sharevCpu</code> is the total amount of vCPU given to that particular share; that is,
         *                     the sum of the vCPU of each job currently in the Compute Environment for that share.
         *                     <p>
         *                     See the readme of this module for a detailed example that shows how these are used,
         *                     how it relates to <code>computeReservation</code>, and how <code>shareDecay</code> affects these calculations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weightFactor(java.lang.Number weightFactor) {
            this.weightFactor = weightFactor;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Share}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Share build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Share}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Share {
        private final java.lang.String shareIdentifier;
        private final java.lang.Number weightFactor;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.shareIdentifier = software.amazon.jsii.Kernel.get(this, "shareIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.weightFactor = software.amazon.jsii.Kernel.get(this, "weightFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.shareIdentifier = java.util.Objects.requireNonNull(builder.shareIdentifier, "shareIdentifier is required");
            this.weightFactor = java.util.Objects.requireNonNull(builder.weightFactor, "weightFactor is required");
        }

        @Override
        public final java.lang.String getShareIdentifier() {
            return this.shareIdentifier;
        }

        @Override
        public final java.lang.Number getWeightFactor() {
            return this.weightFactor;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("shareIdentifier", om.valueToTree(this.getShareIdentifier()));
            data.set("weightFactor", om.valueToTree(this.getWeightFactor()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.Share"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Share.Jsii$Proxy that = (Share.Jsii$Proxy) o;

            if (!shareIdentifier.equals(that.shareIdentifier)) return false;
            return this.weightFactor.equals(that.weightFactor);
        }

        @Override
        public final int hashCode() {
            int result = this.shareIdentifier.hashCode();
            result = 31 * result + (this.weightFactor.hashCode());
            return result;
        }
    }
}
