package software.amazon.awscdk.services.cloudformation;

/**
 * Properties for defining a <code>CfnLambdaHook</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudformation.*;
 * CfnLambdaHookProps cfnLambdaHookProps = CfnLambdaHookProps.builder()
 *         .alias("alias")
 *         .executionRole("executionRole")
 *         .failureMode("failureMode")
 *         .hookStatus("hookStatus")
 *         .lambdaFunction("lambdaFunction")
 *         .targetOperations(List.of("targetOperations"))
 *         // the properties below are optional
 *         .stackFilters(StackFiltersProperty.builder()
 *                 .filteringCriteria("filteringCriteria")
 *                 // the properties below are optional
 *                 .stackNames(StackNamesProperty.builder()
 *                         .exclude(List.of("exclude"))
 *                         .include(List.of("include"))
 *                         .build())
 *                 .stackRoles(StackRolesProperty.builder()
 *                         .exclude(List.of("exclude"))
 *                         .include(List.of("include"))
 *                         .build())
 *                 .build())
 *         .targetFilters(TargetFiltersProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .invocationPoints(List.of("invocationPoints"))
 *                 .targetNames(List.of("targetNames"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:18.705Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnLambdaHookProps")
@software.amazon.jsii.Jsii.Proxy(CfnLambdaHookProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLambdaHookProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type name alias for the Hook. This alias must be unique per account and Region.
     * <p>
     * The alias must be in the form <code>Name1::Name2::Name3</code> and must not begin with <code>AWS</code> . For example, <code>Private::Lambda::MyTestHook</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-alias</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAlias();

    /**
     * The IAM role that the Hook assumes to invoke your Lambda function.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-executionrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

    /**
     * Specifies how the Hook responds when the Lambda function invoked by the Hook returns a <code>FAILED</code> response.
     * <p>
     * <ul>
     * <li><code>FAIL</code> : Prevents the action from proceeding. This is helpful for enforcing strict compliance or security policies.</li>
     * <li><code>WARN</code> : Issues warnings to users but allows actions to continue. This is useful for non-critical validations or informational checks.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-failuremode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-failuremode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFailureMode();

    /**
     * Specifies if the Hook is <code>ENABLED</code> or <code>DISABLED</code> .
     * <p>
     * Default: - "ENABLED"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-hookstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-hookstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHookStatus();

    /**
     * Specifies the Lambda function for the Hook. You can use:.
     * <p>
     * <ul>
     * <li>The full Amazon Resource Name (ARN) without a suffix.</li>
     * <li>A qualified ARN with a version or alias suffix.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-lambdafunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-lambdafunction</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLambdaFunction();

    /**
     * Specifies which type of operation the Hook is run against.
     * <p>
     * Valid values: <code>STACK</code> | <code>RESOURCE</code> | <code>CHANGE_SET</code> | <code>CLOUD_CONTROL</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetoperations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetoperations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargetOperations();

    /**
     * Specifies the stack level filters for the Hook.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-stackfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-stackfilters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStackFilters() {
        return null;
    }

    /**
     * Specifies the target filters for the Hook.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-lambdahook.html#cfn-cloudformation-lambdahook-targetfilters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetFilters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLambdaHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLambdaHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLambdaHookProps> {
        java.lang.String alias;
        java.lang.String executionRole;
        java.lang.String failureMode;
        java.lang.String hookStatus;
        java.lang.String lambdaFunction;
        java.util.List<java.lang.String> targetOperations;
        java.lang.Object stackFilters;
        java.lang.Object targetFilters;

        /**
         * Sets the value of {@link CfnLambdaHookProps#getAlias}
         * @param alias The type name alias for the Hook. This alias must be unique per account and Region. This parameter is required.
         *              The alias must be in the form <code>Name1::Name2::Name3</code> and must not begin with <code>AWS</code> . For example, <code>Private::Lambda::MyTestHook</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(java.lang.String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link CfnLambdaHookProps#getExecutionRole}
         * @param executionRole The IAM role that the Hook assumes to invoke your Lambda function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(java.lang.String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnLambdaHookProps#getFailureMode}
         * @param failureMode Specifies how the Hook responds when the Lambda function invoked by the Hook returns a <code>FAILED</code> response. This parameter is required.
         *                    <ul>
         *                    <li><code>FAIL</code> : Prevents the action from proceeding. This is helpful for enforcing strict compliance or security policies.</li>
         *                    <li><code>WARN</code> : Issues warnings to users but allows actions to continue. This is useful for non-critical validations or informational checks.</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureMode(java.lang.String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnLambdaHookProps#getHookStatus}
         * @param hookStatus Specifies if the Hook is <code>ENABLED</code> or <code>DISABLED</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hookStatus(java.lang.String hookStatus) {
            this.hookStatus = hookStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnLambdaHookProps#getLambdaFunction}
         * @param lambdaFunction Specifies the Lambda function for the Hook. You can use:. This parameter is required.
         *                       <ul>
         *                       <li>The full Amazon Resource Name (ARN) without a suffix.</li>
         *                       <li>A qualified ARN with a version or alias suffix.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaFunction(java.lang.String lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        /**
         * Sets the value of {@link CfnLambdaHookProps#getTargetOperations}
         * @param targetOperations Specifies which type of operation the Hook is run against. This parameter is required.
         *                         Valid values: <code>STACK</code> | <code>RESOURCE</code> | <code>CHANGE_SET</code> | <code>CLOUD_CONTROL</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetOperations(java.util.List<java.lang.String> targetOperations) {
            this.targetOperations = targetOperations;
            return this;
        }

        /**
         * Sets the value of {@link CfnLambdaHookProps#getStackFilters}
         * @param stackFilters Specifies the stack level filters for the Hook.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackFilters(software.amazon.awscdk.IResolvable stackFilters) {
            this.stackFilters = stackFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnLambdaHookProps#getStackFilters}
         * @param stackFilters Specifies the stack level filters for the Hook.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackFilters(software.amazon.awscdk.services.cloudformation.CfnLambdaHook.StackFiltersProperty stackFilters) {
            this.stackFilters = stackFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnLambdaHookProps#getTargetFilters}
         * @param targetFilters Specifies the target filters for the Hook.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetFilters(software.amazon.awscdk.IResolvable targetFilters) {
            this.targetFilters = targetFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnLambdaHookProps#getTargetFilters}
         * @param targetFilters Specifies the target filters for the Hook.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetFilters(software.amazon.awscdk.services.cloudformation.CfnLambdaHook.TargetFiltersProperty targetFilters) {
            this.targetFilters = targetFilters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLambdaHookProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLambdaHookProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLambdaHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLambdaHookProps {
        private final java.lang.String alias;
        private final java.lang.String executionRole;
        private final java.lang.String failureMode;
        private final java.lang.String hookStatus;
        private final java.lang.String lambdaFunction;
        private final java.util.List<java.lang.String> targetOperations;
        private final java.lang.Object stackFilters;
        private final java.lang.Object targetFilters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.failureMode = software.amazon.jsii.Kernel.get(this, "failureMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hookStatus = software.amazon.jsii.Kernel.get(this, "hookStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lambdaFunction = software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetOperations = software.amazon.jsii.Kernel.get(this, "targetOperations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stackFilters = software.amazon.jsii.Kernel.get(this, "stackFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetFilters = software.amazon.jsii.Kernel.get(this, "targetFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
            this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
            this.failureMode = java.util.Objects.requireNonNull(builder.failureMode, "failureMode is required");
            this.hookStatus = java.util.Objects.requireNonNull(builder.hookStatus, "hookStatus is required");
            this.lambdaFunction = java.util.Objects.requireNonNull(builder.lambdaFunction, "lambdaFunction is required");
            this.targetOperations = java.util.Objects.requireNonNull(builder.targetOperations, "targetOperations is required");
            this.stackFilters = builder.stackFilters;
            this.targetFilters = builder.targetFilters;
        }

        @Override
        public final java.lang.String getAlias() {
            return this.alias;
        }

        @Override
        public final java.lang.String getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getFailureMode() {
            return this.failureMode;
        }

        @Override
        public final java.lang.String getHookStatus() {
            return this.hookStatus;
        }

        @Override
        public final java.lang.String getLambdaFunction() {
            return this.lambdaFunction;
        }

        @Override
        public final java.util.List<java.lang.String> getTargetOperations() {
            return this.targetOperations;
        }

        @Override
        public final java.lang.Object getStackFilters() {
            return this.stackFilters;
        }

        @Override
        public final java.lang.Object getTargetFilters() {
            return this.targetFilters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alias", om.valueToTree(this.getAlias()));
            data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            data.set("failureMode", om.valueToTree(this.getFailureMode()));
            data.set("hookStatus", om.valueToTree(this.getHookStatus()));
            data.set("lambdaFunction", om.valueToTree(this.getLambdaFunction()));
            data.set("targetOperations", om.valueToTree(this.getTargetOperations()));
            if (this.getStackFilters() != null) {
                data.set("stackFilters", om.valueToTree(this.getStackFilters()));
            }
            if (this.getTargetFilters() != null) {
                data.set("targetFilters", om.valueToTree(this.getTargetFilters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudformation.CfnLambdaHookProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLambdaHookProps.Jsii$Proxy that = (CfnLambdaHookProps.Jsii$Proxy) o;

            if (!alias.equals(that.alias)) return false;
            if (!executionRole.equals(that.executionRole)) return false;
            if (!failureMode.equals(that.failureMode)) return false;
            if (!hookStatus.equals(that.hookStatus)) return false;
            if (!lambdaFunction.equals(that.lambdaFunction)) return false;
            if (!targetOperations.equals(that.targetOperations)) return false;
            if (this.stackFilters != null ? !this.stackFilters.equals(that.stackFilters) : that.stackFilters != null) return false;
            return this.targetFilters != null ? this.targetFilters.equals(that.targetFilters) : that.targetFilters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alias.hashCode();
            result = 31 * result + (this.executionRole.hashCode());
            result = 31 * result + (this.failureMode.hashCode());
            result = 31 * result + (this.hookStatus.hashCode());
            result = 31 * result + (this.lambdaFunction.hashCode());
            result = 31 * result + (this.targetOperations.hashCode());
            result = 31 * result + (this.stackFilters != null ? this.stackFilters.hashCode() : 0);
            result = 31 * result + (this.targetFilters != null ? this.targetFilters.hashCode() : 0);
            return result;
        }
    }
}
