package software.amazon.awscdk.services.cloudfront;

/**
 * Determines whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creating a custom cache policy for a Distribution -- all parameters optional
 * S3Origin bucketOrigin;
 * CachePolicy myCachePolicy = CachePolicy.Builder.create(this, "myCachePolicy")
 *         .cachePolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .defaultTtl(Duration.days(2))
 *         .minTtl(Duration.minutes(1))
 *         .maxTtl(Duration.days(10))
 *         .cookieBehavior(CacheCookieBehavior.all())
 *         .headerBehavior(CacheHeaderBehavior.allowList("X-CustomHeader"))
 *         .queryStringBehavior(CacheQueryStringBehavior.denyList("username"))
 *         .enableAcceptEncodingGzip(true)
 *         .enableAcceptEncodingBrotli(true)
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .cachePolicy(myCachePolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:18.779Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CacheHeaderBehavior")
public class CacheHeaderBehavior extends software.amazon.jsii.JsiiObject {

    protected CacheHeaderBehavior(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CacheHeaderBehavior(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Listed headers are included in the cache key and are automatically included in requests that CloudFront sends to the origin.
     * <p>
     * @param headers This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior allowList(final @org.jetbrains.annotations.NotNull java.lang.String... headers) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior.class, "allowList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior.class), java.util.Arrays.<Object>stream(headers).toArray(Object[]::new));
    }

    /**
     * HTTP headers are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior none() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior.class, "none", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheHeaderBehavior.class));
    }

    /**
     * If no headers will be passed, or an allow list of headers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBehavior() {
        return software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The headers for the allow/deny list, if applicable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaders() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
