package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFront distribution with associated origin(s) and caching behavior(s).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Adding an existing Lambda&#64;Edge function created in a different stack
 * // to a CloudFront distribution.
 * Bucket s3Bucket;
 * IVersion functionVersion = Version.fromVersionArn(this, "Version", "arn:aws:lambda:us-east-1:123456789012:function:functionName:1");
 * Distribution.Builder.create(this, "distro")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(s3Bucket))
 *                 .edgeLambdas(List.of(EdgeLambda.builder()
 *                         .functionVersion(functionVersion)
 *                         .eventType(LambdaEdgeEventType.VIEWER_REQUEST)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:18.904Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.Distribution")
public class Distribution extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IDistribution {

    protected Distribution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Distribution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Distribution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.DistributionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a Distribution construct that represents an external (imported) distribution.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IDistribution fromDistributionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.DistributionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.Distribution.class, "fromDistributionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IDistribution.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds a new behavior to this distribution for the given pathPattern.
     * <p>
     * @param pathPattern the path pattern (e.g., 'images/*') that specifies which requests to apply the behavior to. This parameter is required.
     * @param origin the origin to use for this behavior. This parameter is required.
     * @param behaviorOptions the options for the behavior at this path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addBehavior(final @org.jetbrains.annotations.NotNull java.lang.String pathPattern, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin origin, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.AddBehaviorOptions behaviorOptions) {
        software.amazon.jsii.Kernel.call(this, "addBehavior", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(pathPattern, "pathPattern is required"), java.util.Objects.requireNonNull(origin, "origin is required"), behaviorOptions });
    }

    /**
     * Adds a new behavior to this distribution for the given pathPattern.
     * <p>
     * @param pathPattern the path pattern (e.g., 'images/*') that specifies which requests to apply the behavior to. This parameter is required.
     * @param origin the origin to use for this behavior. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addBehavior(final @org.jetbrains.annotations.NotNull java.lang.String pathPattern, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin origin) {
        software.amazon.jsii.Kernel.call(this, "addBehavior", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(pathPattern, "pathPattern is required"), java.util.Objects.requireNonNull(origin, "origin is required") });
    }

    /**
     * Attach WAF WebACL to this CloudFront distribution.
     * <p>
     * WebACL must be in the us-east-1 region
     * <p>
     * @param webAclId The WAF WebACL to associate with this distribution. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachWebAclId(final @org.jetbrains.annotations.NotNull java.lang.String webAclId) {
        software.amazon.jsii.Kernel.call(this, "attachWebAclId", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(webAclId, "webAclId is required") });
    }

    /**
     * Adds an IAM policy statement associated with this distribution to an IAM principal's policy.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param actions The set of actions to allow (i.e. "cloudfront:ListInvalidations"). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant to create invalidations for this bucket to an IAM principal (Role/Group/User).
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantCreateInvalidation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantCreateInvalidation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Return the given named metric for this Distribution.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Distribution.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 401.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric401ErrorRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric401ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 401.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric401ErrorRate() {
        return software.amazon.jsii.Kernel.call(this, "metric401ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 403.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric403ErrorRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric403ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 403.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric403ErrorRate() {
        return software.amazon.jsii.Kernel.call(this, "metric403ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 404.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric404ErrorRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric404ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 404.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric404ErrorRate() {
        return software.amazon.jsii.Kernel.call(this, "metric404ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 4xx.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric4xxErrorRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric4xxErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 4xx.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric4xxErrorRate() {
        return software.amazon.jsii.Kernel.call(this, "metric4xxErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 502.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric502ErrorRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric502ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 502.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric502ErrorRate() {
        return software.amazon.jsii.Kernel.call(this, "metric502ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 503.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric503ErrorRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric503ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 503.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric503ErrorRate() {
        return software.amazon.jsii.Kernel.call(this, "metric503ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 504.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric504ErrorRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric504ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 504.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric504ErrorRate() {
        return software.amazon.jsii.Kernel.call(this, "metric504ErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 5xx.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric5xxErrorRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric5xxErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 5xx.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric5xxErrorRate() {
        return software.amazon.jsii.Kernel.call(this, "metric5xxErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the total number of bytes downloaded by viewers for GET, HEAD, and OPTIONS requests.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBytesDownloaded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricBytesDownloaded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the total number of bytes downloaded by viewers for GET, HEAD, and OPTIONS requests.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBytesDownloaded() {
        return software.amazon.jsii.Kernel.call(this, "metricBytesDownloaded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the total number of bytes that viewers uploaded to your origin with CloudFront, using POST and PUT requests.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBytesUploaded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricBytesUploaded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the total number of bytes that viewers uploaded to your origin with CloudFront, using POST and PUT requests.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBytesUploaded() {
        return software.amazon.jsii.Kernel.call(this, "metricBytesUploaded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the percentage of all cacheable requests for which CloudFront served the content from its cache.
     * <p>
     * HTTP POST and PUT requests, and errors, are not considered cacheable requests.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheHitRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCacheHitRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all cacheable requests for which CloudFront served the content from its cache.
     * <p>
     * HTTP POST and PUT requests, and errors, are not considered cacheable requests.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheHitRate() {
        return software.amazon.jsii.Kernel.call(this, "metricCacheHitRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the total time spent from when CloudFront receives a request to when it starts providing a response to the network (not the viewer), for requests that are served from the origin, not the CloudFront cache.
     * <p>
     * This is also known as first byte latency, or time-to-first-byte.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOriginLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricOriginLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the total time spent from when CloudFront receives a request to when it starts providing a response to the network (not the viewer), for requests that are served from the origin, not the CloudFront cache.
     * <p>
     * This is also known as first byte latency, or time-to-first-byte.
     * <p>
     * To obtain this metric, you need to set <code>publishAdditionalMetrics</code> to <code>true</code>.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOriginLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricOriginLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the total number of viewer requests received by CloudFront, for all HTTP methods and for both HTTP and HTTPS requests.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequests(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the total number of viewer requests received by CloudFront, for all HTTP methods and for both HTTP and HTTPS requests.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequests() {
        return software.amazon.jsii.Kernel.call(this, "metricRequests", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 4xx or 5xx.
     * <p>
     * Default: - average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTotalErrorRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTotalErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the percentage of all viewer requests for which the response's HTTP status code is 4xx or 5xx.
     * <p>
     * Default: - average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTotalErrorRate() {
        return software.amazon.jsii.Kernel.call(this, "metricTotalErrorRate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The distribution ARN for this distribution.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDistributionArn() {
        return software.amazon.jsii.Kernel.get(this, "distributionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name of the Distribution, such as d111111abcdef8.cloudfront.net.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDistributionDomainName() {
        return software.amazon.jsii.Kernel.get(this, "distributionDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The distribution ID for this distribution.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDistributionId() {
        return software.amazon.jsii.Kernel.get(this, "distributionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name of the Distribution, such as d111111abcdef8.cloudfront.net.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.Distribution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.Distribution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.DistributionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.DistributionProps.Builder();
        }

        /**
         * The default behavior for the distribution.
         * <p>
         * @return {@code this}
         * @param defaultBehavior The default behavior for the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBehavior(final software.amazon.awscdk.services.cloudfront.BehaviorOptions defaultBehavior) {
            this.props.defaultBehavior(defaultBehavior);
            return this;
        }

        /**
         * Additional behaviors for the distribution, mapped by the pathPattern that specifies which requests to apply the behavior to.
         * <p>
         * Default: - no additional behaviors are added.
         * <p>
         * @return {@code this}
         * @param additionalBehaviors Additional behaviors for the distribution, mapped by the pathPattern that specifies which requests to apply the behavior to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalBehaviors(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.cloudfront.BehaviorOptions> additionalBehaviors) {
            this.props.additionalBehaviors(additionalBehaviors);
            return this;
        }

        /**
         * A certificate to associate with the distribution.
         * <p>
         * The certificate must be located in N. Virginia (us-east-1).
         * <p>
         * Default: - the CloudFront wildcard certificate (*.cloudfront.net) will be used.
         * <p>
         * @return {@code this}
         * @param certificate A certificate to associate with the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(final software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.props.certificate(certificate);
            return this;
        }

        /**
         * Any comments you want to include about the distribution.
         * <p>
         * Default: - no comment
         * <p>
         * @return {@code this}
         * @param comment Any comments you want to include about the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The object that you want CloudFront to request from your origin (for example, index.html) when a viewer requests the root URL for your distribution. If no default object is set, the request goes to the origin's root (e.g., example.com/).
         * <p>
         * Default: - no default root object
         * <p>
         * @return {@code this}
         * @param defaultRootObject The object that you want CloudFront to request from your origin (for example, index.html) when a viewer requests the root URL for your distribution. If no default object is set, the request goes to the origin's root (e.g., example.com/). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRootObject(final java.lang.String defaultRootObject) {
            this.props.defaultRootObject(defaultRootObject);
            return this;
        }

        /**
         * Alternative domain names for this distribution.
         * <p>
         * If you want to use your own domain name, such as www.example.com, instead of the cloudfront.net domain name,
         * you can add an alternate domain name to your distribution. If you attach a certificate to the distribution,
         * you should add (at least one of) the domain names of the certificate to this list.
         * <p>
         * When you want to move a domain name between distributions, you can associate a certificate without specifying any domain names.
         * For more information, see the <em>Moving an alternate domain name to a different distribution</em> section in the README.
         * <p>
         * Default: - The distribution will only support the default generated name (e.g., d111111abcdef8.cloudfront.net)
         * <p>
         * @return {@code this}
         * @param domainNames Alternative domain names for this distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNames(final java.util.List<java.lang.String> domainNames) {
            this.props.domainNames(domainNames);
            return this;
        }

        /**
         * Enable or disable the distribution.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Enable or disable the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * Whether CloudFront will respond to IPv6 DNS requests with an IPv6 address.
         * <p>
         * If you specify false, CloudFront responds to IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
         * This allows viewers to submit a second request, for an IPv4 address for your distribution.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableIpv6 Whether CloudFront will respond to IPv6 DNS requests with an IPv6 address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIpv6(final java.lang.Boolean enableIpv6) {
            this.props.enableIpv6(enableIpv6);
            return this;
        }

        /**
         * Enable access logging for the distribution.
         * <p>
         * Default: - false, unless `logBucket` is specified.
         * <p>
         * @return {@code this}
         * @param enableLogging Enable access logging for the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogging(final java.lang.Boolean enableLogging) {
            this.props.enableLogging(enableLogging);
            return this;
        }

        /**
         * How CloudFront should handle requests that are not successful (e.g., PageNotFound).
         * <p>
         * Default: - No custom error responses.
         * <p>
         * @return {@code this}
         * @param errorResponses How CloudFront should handle requests that are not successful (e.g., PageNotFound). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorResponses(final java.util.List<? extends software.amazon.awscdk.services.cloudfront.ErrorResponse> errorResponses) {
            this.props.errorResponses(errorResponses);
            return this;
        }

        /**
         * Controls the countries in which your content is distributed.
         * <p>
         * Default: - No geographic restrictions
         * <p>
         * @return {@code this}
         * @param geoRestriction Controls the countries in which your content is distributed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoRestriction(final software.amazon.awscdk.services.cloudfront.GeoRestriction geoRestriction) {
            this.props.geoRestriction(geoRestriction);
            return this;
        }

        /**
         * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront.
         * <p>
         * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support server name identification (SNI).
         * <p>
         * Default: HttpVersion.HTTP2
         * <p>
         * @return {@code this}
         * @param httpVersion Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpVersion(final software.amazon.awscdk.services.cloudfront.HttpVersion httpVersion) {
            this.props.httpVersion(httpVersion);
            return this;
        }

        /**
         * The Amazon S3 bucket to store the access logs in.
         * <p>
         * Make sure to set <code>objectOwnership</code> to <code>s3.ObjectOwnership.OBJECT_WRITER</code> in your custom bucket.
         * <p>
         * Default: - A bucket is created if `enableLogging` is true
         * <p>
         * @return {@code this}
         * @param logBucket The Amazon S3 bucket to store the access logs in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logBucket(final software.amazon.awscdk.services.s3.IBucket logBucket) {
            this.props.logBucket(logBucket);
            return this;
        }

        /**
         * An optional string that you want CloudFront to prefix to the access log filenames for this distribution.
         * <p>
         * Default: - no prefix
         * <p>
         * @return {@code this}
         * @param logFilePrefix An optional string that you want CloudFront to prefix to the access log filenames for this distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logFilePrefix(final java.lang.String logFilePrefix) {
            this.props.logFilePrefix(logFilePrefix);
            return this;
        }

        /**
         * Specifies whether you want CloudFront to include cookies in access logs.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param logIncludesCookies Specifies whether you want CloudFront to include cookies in access logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logIncludesCookies(final java.lang.Boolean logIncludesCookies) {
            this.props.logIncludesCookies(logIncludesCookies);
            return this;
        }

        /**
         * The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
         * <p>
         * CloudFront serves your objects only to browsers or devices that support at
         * least the SSL version that you specify.
         * <p>
         * Default: - SecurityPolicyProtocol.TLS_V1_2_2021 if the '@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021' feature flag is set; otherwise, SecurityPolicyProtocol.TLS_V1_2_2019.
         * <p>
         * @return {@code this}
         * @param minimumProtocolVersion The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumProtocolVersion(final software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol minimumProtocolVersion) {
            this.props.minimumProtocolVersion(minimumProtocolVersion);
            return this;
        }

        /**
         * The price class that corresponds with the maximum price that you want to pay for CloudFront service.
         * <p>
         * If you specify PriceClass_All, CloudFront responds to requests for your objects from all CloudFront edge locations.
         * If you specify a price class other than PriceClass_All, CloudFront serves your objects from the CloudFront edge location
         * that has the lowest latency among the edge locations in your price class.
         * <p>
         * Default: PriceClass.PRICE_CLASS_ALL
         * <p>
         * @return {@code this}
         * @param priceClass The price class that corresponds with the maximum price that you want to pay for CloudFront service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priceClass(final software.amazon.awscdk.services.cloudfront.PriceClass priceClass) {
            this.props.priceClass(priceClass);
            return this;
        }

        /**
         * Whether to enable additional CloudWatch metrics.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html</a>
         * @param publishAdditionalMetrics Whether to enable additional CloudWatch metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishAdditionalMetrics(final java.lang.Boolean publishAdditionalMetrics) {
            this.props.publishAdditionalMetrics(publishAdditionalMetrics);
            return this;
        }

        /**
         * The SSL method CloudFront will use for your distribution.
         * <p>
         * Server Name Indication (SNI) - is an extension to the TLS computer networking protocol by which a client indicates
         * which hostname it is attempting to connect to at the start of the handshaking process. This allows a server to present
         * multiple certificates on the same IP address and TCP port number and hence allows multiple secure (HTTPS) websites
         * (or any other service over TLS) to be served by the same IP address without requiring all those sites to use the same certificate.
         * <p>
         * CloudFront can use SNI to host multiple distributions on the same IP - which a large majority of clients will support.
         * <p>
         * If your clients cannot support SNI however - CloudFront can use dedicated IPs for your distribution - but there is a prorated monthly charge for
         * using this feature. By default, we use SNI - but you can optionally enable dedicated IPs (VIP).
         * <p>
         * See the CloudFront SSL for more details about pricing : https://aws.amazon.com/cloudfront/custom-ssl-domains/
         * <p>
         * Default: SSLMethod.SNI
         * <p>
         * @return {@code this}
         * @param sslSupportMethod The SSL method CloudFront will use for your distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslSupportMethod(final software.amazon.awscdk.services.cloudfront.SSLMethod sslSupportMethod) {
            this.props.sslSupportMethod(sslSupportMethod);
            return this;
        }

        /**
         * Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution.
         * <p>
         * To specify a web ACL created using the latest version of AWS WAF, use the ACL ARN, for example
         * <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
         * To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
         * <p>
         * Default: - No AWS Web Application Firewall web access control list (web ACL).
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html#API_CreateDistribution_RequestParameters.">https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html#API_CreateDistribution_RequestParameters.</a>
         * @param webAclId Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclId(final java.lang.String webAclId) {
            this.props.webAclId(webAclId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.Distribution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.Distribution build() {
            return new software.amazon.awscdk.services.cloudfront.Distribution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
