package software.amazon.awscdk.services.cloudfront;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * import software.amazon.awscdk.services.lambda.*;
 * Version version;
 * LambdaFunctionAssociation lambdaFunctionAssociation = LambdaFunctionAssociation.builder()
 *         .eventType(LambdaEdgeEventType.ORIGIN_REQUEST)
 *         .lambdaFunction(version)
 *         // the properties below are optional
 *         .includeBody(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:18.925Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.LambdaFunctionAssociation")
@software.amazon.jsii.Jsii.Proxy(LambdaFunctionAssociation.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaFunctionAssociation extends software.amazon.jsii.JsiiSerializable {

    /**
     * The lambda event type defines at which event the lambda is called during the request lifecycle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType getEventType();

    /**
     * A version of the lambda to associate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion getLambdaFunction();

    /**
     * Allows a Lambda function to have read access to the body content.
     * <p>
     * Only valid for "request" event types (<code>ORIGIN_REQUEST</code> or <code>VIEWER_REQUEST</code>).
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeBody() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaFunctionAssociation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaFunctionAssociation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaFunctionAssociation> {
        software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType;
        software.amazon.awscdk.services.lambda.IVersion lambdaFunction;
        java.lang.Boolean includeBody;

        /**
         * Sets the value of {@link LambdaFunctionAssociation#getEventType}
         * @param eventType The lambda event type defines at which event the lambda is called during the request lifecycle. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventType(software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType) {
            this.eventType = eventType;
            return this;
        }

        /**
         * Sets the value of {@link LambdaFunctionAssociation#getLambdaFunction}
         * @param lambdaFunction A version of the lambda to associate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaFunction(software.amazon.awscdk.services.lambda.IVersion lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        /**
         * Sets the value of {@link LambdaFunctionAssociation#getIncludeBody}
         * @param includeBody Allows a Lambda function to have read access to the body content.
         *                    Only valid for "request" event types (<code>ORIGIN_REQUEST</code> or <code>VIEWER_REQUEST</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeBody(java.lang.Boolean includeBody) {
            this.includeBody = includeBody;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaFunctionAssociation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaFunctionAssociation build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaFunctionAssociation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaFunctionAssociation {
        private final software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType;
        private final software.amazon.awscdk.services.lambda.IVersion lambdaFunction;
        private final java.lang.Boolean includeBody;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType.class));
            this.lambdaFunction = software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class));
            this.includeBody = software.amazon.jsii.Kernel.get(this, "includeBody", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventType = java.util.Objects.requireNonNull(builder.eventType, "eventType is required");
            this.lambdaFunction = java.util.Objects.requireNonNull(builder.lambdaFunction, "lambdaFunction is required");
            this.includeBody = builder.includeBody;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType getEventType() {
            return this.eventType;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IVersion getLambdaFunction() {
            return this.lambdaFunction;
        }

        @Override
        public final java.lang.Boolean getIncludeBody() {
            return this.includeBody;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventType", om.valueToTree(this.getEventType()));
            data.set("lambdaFunction", om.valueToTree(this.getLambdaFunction()));
            if (this.getIncludeBody() != null) {
                data.set("includeBody", om.valueToTree(this.getIncludeBody()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.LambdaFunctionAssociation"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaFunctionAssociation.Jsii$Proxy that = (LambdaFunctionAssociation.Jsii$Proxy) o;

            if (!eventType.equals(that.eventType)) return false;
            if (!lambdaFunction.equals(that.lambdaFunction)) return false;
            return this.includeBody != null ? this.includeBody.equals(that.includeBody) : that.includeBody == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventType.hashCode();
            result = 31 * result + (this.lambdaFunction.hashCode());
            result = 31 * result + (this.includeBody != null ? this.includeBody.hashCode() : 0);
            return result;
        }
    }
}
