package software.amazon.awscdk.services.cloudtrail;

/**
 * Properties for defining a <code>CfnEventDataStore</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnEventDataStoreProps cfnEventDataStoreProps = CfnEventDataStoreProps.builder()
 *         .advancedEventSelectors(List.of(AdvancedEventSelectorProperty.builder()
 *                 .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
 *                         .field("field")
 *                         // the properties below are optional
 *                         .endsWith(List.of("endsWith"))
 *                         .equalTo(List.of("equalTo"))
 *                         .notEndsWith(List.of("notEndsWith"))
 *                         .notEquals(List.of("notEquals"))
 *                         .notStartsWith(List.of("notStartsWith"))
 *                         .startsWith(List.of("startsWith"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build()))
 *         .billingMode("billingMode")
 *         .federationEnabled(false)
 *         .federationRoleArn("federationRoleArn")
 *         .ingestionEnabled(false)
 *         .insightsDestination("insightsDestination")
 *         .insightSelectors(List.of(InsightSelectorProperty.builder()
 *                 .insightType("insightType")
 *                 .build()))
 *         .kmsKeyId("kmsKeyId")
 *         .multiRegionEnabled(false)
 *         .name("name")
 *         .organizationEnabled(false)
 *         .retentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .terminationProtectionEnabled(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:19.033Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStoreProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventDataStoreProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventDataStoreProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The advanced event selectors to use to select the events for the data store.
     * <p>
     * You can configure up to five advanced event selectors for each event data store.
     * <p>
     * For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
     * <p>
     * For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-eds-cli.html#lake-cli-create-eds-config">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
     * <p>
     * For more information about how to use advanced event selectors to include events outside of AWS events in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-integrations-cli.html#lake-cli-create-integration">Create an integration to log events from outside AWS</a> in the CloudTrail User Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-advancedeventselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-advancedeventselectors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedEventSelectors() {
        return null;
    }

    /**
     * The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.
     * <p>
     * The following are the possible values:
     * <p>
     * <ul>
     * <li><code>EXTENDABLE_RETENTION_PRICING</code> - This billing mode is generally recommended if you want a flexible retention period of up to 3653 days (about 10 years). The default retention period for this billing mode is 366 days.</li>
     * <li><code>FIXED_RETENTION_PRICING</code> - This billing mode is recommended if you expect to ingest more than 25 TB of event data per month and need a retention period of up to 2557 days (about 7 years). The default retention period for this billing mode is 2557 days.</li>
     * </ul>
     * <p>
     * The default value is <code>EXTENDABLE_RETENTION_PRICING</code> .
     * <p>
     * For more information about CloudTrail pricing, see <a href="https://docs.aws.amazon.com/cloudtrail/pricing/">AWS CloudTrail Pricing</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html">Managing CloudTrail Lake costs</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-billingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-billingmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBillingMode() {
        return null;
    }

    /**
     * Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFederationEnabled() {
        return null;
    }

    /**
     * If Lake query federation is enabled, provides the ARN of the federation role used to access the resources for the federated event data store.
     * <p>
     * The federation role must exist in your account and provide the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role">required minimum permissions</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-federationrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFederationRoleArn() {
        return null;
    }

    /**
     * Specifies whether the event data store should start ingesting live events.
     * <p>
     * The default is true.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-ingestionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-ingestionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIngestionEnabled() {
        return null;
    }

    /**
     * The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store-insights.html">Create an event data store for CloudTrail Insights events</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightsdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightsdestination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInsightsDestination() {
        return null;
    }

    /**
     * A JSON string that contains the Insights types you want to log on an event data store.
     * <p>
     * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
     * <p>
     * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
     * <p>
     * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-insightselectors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInsightSelectors() {
        return null;
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
     * <p>
     * The value can be an alias name prefixed by <code>alias/</code> , a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     * <p>
     * <blockquote>
     * <p>
     * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
     * <p>
     * </blockquote>
     * <p>
     * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * Examples:
     * <p>
     * <ul>
     * <li><code>alias/MyAliasName</code></li>
     * <li><code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code></li>
     * <li><code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
     * <li><code>12345678-1234-1234-1234-123456789012</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-multiregionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-multiregionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiRegionEnabled() {
        return null;
    }

    /**
     * The name of the event data store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-organizationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-organizationenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationEnabled() {
        return null;
    }

    /**
     * The retention period of the event data store, in days.
     * <p>
     * If <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code> , you can set a retention period of up to 3653 days, the equivalent of 10 years. If <code>BillingMode</code> is set to <code>FIXED_RETENTION_PRICING</code> , you can set a retention period of up to 2557 days, the equivalent of seven years.
     * <p>
     * CloudTrail Lake determines whether to retain an event by checking if the <code>eventTime</code> of the event is within the specified retention period. For example, if you set a retention period of 90 days, CloudTrail will remove events when the <code>eventTime</code> is older than 90 days.
     * <p>
     * <blockquote>
     * <p>
     * If you plan to copy trail events to this event data store, we recommend that you consider both the age of the events that you want to copy as well as how long you want to keep the copied events in your event data store. For example, if you copy trail events that are 5 years old and specify a retention period of 7 years, the event data store will retain those events for two years.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-retentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriod() {
        return null;
    }

    /**
     * A list of tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies whether termination protection is enabled for the event data store.
     * <p>
     * If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-terminationprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-eventdatastore.html#cfn-cloudtrail-eventdatastore-terminationprotectionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTerminationProtectionEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEventDataStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventDataStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventDataStoreProps> {
        java.lang.Object advancedEventSelectors;
        java.lang.String billingMode;
        java.lang.Object federationEnabled;
        java.lang.String federationRoleArn;
        java.lang.Object ingestionEnabled;
        java.lang.String insightsDestination;
        java.lang.Object insightSelectors;
        java.lang.String kmsKeyId;
        java.lang.Object multiRegionEnabled;
        java.lang.String name;
        java.lang.Object organizationEnabled;
        java.lang.Number retentionPeriod;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object terminationProtectionEnabled;

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getAdvancedEventSelectors}
         * @param advancedEventSelectors The advanced event selectors to use to select the events for the data store.
         *                               You can configure up to five advanced event selectors for each event data store.
         *                               <p>
         *                               For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         *                               <p>
         *                               For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-eds-cli.html#lake-cli-create-eds-config">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
         *                               <p>
         *                               For more information about how to use advanced event selectors to include events outside of AWS events in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-integrations-cli.html#lake-cli-create-integration">Create an integration to log events from outside AWS</a> in the CloudTrail User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(software.amazon.awscdk.IResolvable advancedEventSelectors) {
            this.advancedEventSelectors = advancedEventSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getAdvancedEventSelectors}
         * @param advancedEventSelectors The advanced event selectors to use to select the events for the data store.
         *                               You can configure up to five advanced event selectors for each event data store.
         *                               <p>
         *                               For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         *                               <p>
         *                               For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-eds-cli.html#lake-cli-create-eds-config">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
         *                               <p>
         *                               For more information about how to use advanced event selectors to include events outside of AWS events in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-integrations-cli.html#lake-cli-create-integration">Create an integration to log events from outside AWS</a> in the CloudTrail User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(java.util.List<? extends java.lang.Object> advancedEventSelectors) {
            this.advancedEventSelectors = advancedEventSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getBillingMode}
         * @param billingMode The billing mode for the event data store determines the cost for ingesting events and the default and maximum retention period for the event data store.
         *                    The following are the possible values:
         *                    <p>
         *                    <ul>
         *                    <li><code>EXTENDABLE_RETENTION_PRICING</code> - This billing mode is generally recommended if you want a flexible retention period of up to 3653 days (about 10 years). The default retention period for this billing mode is 366 days.</li>
         *                    <li><code>FIXED_RETENTION_PRICING</code> - This billing mode is recommended if you expect to ingest more than 25 TB of event data per month and need a retention period of up to 2557 days (about 7 years). The default retention period for this billing mode is 2557 days.</li>
         *                    </ul>
         *                    <p>
         *                    The default value is <code>EXTENDABLE_RETENTION_PRICING</code> .
         *                    <p>
         *                    For more information about CloudTrail pricing, see <a href="https://docs.aws.amazon.com/cloudtrail/pricing/">AWS CloudTrail Pricing</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html">Managing CloudTrail Lake costs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(java.lang.String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getFederationEnabled}
         * @param federationEnabled Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationEnabled(java.lang.Boolean federationEnabled) {
            this.federationEnabled = federationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getFederationEnabled}
         * @param federationEnabled Indicates if <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Lake query federation</a> is enabled. By default, Lake query federation is disabled. You cannot delete an event data store if Lake query federation is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationEnabled(software.amazon.awscdk.IResolvable federationEnabled) {
            this.federationEnabled = federationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getFederationRoleArn}
         * @param federationRoleArn If Lake query federation is enabled, provides the ARN of the federation role used to access the resources for the federated event data store.
         *                          The federation role must exist in your account and provide the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role">required minimum permissions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationRoleArn(java.lang.String federationRoleArn) {
            this.federationRoleArn = federationRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getIngestionEnabled}
         * @param ingestionEnabled Specifies whether the event data store should start ingesting live events.
         *                         The default is true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionEnabled(java.lang.Boolean ingestionEnabled) {
            this.ingestionEnabled = ingestionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getIngestionEnabled}
         * @param ingestionEnabled Specifies whether the event data store should start ingesting live events.
         *                         The default is true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionEnabled(software.amazon.awscdk.IResolvable ingestionEnabled) {
            this.ingestionEnabled = ingestionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getInsightsDestination}
         * @param insightsDestination The ARN (or ID suffix of the ARN) of the destination event data store that logs Insights events.
         *                            For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store-insights.html">Create an event data store for CloudTrail Insights events</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightsDestination(java.lang.String insightsDestination) {
            this.insightsDestination = insightsDestination;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getInsightSelectors}
         * @param insightSelectors A JSON string that contains the Insights types you want to log on an event data store.
         *                         <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         *                         <p>
         *                         The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         *                         <p>
         *                         The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(software.amazon.awscdk.IResolvable insightSelectors) {
            this.insightSelectors = insightSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getInsightSelectors}
         * @param insightSelectors A JSON string that contains the Insights types you want to log on an event data store.
         *                         <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         *                         <p>
         *                         The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         *                         <p>
         *                         The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(java.util.List<? extends java.lang.Object> insightSelectors) {
            this.insightSelectors = insightSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getKmsKeyId}
         * @param kmsKeyId Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
         *                 The value can be an alias name prefixed by <code>alias/</code> , a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
         *                 <p>
         *                 </blockquote>
         *                 <p>
         *                 CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                 <p>
         *                 Examples:
         *                 <p>
         *                 <ul>
         *                 <li><code>alias/MyAliasName</code></li>
         *                 <li><code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code></li>
         *                 <li><code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
         *                 <li><code>12345678-1234-1234-1234-123456789012</code></li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getMultiRegionEnabled}
         * @param multiRegionEnabled Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(java.lang.Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getMultiRegionEnabled}
         * @param multiRegionEnabled Specifies whether the event data store includes events from all Regions, or only from the Region in which the event data store is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(software.amazon.awscdk.IResolvable multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getName}
         * @param name The name of the event data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getOrganizationEnabled}
         * @param organizationEnabled Specifies whether an event data store collects events logged for an organization in AWS Organizations .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(java.lang.Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getOrganizationEnabled}
         * @param organizationEnabled Specifies whether an event data store collects events logged for an organization in AWS Organizations .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(software.amazon.awscdk.IResolvable organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getRetentionPeriod}
         * @param retentionPeriod The retention period of the event data store, in days.
         *                        If <code>BillingMode</code> is set to <code>EXTENDABLE_RETENTION_PRICING</code> , you can set a retention period of up to 3653 days, the equivalent of 10 years. If <code>BillingMode</code> is set to <code>FIXED_RETENTION_PRICING</code> , you can set a retention period of up to 2557 days, the equivalent of seven years.
         *                        <p>
         *                        CloudTrail Lake determines whether to retain an event by checking if the <code>eventTime</code> of the event is within the specified retention period. For example, if you set a retention period of 90 days, CloudTrail will remove events when the <code>eventTime</code> is older than 90 days.
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        If you plan to copy trail events to this event data store, we recommend that you consider both the age of the events that you want to copy as well as how long you want to keep the copied events in your event data store. For example, if you copy trail events that are 5 years old and specify a retention period of 7 years, the event data store will retain those events for two years.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(java.lang.Number retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getTags}
         * @param tags A list of tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getTerminationProtectionEnabled}
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the event data store.
         *                                     If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(java.lang.Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventDataStoreProps#getTerminationProtectionEnabled}
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the event data store.
         *                                     If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(software.amazon.awscdk.IResolvable terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventDataStoreProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventDataStoreProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventDataStoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventDataStoreProps {
        private final java.lang.Object advancedEventSelectors;
        private final java.lang.String billingMode;
        private final java.lang.Object federationEnabled;
        private final java.lang.String federationRoleArn;
        private final java.lang.Object ingestionEnabled;
        private final java.lang.String insightsDestination;
        private final java.lang.Object insightSelectors;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object multiRegionEnabled;
        private final java.lang.String name;
        private final java.lang.Object organizationEnabled;
        private final java.lang.Number retentionPeriod;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object terminationProtectionEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.advancedEventSelectors = software.amazon.jsii.Kernel.get(this, "advancedEventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.billingMode = software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.federationEnabled = software.amazon.jsii.Kernel.get(this, "federationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.federationRoleArn = software.amazon.jsii.Kernel.get(this, "federationRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ingestionEnabled = software.amazon.jsii.Kernel.get(this, "ingestionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.insightsDestination = software.amazon.jsii.Kernel.get(this, "insightsDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.insightSelectors = software.amazon.jsii.Kernel.get(this, "insightSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiRegionEnabled = software.amazon.jsii.Kernel.get(this, "multiRegionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationEnabled = software.amazon.jsii.Kernel.get(this, "organizationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.terminationProtectionEnabled = software.amazon.jsii.Kernel.get(this, "terminationProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.advancedEventSelectors = builder.advancedEventSelectors;
            this.billingMode = builder.billingMode;
            this.federationEnabled = builder.federationEnabled;
            this.federationRoleArn = builder.federationRoleArn;
            this.ingestionEnabled = builder.ingestionEnabled;
            this.insightsDestination = builder.insightsDestination;
            this.insightSelectors = builder.insightSelectors;
            this.kmsKeyId = builder.kmsKeyId;
            this.multiRegionEnabled = builder.multiRegionEnabled;
            this.name = builder.name;
            this.organizationEnabled = builder.organizationEnabled;
            this.retentionPeriod = builder.retentionPeriod;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        }

        @Override
        public final java.lang.Object getAdvancedEventSelectors() {
            return this.advancedEventSelectors;
        }

        @Override
        public final java.lang.String getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final java.lang.Object getFederationEnabled() {
            return this.federationEnabled;
        }

        @Override
        public final java.lang.String getFederationRoleArn() {
            return this.federationRoleArn;
        }

        @Override
        public final java.lang.Object getIngestionEnabled() {
            return this.ingestionEnabled;
        }

        @Override
        public final java.lang.String getInsightsDestination() {
            return this.insightsDestination;
        }

        @Override
        public final java.lang.Object getInsightSelectors() {
            return this.insightSelectors;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getMultiRegionEnabled() {
            return this.multiRegionEnabled;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOrganizationEnabled() {
            return this.organizationEnabled;
        }

        @Override
        public final java.lang.Number getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdvancedEventSelectors() != null) {
                data.set("advancedEventSelectors", om.valueToTree(this.getAdvancedEventSelectors()));
            }
            if (this.getBillingMode() != null) {
                data.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getFederationEnabled() != null) {
                data.set("federationEnabled", om.valueToTree(this.getFederationEnabled()));
            }
            if (this.getFederationRoleArn() != null) {
                data.set("federationRoleArn", om.valueToTree(this.getFederationRoleArn()));
            }
            if (this.getIngestionEnabled() != null) {
                data.set("ingestionEnabled", om.valueToTree(this.getIngestionEnabled()));
            }
            if (this.getInsightsDestination() != null) {
                data.set("insightsDestination", om.valueToTree(this.getInsightsDestination()));
            }
            if (this.getInsightSelectors() != null) {
                data.set("insightSelectors", om.valueToTree(this.getInsightSelectors()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getMultiRegionEnabled() != null) {
                data.set("multiRegionEnabled", om.valueToTree(this.getMultiRegionEnabled()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOrganizationEnabled() != null) {
                data.set("organizationEnabled", om.valueToTree(this.getOrganizationEnabled()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTerminationProtectionEnabled() != null) {
                data.set("terminationProtectionEnabled", om.valueToTree(this.getTerminationProtectionEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnEventDataStoreProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventDataStoreProps.Jsii$Proxy that = (CfnEventDataStoreProps.Jsii$Proxy) o;

            if (this.advancedEventSelectors != null ? !this.advancedEventSelectors.equals(that.advancedEventSelectors) : that.advancedEventSelectors != null) return false;
            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.federationEnabled != null ? !this.federationEnabled.equals(that.federationEnabled) : that.federationEnabled != null) return false;
            if (this.federationRoleArn != null ? !this.federationRoleArn.equals(that.federationRoleArn) : that.federationRoleArn != null) return false;
            if (this.ingestionEnabled != null ? !this.ingestionEnabled.equals(that.ingestionEnabled) : that.ingestionEnabled != null) return false;
            if (this.insightsDestination != null ? !this.insightsDestination.equals(that.insightsDestination) : that.insightsDestination != null) return false;
            if (this.insightSelectors != null ? !this.insightSelectors.equals(that.insightSelectors) : that.insightSelectors != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.multiRegionEnabled != null ? !this.multiRegionEnabled.equals(that.multiRegionEnabled) : that.multiRegionEnabled != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.organizationEnabled != null ? !this.organizationEnabled.equals(that.organizationEnabled) : that.organizationEnabled != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.terminationProtectionEnabled != null ? this.terminationProtectionEnabled.equals(that.terminationProtectionEnabled) : that.terminationProtectionEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.advancedEventSelectors != null ? this.advancedEventSelectors.hashCode() : 0;
            result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
            result = 31 * result + (this.federationEnabled != null ? this.federationEnabled.hashCode() : 0);
            result = 31 * result + (this.federationRoleArn != null ? this.federationRoleArn.hashCode() : 0);
            result = 31 * result + (this.ingestionEnabled != null ? this.ingestionEnabled.hashCode() : 0);
            result = 31 * result + (this.insightsDestination != null ? this.insightsDestination.hashCode() : 0);
            result = 31 * result + (this.insightSelectors != null ? this.insightSelectors.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.multiRegionEnabled != null ? this.multiRegionEnabled.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.organizationEnabled != null ? this.organizationEnabled.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.terminationProtectionEnabled != null ? this.terminationProtectionEnabled.hashCode() : 0);
            return result;
        }
    }
}
